# -*- coding: utf-8 -*-
# Canola2 Tuning Plugin
# Copyright (C) 2008 Instituto Nokia de Tecnologia
# Authors: Adriano Rezende <adriano.rezende@openbossa.org>
#          Renato Chencarek <renato.chencarek@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Additional permission under GNU GPL version 3 section 7
#
# If you modify this Program, or any covered work, by linking or combining it
# with Canola2 and its core components (or a modified version of any of those),
# containing parts covered by the terms of Instituto Nokia de Tecnologia End
# User Software Agreement, the licensors of this Program grant you additional
# permission to convey the resulting work.

import re
import socket
import urllib


def request_content(url, **params):
    if not params:
        return urllib.urlopen(url).read()
    else:
        url_encoded = url + "?" + urllib.urlencode(params)
        return urllib.urlopen(url_encoded).read()


class RemoteCoverSearcher(object):
    def __init__(self, artist, album):
        self.artist = artist
        self.album  = album


class AmazonCoverSearcher(RemoteCoverSearcher):
    license_key = "0JE9C2T2RN684MDM6G02"
    re_small = re.compile('<SmallImage>.*?<URL>(.*?)</URL>.*?</SmallImage>')
    re_large = re.compile('<LargeImage>.*?<URL>(.*?)</URL>.*?</LargeImage>')
    re_medium = re.compile('<MediumImage>.*?<URL>(.*?)</URL>.*?</MediumImage>')

    def fetch(self):
        try:
            host_addr = socket.gethostbyname("xml.amazon.com")
            query = self.artist + " " + self.album
            data = request_content("http://%s/onca/xml?" % host_addr,
                                   Service="AWSECommerceService",
                                   ResponseGroup="Images", SearchIndex="Music",
                                   AssociateTag="devconn-20", Operation="ItemSearch",
                                   AWSAccessKeyId=self.license_key, Keywords=query)
        except:
            return []

        if not data:
            return []

        for re_match in [self.re_large, self.re_medium, self.re_small]:
            images = re_match.findall(data)
            if images:
                return list(set(images))

        return []


class LastfmCoverSearcher(RemoteCoverSearcher):
    base_url = "http://www.last.fm/music/%s/%s"
    img_re = re.compile('<div class="cover">.*?<img src="([^"]+)"')

    def fetch(self):
        if self.artist.upper() in ['COMPILATION', 'VARIOUS', 'VARIOUS ARTISTS']:
            params = urllib.quote("Various Artists"), urllib.quote(self.album)
        else:
            params = urllib.quote(self.artist), urllib.quote(self.album)

        try:
            data = urllib.urlopen(self.base_url % params).read()
        except:
            return []

        if not data:
            return []

        return self.img_re.findall(data)
