# Canola2 Flickr Plugin
# Copyright (C) 2008 Thomas Schmidt <tschmidt@debian.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Additional permission under GNU GPL version 3 section 7
#
# If you modify this Program, or any covered work, by linking or combining it
# with Canola2 and its core components (or a modified version of any of those),
# containing parts covered by the terms of Instituto Nokia de Tecnologia End
# User Software Agreement, the licensors of this Program grant you additional
# permission to convey the resulting work.

from terra.core.plugin_prefs import PluginPrefs

import flickr, os, urlparse, urllib, helper

class FlickrManager(flickr.Flickr):
    def __init__(self):
        self.prefs = PluginPrefs("flickr")
        flickr.Flickr.__init__(self, username=self.get_preference("username", ""))

    def get_image_dir(self):
        prefs = PluginPrefs("settings")
        try:
            path = prefs["download_path"]
            path = os.path.join(path, "flickr")
        except KeyError:
            path = os.path.join(os.path.expanduser("~"), ".canola", "flickr", "images")

        return path

    def search_imagefile(self, photo):
        filename = None

        # look only for small, medium, large and original images
        pattern = "%s_.{10}(_[mbo])?\.(gif|jpg|png)" % photo.id
        files   = helper.search_files(self.get_image_dir(), pattern)

        if len(files) > 0:
            # sort filelist by size, biggest first
            sorted_files = sorted(files, lambda x,y: int(os.stat(x).st_size-os.stat(y).st_size), reverse=True)

            # return the biggest file
            filename = sorted_files[0]

        return filename

    def logout(self):
        self.logged = False

    def is_logged(self):
        return self.logged

    def has_preference(self, name):
        return self.prefs.has_key(name)

    def get_preference(self, name, default=None):
        return self.prefs.get(name, default)

    def set_preference(self, name, value):
        self.prefs[name] = value
        self.prefs.save()

    def get_username(self):
        return self.username

    def set_username(self, value):
        self.username = value
        self.set_preference("username", value)

flickr_manager = FlickrManager()
class DownloadManager:
    def __init__(self, verbose=False):
        self.verbose    = verbose

    def download_image(self, url, force=False):
        '''
        check if we have to file in out local cache already, if not, download it

        returns the path of the file and None in case of an error
        '''

        try:
            filename = urlparse.urlsplit(url)[2]
            filename = os.path.basename(filename)
        except IndexError:
            return None

        image_path = os.path.join(flickr_manager.get_image_dir(), filename)

        # download image if the file does not exist locally
        if force or not os.path.exists(image_path):
            res = self.download(url, image_path)
            if not res:
                return None

        return image_path

    def download(self, url, local_path):
        '''
        download url, save it under localpath

        return True if it was sucessful, False if there were errors
        '''

        if self.verbose: print "downloading file %s to %s" % (url, local_path)
        local_dir = os.path.dirname(local_path)
        if not os.path.exists(local_dir):
            os.makedirs(local_dir)
        filename, message = urllib.urlretrieve(url, filename=local_path)
        if self.verbose: print "downloading file %s to %s - success" % (url, local_path)
        return True

def main():
    dl = DownloadManager(verbose=True)
    image_path = dl.download_image("http://farm4.static.flickr.com/3114/2713814846_fa32aaaa19_s.jpg")
    print "image_path: %s" % image_path

if __name__ == "__main__":
    import sys
    sys.exit(main())
