#
# classes and functions to use the flickr api 
#

import flickrapi, helper

API_KEY     = 'a5a079f32c1ff7de4f56f5e71455a210'
API_SECRET  = 'bef25bdff383f762'

class Flickr:
    def __init__(self, username, api_key=API_KEY, api_secret=API_SECRET):
        helper.attributesFromDict(locals())

        self.flickr = flickrapi.FlickrAPI(api_key, api_secret, format='etree')
        self.logged = False
        self.token  = None
        self.frob   = None

    def check_login(func):
        """Used as decorator to validate login."""
        def new_def(*args, **kwds):
            self = args[0]
            if not self.logged:
                self.login()
            return func(*args, **kwds)
        return new_def

    def login(self):
        if not self.frob and not self.token:
            token, self.frob = self.flickr.get_token_part_one(perms='write')
            if not token:
                self.token = None
                return False
            else: self.token = token

        self.token = self.flickr.get_token_part_two((self.token, self.frob))
        if not self.token:
            self.logged = False
            # TODO: raise Exception here, it seems that we can not login at all
        else: self.logged = True
        return self.logged

    def delete_token(self):
        import os
        token = os.path.join(os.path.expanduser("~"), ".flickr", self.api_key, "auth.token")

        if os.path.exists(token):
            os.unlink(token)
            return True
        else:
            return False

    def get_user(self):
        try:
            user = self.flickr.people_findByUsername(username=self.username)
        except flickrapi.FlickrError, msg:
            print "FlickrError ocurred: %s" % msg
            return None
        
        if not user.attrib['stat'] == "ok":
            return None
        
        nsid = user.find('user').attrib['nsid']
        return User(username=self.username, nsid=nsid)

    def get_photosets(self, user=None):
        photosets = []

        if not user:
            sets = self.flickr.photosets_getList()
        else:
            try:
                user_id = user.nsid
            except AttributeError:
                return None
            sets = self.flickr.photosets_getList(user_id=user_id)
        
        if not sets.attrib['stat'] == "ok":
            return None

        num = 0
        while True:
            try:
                set = sets.find('photosets').findall('photoset')[num]
                num = num + 1
            except IndexError:
                break
            
            id          = set.attrib['id']
            title       = set.find('title').text
            description = set.find('description').text
            photos      = set.attrib['photos']

            photoset = Photoset(id=id, title=title, description=description, photos=photos)
            photosets.append(photoset)

        return photosets

    @check_login
    def get_favorites(self, user=None):
        if user:
            try:
                userid = user.id
            except AttributeError:
                return None
            res = self.flickr.favorites_getList(user_id=userid)
        else:
            res = self.flickr.favorites_getList()

        photos = []

        if not res.attrib['stat'] == "ok":
            return None

        num = 0
        while True:
            try:
                photo = res.find('photos').findall('photo')[num]
                num = num + 1
            except IndexError:
                break

            id          = photo.attrib['id']
            title       = photo.attrib['title']
            secret      = photo.attrib['secret']

            photos.append(Photo(id=id, title=title, secret=secret))

        return photos

    @check_login
    def get_photos_notinset(self):
        photos = []

        res = self.flickr.photos_getNotInSet()

        if not res.attrib['stat'] == "ok":
            return None

        num = 0
        while True:
            try:
                photo = res.find('photos').findall('photo')[num]
                num = num + 1
            except IndexError:
                break

            id          = photo.attrib['id']
            title       = photo.attrib['title']
            secret      = photo.attrib['secret']

            photos.append(Photo(id=id, title=title, secret=secret))

        return photos

    def get_photos_photoset(self, photoset):
        try:
            photoset_id = photoset.id
        except AttributeError:
            return None

        photos = []

        res = self.flickr.photosets_getPhotos(photoset_id=photoset_id)

        if not res.attrib['stat'] == "ok":
            return None

        num = 0
        while True:
            try:
                photo = res.find('photoset').findall('photo')[num]
                num = num + 1
            except IndexError:
                break

            id          = photo.attrib['id']
            title       = photo.attrib['title']
            secret      = photo.attrib['secret']

            photos.append(Photo(id=id, title=title, secret=secret))

        return photos

    def get_photosizes(self, photo):
        try:
            photo_id = photo.id
        except AttributeError:
            return None

        sizes = []

        res = self.flickr.photos_getSizes(photo_id=photo_id)

        if not res.attrib['stat'] == "ok":
            return None

        num = 0
        while True:
            try:
                size = res.find('sizes').findall('size')[num]
                num = num + 1
            except IndexError:
                break

            label       = size.attrib['label']
            width       = size.attrib['width']
            height      = size.attrib['height']
            url         = size.attrib['source']
            photopage   = size.attrib['url']

            sizes.append(Size(label=label, width=width, height=height, url=url, photopage=photopage))

        return sizes

    @check_login
    def get_contacts(self):
        contacts = []

        res = self.flickr.contacts_getList()

        if not res.attrib['stat'] == "ok":
            return None

        num = 0
        while True:
            try:
                contact = res.find('contacts').findall('contact')[num]
                num = num + 1
            except IndexError:
                break

            nsid        = contact.attrib['nsid']
            username    = contact.attrib['username']
            realname    = contact.attrib['realname']
            friend      = contact.attrib['friend']
            family      = contact.attrib['family']

            contacts.append(Contact(username=username, nsid=nsid, realname=realname, friend=friend, family=family))

        return contacts

    @check_login
    def search_tags(self, tags, user_id="me"):
        photos = []

        res = self.flickr.photos_Search(user_id=user_id, tags=tags)

        if not res.attrib['stat'] == "ok":
            return None

        num = 0
        while True:
            try:
                photo = res.find('photos').findall('photo')[num]
                num = num + 1
            except IndexError:
                break

            id          = photo.attrib['id']
            title       = photo.attrib['title']
            secret      = photo.attrib['secret']

            photos.append(Photo(id=id, title=title, secret=secret))

        return photos

class User:
    def __init__(self, username, nsid):
        helper.attributesFromDict(locals())

    def __str__(self):
        return "User <username=%s, nsid=%s>" % (self.username, self.nsid)

class Contact(User):
    def __init__(self, username, nsid, realname, family=False, friend=False):
        User.__init__(self, username, nsid)
        
        self.realname   = realname
        self.family     = family
        self.friend     = friend

    def __str__(self):
        return "Contact <realname: %s, username: %s, nsid: %s, family: %s, friend: %s>" % (
                self.realname, self.username, self.nsid, self.family, self.friend)

class Photoset:
    def __init__(self, id, title, description, photos):
        helper.attributesFromDict(locals())

    def __str__(self):
        return "Photoset <id=%s, title=%s, description=%s, photos=%s>" % (
                self.id, self.title, self.description, self.photos)

class Photo:
    def __init__(self,
                id,
                title,
                description = None,
                sizes       = None,
                secret      = None
            ):
        helper.attributesFromDict(locals())

    def __str__(self):
        return "Photo <id=%s, secret: %s, title=%s, description=%s, sizes=%s>" % (
                self.id, self.secret, self.title, self.description, self.sizes)

    def get_preferred_size(self, resolution):
        preferred_size  = None
        res_tmp         = 0
        optimal_diff    = resolution
        if self.sizes:
            for size in self.sizes:
                res_tmp = int(size.width) * int(size.height)
                diff    = abs(resolution-res_tmp)

                # select the size is the difference in resolutions is smaller
                # than to the one of the previously selected size and if the
                # resolution at least 90% of the requested resolution
                if diff < optimal_diff and not res_tmp < 0.9*resolution:
                    optimal_diff    = diff
                    preferred_size  = size

            # select the size with the highest resolution if no size has been
            # selected yet
            if not preferred_size:
                preferred_size = self.sizes[-1]

        return preferred_size

class Size:
    def __init__(self, label, width, height, url, photopage):
        helper.attributesFromDict(locals())

    def __str__(self):
        return "Size <label=%s, width=%s, height=%s, url=%s, photopage=%s>" % (
                self.label, self.width, self.height, self.url, self.photopage)

    def __repr__(self):
        return "Size <label=%s, width=%s, height=%s, url=%s, photopage=%s>" % (
                self.label, self.width, self.height, self.url, self.photopage)

def main():
    #username = "chelli"
    username = ""
    flickr = Flickr(username)
    res = flickr.login()
    if not res == True:
        raw_input("Please switch to your browser window and permit Canola-Flickr access to your flickr account!")
        res = flickr.login()
        if not res == True:
            print "Error, could not get access to a flickr account!"
            return -1

    #flickr.user = flickr.get_user()
    #print "User: %s" % flickr.user

    #contacts = flickr.get_contacts()

    #if not contacts:
    #    print "Error, no contacts found!"
    #    return 1

    #print "Contacts:"
    #for contact in contacts:
    #    print contact

    #res = flickr.delete_token()
    #print "res(delete_token()): %s" % res

    #print "Contact[1]: %s" % contacts[1]

    #photosets = flickr.get_photosets()
    #photosets = flickr.get_photosets(user=contacts[1])
   
    #if not photosets:
    #    print "Error, no photosets found!"
    #    return 1

    #for photoset in photosets:
    #    print photoset
    #print photosets[0]

    #photos = flickr.get_photos_photoset(photoset=photosets[0])
    photos = flickr.get_favorites()
    #photos = flickr.get_photos_notinset()
    #photos = flickr.search_tags(tags="n810")
    
    if not photos:
        print "Error, no photos found!"
        return 1

    #print "photos from %s:" % photosets[0]
    for photo in photos:
        #print photo
        photo.sizes = flickr.get_photosizes(photo)
        size = photo.get_preferred_size(800*600)
        print size
        #print photo.sizes[0]

    return 0

if __name__ == "__main__":
    import sys
    sys.exit(main())

