SDL_Surface *recolor_image (SDL_Surface * src, int k)
{
    int i, j;
    Uint32 c1 = 0, c2 = 0, c3 = 0, c4 = 0, p;
    SDL_Surface *surface;

    surface =
	SDL_CreateRGBSurface (SDL_SWSURFACE, src->w, src->h, DEPTH, 0x00ff0000, 0x0000ff00,
			      0x000000ff, 0xff000000);
    surface = SDL_ConvertSurface (surface, src->format, SDL_SWSURFACE);
    SDL_FillRect (surface, NULL, 0xffffc6ff);
    SDL_BlitSurface (src, NULL, surface, NULL);
    SDL_SetColorKey (surface, SDL_SRCCOLORKEY, SDL_MapRGB (surface->format, 0xff, 0xc6, 0xff));
    surface = SDL_DisplayFormatAlpha (surface);

    switch (k)
	{
	    case 0:
		c1 = 0xff5a5a6b;
		c2 = 0xff39394a;
		c3 = 0xff5a5a6b;
		c4 = 0xff39394a;
		break;

	    case 1:
		c1 = 0xff5a9cff;
		c2 = 0xff3963bd;
		c3 = 0xff5a9cff;
		c4 = 0xff3963bd;
		break;

	    case 2:
		c1 = 0xff6bf76b;
		c2 = 0xff29b54a;
		c3 = 0xff6bf76b;
		c4 = 0xff298c4a;
		break;

	    case 3:
		c1 = 0xffe73929;
		c2 = 0xff9c2939;
		c3 = 0xffe73929;
		c4 = 0xff7b2939;
		break;
	}

    for (j = 0; j < src->h; j++)
	for (i = 0; i < src->w; i++)
	    {
		p = *(Uint32 *) ((Uint32 *) surface->pixels + i + j * src->w);

		if (p == 0xff9cbdad)
		    *(Uint32 *) ((Uint32 *) surface->pixels + i + j * src->w) = c2;
		if (p == 0xfffff7e7)
		    *(Uint32 *) ((Uint32 *) surface->pixels + i + j * src->w) = c1;
		if (p == 0xff5a31b5)
		    *(Uint32 *) ((Uint32 *) surface->pixels + i + j * src->w) = c4;
		if (p == 0xff8c6bef)
		    *(Uint32 *) ((Uint32 *) surface->pixels + i + j * src->w) = c3;
	    }
    return surface;
}
