/*
** Bombermanserver (c) 2000-2002 by Robert Hockauf
** ported 2003-08-15 to Sharp Zaurus by Klaus Rotter kr
** 
** HISTORY:
**
** 2003-08-15	: Initial port
** 2003-12-27	: Some code cleanup
**
*/

#define __LINUX__

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <time.h>
#ifndef __LINUX__
#include <winsock2.h>
#define socklen_t int
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#define SOCKET int

int min (int a, int b)
{
    if (a < b)
	return a;
    return b;
}

clock_t clock ()
{
    struct timeval v;

    gettimeofday (&v, NULL);
    return (v.tv_sec * 1000 + v.tv_usec / 1000);
}
#endif

#define BMVERSION "02.aug.2002"
#define BOMBERMAN_PACKETLENGTH 48
#define BOMBERMAN_MAXBOMBS 16

#define BOMBERMAN_REQUEST 5
#define NOBOMBS_DISEASE 2
#define ALLBOMBS_DISEASE 3
#define SLOW_DISEASE 4
#define FAST_DISEASE 5
#define IMMUNE_DISEASE 1

#define BOMBERMAN_PING 4
#define BOMBERMAN_UP 2
#define BOMBERMAN_DOWN 0
#define BOMBERMAN_LEFT 3
#define BOMBERMAN_RIGHT 1
#define BOMBERMAN_FIRE 16
#define BOMBERMAN_PLAYER 6
#define BOMBERMAN_ARENA 7
#define BOMBERMAN_IDLE 5
#define BOMBERMAN_TEXT 8
#define BOMBERMAN_STATUS 9
#define BOMBERMAN_SOUND 10
#define BOMBERMAN_MUSIC 11
#define BOMBERMAN_AI 12

typedef signed char byte;

byte MESSAGE_LEAVE[] = { ' ', 'l', 'e', 'f', 't', '.' };
byte MESSAGE_JOIN[] = { ' ', 'j', 'o', 'i', 'n', 'e', 'd', '.' };
byte MESSAGE_KILL[] = { ' ', 'w', 'a', 's', ' ', 'k', 'i', 'l', 'l', 'e', 'd', ' ', 'b', 'y',
    ' '
};

char *host = NULL;
int port = 1033;
bool eternal = false;
byte step = 3;
long timeout = 60000 * 5;

SOCKET _socket;
struct sockaddr_in _addr;
socklen_t data_len;
byte data[BOMBERMAN_PACKETLENGTH];

byte message[BOMBERMAN_PACKETLENGTH] = { 0, };

int playerX[5], playerY[5], playerState[5], playerHealth[5], playerNoResponse[5];
byte playerAnim[5],
    playerAction[5],
    playerIdle[5],
    playerStep[5],
    playerBombs[5],
    playerFlames[5],
    playerFrags[5],
    playerName[5][10],
    arena[15][13],
    bombs[(BOMBERMAN_MAXBOMBS + 1) * 5], flames[128 * 4], walls[128 * 3], blows[32 * 3];
int firstbomb = 0, lastbomb = 0, firstflame = 0, lastflame = 0,
    firstwall = 0, lastwall = 0, firstblow = 0, lastblow = 0;
int playerPort[5];
__u_long playerAddress[5];
clock_t starttime = 0, timer = 0;
int startX[] = { 16, 208, 208, 16, 112 };
int startY[] = { 4, 164, 4, 164, 84 };
byte walking[] = { 1, 2, 3, 2, 1, 4, 5, 6, 5, 4 };
byte idle[] = { 0, 0, 1, 1, 1, 0, 0, 2, 2, 2 };
byte bomb[] = { 9, 9, 10, 10, 11, 11, 10, 10 };
byte flame[] = { 1, 0, 1, 2, 3 };
byte empty[] = { 1, 1, 2, 1, 1, 2, 12, 1, 13, 1, 13, 2, 1, 10, 1, 11, 2, 11, 13, 10, 12,
    11, 13, 11, 6, 5, 7, 5, 7, 6, 7, 7, 8, 7
};
byte jump[] = { 0, 0, 2, 3, 4, 3, 2 };

struct PLAYERINFO
{
    byte info[6];
};

struct PLAYERINFO lastPlayerInfo[5] = {
    {BOMBERMAN_PLAYER, 0, 0, -1, 0, BOMBERMAN_IDLE},
    {BOMBERMAN_PLAYER, 1, 0, -1, 0, BOMBERMAN_IDLE},
    {BOMBERMAN_PLAYER, 2, 0, -1, 0, BOMBERMAN_IDLE},
    {BOMBERMAN_PLAYER, 3, 0, -1, 0, BOMBERMAN_IDLE},
    {BOMBERMAN_PLAYER, 4, 0, -1, 0, BOMBERMAN_IDLE}
};

void run ()
{
    int i, j;
    byte x, y, k, *a;
    bool broadcast, wait;

    int x1, x2, y1, y2, sx, sy, dx, dy;

    if ((_socket = socket (AF_INET, SOCK_DGRAM, 0)) == -1)
	{
	    printf ("unable to open socket.\n");
	    exit (1);
	}
    if (!host)
	{
	    gethostname (data, sizeof (data) - 1);
	    {
	        printf("Hostname: %s\n",data);
	    
		struct hostent *h = gethostbyname (data);

		host = inet_ntoa (*((struct in_addr *) h->h_addr));
	    }
	}
    _addr.sin_family = AF_INET;
    _addr.sin_port = htons (port);
    _addr.sin_addr.s_addr = inet_addr (host);
    memset (&(_addr.sin_zero), '\0', 8);

    if (bind (_socket, (struct sockaddr *) &_addr, sizeof (struct sockaddr)) == -1)
	{
	    printf ("unable to bind socket to port %d.\n", port);
	    exit (1);
	}

    printf ("server %s:%d running...\n", host, port);

    for (i = 0; i < 5; i++)
	playerPort[i] = -1;

    while (true)
	{
	    wait = true;
	    while (wait)
		{
		    data_len = sizeof (struct sockaddr);
		    if ((data_len =
			 recvfrom (_socket, data, sizeof (data), 0,
				   (struct sockaddr *) &_addr, &data_len)) == -1)
			{
			    printf ("error while waiting for packet.\n");
			    exit (1);
			}

		    if (data[0] == BOMBERMAN_TEXT)
			{
			    for (i = data[2]; i >= 0; i--)
				data[6 + i + strlen (playerName[data[1]])] = data[3 + i];
			    data[2] += strlen (playerName[data[1]]) + 3;
			    for (i = 0; i < strlen (playerName[data[1]]); i++)
				data[4 + i] = playerName[data[1]][i];
			    data[3] = '[';
			    data[4 + strlen (playerName[data[1]])] = ']';
			    data[5 + strlen (playerName[data[1]])] = ' ';
			    data[1] = 5;
			    data[data[2] + 3] = BOMBERMAN_IDLE;
			    for (i = 0; i < 5; i++)
				{
				    if (playerPort[i] >= 0)
					{
					    _addr.sin_family = AF_INET;
					    _addr.sin_port = playerPort[i];
					    _addr.sin_addr.s_addr = playerAddress[i];
					    memset (&(_addr.sin_zero), '\0', 8);
					    sendto (_socket, data, data[2] + 4, 0,
						    (struct sockaddr *) &_addr,
						    sizeof (struct sockaddr));
					}
				}
			}
		    else
			wait = false;
		}

	    if (data[1] < 5)
		playerNoResponse[data[1]] = 0;

	    broadcast = true;

		/**
		 * begin player isn't <normal> any more
		 */
	    if (data[0] != BOMBERMAN_PING && playerState[data[1]] < 48)
		{
		    data[0] = BOMBERMAN_PLAYER;
		    data[2] = (byte) (playerX[data[1]]);
		    if (playerState[data[1]] < 5)
			{
			    /* begin player is going to die */
			    if (playerState[data[1]] == 0)
				data[3] = -1;
			    else
				data[3] = (byte) (playerY[data[1]]);
			    data[4] = (byte) (35 - playerState[data[1]]);
			    if (playerState[data[1]] > 0)
				playerState[data[1]]--;

			    /* end player is going to die */
			    else
				{

					/**
					 * begin how many players still living
					 */
				    k = 0;
				    j = -1;
				    for (i = 0; i < 5; i++)
					if (playerPort[i] >= 0 && playerState[i] > 4)
					    {

						k++;
						if (playerState[i] > 47)
						    j = i;
					    }

					/**
					 * end how many players still living
					 */
				    if (k == 0)
					{

						/**
						 * begin new game
						 */
					    printf ("starting game...\n");
					    for (i = 0; i < 15; i++)
						for (j = 0; j < 13; j++)
						    {

							if (i == 0 || i == 14 || j == 0 || j == 12
							    || (((i / 2) * 2) == i
								&& ((j / 2) * 2) == j))
							    arena[i][j] = 32;
							else
							    arena[i][j] = 5;
						    }
					    for (j = 0; j < 4; j++)
						for (i = 0; i < 10; i++)
						    {

							do
							    {

								x = (byte) (abs (rand ()) % 15);
								y = (byte) (abs (rand ()) % 13);
							    }
							while (arena[x][y] != 5);
							arena[x][y] = (byte) (49 + j);
						    }
					    for (i = 0; i < 400; i++)
						{

						    x = (byte) (abs (rand ()) % 15);
						    y = (byte) (abs (rand ()) % 13);
						    if (arena[x][y] == 5)
							arena[x][y] = 48;
						}
					    for (i = 0; i < sizeof (empty); i += 2)
						arena[empty[i]][empty[i + 1]] = 5;
					    starttime = clock ();
					    timer = starttime;
					    for (i = 0; i < 5; i++)
						if (playerPort[i] >= 0)
						    {

							playerX[i] = startX[i];
							playerY[i] = startY[i];
							playerAnim[i] = 0;
							playerAction[i] = BOMBERMAN_DOWN;
							playerIdle[i] = 0;
							playerBombs[i] = 1;
							playerFlames[i] = 2;
							playerStep[i] = step;
							playerState[i] = 64;
							playerHealth[i] = 0;
						    }
					    data[0] = BOMBERMAN_IDLE;
					    k = 0;
					    for (x = 1; x <= 13; x++)
						for (y = 1; y <= 11; y++)
						    {

							if ((arena[x][y] > 4 && arena[x][y] < 31) ||
							    (arena[x][y] > 47 && arena[x][y] < 64))
							    {

								data[k++] = BOMBERMAN_ARENA;
								data[k++] = x;
								data[k++] = y;
								if (arena[x][y] > 32)
								    data[k++] = 3;
								else
								    data[k++] =
									(byte) (7 + arena[x][y]);
								data[k] = BOMBERMAN_IDLE;
							    }
							if (x == 13 && y == 1)
							    {

								data[k++] = BOMBERMAN_SOUND;
								data[k++] = 3;
								data[k++] = BOMBERMAN_MUSIC;
								data[k] = BOMBERMAN_IDLE;
							    }
							if (k + 7 > sizeof (data)
							    || (x == 13 && y == 11))
							    {

								for (i = 0; i < 5; i++)
								    if (playerPort[i] >= 0)
									{

									    _addr.sin_family =
										AF_INET;
									    _addr.sin_port =
										playerPort[i];
									    _addr.sin_addr.s_addr =
										playerAddress[i];
									    memset (&
										    (_addr.
										     sin_zero),
										    '\0', 8);
									    sendto (_socket, data,
										    k + 1, 0,
										    (struct sockaddr
										     *) &_addr,
										    sizeof (struct
											    sockaddr));
									}
								k = 0;
							    }
						    }
					    firstbomb = 0;
					    lastbomb = 0;
					    firstflame = 0;
					    lastflame = 0;
					    firstwall = 0;
					    lastwall = 0;
					    firstblow = 0;
					    lastblow = 0;
					    broadcast = false;

						/**
						 * end new game
						 */
					}
				    else if (k == 1 && j >= 0)
					playerState[j] = 47;	/* player won */
				}
			}
		    else
			{

				/**
				 * begin player won
				 */
			    if (playerY[data[1]] < 5)
				playerY[data[1]] = 5;
			    data[3] =
				(byte) (playerY[data[1]] -
					jump[playerState[data[1]] % sizeof (jump)]);
			    if (playerState[data[1]] % sizeof (jump) < 2)
				data[4] = 35;
			    else
				data[4] = 36;
			    if (playerState[data[1]] > 5)
				playerState[data[1]]--;
			    else
				playerState[data[1]] = 0;

				/**
				 * end player won
				 */
			}
		}

		/**
		 * end player isn't <normal> any more
		 */

	    if (data[0] != BOMBERMAN_PING)
		{

		    data[5] = BOMBERMAN_IDLE;
		    if ((data[0] <= BOMBERMAN_IDLE
			 && playerHealth[data[1]] == ALLBOMBS_DISEASE)
			|| (data[0] >= BOMBERMAN_FIRE && playerHealth[data[1]] != NOBOMBS_DISEASE))
			{

				/**
				 * begin player drops bomb
				 */
			    x = (byte) ((playerX[data[1]] + 8) / 16);
			    y = (byte) ((playerY[data[1]] + 22) / 16);
			    if (playerBombs[data[1]] > 0 && arena[x][y] < 32)
				{

				    playerBombs[data[1]]--;
				    arena[x][y] = 64;
				    bombs[lastbomb++] = 1;
				    bombs[lastbomb++] = x;
				    bombs[lastbomb++] = y;
				    bombs[lastbomb++] = data[1];
				    bombs[lastbomb++] = playerFlames[data[1]];
				    lastbomb %= sizeof (bombs);
				}

				/**
				 * end player drops bomb
				 */
			}
		    if (data[0] >= BOMBERMAN_FIRE)
			data[0] -= BOMBERMAN_FIRE;
		}

		/**
		 * begin player requests
		 */
	    switch (data[0])
		{

		    case BOMBERMAN_PING:
			if (data[1] < BOMBERMAN_REQUEST)
			    {

				playerPort[data[1]] = -1;
				printf ("%s (%s:%d) left game.\n", playerName[data[1]],
					inet_ntoa (_addr.sin_addr), ntohs (_addr.sin_port));
				j = 0;
				for (i = 0; i < 5; i++)
				    if (playerPort[i] >= 0)
					j++;
				if (j == 0)
				    {

					printf ("all players left.\n");
					if (!eternal)
					    {

						printf
						    ("server shut down due to no players any more.\n");
						exit (0);
					    }
				    }
				data[0] = BOMBERMAN_PLAYER;
				data[3] = -1;
				data[5] = BOMBERMAN_IDLE;
				playerFrags[data[1]] = 0;
				message[1] = BOMBERMAN_TEXT;
				message[2] = 5;
				message[3] = (byte) strlen (playerName[data[1]]);
				memcpy (&message[4], playerName[data[1]], message[3]);
				memcpy (&message[message[3] + 4], MESSAGE_LEAVE,
					sizeof (MESSAGE_LEAVE));
				message[3] += sizeof (MESSAGE_LEAVE);
				message[0] = (byte) (message[3] + 4);
				message[message[0]] = BOMBERMAN_IDLE;
			    }
			else if (data[1] == BOMBERMAN_REQUEST)
			    {
				printf ("Received bomberman request\n");
				for (i = 0; i <= 5; i++)
				    if (i < 5 && playerPort[i] < 0)
					break;
				data[1] = (byte) (i);
				sendto (_socket, data, 2, 0, (struct sockaddr *) &_addr,
					sizeof (struct sockaddr));
				if (i < 5)
				    {

					playerPort[i] = _addr.sin_port;
					playerAddress[i] = _addr.sin_addr.s_addr;
					for (k = 0; k < data[2]; k++)
					    playerName[i][k] = data[3 + k];
					playerName[i][k] = '\0';
					playerState[i] = 0;
					playerFrags[i] = 0;
					playerNoResponse[i] = 0;
					data[0] = BOMBERMAN_IDLE;
					k = 0;
					for (x = 0; x < 5; x++)
					    if (x != i && playerPort[x] >= 0)
						{

						    data[k++] = BOMBERMAN_TEXT;
						    data[k++] = x;
						    data[k++] = (byte) strlen (playerName[x]);
						    memcpy (&data[k], playerName[x],
							    strlen (playerName[x]));
						    k += (byte) strlen (playerName[x]);
						    data[k] = BOMBERMAN_IDLE;
						}
					for (x = 1; x <= 13; x++)
					    for (y = 1; y <= 11; y++)
						{

						    if ((arena[x][y] > 5 && arena[x][y] < 31) ||
							(arena[x][y] > 47 && arena[x][y] < 64))
							{

							    data[k++] = BOMBERMAN_ARENA;
							    data[k++] = x;
							    data[k++] = y;
							    if (arena[x][y] > 32)
								data[k++] = 3;
							    else
								data[k++] =
								    (byte) (7 + arena[x][y]);
							    data[k] = BOMBERMAN_IDLE;
							}
						    if (k + 5 > sizeof (data)
							|| (x == 13 && y == 11))
							{

							    sendto (_socket, data, k + 1, 0,
								    (struct sockaddr *) &_addr,
								    sizeof (struct sockaddr));
							    k = 0;
							}
						}
					data[0] = BOMBERMAN_PLAYER;
					data[1] = (byte) (i);
					data[2] = 0;
					data[3] = -1;
					data[4] = 0;
					data[5] = BOMBERMAN_IDLE;

					message[0] =
					    (byte) (7 + 2 * strlen (playerName[data[1]]) +
						    sizeof (MESSAGE_JOIN));
					message[1] = BOMBERMAN_TEXT;
					message[2] = data[1];
					message[3] = (byte) strlen (playerName[data[1]]);
					memcpy (&message[4], playerName[data[1]], message[3]);
					k = (byte) (message[3] + 4);
					message[k++] = BOMBERMAN_TEXT;
					message[k++] = 5;
					message[k++] = (byte) (message[3] + sizeof (MESSAGE_JOIN));
					memcpy (&message[k], playerName[data[1]], message[3]);
					k += message[3];
					memcpy (&message[k], MESSAGE_JOIN, sizeof (MESSAGE_JOIN));
					k += sizeof (MESSAGE_JOIN);
					message[k] = BOMBERMAN_IDLE;

					printf ("%s (%s:%d) joined game.\n", playerName[i],
						inet_ntoa (_addr.sin_addr), ntohs (_addr.sin_port));
				    }
				else
				    {

					broadcast = false;
					printf
					    ("player (%s:%d) was rejected due to too many players.\n",
					     inet_ntoa (_addr.sin_addr), ntohs (_addr.sin_port));
				    }
			    }
			break;

		    case BOMBERMAN_IDLE:
			playerAnim[data[1]] = 0;
			data[0] = BOMBERMAN_PLAYER;
			data[2] = (byte) (playerX[data[1]]);
			data[3] = (byte) (playerY[data[1]]);
			playerIdle[data[1]]++;
			if (playerIdle[data[1]] == 50 + sizeof (idle))
			    playerIdle[data[1]] = 50;
			if (playerIdle[data[1]] < 50)
			    data[4] = (byte) (playerAction[data[1]] * 7);
			else
			    data[4] = (byte) (28 + idle[playerIdle[data[1]] - 50]);
			break;

		    case BOMBERMAN_UP:
		    case BOMBERMAN_DOWN:
		    case BOMBERMAN_LEFT:
		    case BOMBERMAN_RIGHT:
			playerIdle[data[1]] = 0;
			playerAction[data[1]] = data[0];
			{
			    byte step;

			    step = playerStep[data[1]];
			    if (playerHealth[data[1]] == SLOW_DISEASE)
				step = 1;
			    else if (playerHealth[data[1]] == FAST_DISEASE)
				step = 9;

			    switch (data[0])
				{

				    case BOMBERMAN_UP:
					x1 = playerX[data[1]] + 2;
					x2 = x1 + 13;
					y1 = playerY[data[1]] + 13 - step;
					y2 = y1;
					sy = (y1 / 16) * 16 + 3 - playerY[data[1]];
					sx = min (step + sy, 3);
					dx = 0;
					dy = -step;
					break;

				    case BOMBERMAN_DOWN:
					x1 = playerX[data[1]] + 2;
					x2 = x1 + 13;
					y1 = playerY[data[1]] + 26 + step;
					y2 = y1;
					sy = (y1 / 16) * 16 - 27 - playerY[data[1]];
					sx = min (step - sy, 3);
					dx = 0;
					dy = step;
					break;

				    case BOMBERMAN_LEFT:
					x1 = playerX[data[1]] + 2 - step;
					x2 = x1;
					y1 = playerY[data[1]] + 13;
					y2 = y1 + 13;
					sx = (x1 / 16) * 16 + 14 - playerX[data[1]];
					sy = min (step + sx, 3);
					dx = -step;
					dy = 0;
					break;

				    case BOMBERMAN_RIGHT:
				    default:
					x1 = playerX[data[1]] + 15 + step;
					x2 = x1;
					y1 = playerY[data[1]] + 13;
					y2 = y1 + 13;
					sx = (x1 / 16 - 1) * 16 - playerX[data[1]];
					sy = min (step - sx, 3);
					dx = step;
					dy = 0;
					break;
				}

			    if ((x1 == x2 && abs (sx) >= step) || (y1 == y2 && abs (sy) >= step))
				{

				    playerX[data[1]] = playerX[data[1]] + dx;
				    playerY[data[1]] = playerY[data[1]] + dy;
				}
			    else if (arena[x1 / 16][y1 / 16] < 32)
				{

				    if (arena[x2 / 16][y2 / 16] < 32)
					{

					    playerX[data[1]] = playerX[data[1]] + dx;
					    playerY[data[1]] = playerY[data[1]] + dy;
					}
				    else
					{

					    if (x1 == x2)
						{

						    playerY[data[1]] = playerY[data[1]] - sy;
						    playerX[data[1]] = playerX[data[1]] + sx;
						}
					    else
						{

						    playerY[data[1]] = playerY[data[1]] + sy;
						    playerX[data[1]] = playerX[data[1]] - sx;
						}
					}
				}
			    else if (arena[x2 / 16][y2 / 16] < 32)
				{

				    playerY[data[1]] = playerY[data[1]] + sy;
				    playerX[data[1]] = playerX[data[1]] + sx;
				}
			    else if (x1 == x2)
				playerX[data[1]] = playerX[data[1]] + sx;
			    else
				playerY[data[1]] = playerY[data[1]] + sy;
			}
			data[2] = (byte) (playerX[data[1]]);
			data[3] = (byte) (playerY[data[1]]);
			playerAnim[data[1]] = (byte) ((playerAnim[data[1]] + 1) % sizeof (walking));
			data[4] = (byte) (data[0] * 7 + walking[playerAnim[data[1]]]);
			data[0] = BOMBERMAN_PLAYER;
			break;
		}

		/**
		 * end player requests
		 */

		/**
		 * begin send player information
		 */
	    if (broadcast)
		{

		    if (playerState[data[1]] > 48)
			{

			    playerState[data[1]]--;
			    if (playerState[data[1]] == 48)
				playerHealth[data[1]] = 0;
			}

			/**
			 * begin player blinking
			 */
		    //if(playerHealth[data[1]] > 0)
		    if (playerState[data[1]] > 48 && (playerState[data[1]] % 2) == 0)
			data[3] = -1;

			/**
			 * end player blinking
			 */

		    j = data[1];
		    memcpy (&lastPlayerInfo[j], data, 6);

			/**
			 * start send time information
			 */
		    data[0] = BOMBERMAN_STATUS;
		    data[1] = 5;
		    data[2] = (byte) (((timeout - (timer - starttime)) / 60000) % 10);
		    {
			byte b;

			b = (byte) (((timeout - (timer - starttime)) / 1000) % 60);
			if (b < 0)
			    b = 0;
			data[3] = b;
		    }
		    data[4] = BOMBERMAN_IDLE;

			/**
			 * end send time information
			 */

			/**
			 * timeout (everyone's a winner)
			 */
		    if (timer - starttime > timeout)
			for (i = 0; i < 5; i++)
			    if (playerState[i] > 47)
				playerState[i] = 47;

		    x = 4;
		    for (i = 0; i < 5; i++)
			{

			    data[x++] = BOMBERMAN_STATUS;
			    data[x++] = (byte) i;
			    data[x++] = playerFrags[i];

				/**
				 * begin remove player getting no response any more
				 */
			    if (playerPort[i] >= 0)
				{
				    if (playerNoResponse[i] > 50)
					{

					    printf
						("%s (%s:%d) was removed due to not responding any more.\n",
						 playerName[i], inet_ntoa (_addr.sin_addr),
						 ntohs (_addr.sin_port));
					    playerPort[i] = -1;
					    playerFrags[i] = 0;
					    lastPlayerInfo[i].info[3] = -1;
					}

				    else
					{
					    playerNoResponse[i]++;
					}
				}

				/**
				 * end remove player getting no response any more
				 */

			    memcpy (&data[x], &lastPlayerInfo[i], 6);
			    x += 5;
			}
		    if (playerPort[j] >= 0)
			sendto (_socket, data, x + 1, 0, (struct sockaddr *) &_addr,
				sizeof (struct sockaddr));
		}

		/**
		 * end send player information
		 */

		/**
		 * begin processing bombs, flames, walls, blows
		 */
	    i = firstbomb;
	    j = 0;
	    a = NULL;
	    x = 0;
	    y = -1;

	    if (clock () - timer >= 100)
		{
		    {
			int l;
			byte m, s;

			timer = clock ();

			data[0] = BOMBERMAN_IDLE;
			l = lastbomb;
			do
			    {

				m = 50;
				s = 5;
				if (a == bombs)
				    {

					i = firstflame;
					l = lastflame;
					a = flames;
					m = 5;
					s = 4;
				    }
				if (a == flames && i == lastflame)
				    {

					i = firstwall;
					l = lastwall;
					a = walls;
					m = 5;
					s = 3;
				    }
				if (a == walls && i == lastwall)
				    {

					i = firstblow;
					l = lastblow;
					a = blows;
					m = 6;
					s = 3;
				    }
				if (a == NULL)
				    a = bombs;
				while (i != l)
				    {

					if (a[i] == m)
					    {

						if (a == bombs)
						    {

							arena[bombs[i + 1]][bombs[i + 2]] =
							    bombs[i + 3];
							playerBombs[bombs[i + 3]]++;
							flames[lastflame++] = 0;
							flames[lastflame++] = bombs[i + 1];
							flames[lastflame++] = bombs[i + 2];
							flames[lastflame++] = 8;
							lastflame %= sizeof (flames);
							data[j++] = BOMBERMAN_SOUND;
							data[j++] = 0;
							data[j] = BOMBERMAN_IDLE;
							{
							    byte d;

							    for (d = 0; d < 4; d++)
								{

								    for (k = 1; k <= bombs[i + 4];
									 k++)
									if (arena
									    [bombs[i + 1] +
									     x * k][bombs[i + 2] +
										    y * k] < 6)
									    {

										arena[bombs[i + 1] +
										      x *
										      k][bombs[i +
											       2] +
											 y * k] =
										    bombs[i + 3];
										flames[lastflame++]
										    = 0;
										flames[lastflame++]
										    =
										    (byte) (bombs
											    [i +
											     1] +
											    x * k);
										flames[lastflame++]
										    =
										    (byte) (bombs
											    [i +
											     2] +
											    y * k);
										flames[lastflame++]
										    = d;
										if (k ==
										    bombs[i + 4])
										    flames[lastflame
											   - 1] +=
											4;
										lastflame %=
										    sizeof (flames);
									    }
									else
									    {

										if (arena
										    [bombs[i + 1] +
										     x *
										     k][bombs[i +
											      2] +
											y * k] < 31)
										    {

											arena[bombs
											      [i +
											       1] +
											      x *
											      k]
											    [bombs
											     [i +
											      2] +
											     y *
											     k] =
											    31;
											blows
											    [lastblow++]
											    = 0;
											blows
											    [lastblow++]
											    =
											    (byte)
											    (bombs
											     [i +
											      1] +
											     x * k);
											blows
											    [lastblow++]
											    =
											    (byte)
											    (bombs
											     [i +
											      2] +
											     y * k);
											lastblow %=
											    sizeof
											    (blows);
										    }
										else if (arena
											 [bombs
											  [i + 1] +
											  x *
											  k][bombs[i
												   +
												   2]
											     +
											     y *
											     k] ==
											 64)
										    {
											{
											    int b;

											    for (b =
												 firstbomb;
												 b
												 !=
												 lastbomb;
												 b =
												 (b
												  +
												  5)
												 %
												 sizeof
												 (bombs))
												if (bombs[b + 1] == bombs[i + 1] + x * k && bombs[b + 2] == bombs[i + 2] + y * k)
												    {

													bombs
													    [b]
													    =
													    49;
													break;
												    }
											}
										    }
										else if (arena
											 [bombs
											  [i + 1] +
											  x *
											  k][bombs[i
												   +
												   2]
											     +
											     y *
											     k] >
											 47)
										    {

											arena[bombs
											      [i +
											       1] +
											      x *
											      k]
											    [bombs
											     [i +
											      2] +
											     y *
											     k] -=
											    14;
											walls
											    [lastwall++]
											    = 0;
											walls
											    [lastwall++]
											    =
											    (byte)
											    (bombs
											     [i +
											      1] +
											     x * k);
											walls
											    [lastwall++]
											    =
											    (byte)
											    (bombs
											     [i +
											      2] +
											     y * k);
											lastwall %=
											    sizeof
											    (walls);
										    }
										break;
									    }

								    if (x == 0)
									{

									    x = (byte) (-y);
									    y = 0;
									}
								    else
									{

									    y = x;
									    x = 0;
									}
								}
							}
							if (lastbomb > 0)
							    lastbomb -= 5;
							else
							    lastbomb = sizeof (bombs) - 5;
							l = lastbomb;
							for (k = 0; k < 5; k++)
							    bombs[i + k] = bombs[lastbomb + k];
							k = -1;
						    }
						else
						    {

							k = 12;
							if (a == walls)
							    {

								arena[a[i + 1]][a[i + 2]] -= 29;
								k = (byte) (7 +
									    arena[a[i + 1]][a
											    [i +
											     2]]);
								firstwall =
								    (firstwall +
								     s) % sizeof (walls);
							    }
							else
							    {

								arena[a[i + 1]][a[i + 2]] = 5;
								if (a == flames)
								    firstflame =
									(firstflame +
									 s) % sizeof (flames);
								else
								    firstblow =
									(firstblow +
									 s) % sizeof (blows);
							    }
						    }
					    }
					else
					    {

						k = (byte) (4 + a[i]);
						if (a == blows)
						    k += 49;
						else if (a == flames)
						    k = (byte) (17 + a[i + 3] + flame[a[i]] * 9);
						else if (a == bombs)
						    k = bomb[bombs[i] % sizeof (bomb)];
					    }

					if (k != -1)
					    {

						a[i]++;
						data[j++] = BOMBERMAN_ARENA;
						data[j++] = a[i + 1];
						data[j++] = a[i + 2];
						data[j++] = k;

						/**
						 * info for ai only
						 */
						if ((a == bombs) && (a[i] == 2))
						    {

							data[j++] = BOMBERMAN_AI;
							data[j++] = a[i + 4];
						    }
						data[j] = BOMBERMAN_IDLE;
						if (a == bombs)
						    i = (i + s) % sizeof (bombs);
						else if (a == flames)
						    i = (i + s) % sizeof (flames);
						else if (a == walls)
						    i = (i + s) % sizeof (walls);
						else if (a == blows)
						    i = (i + s) % sizeof (blows);
						else
						    {
							printf ("another array has to be added.\n");
							exit (0);
						    }
						if (j + 9 > sizeof (data))
						    {

							for (k = 0; k < 5; k++)
							    if (playerPort[k] >= 0)
								{

								    _addr.sin_family = AF_INET;
								    _addr.sin_port = playerPort[k];
								    _addr.sin_addr.s_addr =
									playerAddress[k];
								    memset (&(_addr.sin_zero), '\0',
									    8);
								    sendto (_socket, data, j + 1, 0,
									    (struct sockaddr *)
									    &_addr,
									    sizeof (struct
										    sockaddr));
								}
							j = 0;
						    }
					    }
				    }
			    }
			while (a != blows);
		    }
		}

		/**
		 * end processing bombs, flames, walls, blows
		 */

		/**
		 * begin processing player position
		 */
	    for (i = 0; i < 5; i++)
		if (playerPort[i] >= 0)
		    {

			x = (byte) ((playerX[i] + 8) / 16);
			y = (byte) ((playerY[i] + 22) / 16);

				/**
				 * begin player infects other player
				 */
			if (playerHealth[i] > IMMUNE_DISEASE)
			    {

				for (k = 0; k < 5; k++)
				    if (k != i && playerPort[k] >= 0 && playerState[k] > 4 &&
					playerHealth[k] != IMMUNE_DISEASE &&
					x == (byte) ((playerX[k] + 8) / 16) &&
					y == (byte) ((playerY[k] + 22) / 16))
					{

					    playerHealth[k] = playerHealth[i];
					    playerState[k] = 148;
					    playerHealth[i] = IMMUNE_DISEASE;
					    playerState[i] = 64;
					    break;
					}
			    }

				/**
				 * end player infects other player
				 */

			switch (arena[x][y])
			    {

					/**
					 * begin player has to die
					 */
				case 0:
				case 1:
				case 2:
				case 3:
				case 4:
				    if (playerState[i] > 47)
					{

					    playerState[i] = 4;
					    data[j++] = BOMBERMAN_SOUND;
					    data[j++] = 1;
					    data[j] = BOMBERMAN_IDLE;
					    if (arena[x][y] != i && playerFrags[arena[x][y]] < 99)
						playerFrags[arena[x][y]]++;
					    if (playerFrags[i] > -99)
						playerFrags[i]--;
					    message[1] = BOMBERMAN_TEXT;
					    message[2] = 5;
					    message[3] = (byte) strlen (playerName[i]);
					    memcpy (&message[4], playerName[i], message[3]);
					    memcpy (&message[message[3] + 4], MESSAGE_KILL,
						    sizeof (MESSAGE_KILL));
					    message[3] += sizeof (MESSAGE_KILL);
					    memcpy (&message[message[3] + 4],
						    playerName[arena[x][y]],
						    strlen (playerName[arena[x][y]]));
					    message[3] += strlen (playerName[arena[x][y]]) + 1;
					    message[0] = (byte) (message[3] + 3);
					    message[message[0]++] = '.';
					    message[message[0]] = BOMBERMAN_IDLE;
					}
				    break;

					/**
					 * end player has to die
					 * begin player got extra
					 */
				case 6:
				    playerBombs[i]++;
				    break;
				case 7:
				    playerFlames[i]++;
				    break;
				case 8:
				    if (playerStep[i] < 7)
					playerStep[i]++;
				    break;
				case 9:
				    playerState[i] = 148;
				    playerHealth[i] = abs ((rand () % 4)) + 2;
				    break;

					/**
					 * end player got extra
					 */
			    }

			if (arena[x][y] > 5 && arena[x][y] < 31)
			    {

				arena[x][y] = 5;
				data[j++] = BOMBERMAN_ARENA;
				data[j++] = x;
				data[j++] = y;
				data[j++] = 12;
				data[j++] = BOMBERMAN_SOUND;
				data[j++] = 2;
				data[j] = BOMBERMAN_IDLE;
				if (j + 7 > sizeof (data))
				    {

					for (k = 0; k < 5; k++)
					    if (playerPort[k] >= 0)
						{

						    _addr.sin_family = AF_INET;
						    _addr.sin_port = playerPort[k];
						    _addr.sin_addr.s_addr = playerAddress[k];
						    memset (&(_addr.sin_zero), '\0', 8);
						    sendto (_socket, data, j + 1, 0,
							    (struct sockaddr *) &_addr,
							    sizeof (struct sockaddr));
						}
					j = 0;
				    }
			    }
		    }

		/**
		 * end processing player position
		 */

		/**
		 * begin send remaining data
		 */
	    if (j > 0)
		{

		    for (k = 0; k < 5; k++)
			if (playerPort[k] >= 0)
			    {

				_addr.sin_family = AF_INET;
				_addr.sin_port = playerPort[k];
				_addr.sin_addr.s_addr = playerAddress[k];
				memset (&(_addr.sin_zero), '\0', 8);
				sendto (_socket, data, j + 1, 0, (struct sockaddr *) &_addr,
					sizeof (struct sockaddr));
			    }
		}

		/**
		 * end send remaining data
		 * begin send message
		 */
	    if (message[0] > 0)
		{

		    j = message[0];
		    memcpy (data, &message[1], j);
		    message[0] = 0;
		    for (k = 0; k < 5; k++)
			if (playerPort[k] >= 0)
			    {

				_addr.sin_family = AF_INET;
				_addr.sin_port = playerPort[k];
				_addr.sin_addr.s_addr = playerAddress[k];
				memset (&(_addr.sin_zero), '\0', 8);
				sendto (_socket, data, j, 0, (struct sockaddr *) &_addr,
					sizeof (struct sockaddr));
			    }
		}

		/**
		 * end send message
		 */
	}
}

int main (int argc, char *argv[])
{
    int i;

    for (i = 0; i < argc; i++)
	{

	    if (!strncmp (argv[i], "-p", 2))
		{

		    port = atoi (argv[++i]);
		}
	    else if (!strncmp (argv[i], "-h", 2))
		{

		    host = argv[++i];
		}
	    else if (!strncmp (argv[i], "-s", 2))
		{

		    step = atoi (argv[++i]);
		    if (step > 7)
			step = 7;
		}
	    else if (!strcmp (argv[i], "-eternal"))
		{

		    eternal = true;
		}
	    else if (!strncmp (argv[i], "-t", 2))
		{

		    timeout = atoi (argv[++i]) * 1000;
		    if (timeout > 600000)
			timeout = 600000;
		}
	}

    printf ("bombermanserver version %s\n copyright 2000 robert hockauf\n",
	    BMVERSION " compiled " __DATE__);
    printf ("** Distribution under GNU Public Licence Version 2 **\n");

    if (eternal)
	printf ("warning: server won't die (option -eternal used)\n");

#ifndef __LINUX__
    WSADATA wsa_data;

    if (WSAStartup (MAKEWORD (1, 1), &wsa_data))
	{

	    printf ("unable to startup socket.\n");
	    return 1;
	}
#endif

    run ();
    return 0;
}
