/*
** Bombermanclient SDL (c) 2000-2002 by Robert Hockauf
**
** ported 2003-08-15 to Sharp Zaurus (linux w/ qtopia + SDL) 
** by Klaus Rotter kr@rotters.de
** ported Jan 2007 to Nokia 770 IT2006 (Linux/ARMEL w/ gtk-X11, Maemo based)
** original port for IT2005 (Okt 2005) got lost.
** It may be distributed according the GNU Public Licence Version 2
*/

// Maybe we should get rid of the dozens of #defines, because for windows we have
// a nice java version... just get it for Zaurus & Nokia 770 working...
// 2007-01-22 - removed all Windows and 8 and 32 bit bitmap code


#define __LINUX__

#define ZOOM 0			// 0 = buildin hermes, 1 = software impl.
#define AUDIO 1

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <sys/select.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#define clock() (SDL_GetTicks())
#define SOCKET int


#include <SDL/SDL.h>
#include <SDL/SDL_thread.h>
#include <SDL/SDL_main.h>
//#include <SDL/SDL_mixer.h>

#include "SFont.c"

#define SCREEN_DEPTH 16
#define DEPTH 8

#define BOMBERMAN_PACKETLENGTH 48
#define BOMBERMAN_REQUEST 5
#define BOMBERMAN_PING 4
#define BOMBERMAN_UP 2
#define BOMBERMAN_DOWN 0
#define BOMBERMAN_LEFT 3
#define BOMBERMAN_RIGHT 1
#define BOMBERMAN_FIRE 16
#define BOMBERMAN_PLAYER 6
#define BOMBERMAN_ARENA 7
#define BOMBERMAN_IDLE 5
#define BOMBERMAN_TEXT 8
#define BOMBERMAN_STATUS 9
#define BOMBERMAN_SOUND 10
#define BOMBERMAN_MUSIC 11
#define BOMBERMAN_AI 12

typedef signed char byte;

/*
** Prototypes, mostly AI stuff
*/

extern void ai_arena (byte x, byte y, byte arena_type);
extern void ai_player (byte i, int x, int y, byte direction);
extern void ai_info (byte bomb_flamelength);
extern int ai_run (void *id);
extern int ai_bg_init (int port);

/*
** Global variables - uninitialisized
*/

char *server_host, *client_host;
int server_port;

SOCKET _socket;
struct sockaddr_in _addr;
int data_len;
byte data[BOMBERMAN_PACKETLENGTH];
byte theme_arena[15][13];
byte player_id;

int screen_width = 480, screen_height = 480;	// Fullscreen Mode

SDL_Surface *screen, *screen_buf, *background, *tile[17 + 4 * 9 + 6];
SDL_Surface *player[5][37], *special[35], *background2 = NULL;
SDL_Surface *leftgui, *rightgui;

/*
** Global variables - flags
*/

bool debug_flag = false;

bool sound_enabled = true;
bool swapkeys_enabled = false;
bool music_enabled = false;
bool smooth_enabled = true;

bool ai = false;

bool terminate = false;
bool keyUp = false;
bool keyDown = false;
bool keyLeft = false;
bool keyRight = false;
bool keyFire = false;
bool keyExit = false;

/*
** Find min of two variables
*/
int min (int a, int b)
{
    if (a < b)
	return a;
    return b;
}

/*
** Send a formated text (like printf) to the message widget txtMsg
*/
void debug (const char *fmt, ...)
{
    va_list ap;

    if (debug_flag)
	{
	    va_start (ap, fmt);	// init varargs list
	    vprintf (fmt, ap);	// print string formated to txt buffer
	}
}

#if AUDIO == 0
Mix_Chunk *chunk[4];

void load_sound (char *file_name, char *file_name2, byte s)
{
    if (!(chunk[s] = Mix_LoadWAV (file_name)))
	if (!(chunk[s] = Mix_LoadWAV (file_name2)))
    {
		printf ("Could not Mix_LoadWAV() file %s or %s.\n", file_name, filename2);
    }
}

void play_sound (byte s)
{
    Mix_PlayChannel (-1, chunk[s], 0);
}

Mix_Music *midi = NULL;

void play_music (void)
{
    Mix_HaltMusic ();
    Mix_PlayMusic (midi, -1);
}

#else

#define MIXER_SOUNDS 8
struct sample
{
    Uint8 *data;
    Uint32 dpos;
    Uint32 dlen;
} sounds[MIXER_SOUNDS];

SDL_AudioCVT cvt[4];

void sound_mixer (void *not_used, Uint8 * stream, int len)
{
    int i;
    Uint32 mix;

    for (i = 0; i < MIXER_SOUNDS; ++i)
	{
	    mix = (sounds[i].dlen - sounds[i].dpos);
	    if (mix > len)
		mix = len;

	    SDL_MixAudio (stream, &sounds[i].data[sounds[i].dpos], mix, SDL_MIX_MAXVOLUME);
	    sounds[i].dpos += mix;
	}
}

void load_sound (char *file_name, char *file_name2, byte s)
{
    SDL_AudioSpec wave;
    Uint8 *data;
    Uint32 dlen;

    if (SDL_LoadWAV (file_name, &wave, &data, &dlen) == NULL)
	{
	    if (SDL_LoadWAV (file_name2, &wave, &data, &dlen) == NULL)
		{
		    printf ("Could not SDL_LoadWAV() file %s or %s.\n", file_name, file_name2);
		    exit (-200);
		}
	}
    SDL_BuildAudioCVT (&cvt[s], wave.format, wave.channels, wave.freq, AUDIO_S16, 1, 8000);
    cvt[s].buf = malloc ((size_t) dlen * cvt[s].len_mult);
    memcpy (cvt[s].buf, data, dlen);
    cvt[s].len = dlen;
    SDL_ConvertAudio (&cvt[s]);
    SDL_FreeWAV (data);
}

void play_sound (byte s)
{
    int i;
    for (i = 0; i < MIXER_SOUNDS; ++i)
    {
	    if (sounds[i].dpos == sounds[i].dlen)
	        break;
    }
    if (i == MIXER_SOUNDS)
	return;

    SDL_LockAudio ();
    sounds[i].data = cvt[s].buf;
    sounds[i].dlen = cvt[s].len_cvt;
    sounds[i].dpos = 0;
    SDL_UnlockAudio ();
}

void play_music (void)
{

}
#endif


SDL_Surface *mirror_image (SDL_Surface * src)
{
    int i, j;
    SDL_Surface *surface;

    surface =
	SDL_CreateRGBSurface (SDL_SWSURFACE, src->w, src->h, DEPTH, 0x00ff0000, 0x0000ff00,
			      0x000000ff, 0xff000000);

    surface = SDL_ConvertSurface(surface, src->format, SDL_SWSURFACE);

    for (j = 0; j < src->h; j++)
    {
	    for (i = 0; i < src->w; i++)
	    {
	        *(Uint32 *) ((Uint32 *) surface->pixels + j * surface->pitch / 4 + i) =
            *(Uint32 *) ((Uint32 *) src->pixels + j * src->pitch / 4 + (src->w - i - 1));
        }
    }    
    return surface;
}

SDL_Surface *rotate_image (SDL_Surface * src)
{
    int i, j;
    SDL_Surface *surface;

    surface =
	SDL_CreateRGBSurface (SDL_SWSURFACE, src->w, src->h, DEPTH, 0x00ff0000, 0x0000ff00,
			      0x000000ff, 0xff000000);

    surface = SDL_ConvertSurface(surface, src->format, SDL_SWSURFACE);

    for (j = 0; j < src->w; j++)
    {
	    for (i = 0; i < src->w; i++)
	    {
	        *(Uint32 *) ((Uint32 *) surface->pixels + j + (src->w - i - 1) * src->w) =
            *(Uint32 *) ((Uint32 *) src->pixels + i + j * src->w);
        }
    }                
    return surface;
}

#if ZOOM == 1
void scale_image (SDL_Surface * src, SDL_Surface * dst)
{
    int i, j, dx, dy, x, y;
    Uint16 *psrc, *pdst;
    Uint16 *px, *py;		//*ppx, p, pp, pq;
    const int fxp = 16;

    if (!dst)
	return;

    psrc = (Uint16 *) src->pixels;
    pdst = (Uint16 *) dst->pixels;

    dx = (src->w << fxp) / dst->w;
    dy = (src->h << fxp) / dst->h;
    x = 0;
    y = 0;

    for (j = 0; j < dst->h; j++)
	{

	    py = ((y >> fxp) * src->w) + psrc;
	    y += dy;
	    x = 0;

	    for (i = 0; i < dst->w; i++)
		{

		    px = py + (x >> fxp);
		    *pdst = *px;
		    pdst++;
		    x += dx;
		}
	}
}
#endif

SDL_Surface *recolor_image (SDL_Surface * src, int k)
{
    int i, j;
    Uint32 c1 = 0, c2 = 0, c3 = 0, c4 = 0, p;
    SDL_Surface *surface;

    surface = SDL_CreateRGBSurface (SDL_SWSURFACE, src->w, src->h, DEPTH, 0x00ff0000, 0x0000ff00, 0x000000ff, 0xff000000);
    surface = SDL_ConvertSurface (surface, src->format, SDL_SWSURFACE);
    SDL_FillRect (surface, NULL, 0xffffc6ff);
    SDL_BlitSurface (src, NULL, surface, NULL);
    SDL_SetColorKey (surface, SDL_SRCCOLORKEY, SDL_MapRGB (surface->format, 0xff, 0xc6, 0xff));
    surface = SDL_DisplayFormatAlpha (surface);

    switch (k)
	{
	    case 0:
		c1 = 0xff5a5a6b;
		c2 = 0xff39394a;
		c3 = 0xff5a5a6b;
		c4 = 0xff39394a;
		break;

	    case 1:
		c1 = 0xff5a9cff;
		c2 = 0xff3963bd;
		c3 = 0xff5a9cff;
		c4 = 0xff3963bd;
		break;

	    case 2:
		c1 = 0xff6bf76b;
		c2 = 0xff29b54a;
		c3 = 0xff6bf76b;
		c4 = 0xff298c4a;
		break;

	    case 3:
		c1 = 0xffe73929;
		c2 = 0xff9c2939;
		c3 = 0xffe73929;
		c4 = 0xff7b2939;
		break;
	}

    for (j = 0; j < src->h; j++)
    {
	    for (i = 0; i < src->w; i++)
	    {
		    p = *(Uint32 *) ((Uint32 *) surface->pixels + i + j * src->w);

            if (p == 0xff9cbdad)
		        *(Uint32 *) ((Uint32 *) surface->pixels + i + j * src->w) = c2;
            if (p == 0xfffff7e7)
		        *(Uint32 *) ((Uint32 *) surface->pixels + i + j * src->w) = c1;
            if (p == 0xff5a31b5)
		        *(Uint32 *) ((Uint32 *) surface->pixels + i + j * src->w) = c4;
            if (p == 0xff8c6bef)
		        *(Uint32 *) ((Uint32 *) surface->pixels + i + j * src->w) = c3;
	    }
	}    
    return surface;
}


SDL_Surface *create_image (SDL_Surface * source, SDL_Rect * srect, SDL_Rect * drect)
{
    SDL_Surface *surface;

    surface =
	SDL_CreateRGBSurface (SDL_SWSURFACE, srect->w, srect->h, DEPTH, 0x000000ff, 0x0000ff00,
			      0x00ff0000, 0xff000000);
    surface = SDL_ConvertSurface(surface, source->format, SDL_SWSURFACE);
       
    SDL_BlitSurface (source, srect, surface, drect);
    SDL_SetColorKey (surface, SDL_SRCCOLORKEY, SDL_MapRGB (surface->format, 0xff, 0xc6, 0xff));
    return SDL_DisplayFormatAlpha (surface);
}

SDL_Rect *crect(SDL_Rect *rect,int x, int y, int w, int h)
{
    rect->x = x;
    rect->y = y;
    rect->w = w;
    rect->h = h;
    
    return(rect);
}    

void load_image (char *file_name)
{
    int i, j;
    SDL_Surface *source;
    SDL_Rect srect, drect;
    FILE *file;
    char index;			//c
    int c;

    screen_buf =
	SDL_ConvertSurface (SDL_CreateRGBSurface
			    (SDL_SWSURFACE, 240, 228, DEPTH, 0x000000ff, 0x0000ff00, 0x00ff0000,
			     0xff000000), screen->format, SDL_SWSURFACE);
    background =
	SDL_ConvertSurface (SDL_CreateRGBSurface
			    (SDL_SWSURFACE, 240, 208, DEPTH, 0x000000ff, 0x0000ff00, 0x00ff0000,
			     0xff000000), screen->format, SDL_SWSURFACE);

    source = SDL_LoadBMP (LIB_PATH "/Arial_10.bmp");
    if (!source) source = SDL_LoadBMP ("./Arial_10.bmp");
    if (!source)
	{
	    printf ("Could not load Arial_10.bmp\n");
	    exit (-301);
	}
    InitFont (source);

    leftgui = SDL_LoadBMP (LIB_PATH "/leftgui.bmp");
    if (!leftgui) leftgui = SDL_LoadBMP ("./leftgui.bmp");
    if (!leftgui)
	{
	    printf ("Could not load leftgui.bmp\n");
	    exit (-302);
	}

    rightgui = SDL_LoadBMP (LIB_PATH "/rightgui.bmp");
    if (!rightgui) rightgui = SDL_LoadBMP ("./rightgui.bmp");
    if (!rightgui)
	{
	    printf ("Could not load rightgui.bmp\n");
	    exit (-303);
	}

    source = SDL_LoadBMP (file_name);
    if (!source) source = SDL_LoadBMP (LIB_PATH "/Bomberman.bmp");
    if (!source) source = SDL_LoadBMP ("./Bomberman.bmp");
    if (!source)
	{
	    printf ("Could not load Bomberman.bmp\n");
	    exit (-300);
	}

    crect(&srect,0,0,18,24);
    crect(&drect,0,0,18,24);

    for (i = 0; i < 4; i++)
	{
	    srect.x = i * 19;
	    player[0][i] = create_image (source, &srect, &drect);

	    srect.x = (4 + i) * 19;
	    player[0][14 + i] = create_image (source, &srect, &drect);
	}

    for (i = 1; i < 4; i++)
	{
	    player[0][3 + i] = mirror_image (player[0][i]);
	    player[0][17 + i] = mirror_image (player[0][14 + i]);
	}

    for (i = 0; i < 7; i++)
	{
	    srect.x = (8 + i) * 19;
	    player[0][7 + i] = create_image (source, &srect, &drect);
	    player[0][21 + i] = mirror_image (player[0][7 + i]);
	}

    for (i = 0; i < 9; i++)
	{
	    srect.x = (15 + i) * 19;
	    player[0][28 + i] = create_image (source, &srect, &drect);
	}

	debug("Create images...\n");

    for (i = 1; i < 5; i++)
        for (j = 0; j < 37; j++)
	        player[i][j] = recolor_image (player[0][j], i - 1);

	debug("Recolor images...\n");
	
    crect(&srect,0,25,16,16);
    crect(&drect,0,0,16,16);

    for (i = 0; i < 17; i++)
	{
	    srect.x = i * 17;
	    tile[i] = create_image (source, &srect, &drect);
	}

    for (i = 0; i < 4; i++)
	{
	    srect.x = (17 + i * 3) * 17;
	    tile[17 + 8 + i * 9] = create_image (source, &srect, &drect);

	    srect.x = (18 + i * 3) * 17;
	    tile[17 + 3 + i * 9] = create_image (source, &srect, &drect);

	    tile[17 + 1 + i * 9] = tile[17 + 3 + i * 9];

	    srect.x = (19 + i * 3) * 17;
	    tile[17 + 5 + i * 9] = create_image (source, &srect, &drect);

	    tile[17 + 7 + i * 9] = mirror_image (tile[17 + 5 + i * 9]);

	    tile[17 + 4 + i * 9] = rotate_image (tile[17 + 5 + i * 9]);
	    tile[17 + 6 + i * 9] = rotate_image (tile[17 + 7 + i * 9]);
	    tile[17 + i * 9] = rotate_image (tile[17 + 1 + i * 9]);
	    tile[17 + 2 + i * 9] = tile[17 + i * 9];
	}

    for (i = 0; i < 6; i++)
	{
	    srect.x = (29 + i) * 17;
	    tile[53 + i] = create_image (source, &srect, &drect);
	}


    for (i = 0; i < 15; i++)
    {
      for (j = 0; j < 13; j++)
        theme_arena[i][j] = 127;
    }        

    srect.y = 42;
    if (source->h == 58)
	{
	    for (i = 0; i < 35; i++)
		{
		    srect.x = i * 17;
		    special[i] = create_image (source, &srect, &drect);
		}

	    srect.x = 0;
	    srect.y = 0;
	    strcpy (file_name + strlen (file_name) - 3, "scn");

	    if ((file = fopen (file_name, "r")))
		{
		    while ((c = fgetc (file)) != EOF)
			{
			    switch (c)
				{
				    case '0':
					if (!background2)
                    {
						background2 = SDL_ConvertSurface (SDL_CreateRGBSurface
									(SDL_SWSURFACE, 240, 208,
									 DEPTH, 0x000000ff,
									 0x0000ff00, 0x00ff0000,
									 0xff000000),
									screen->format,
									SDL_SWSURFACE);
						SDL_FillRect (background2, NULL, 0xffc6ff);
                    }
					index = fgetc (file) - '0';
					drect.x = (fgetc (file) - '0') * 16;
					drect.y = (fgetc (file) - '0') * 16;
					SDL_BlitSurface (special[(int) index], NULL, background2,&drect);
					break;

				    case '1':
					drect.x = fgetc (file) - '0';
					drect.y = fgetc (file) - '0';
					theme_arena[drect.x][drect.y] = fgetc (file) - '0';
					break;

				    case '\n':
				    case '\r':
					break;

				    default:
					printf ("Could not handle .scn\n");
					exit (-800);
					break;
				}
			}
		    if (background2)
			{
			    SDL_SetColorKey (background2, SDL_SRCCOLORKEY,
					     SDL_MapRGB (background2->format, 0xff, 0xc6, 0xff));
			    SDL_DisplayFormatAlpha (background2);
			}
		    fclose (file);
		}
	}
}

SDL_Surface *theme_tile (int def, int i, int j)
{
    if (theme_arena[i][j] == 127)
	return tile[def];
    return special[theme_arena[i][j]];
}

int receiver_function (void *screen_lock)
{
    int i, j, k;
    int playerX[5], playerY[5];
    byte playerImage[5];
    byte zbuf[5];
    long time = 0, t;
    SDL_Rect rect, srect;
    struct sockaddr_in _addr;
    int data_len;
    byte data[BOMBERMAN_PACKETLENGTH];

    debug ("Receiver thread started...\n");

    SDL_FillRect (screen_buf, crect(&rect,0,0,240,20), 0xff203890);

    SDL_BlitSurface (tile[0], NULL, screen_buf, crect(&rect,8,2,16,16));

    crect(&rect,0,2,18,24);

    for (i = 0; i < 5; i++)
	{
	    rect.x = 56 + i * 35;
	    SDL_BlitSurface (player[i][0], NULL, screen_buf, &rect);
	}
	
    SDL_FillRect (screen_buf, crect(&rect,0,18,240,2), 0xff203890);

    rect.w = 16;
    rect.h = 16;

    for (i = 0; i < 13; i++)
	{
	    for (j = 0; j < 11; j++)
		{
		    rect.x = 16 + i * 16;
		    rect.y = 16 + j * 16;
		    SDL_BlitSurface (theme_tile (12, 1 + i, 1 + j), NULL, background, &rect);
		    rect.x = 32 + (i % 6) * 32;
		    rect.y = 32 + (j % 5) * 32;
		    SDL_BlitSurface (theme_tile (2, 2 + (i % 6) * 2, 2 + (j % 5) * 2), NULL,
				     background, &rect);
		}
	    rect.x = 0;
	    rect.y = i * 16;
	    SDL_BlitSurface (theme_tile (1, 0, i), NULL, background, &rect);
	    rect.x = 14 * 16;
	    rect.y = i * 16;
	    SDL_BlitSurface (theme_tile (1, 14, i), NULL, background, &rect);
	    rect.x = 16 + i * 16;
	    rect.y = 0;
	    SDL_BlitSurface (theme_tile (1, 1 + i, 0), NULL, background, &rect);
	    rect.x = 16 + i * 16;
	    rect.y = 12 * 16;
	    SDL_BlitSurface (theme_tile (1, 1 + i, 12), NULL, background, &rect);
	}

    for (i = 0; i < 5; i++)
	  playerY[i] = 255;

	debug("Draw GUI.0\n");   
	  
    // Clean screen
    SDL_FillRect (screen, crect(&rect,0,0,799,20), 0x00000000);
	  
    // Draw left and right GUI	  

    SDL_BlitSurface(leftgui, NULL, screen, crect(&rect,0,0,160,480));
    rect.x = 480+160; // Other values are still present ^^^^^^^^^^
    SDL_BlitSurface(rightgui, NULL, screen, &rect);

	debug("Draw GUI.1\n");   
    
    if (swapkeys_enabled)
    {	// Temp position is 320,160 (160x160)
    
        // Swap upper two buttons 
        SDL_BlitSurface(screen, crect(&srect,0,0,159,159), screen, crect(&rect,320,159,159,159));
        SDL_BlitSurface(screen, crect(&srect,640,0,159,159), screen, crect(&rect,0,0,159,159));
        SDL_BlitSurface(screen, crect(&srect,320,159,159,159), screen, crect(&rect,640,0,159,159));

        // Swap lower two buttons 
        SDL_BlitSurface(screen, crect(&srect,0,320,159,159), screen, crect(&rect,320,159,159,159));
        SDL_BlitSurface(screen, crect(&srect,640,320,159,159), screen, crect(&rect,0,320,159,159));
        SDL_BlitSurface(screen, crect(&srect,320,159,159,159), screen, crect(&rect,640,320,159,159));
    }
    
    debug("Draw GUI.2\n");   
    
    SDL_UpdateRects (screen, 1, crect(&rect,0,0,800,480));
	//SDL_mutexV ((SDL_mutex *) screen_lock);

    while (!terminate)
	{
	    data_len = sizeof (struct sockaddr);
	    if (((data_len = recvfrom (_socket, data, sizeof (data), 0, (struct sockaddr *) &_addr, &data_len)) == -1))
		{
		    printf ("Error receiving socket.\n");
		    exit (-100);
		}
	    i = 0;

	    while (data[i] != BOMBERMAN_IDLE)
		{
		    switch (data[i])
			{
			    case BOMBERMAN_PLAYER:
				i++;
				playerX[data[i]] = (((int) data[i + 1]) + 256) % 256;
				playerY[data[i]] = ((((int) data[i + 2]) + 256) % 256) + 20;
				playerImage[data[i]] = data[i + 3];
				if (ai) ai_player (data[i], playerX[data[i]], playerY[data[i]] - 20, playerImage[data[i]]);
				// printf("ID 0: Player id=%d X=%d Y=%d img=%d\n", data[i],playerX[data[i]], playerY[data[i]]-20, playerImage[data[i]]);

				i += 4;
				break;

			    case BOMBERMAN_ARENA:
				    if (ai) ai_arena (data[i + 1], data[i + 2], data[i + 3]);	// Manage AI

				    crect(&rect,16*data[i+1], 16*data[i+2], 16, 16);
				    SDL_BlitSurface (tile[data[i + 3]], NULL, background, &rect);
				    i += 4;
				    break;

			    case BOMBERMAN_AI:
				    i++;
				    if (ai) ai_info (data[i]);
				    i++;
				    break;

			    case BOMBERMAN_TEXT:
				    if (data[++i] < 5)
				        i += data[i + 1] + 2;
                    break;

			    case BOMBERMAN_STATUS:
				    if (data[++i] == 5)
				    {
					    char status_time[5] = "X:XX";
                        byte m = data[++i];
                        byte s = data[++i];
                        status_time[0] = '0' + m;
                        status_time[2] = '0' + s / 10;
                        status_time[3] = '0' + s % 10;

					    SDL_FillRect (screen_buf, crect(&rect,26,6,28,10), 0xff203890);
					    PutString (screen_buf, 26, 6, status_time);
					    i++;
                    }
                    else
                    {
					    char status_frags[4] = "-XX";
					    byte p = data[i++];
					    byte f = data[i++];
					    if (f >= 0)
					        status_frags[0] = ' ';
                        else
					        status_frags[0] = '-';
                        f = abs (f);
                        status_frags[1] = '0' + f / 10;
                        status_frags[2] = '0' + f % 10;

					    crect(&rect,72 + p * 35,6,20,10);
					    SDL_FillRect (screen_buf, &rect, 0xff203890);
					    PutString (screen_buf, 72 + p * 35, 6, status_frags);
                    }
                    break;

			    case BOMBERMAN_SOUND:
				    if (sound_enabled)
				        play_sound (data[i + 1]);
                    i += 2;
                    break;

			    case BOMBERMAN_MUSIC:
				    if (music_enabled)
				        play_music ();
                    i++;
                    break;

			    default:
				    printf ("Error handling data.\n");
				    exit (-101);
				    break;
            }
		}
	    SDL_BlitSurface (background, NULL, screen_buf, crect(&rect,0,20,240,208));

	    for (i = 0; i < 5; i++)
		{
		    byte j;
		    for (j = 0; j < i; j++)
			if (playerY[zbuf[j]] > playerY[i])
			    break;
		    for (k = 4; k > j; k--)
			zbuf[k] = zbuf[k - 1];
		    zbuf[j] = i;
		}

	    for (i = 0; i < 5; i++)
		if (playerY[zbuf[i]] < 255)
        {
			crect(&rect,playerX[zbuf[i]],playerY[zbuf[i]],18,24);
			SDL_BlitSurface (player[zbuf[i]][playerImage[zbuf[i]]], NULL, screen_buf,
					 &rect);
        }
	    if (background2)
		{
		    crect(&rect,0,20,240,208);
		    SDL_BlitSurface (background2, NULL, screen_buf, &rect);
		}
	    t = clock ();
	    if (t - time > 50)
		{
		    time = t;

		    SDL_mutexP ((SDL_mutex *) screen_lock);
		    rect.x = 0;
		    rect.y = 0;
		    rect.w = screen_width;
		    rect.h = screen_height;

#if ZOOM == 1
		    //SDL_BlitSurface(screen_buf, NULL, screen, &rect);
		    scale_image (screen_buf, screen);
#else
		    SDL_SoftStretch (screen_buf, crect(&srect,0,0,240,228), 
		        screen, crect(&rect,160,8,480,456));
#endif
		    SDL_UpdateRects (screen, 1, &rect);
		    SDL_mutexV ((SDL_mutex *) screen_lock);
		}
	}
    return 0;
}

int sender_function (void *_lock)
{
    SDL_mutex *lock;

    lock = (SDL_mutex *) _lock;

    while (!terminate)
	{
	    data[0] = BOMBERMAN_IDLE;
	    if (keyUp)
		    data[0] = BOMBERMAN_UP;
	    else if (keyDown)
		    data[0] = BOMBERMAN_DOWN;
	    else if (keyLeft)
		    data[0] = BOMBERMAN_LEFT;
	    else if (keyRight)
		    data[0] = BOMBERMAN_RIGHT;
	    if (keyFire)
		    data[0] |= BOMBERMAN_FIRE;
	    if (sendto (_socket, data, 2, 0, (struct sockaddr *) &_addr, sizeof (struct sockaddr)) == -1)
		    debug ("ID 0: sento failed!\n");
	    SDL_Delay (100);
	}

    data[0] = BOMBERMAN_PING;
    sendto (_socket, data, 2, 0, (struct sockaddr *) &_addr, sizeof (struct sockaddr));

    return 0;
}

int y_msg = 2;

void display_message (char *msg)
{
    SDL_Rect rect;

    PutString (screen, 2, y_msg, msg);
    y_msg += 14;

    rect.x = 0;
    rect.y = 0;
    rect.w = screen_width;
    rect.h = screen_height;
    SDL_UpdateRects (screen, 1, &rect);
}

void clearkeys(void)
{
    keyUp = false;
    keyDown = false;
    keyLeft = false;
    keyRight = false;
    keyFire = false;
}    

int main (int argc, char *argv[])
{
    char *nickname = NULL;
    int i, k, client_port = 1034;
    char theme_path[256];
    struct hostent *h;
    // char         *client_host;
    int bgclient = 0;

    SDL_Thread *receiver_thread;
    SDL_Thread *sender_thread = NULL;
    SDL_Thread *ai_thread;
    SDL_mutex *screen_lock;
    SDL_mutex *key_lock;
    SDL_Rect rect;

    strcpy (theme_path, LIB_PATH);
    server_host = NULL;
    server_port = 1033;

    for (i = 0; i < argc; i++)
	{
	    if (!strncmp (argv[i], "-p", 2))
		{
		    client_port = atoi (argv[++i]);
		}
	    else if (!strncmp (argv[i], "-h", 2))
		{
		    server_host = argv[++i];
		}
	    else if (!strncmp (argv[i], "-s", 2))
		{
		    server_port = atoi (argv[++i]);
		}
	    else if (!strncmp (argv[i], "-n", 2))
		{
		    nickname = argv[++i];
		}
	    else if (!strncmp (argv[i], "-q", 2))
		{
		    sound_enabled = false;
		}
	    else if (!strncmp (argv[i], "-w", 2))
		{
		    swapkeys_enabled = true;
		}
	    else if (!strncmp (argv[i], "-m", 2))
		{
		    music_enabled = true;
		}
	    else if (!strncmp (argv[i], "-t", 2))
		{
		    strcpy (theme_path, argv[++i]);
		}
	    else if (!strncmp (argv[i], "-a", 2))
		{
		    ai = true;
		}
	    else if (!strncmp (argv[i], "-g", 2))
		{
		    smooth_enabled = false;
		}
	    else if (!strncmp (argv[i], "-d", 2))
		{
		    debug_flag = true;
		}
	    else if (!strncmp (argv[i], "-b", 2))
		{
		    bgclient = atoi (argv[++i]);
		    printf ("Start %d background AI client(s)...\n", bgclient);
		}
	    else if (!strncmp (argv[i], "-?", 2))
		{
		    printf ("Bomberman SDL/C Version (" __DATE__ ") by Robert Hockauf\n"
			    "(c) 2002 by Robert Hockauf. Ditributed under GPL Version 2.\n"
			    "Sharp Zaurus (2004) & Nokia 770 (2006) port by Klaus Rotter. kr@rotters.de\n"
			    "Usage:\n"
			    "\t-a\tenable AI. Computer steers player\n"
			    "\t-b #\tbackground player. Launches # background players (with AI)\n"
			    "\t-h addr\tspecifies server host address\n"
			    "\t-s port\tserver port\n"
			    "\t-p port\tclient port\n"
			    "\t-n name\tnickname used\n"
			    "\t-q\tno sound output\n"
			    "\t-w\tswap softkeys\n" "\t-?\tdisplay help message\n");
		}
	}

    debug ("LIB PATH %s\n", LIB_PATH);

    if (SDL_Init (SDL_INIT_VIDEO | SDL_INIT_AUDIO) < 0)
	{
	    printf ("SDL_Init() failed.\n");
	    return -1;
	}

	if (debug_flag) 
	{
	    SDL_VideoInfo *si;
	  
	    si = SDL_GetVideoInfo();
	  
	    printf("hw:%d wm:%d blit:%d cc:%d alpha:%d\n",si->hw_available,
	        si->wm_available, si->blit_hw, si->blit_hw_CC, si->blit_hw_A);
	    printf("swblit:%d swcc:%d swalpha:%d colfil:%d\n", si->blit_sw,
            si->blit_sw_CC, si->blit_sw_A, si->blit_fill);
        printf("Max gfx-mem:%08x pixel-fmt:%d\n",si->video_mem, si->vfmt->BitsPerPixel);
  	}

    screen_width = 800, screen_height = 480;	// Fullscreen Mode
    screen = SDL_SetVideoMode (screen_width, screen_height, SCREEN_DEPTH,SDL_ANYFORMAT | SDL_FULLSCREEN | SDL_HWSURFACE);

    if (!screen)
	{
	    printf ("SDL_SetVideoMode() failed.\n");
	    return -2;
	}

    SDL_WM_SetCaption ("bomberman", NULL);
    SDL_ShowCursor(SDL_DISABLE); // Disable Mousecursor
    
    if ((_socket = socket (AF_INET, SOCK_DGRAM, 0)) == -1)
	{
	    printf ("Could not open Socket.\n");
	    return -4;
	}

    strcat (theme_path, "/Bomberman.bmp");

    load_image (theme_path);
    debug("Image loading passed...\n");

    gethostname (data, sizeof (data) - 1);
    debug ("hostname: %s\n", data);
    h = gethostbyname (data);

    i = 0;

    debug ("struct hostent:\n\th_name: %s\n", h->h_name);
    while (h->h_aliases[i] != 0)
	{
	    debug ("\talias %d:%s\n", i, h->h_aliases[i]);
	    i++;
	}
    debug ("\th_addrtype: %d\n", h->h_addrtype);
    debug ("\th_length: %d\n", h->h_length);
    i = 0;
    while (h->h_addr_list[i] != 0)
	{
	    debug ("\taddr %d: ", i);
	    for (k = 0; k < h->h_length; k++)
		debug ("%d.", h->h_addr_list[i][k]);
	    i++;
	    debug ("\n");
	}
    client_host = inet_ntoa (*((struct in_addr *) h->h_addr));
    if (!server_host)
	server_host = client_host;

    _addr.sin_family = AF_INET;
    _addr.sin_port = htons (client_port);
    _addr.sin_addr.s_addr = inet_addr (client_host);
    memset (&(_addr.sin_zero), '\0', 8);
    if (bind (_socket, (struct sockaddr *) &_addr, sizeof (struct sockaddr)) == -1)
	return -5;

    if (sound_enabled)
	{
#if AUDIO == 0
	    if (Mix_OpenAudio (44100, AUDIO_S16, 2, 4096))
		{
		    display_message ("sound fx disabled");
		    sound_enabled = false;
		}
#else
	    extern void sound_mixer (void *not_used, Uint8 * stream, int len);
	    SDL_AudioSpec format;
	    format.freq = 8000;
	    format.format = AUDIO_S16;
	    format.channels = 1;
	    format.samples = 512;
	    format.callback = sound_mixer;
	    format.userdata = NULL;

	    if (SDL_OpenAudio (&format, NULL) < 0)
		{
		    display_message ("sound fx disabled");
		    sound_enabled = false;
		}
	    else
		SDL_PauseAudio (0);
#endif

	    if (sound_enabled)
		{
		    char file_name[] = LIB_PATH "/BombermanX.wav";
		    char file_name2[] = "./BombermanX.wav";

		    for (i = 0; i < 4; i++)
			{
			    file_name[sizeof (LIB_PATH) + 9] = i + '0';
			    file_name2[11] = i + '0';
			    load_sound (file_name, file_name2, i);
			}
		}
	}

    if (music_enabled)
	{
	    strcpy (theme_path + strlen (theme_path) - 3, "mid");
#if AUDIO == 0
	    if (!(midi = Mix_LoadMUS (theme_path)))
		if (!(midi = Mix_LoadMUS (LIB_PATH "/Bomberman.mid")))
		    if (!(midi = Mix_LoadMUS ("./Bomberman.mid")))
			{
			    display_message ("music disabled");
			    music_enabled = false;
			}
#endif
	}

    data[0] = BOMBERMAN_PING;
    data[1] = BOMBERMAN_REQUEST;
    data[2] = 0;

    if (nickname)
	{
	    data[2] = min (8, strlen (nickname));
	    memcpy (&data[3], nickname, data[2]);
	}

    _addr.sin_family = AF_INET;
    _addr.sin_port = htons (server_port);
    _addr.sin_addr.s_addr = inet_addr (server_host);
    memset (&(_addr.sin_zero), '\0', 8);
    sendto (_socket, data, data[2] + 3, 0, (struct sockaddr *) &_addr, sizeof (struct sockaddr));


    screen_lock = SDL_CreateMutex ();
    key_lock = SDL_CreateMutex ();

    data_len = sizeof (struct sockaddr);

    // Blocking Input. Better use select() here. FIX ME! KR 01-2007
    // If the server didn't exist, the program hangs!
    // Read http://www.zotteljedi.de/doc/socket-tipps/ and
    // http://www.opengroup.org/onlinepubs/000095399/functions/recvfrom.html

    // Done - 2007-01-17 KR

    if (1)
	{
	    fd_set fds;
	    struct timeval tv;
	    int j, d;
	    char buf[100];

#define HOWLONG 60

	    sprintf (buf, "Connecting to server %s : %d", server_host, server_port);
	    display_message (buf);

	    j = 0;
	    i = y_msg;
	    do
		{
		    // Set up file descriptor/socket set, we only have one socket
		    FD_ZERO (&fds);
		    FD_SET (_socket, &fds);

		    // Wait 1 second
		    tv.tv_sec = 1;
		    tv.tv_usec = 0;

		    //SDL_mutexP(screen_lock);
		    rect.x = 0;
		    rect.y = i;
		    rect.w = 200;
		    rect.h = 14;
		    SDL_FillRect (screen, &rect, 0);

		    sprintf (buf, "Waiting for server  (%d  of  %d  sec)\n", j, HOWLONG);
		    y_msg = i;
		    display_message (buf);
		    d = select (_socket + 1, &fds, NULL, NULL, &tv);
		    j++;
		}
	    while (d < 1 && j < HOWLONG);

	    if (d < 1)		// HOWLONG seconds later, still timeout or error? Exit!
		{
		    display_message ("Timeout. Will exit. Bye bye...");
		    SDL_Delay (1000);

		    shutdown (_socket, SHUT_RDWR);
#if AUDIO == 0
		    if (sound_enabled)
			    Mix_CloseAudio ();
		    if (music_enabled)
			    Mix_FreeMusic (midi);
#endif
		    SDL_Quit ();
		    return 0;
		}
	}
    // Now we should have data to read, no more blocking... KR

    if (((data_len = recvfrom (_socket, data, sizeof (data), 0, (struct sockaddr *) &_addr, &data_len)) == -1) || data[1] > 4)
	{
	    display_message ("server not found or too many players");
	    exit(-300);
	}
    else
	{
	    player_id = data[1];

	    debug ("Player id=%d port=%d\n", player_id, client_port);

	    if (!(receiver_thread = SDL_CreateThread (receiver_function, screen_lock)))
		    return -7;
	    if (!(sender_thread = SDL_CreateThread (sender_function, key_lock)))
		    return -8;
	    if (ai)
		{
		    if (!(ai_thread = SDL_CreateThread (ai_run, &player_id)))
			return -9;
		}
	    if (bgclient > 0)
		{
		    for (i = 0; i < bgclient; i++)
			{
			    ai_bg_init (client_port + 1 + i);
			}
		}
	}

    while (1)			// Forever
	{
	    SDL_Event event;
	    SDLKey key;
	    SDL_WaitEvent (&event);

	    if (keyExit == true)
		event.type = SDL_QUIT;	// Dirty, but it works... KR

	    switch (event.type)
		{
		    int mx, my;
		
            case SDL_MOUSEBUTTONDOWN:
                mx = event.button.x;
                my = event.button.y;
                
                debug("Mousebutton %d pressed at (%d,%d)\n",
                        event.button.button, mx, my);
                        
                if (mx < 160) 			// left side
                {
                    clearkeys();
                    if (my < 160) 		// "Exit" pressed 
                    {  
                        if (swapkeys_enabled)
                            keyUp = true;
                        else    
                            keyExit = true;
                    }        
                    else if (my < 320)	// "Left" pressed
                    {  
                        keyLeft = true;  
                    }
                    else // my < 480	// drop bomb pressed
                    { 
                        if (swapkeys_enabled)
                            keyDown = true;
                        else    
                            keyFire = true;      
                    }            
                } 
                else if (mx > 640) // right side of gui
                {
                    clearkeys();
                    if (my < 160) 		// "Up" pressed
                    {  
                        if (!swapkeys_enabled)
                            keyUp = true;
                        else    
                            keyExit = true;
                    }        
                    else if (my < 320)	// "Right" pressed
                    {  
                        keyRight = true;  
                    }
                    else // my < 480	// "Down pressed
                    { 
                        if (!swapkeys_enabled)
                            keyDown = true;
                        else    
                            keyFire = true;      
                    }            
                }          
                break;
		
            case SDL_MOUSEBUTTONUP:
                mx = event.button.x;
                my = event.button.y;
                
                debug("Mousebutton Number %d released at (%d,%d)\n",
                        event.button.button, mx, my);
                clearkeys();
                break;
		
		    case SDL_KEYDOWN:
			    key = ((SDL_KeyboardEvent *) & event)->keysym.sym;
                debug ("Key = %08x\n", (int) key);
                SDL_mutexP (key_lock);
                switch (key)
                {	
				case SDLK_UP:
				    keyUp = true;
				    break;
				case SDLK_DOWN:
				    keyDown = true;
				    break;
				case SDLK_LEFT:
				    keyLeft = true;
				    break;
				case SDLK_RIGHT:
				    keyRight = true;
				    break;
#ifdef ZAURUS
				case SDLK_SPACE:	// Center-Button Sharp Zaurus
#else
				case 0x0d:			// Center Button Nokia 770                                     
#endif
				    keyFire = true;
				    break;
#ifdef ZAURUS
				case 0x0126:		// Mail-Button Sharp Zaurus
#else
				case SDLK_F5:		// ESC or Home Key Nokia 770
				case SDLK_ESCAPE:
#endif
				    keyExit = true;
				    break;
				default:
				    break;
            }
			SDL_mutexV (key_lock);
			break;

		    case SDL_KEYUP:
			  key = ((SDL_KeyboardEvent *) & event)->keysym.sym;
			  SDL_mutexP (key_lock);

			switch (key)
			    {
				case SDLK_UP:
				    keyUp = false;
				    break;
				case SDLK_DOWN:
				    keyDown = false;
				    break;
				case SDLK_LEFT:
				    keyLeft = false;
				    break;
				case SDLK_RIGHT:
				    keyRight = false;
				    break;
#ifdef ZAURUS
				case SDLK_SPACE:	// Center-Button Sharp Zaurus
#else
				case 0x0d:	// Center Button Nokia 770                                     
#endif
				    keyFire = false;
				    break;
				default:
				    break;
			    }
			SDL_mutexV (key_lock);
			break;

		    case SDL_QUIT:
			SDL_mutexP (screen_lock);
			SDL_FillRect (screen, crect(&rect,0,0,screen_width, screen_height), 0);
			y_msg = 2;
#if 0
			display_message ("Bomberman");
			display_message ("(c) 2000 by Robert Hockauf");
			display_message ("Not for commercial use!");
			display_message ("ported to Sharp Zaurus & Nokia 770 by Klaus Rotter");
			display_message ("(compiled " __DATE__ ") kr@rotters.de");
#endif
			terminate = true;
			if (sender_thread)
			    SDL_WaitThread (sender_thread, NULL);

			shutdown (_socket, SHUT_RDWR);
#if AUDIO == 0
			if (sound_enabled)
			    Mix_CloseAudio ();
			if (music_enabled)
			    Mix_FreeMusic (midi);
#endif
			SDL_Delay (500);
			SDL_Quit ();
			return 0;

		    default:
			break;
		}
	}
    return 0;
}
