
# this is latex2html module which handles latex some of \listings issues and corrects latex2html outputting html codes

package main;

use File::Temp qw/ :POSIX /;

%lst_commands_hash = ( '\lstset' => '2', '\lstinputlisting' => '2');
local ($lst_langs,$lst_from_file);

# do_cmd_lstlistings subroutine handle \listings functionalities e.g. \lstset and \lstinputlisting commands.
sub do_cmd_lstlistings {
    my $list_cmd=@_[0];
    my ($tmp_langs,$lst_file,$lst_file_nbr,$lst_code_ff,$tag_regs);
    my ($tag_regs,$tmp_tags_r,$tmp_tags,$tmp_w_tags,$next_tag,$next_tag_r,$not_first);
    $lst_from_file='';
    my @lst_lang_arr=split("\n",$list_cmd);

    # loops through all the input lines which are spilted to single lines. Checks all the needed 
    # informations from \lstset and \lstinputlisting command e.g. Language and path to the files
    foreach $tmp_langs (@lst_lang_arr) {
      if ($tmp_langs=~s/(language=)(\w*\+*)(\s*\,\s*caption\=)/\<\!\-\- \1\2\3 \-\-\>/) {
        $lst_langs=((!$2)? '' : lc($2));
        $lst_langs=~s/bash/sh/;
        $lst_langs=~s/make/sh/; # current source-highlight doesn't support makefile
#        $lst_langs=~s/make/makefile/; # if source-highlight >= 2.10 this can be used. Comment in these cases upper line.
        $lst_langs=~s/c\+\+/C/;
      } elsif ($tmp_langs=~s/(language=)(\S*?)(\<)/\<\!\-\- $1$2 \-\-\>$3/) {
        $lst_langs=((!$2)? '' : lc($2));
        $lst_langs=~s/bash/sh/;
        $lst_langs=~s/make/sh/;
#        $lst_langs=~s/make/makefile/;
        $lst_langs=~s/c\+\+/C/;
      }
      $tmp_langs=~s/(begin\<\<\d+\>\>lstlisting\<\<\d+\>\>)/\1LANGUAGE $lst_langs /;
      if ($tmp_langs=~/\\lstinputlisting\s*<<(\d+)>>(\S+)?<<\1>>.*/) {
        $lst_file_nbr=$1;$lst_file=$2;
        if ($lst_file) {
          $lst_code_ff=&open_lstingfile($lst_file);
          $tmp_langs=~s/(\<\<$lst_file_nbr\>\>)$lst_file(\<\<$lst_file_nbr\>\>)/\1$lst_code_ff\2/ if ($lst_code_ff);
        }
      }
      # Removes all <P> tags. If needed remove comments from following line
#      $tmp_langs=~s/\\begin<<\d+>>tex2html_deferred<<\d+>>\\par\\end<<\d+>>tex2html_deferred<<\d+>>//;
      $lst_from_file.="\n$tmp_langs";
    }
    @lst_lang_arr=();
    $lst_from_file;
}

# open_lstingfile subroutine handles file opening (source code files) and execution of source-highlight.
sub open_lstingfile {
    my $lsint_file=@_[0];
    my $lst_after=@_[1];
    $lst_langs=@_[2] if @_[2];
    my $replace;
    if ($lsint_file) {
      $lsint_file=(($lsint_file=~/^\//) ? $lsint_file : "$texfilepath$dd$lsint_file");
      # checks that file exists
      if (-e $lsint_file) {
        # if -highlight option is used in latex2html execution highlighting is used
        if ($HIGHLIGHT) {
          # source_highlight_required subrutine is used to check that source-highlight is installed
          # requires also that $lst_langs is not empty (languege required)
          if ($lst_langs) {
            $replace = `$source_highlight_exec_path -f xhtml --input=$lsint_file --src-lang=$lst_langs --failsafe --output=STDOUT` or die "\nSOURCE HIGHLIGHT: $!\n";
            if (! $lst_after) {
              # if source code contains \ character[s] it source-highlighting is executed later
              # because \ character causes lots of problems otherwise
              if ( $replace=~/[\\]/msg ) {
                $replace="HIGHLIGHT_LATER,$lsint_file,$lst_langs";
              }
            }
          } else {
            $replace=&code_from_file($lsint_file,$lst_after);
          }
        # source code without highlighting
        } else {
          $replace=&code_from_file($lsint_file,$lst_after);
        }
      }
    }
    $replace;
}

# fix_characters subroutine replaces e.g. < and > characters in source codes.
# %html_specials can found from latex2html script
sub fix_characters {
    my $codeString=@_[0];
    my ($cLines,$html_chars,$codeOutput);
    my @codelines=split ("\n",$codeString);
    foreach $cLines (@codelines) {
      if ($cLines=~/<PRE>/) {
         $codeOutput.="$cLines";
        next;
      }
      foreach $html_chars (keys %html_specials) {
        $cLines=~s/$html_chars/$html_specials{$html_chars}/msg;
      }
      $codeOutput.="\n$cLines";
    }
    $codeOutput;
}

# opens source code file and places <PRE> and <CODE> tags
# returns content of source code file with needed html tags
sub code_from_file {
    my $ff_file=@_[0];
    my $code_rep_after=@_[1];
    my $code_rep;
    open(LST_FILE, "<$ff_file");
    $code_rep.='<PRE><CODE>';
    while (<LST_FILE>) {
       $code_rep.=$_;
    }
    close(LST_FILE);
    if (($code_rep=~/[\\]/msg) && (! $code_rep_after)) {
      $code_rep="HIGHLIGHT_LATER,$ff_file,$lst_langs";
    } else {
      $code_rep=&fix_characters($code_rep);
      $code_rep=~s/-/RPLchar/msg;
      $code_rep.='</CODE></PRE>';
    }
    $code_rep;  
}

# This subroutine is used when source code is in latex file instead of file and
# source highlighting is needed. Reads source code from latex file and writes it
# to file. Uses this file for source-highlight execution.
sub listings_translation_html {
   my $hl_args_str=@_[0];
   my ($ls_html_chars,@hl_brace,$tmp_brace,%brace_matches,$ls_tmp_file,$tmp_hl_args_str);
   $lst_langs=$2 if $hl_args_str=~s/(LANGUAGE\s)(\S*)\s//;
   # Removes all <P> tags. If needed remove comments from following line.
#   $hl_args_str=~s/\\begin\<\<\d+\>\>tex2html_deferred\<\<\d+\>\>\\par\\end\<\<\d+\>\>tex2html_deferred\<\<\d+\>\>//msg;

   @hl_brace=split(/\<\</,$hl_args_str);
   $hl_args_str='';
   foreach $tmp_brace (@hl_brace) {
     if ($tmp_brace=~/(\d+)\>\>/) {
       if ($brace_matches{$1}) {
         $tmp_brace=~s/\d+\>\>/}/;
       } else {
         $brace_matches{$1} = 1;
         $tmp_brace=~s/\d+\>\>/{/;
       }
     }
     $hl_args_str.=$tmp_brace; 
   }
   if ($HIGHLIGHT) {
     # creates tmp where source codes are placed. Tmp file is used with source-highlight.

       my  ($fh, $file) = tmpnam();
       print $fh $hl_args_str;
       close $fh;

     # source_highlight_required subrutine is used to check that source-highlight is installed
     # requires also that $lst_langs is not empty (languege required)
     if ($lst_langs) {
       $hl_args_str=`$source_highlight_exec_path -f xhtml --input=$file --src-lang=$lst_langs --failsafe --output=STDOUT` or die "\nSOURCE LIGHT: $!\n";
     } else {
       $hl_args_str=&code_from_file($file);
     }
     # removes created tmp file
     unlink($file);
   } else {
     $tmp_hl_args_str=$hl_args_str;
     $hl_args_str='<PRE><CODE>'."\n$hl_args_str";
     $hl_args_str.='</CODE></PRE>';
   }
   @hl_brace=();
   %brace_matches=();
   $hl_args_str;
}

# if \lstlisting is used in latex side this subroutine is called
sub do_env_lstlisting {
   my $tmp_args = @_[0];
   s/$next_pair_rx//o;
   my $tmp_lsts;
   local($tmp,$dum)=&get_next_optional_argument;

#   $tmp_args=~s/\<P\>//;
   # listings_translation_html subroutine is used to do the hard work
   $tmp_args=&listings_translation_html($tmp_args);
   $_= $tmp.$tmp_args;
}

sub do_source_highlighting {
   my ($content) = @_;
   my @lines = ();

   foreach my $line (split(/\n/, $content)) {
       if ($line =~ /<#(\d+)#>HIGHLIGHT_LATER,(\S+),(\S*)<#\1#>/g) {
	   my ($lstnbr, $lstfilepath, $lst_langs) = ($1, $2, $3);
	   my $hl_codes = &open_lstingfile($lstfilepath, '1', $lst_langs);
	   $line =~ s/(\<\#$lstnbr\#\>)HIGHLIGHT_LATER\,$lstfilepath\,$lst_langs(\<\#$lstnbr\#\>)/\1$hl_codes\2/ if ($hl_codes);
       }
       push @lines, $line, "\n";
   }

   join('', @lines);
}

1;
