/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(3D_CANVAS)

#include "JSWebGLContextAttributes.h"

#include "WebGLContextAttributes.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebGLContextAttributes);

/* Hash table */

static const HashTableValue JSWebGLContextAttributesTableValues[6] =
{
    { "alpha", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesAlpha), (intptr_t)setJSWebGLContextAttributesAlpha },
    { "depth", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesDepth), (intptr_t)setJSWebGLContextAttributesDepth },
    { "stencil", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesStencil), (intptr_t)setJSWebGLContextAttributesStencil },
    { "antialias", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesAntialias), (intptr_t)setJSWebGLContextAttributesAntialias },
    { "premultipliedAlpha", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesPremultipliedAlpha), (intptr_t)setJSWebGLContextAttributesPremultipliedAlpha },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWebGLContextAttributesTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSWebGLContextAttributesTableValues, 0 };
#else
    { 16, 15, JSWebGLContextAttributesTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSWebGLContextAttributesPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWebGLContextAttributesPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWebGLContextAttributesPrototypeTableValues, 0 };
#else
    { 1, 0, JSWebGLContextAttributesPrototypeTableValues, 0 };
#endif

const ClassInfo JSWebGLContextAttributesPrototype::s_info = { "WebGLContextAttributesPrototype", 0, &JSWebGLContextAttributesPrototypeTable, 0 };

JSObject* JSWebGLContextAttributesPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLContextAttributes>(exec, globalObject);
}

const ClassInfo JSWebGLContextAttributes::s_info = { "WebGLContextAttributes", 0, &JSWebGLContextAttributesTable, 0 };

JSWebGLContextAttributes::JSWebGLContextAttributes(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLContextAttributes> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSWebGLContextAttributes::~JSWebGLContextAttributes()
{
    forgetDOMObject(this, impl());
}

JSObject* JSWebGLContextAttributes::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSWebGLContextAttributesPrototype(JSWebGLContextAttributesPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSWebGLContextAttributes::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLContextAttributes, Base>(exec, &JSWebGLContextAttributesTable, this, propertyName, slot);
}

bool JSWebGLContextAttributes::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLContextAttributes, Base>(exec, &JSWebGLContextAttributesTable, this, propertyName, descriptor);
}

JSValue jsWebGLContextAttributesAlpha(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(imp->alpha());
    return result;
}

JSValue jsWebGLContextAttributesDepth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(imp->depth());
    return result;
}

JSValue jsWebGLContextAttributesStencil(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(imp->stencil());
    return result;
}

JSValue jsWebGLContextAttributesAntialias(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(imp->antialias());
    return result;
}

JSValue jsWebGLContextAttributesPremultipliedAlpha(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLContextAttributes* castedThis = static_cast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(imp->premultipliedAlpha());
    return result;
}

void JSWebGLContextAttributes::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSWebGLContextAttributes, Base>(exec, propertyName, value, &JSWebGLContextAttributesTable, this, slot);
}

void setJSWebGLContextAttributesAlpha(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebGLContextAttributes* castedThisObj = static_cast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThisObj->impl());
    imp->setAlpha(value.toBoolean(exec));
}

void setJSWebGLContextAttributesDepth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebGLContextAttributes* castedThisObj = static_cast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThisObj->impl());
    imp->setDepth(value.toBoolean(exec));
}

void setJSWebGLContextAttributesStencil(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebGLContextAttributes* castedThisObj = static_cast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThisObj->impl());
    imp->setStencil(value.toBoolean(exec));
}

void setJSWebGLContextAttributesAntialias(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebGLContextAttributes* castedThisObj = static_cast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThisObj->impl());
    imp->setAntialias(value.toBoolean(exec));
}

void setJSWebGLContextAttributesPremultipliedAlpha(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebGLContextAttributes* castedThisObj = static_cast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* imp = static_cast<WebGLContextAttributes*>(castedThisObj->impl());
    imp->setPremultipliedAlpha(value.toBoolean(exec));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLContextAttributes* object)
{
    return getDOMObjectWrapper<JSWebGLContextAttributes>(exec, globalObject, object);
}
WebGLContextAttributes* toWebGLContextAttributes(JSC::JSValue value)
{
    return value.inherits(&JSWebGLContextAttributes::s_info) ? static_cast<JSWebGLContextAttributes*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(3D_CANVAS)
