#!/scratchbox/tools/bin/python-host

#Author: Toni Timonen <toni.timonen@movial.fi>
#Copyright (C) 2006-2008 Movial Corporation
#License: GPL, see COPYING for details


import sys,os,re

import shutil

target=sys.argv[1]

tc_cruntime=False
if len(sys.argv) > 2 and sys.argv[2] == "cruntime":
	tc_cruntime=''.split()
	if not tc_cruntime:
		raise RuntimeError, 'Toolchain does not support installing cruntime separately'

target_files=[
	('/usr/bin','catchsegv getconf getent ldd locale localedef rpcinfo tzselect zdump rpcgen mtrace gencat'.split()),
	('/usr/sbin','iconvconfig zic'.split()),
	('/sbin','ldconfig'.split())
]

tc_libs='/scratchbox/compilers/linaro-4.7-2012.09-fremantle-armv7a/arm-none-linux-gnueabi/lib /scratchbox/compilers/linaro-4.7-2012.09-fremantle-armv7a/arm-none-linux-gnueabi/libc/lib /scratchbox/compilers/linaro-4.7-2012.09-fremantle-armv7a/arm-none-linux-gnueabi/libc/usr/lib'.split()
tc_bins='/scratchbox/compilers/linaro-4.7-2012.09-fremantle-armv7a/arm-none-linux-gnueabi/libc/sbin /scratchbox/compilers/linaro-4.7-2012.09-fremantle-armv7a/arm-none-linux-gnueabi/libc/usr/bin /scratchbox/compilers/linaro-4.7-2012.09-fremantle-armv7a/arm-none-linux-gnueabi/libc/usr/lib /scratchbox/compilers/linaro-4.7-2012.09-fremantle-armv7a/arm-none-linux-gnueabi/libc/usr/sbin'.split()
tc_header_dir='/scratchbox/compilers/linaro-4.7-2012.09-fremantle-armv7a/arm-none-linux-gnueabi/libc/usr/include'


filemap={}

for dst,files in target_files:
	filemap.update(dict.fromkeys(files,dst))
#Now filemap has format file->{directory where to install it}

def copytree(src,dst):
	if os.system('cp -arf %s %s'%(src,dst)):
			raise RuntimeError,'Failed copying tree (%s,%s)'%(src,dst)

def symlink(src,dst):
	try:
		os.symlink(src,dst)
	except OSError:
		os.unlink(dst)
		os.symlink(src,dst)


def shallow_copy(src,dst):
	if os.path.islink(src):
		symlink(os.readlink(src),dst)
	elif os.path.isfile(src):
		shutil.copy2(src,dst)
	elif os.path.isdir(src):
		copytree(src,dst)
	else:
		raise RuntimeError,'Copying %s to %s failed.'%(src,dst)


if os.system('mkdir -p %s/{lib,sbin,usr/{lib,include,{,s}bin}}' % target):
	raise RuntimeError,'mkdir failed'


if tc_cruntime:
	for f in tc_cruntime:
		shallow_copy(f, '%s/lib/%s'%(target, os.path.basename(f)))
	sys.exit()


for aDir in tc_libs:
	for f in os.listdir(aDir):
		fulln=aDir+'/'+f
		if os.path.isdir(fulln) or f.endswith('.la'): continue
		#Goes to usr/lib
		if re.match('.*/[^.-]*(\.(s?o|a)|\+\+\..*)$',fulln):
			shallow_copy(fulln,'%s/usr/lib/%s'%(target,f))
		else:
			shallow_copy(fulln,'%s/lib/%s'%(target,f))
		
		
#Fix symlinks
for f in ['%s/usr/lib/%s'%(target,x) for x in os.listdir('%s/usr/lib'%target)]:
	if not os.path.exists(f): #is a broken symlink
		alt_target='%s/lib/%s'%(target,os.path.basename(os.readlink(f)))
		if os.path.exists(alt_target):
			symlink(alt_target,f)



# Find gconv
for aDir in tc_libs: 
	for root,dirs,files in os.walk(aDir):
		if 'gconv' in dirs:
			copytree(os.path.join(root,'gconv'),'%s/usr/lib/'%target)
			break

# Copy binaries
for aDir in tc_bins:
	for root,dirs,files in os.walk(aDir):
		for f in files:
			if filemap.has_key(f):
				shutil.copy2('%s/%s'%(root,f),'%s/%s'%(target,filemap[f]))
			

#Copy headers
copytree('%s/*'%tc_header_dir,'%s/usr/include/'%target)

os.system('chmod a+x %s/lib/ld[\.-]*so*'%target)


#Some insane symlinks
symlink('/bin/cpp','%s/lib/cpp'%target)
symlink('/bin/cc','%s/usr/bin/cc'%target)
