/****************************************************************************
**
** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the test suite of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

struct SprintfDoubleData
{
    const char *fmt;
    const char *expected;
    int bytes[8];
};

static const SprintfDoubleData g_sprintf_double_data[] = {
    { "%'1g", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-'3g", "0  ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0'50g", "00000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-'.0g", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%'3.0g", "  0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-'50.0g", "0                                                 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0'.1g", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-'1.1g", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%'50.1g", "                                                 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-'.3g", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0'1.3g", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-'3.3g", "0  ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%'.50g", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-'1.50g", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0'3.50g", "000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-'50.50g", "0                                                 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%'1G", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-'3G", "0  ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0'50G", "00000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-'.0G", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%'3.0G", "  0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-'50.0G", "0                                                 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0'.1G", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-'1.1G", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%'50.1G", "                                                 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-'.3G", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0'1.3G", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-'3.3G", "0  ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%'.50G", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-'1.50G", "0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0'3.50G", "000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-'50.50G", "0                                                 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%+'1g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-+'3g", "+0 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0+'50g", "+0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-+'.0g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%+'3.0g", " +0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-+'50.0g", "+0                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0+'.1g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-+'1.1g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%+'50.1g", "                                                +0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-+'.3g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0+'1.3g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-+'3.3g", "+0 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%+'.50g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-+'1.50g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0+'3.50g", "+00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-+'50.50g", "+0                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%+'1G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-+'3G", "+0 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0+'50G", "+0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-+'.0G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%+'3.0G", " +0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-+'50.0G", "+0                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0+'.1G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-+'1.1G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%+'50.1G", "                                                +0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-+'.3G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0+'1.3G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-+'3.3G", "+0 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%+'.50G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%-+'1.50G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0+'3.50G", "+00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0-+'50.50G", "+0                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% '1g", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- '3g", " 0 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 '50g", " 0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- '.0g", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% '3.0g", "  0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- '50.0g", " 0                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 '.1g", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- '1.1g", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% '50.1g", "                                                 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- '.3g", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 '1.3g", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- '3.3g", " 0 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% '.50g", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- '1.50g", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 '3.50g", " 00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- '50.50g", " 0                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% '1G", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- '3G", " 0 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 '50G", " 0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- '.0G", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% '3.0G", "  0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- '50.0G", " 0                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 '.1G", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- '1.1G", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% '50.1G", "                                                 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- '.3G", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 '1.3G", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- '3.3G", " 0 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% '.50G", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- '1.50G", " 0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 '3.50G", " 00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- '50.50G", " 0                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% +'1g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- +'3g", "+0 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 +'50g", "+0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- +'.0g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% +'3.0g", " +0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- +'50.0g", "+0                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 +'.1g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- +'1.1g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% +'50.1g", "                                                +0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- +'.3g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 +'1.3g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- +'3.3g", "+0 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% +'.50g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- +'1.50g", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 +'3.50g", "+00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- +'50.50g", "+0                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% +'1G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- +'3G", "+0 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 +'50G", "+0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- +'.0G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% +'3.0G", " +0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- +'50.0G", "+0                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 +'.1G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- +'1.1G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% +'50.1G", "                                                +0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- +'.3G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 +'1.3G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- +'3.3G", "+0 ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "% +'.50G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%- +'1.50G", "+0", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0 +'3.50G", "+00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%0- +'50.50G", "+0                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#'1g", "0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-'3g", "0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0'50g", "00000000000000000000000000000000000000000000.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-'.0g", "0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#'3.0g", " 0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-'50.0g", "0.                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0'.1g", "0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-'1.1g", "0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#'50.1g", "                                                0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-'.3g", "0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0'1.3g", "0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-'3.3g", "0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#'.50g", "0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-'1.50g", "0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0'3.50g", "0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-'50.50g", "0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#'1G", "0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-'3G", "0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0'50G", "00000000000000000000000000000000000000000000.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-'.0G", "0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#'3.0G", " 0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-'50.0G", "0.                                                ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0'.1G", "0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-'1.1G", "0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#'50.1G", "                                                0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-'.3G", "0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0'1.3G", "0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-'3.3G", "0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#'.50G", "0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-'1.50G", "0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0'3.50G", "0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-'50.50G", "0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#+'1g", "+0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-+'3g", "+0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0+'50g", "+0000000000000000000000000000000000000000000.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-+'.0g", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#+'3.0g", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-+'50.0g", "+0.                                               ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0+'.1g", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-+'1.1g", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#+'50.1g", "                                               +0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-+'.3g", "+0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0+'1.3g", "+0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-+'3.3g", "+0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#+'.50g", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-+'1.50g", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0+'3.50g", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-+'50.50g", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#+'1G", "+0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-+'3G", "+0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0+'50G", "+0000000000000000000000000000000000000000000.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-+'.0G", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#+'3.0G", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-+'50.0G", "+0.                                               ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0+'.1G", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-+'1.1G", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#+'50.1G", "                                               +0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-+'.3G", "+0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0+'1.3G", "+0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-+'3.3G", "+0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#+'.50G", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#-+'1.50G", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0+'3.50G", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0-+'50.50G", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# '1g", " 0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- '3g", " 0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 '50g", " 0000000000000000000000000000000000000000000.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- '.0g", " 0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# '3.0g", " 0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- '50.0g", " 0.                                               ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 '.1g", " 0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- '1.1g", " 0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# '50.1g", "                                                0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- '.3g", " 0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 '1.3g", " 0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- '3.3g", " 0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# '.50g", " 0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- '1.50g", " 0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 '3.50g", " 0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- '50.50g", " 0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# '1G", " 0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- '3G", " 0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 '50G", " 0000000000000000000000000000000000000000000.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- '.0G", " 0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# '3.0G", " 0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- '50.0G", " 0.                                               ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 '.1G", " 0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- '1.1G", " 0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# '50.1G", "                                                0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- '.3G", " 0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 '1.3G", " 0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- '3.3G", " 0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# '.50G", " 0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- '1.50G", " 0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 '3.50G", " 0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- '50.50G", " 0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# +'1g", "+0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- +'3g", "+0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 +'50g", "+0000000000000000000000000000000000000000000.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- +'.0g", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# +'3.0g", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- +'50.0g", "+0.                                               ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 +'.1g", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- +'1.1g", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# +'50.1g", "                                               +0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- +'.3g", "+0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 +'1.3g", "+0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- +'3.3g", "+0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# +'.50g", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- +'1.50g", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 +'3.50g", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- +'50.50g", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# +'1G", "+0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- +'3G", "+0.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 +'50G", "+0000000000000000000000000000000000000000000.00000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- +'.0G", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# +'3.0G", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- +'50.0G", "+0.                                               ", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 +'.1G", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- +'1.1G", "+0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# +'50.1G", "                                               +0.", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- +'.3G", "+0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 +'1.3G", "+0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- +'3.3G", "+0.00", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%# +'.50G", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#- +'1.50G", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0 +'3.50G", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%#0- +'50.50G", "+0.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 0, 0 } },
    { "%'1g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-'3g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0'50g", "                                               nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-'.0g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%'3.0g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-'50.0g", "nan                                               ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0'.1g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-'1.1g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%'50.1g", "                                               nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-'.3g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0'1.3g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-'3.3g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%'.50g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-'1.50g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0'3.50g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-'50.50g", "nan                                               ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%'1G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-'3G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0'50G", "                                               NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-'.0G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%'3.0G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-'50.0G", "NAN                                               ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0'.1G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-'1.1G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%'50.1G", "                                               NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-'.3G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0'1.3G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-'3.3G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%'.50G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-'1.50G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0'3.50G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-'50.50G", "NAN                                               ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%+'1g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-+'3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0+'50g", "                                              +nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-+'.0g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%+'3.0g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-+'50.0g", "+nan                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0+'.1g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-+'1.1g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%+'50.1g", "                                              +nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-+'.3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0+'1.3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-+'3.3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%+'.50g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-+'1.50g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0+'3.50g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-+'50.50g", "+nan                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%+'1G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-+'3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0+'50G", "                                              +NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-+'.0G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%+'3.0G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-+'50.0G", "+NAN                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0+'.1G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-+'1.1G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%+'50.1G", "                                              +NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-+'.3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0+'1.3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-+'3.3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%+'.50G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%-+'1.50G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0+'3.50G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0-+'50.50G", "+NAN                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% '1g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- '3g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 '50g", "                                               nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- '.0g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% '3.0g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- '50.0g", " nan                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 '.1g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- '1.1g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% '50.1g", "                                               nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- '.3g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 '1.3g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- '3.3g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% '.50g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- '1.50g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 '3.50g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- '50.50g", " nan                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% '1G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- '3G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 '50G", "                                               NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- '.0G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% '3.0G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- '50.0G", " NAN                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 '.1G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- '1.1G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% '50.1G", "                                               NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- '.3G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 '1.3G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- '3.3G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% '.50G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- '1.50G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 '3.50G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- '50.50G", " NAN                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% +'1g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- +'3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 +'50g", "                                              +nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- +'.0g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% +'3.0g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- +'50.0g", "+nan                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 +'.1g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- +'1.1g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% +'50.1g", "                                              +nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- +'.3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 +'1.3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- +'3.3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% +'.50g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- +'1.50g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 +'3.50g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- +'50.50g", "+nan                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% +'1G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- +'3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 +'50G", "                                              +NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- +'.0G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% +'3.0G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- +'50.0G", "+NAN                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 +'.1G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- +'1.1G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% +'50.1G", "                                              +NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- +'.3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 +'1.3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- +'3.3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "% +'.50G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%- +'1.50G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0 +'3.50G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%0- +'50.50G", "+NAN                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#'1g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-'3g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0'50g", "                                               nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-'.0g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#'3.0g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-'50.0g", "nan                                               ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0'.1g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-'1.1g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#'50.1g", "                                               nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-'.3g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0'1.3g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-'3.3g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#'.50g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-'1.50g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0'3.50g", "nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-'50.50g", "nan                                               ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#'1G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-'3G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0'50G", "                                               NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-'.0G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#'3.0G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-'50.0G", "NAN                                               ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0'.1G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-'1.1G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#'50.1G", "                                               NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-'.3G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0'1.3G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-'3.3G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#'.50G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-'1.50G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0'3.50G", "NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-'50.50G", "NAN                                               ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#+'1g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-+'3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0+'50g", "                                              +nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-+'.0g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#+'3.0g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-+'50.0g", "+nan                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0+'.1g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-+'1.1g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#+'50.1g", "                                              +nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-+'.3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0+'1.3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-+'3.3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#+'.50g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-+'1.50g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0+'3.50g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-+'50.50g", "+nan                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#+'1G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-+'3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0+'50G", "                                              +NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-+'.0G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#+'3.0G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-+'50.0G", "+NAN                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0+'.1G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-+'1.1G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#+'50.1G", "                                              +NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-+'.3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0+'1.3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-+'3.3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#+'.50G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#-+'1.50G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0+'3.50G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0-+'50.50G", "+NAN                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# '1g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- '3g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 '50g", "                                               nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- '.0g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# '3.0g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- '50.0g", " nan                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 '.1g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- '1.1g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# '50.1g", "                                               nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- '.3g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 '1.3g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- '3.3g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# '.50g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- '1.50g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 '3.50g", " nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- '50.50g", " nan                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# '1G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- '3G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 '50G", "                                               NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- '.0G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# '3.0G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- '50.0G", " NAN                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 '.1G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- '1.1G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# '50.1G", "                                               NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- '.3G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 '1.3G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- '3.3G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# '.50G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- '1.50G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 '3.50G", " NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- '50.50G", " NAN                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# +'1g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- +'3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 +'50g", "                                              +nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- +'.0g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# +'3.0g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- +'50.0g", "+nan                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 +'.1g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- +'1.1g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# +'50.1g", "                                              +nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- +'.3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 +'1.3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- +'3.3g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# +'.50g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- +'1.50g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 +'3.50g", "+nan", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- +'50.50g", "+nan                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# +'1G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- +'3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 +'50G", "                                              +NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- +'.0G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# +'3.0G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- +'50.0G", "+NAN                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 +'.1G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- +'1.1G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# +'50.1G", "                                              +NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- +'.3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 +'1.3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- +'3.3G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%# +'.50G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#- +'1.50G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0 +'3.50G", "+NAN", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%#0- +'50.50G", "+NAN                                              ", { 0, 0, 0, 0, 0, 0, 248, 127 } },
    { "%'1g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-'3g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0'50g", "                                               inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-'.0g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%'3.0g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-'50.0g", "inf                                               ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0'.1g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-'1.1g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%'50.1g", "                                               inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-'.3g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0'1.3g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-'3.3g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%'.50g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-'1.50g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0'3.50g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-'50.50g", "inf                                               ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%'1G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-'3G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0'50G", "                                               INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-'.0G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%'3.0G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-'50.0G", "INF                                               ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0'.1G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-'1.1G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%'50.1G", "                                               INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-'.3G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0'1.3G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-'3.3G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%'.50G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-'1.50G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0'3.50G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-'50.50G", "INF                                               ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%+'1g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-+'3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0+'50g", "                                              +inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-+'.0g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%+'3.0g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-+'50.0g", "+inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0+'.1g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-+'1.1g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%+'50.1g", "                                              +inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-+'.3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0+'1.3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-+'3.3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%+'.50g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-+'1.50g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0+'3.50g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-+'50.50g", "+inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%+'1G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-+'3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0+'50G", "                                              +INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-+'.0G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%+'3.0G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-+'50.0G", "+INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0+'.1G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-+'1.1G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%+'50.1G", "                                              +INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-+'.3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0+'1.3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-+'3.3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%+'.50G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%-+'1.50G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0+'3.50G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0-+'50.50G", "+INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% '1g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- '3g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 '50g", "                                               inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- '.0g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% '3.0g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- '50.0g", " inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 '.1g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- '1.1g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% '50.1g", "                                               inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- '.3g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 '1.3g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- '3.3g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% '.50g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- '1.50g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 '3.50g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- '50.50g", " inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% '1G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- '3G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 '50G", "                                               INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- '.0G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% '3.0G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- '50.0G", " INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 '.1G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- '1.1G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% '50.1G", "                                               INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- '.3G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 '1.3G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- '3.3G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% '.50G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- '1.50G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 '3.50G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- '50.50G", " INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% +'1g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- +'3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 +'50g", "                                              +inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- +'.0g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% +'3.0g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- +'50.0g", "+inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 +'.1g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- +'1.1g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% +'50.1g", "                                              +inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- +'.3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 +'1.3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- +'3.3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% +'.50g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- +'1.50g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 +'3.50g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- +'50.50g", "+inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% +'1G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- +'3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 +'50G", "                                              +INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- +'.0G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% +'3.0G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- +'50.0G", "+INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 +'.1G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- +'1.1G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% +'50.1G", "                                              +INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- +'.3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 +'1.3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- +'3.3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "% +'.50G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%- +'1.50G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0 +'3.50G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%0- +'50.50G", "+INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#'1g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-'3g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0'50g", "                                               inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-'.0g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#'3.0g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-'50.0g", "inf                                               ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0'.1g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-'1.1g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#'50.1g", "                                               inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-'.3g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0'1.3g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-'3.3g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#'.50g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-'1.50g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0'3.50g", "inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-'50.50g", "inf                                               ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#'1G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-'3G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0'50G", "                                               INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-'.0G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#'3.0G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-'50.0G", "INF                                               ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0'.1G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-'1.1G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#'50.1G", "                                               INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-'.3G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0'1.3G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-'3.3G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#'.50G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-'1.50G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0'3.50G", "INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-'50.50G", "INF                                               ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#+'1g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-+'3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0+'50g", "                                              +inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-+'.0g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#+'3.0g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-+'50.0g", "+inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0+'.1g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-+'1.1g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#+'50.1g", "                                              +inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-+'.3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0+'1.3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-+'3.3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#+'.50g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-+'1.50g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0+'3.50g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-+'50.50g", "+inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#+'1G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-+'3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0+'50G", "                                              +INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-+'.0G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#+'3.0G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-+'50.0G", "+INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0+'.1G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-+'1.1G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#+'50.1G", "                                              +INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-+'.3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0+'1.3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-+'3.3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#+'.50G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#-+'1.50G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0+'3.50G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0-+'50.50G", "+INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# '1g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- '3g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 '50g", "                                               inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- '.0g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# '3.0g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- '50.0g", " inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 '.1g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- '1.1g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# '50.1g", "                                               inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- '.3g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 '1.3g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- '3.3g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# '.50g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- '1.50g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 '3.50g", " inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- '50.50g", " inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# '1G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- '3G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 '50G", "                                               INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- '.0G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# '3.0G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- '50.0G", " INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 '.1G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- '1.1G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# '50.1G", "                                               INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- '.3G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 '1.3G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- '3.3G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# '.50G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- '1.50G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 '3.50G", " INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- '50.50G", " INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# +'1g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- +'3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 +'50g", "                                              +inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- +'.0g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# +'3.0g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- +'50.0g", "+inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 +'.1g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- +'1.1g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# +'50.1g", "                                              +inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- +'.3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 +'1.3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- +'3.3g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# +'.50g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- +'1.50g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 +'3.50g", "+inf", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- +'50.50g", "+inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# +'1G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- +'3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 +'50G", "                                              +INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- +'.0G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# +'3.0G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- +'50.0G", "+INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 +'.1G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- +'1.1G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# +'50.1G", "                                              +INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- +'.3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 +'1.3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- +'3.3G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%# +'.50G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#- +'1.50G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0 +'3.50G", "+INF", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%#0- +'50.50G", "+INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 127 } },
    { "%'1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-'3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0'50g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-'.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%'3.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-'50.0g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0'.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-'1.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%'50.1g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-'.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0'1.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-'3.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%'.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-'1.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0'3.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-'50.50g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%'1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-'3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0'50G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-'.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%'3.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-'50.0G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0'.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-'1.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%'50.1G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-'.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0'1.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-'3.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%'.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-'1.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0'3.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-'50.50G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%+'1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-+'3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0+'50g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-+'.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%+'3.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-+'50.0g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0+'.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-+'1.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%+'50.1g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-+'.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0+'1.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-+'3.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%+'.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-+'1.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0+'3.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-+'50.50g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%+'1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-+'3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0+'50G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-+'.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%+'3.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-+'50.0G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0+'.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-+'1.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%+'50.1G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-+'.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0+'1.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-+'3.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%+'.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%-+'1.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0+'3.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0-+'50.50G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% '1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- '3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 '50g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- '.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% '3.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- '50.0g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 '.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- '1.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% '50.1g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- '.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 '1.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- '3.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% '.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- '1.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 '3.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- '50.50g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% '1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- '3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 '50G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- '.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% '3.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- '50.0G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 '.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- '1.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% '50.1G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- '.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 '1.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- '3.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% '.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- '1.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 '3.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- '50.50G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% +'1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- +'3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 +'50g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- +'.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% +'3.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- +'50.0g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 +'.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- +'1.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% +'50.1g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- +'.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 +'1.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- +'3.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% +'.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- +'1.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 +'3.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- +'50.50g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% +'1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- +'3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 +'50G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- +'.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% +'3.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- +'50.0G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 +'.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- +'1.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% +'50.1G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- +'.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 +'1.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- +'3.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "% +'.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%- +'1.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0 +'3.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%0- +'50.50G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#'1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-'3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0'50g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-'.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#'3.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-'50.0g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0'.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-'1.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#'50.1g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-'.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0'1.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-'3.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#'.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-'1.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0'3.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-'50.50g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#'1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-'3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0'50G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-'.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#'3.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-'50.0G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0'.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-'1.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#'50.1G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-'.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0'1.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-'3.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#'.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-'1.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0'3.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-'50.50G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#+'1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-+'3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0+'50g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-+'.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#+'3.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-+'50.0g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0+'.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-+'1.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#+'50.1g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-+'.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0+'1.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-+'3.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#+'.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-+'1.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0+'3.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-+'50.50g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#+'1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-+'3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0+'50G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-+'.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#+'3.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-+'50.0G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0+'.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-+'1.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#+'50.1G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-+'.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0+'1.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-+'3.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#+'.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#-+'1.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0+'3.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0-+'50.50G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# '1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- '3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 '50g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- '.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# '3.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- '50.0g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 '.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- '1.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# '50.1g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- '.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 '1.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- '3.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# '.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- '1.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 '3.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- '50.50g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# '1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- '3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 '50G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- '.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# '3.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- '50.0G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 '.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- '1.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# '50.1G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- '.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 '1.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- '3.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# '.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- '1.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 '3.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- '50.50G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# +'1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- +'3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 +'50g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- +'.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# +'3.0g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- +'50.0g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 +'.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- +'1.1g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# +'50.1g", "                                              -inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- +'.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 +'1.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- +'3.3g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# +'.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- +'1.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 +'3.50g", "-inf", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- +'50.50g", "-inf                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# +'1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- +'3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 +'50G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- +'.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# +'3.0G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- +'50.0G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 +'.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- +'1.1G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# +'50.1G", "                                              -INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- +'.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 +'1.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- +'3.3G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%# +'.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#- +'1.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0 +'3.50G", "-INF", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%#0- +'50.50G", "-INF                                              ", { 0, 0, 0, 0, 0, 0, 240, 255 } },
    { "%'1g", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-'3g", "1  ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0'50g", "00000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-'.0g", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%'3.0g", "  1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-'50.0g", "1                                                 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0'.1g", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-'1.1g", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%'50.1g", "                                                 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-'.3g", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0'1.3g", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-'3.3g", "1  ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%'.50g", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-'1.50g", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0'3.50g", "001", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-'50.50g", "1                                                 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%'1G", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-'3G", "1  ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0'50G", "00000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-'.0G", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%'3.0G", "  1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-'50.0G", "1                                                 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0'.1G", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-'1.1G", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%'50.1G", "                                                 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-'.3G", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0'1.3G", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-'3.3G", "1  ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%'.50G", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-'1.50G", "1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0'3.50G", "001", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-'50.50G", "1                                                 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%+'1g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-+'3g", "+1 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0+'50g", "+0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-+'.0g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%+'3.0g", " +1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-+'50.0g", "+1                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0+'.1g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-+'1.1g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%+'50.1g", "                                                +1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-+'.3g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0+'1.3g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-+'3.3g", "+1 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%+'.50g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-+'1.50g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0+'3.50g", "+01", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-+'50.50g", "+1                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%+'1G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-+'3G", "+1 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0+'50G", "+0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-+'.0G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%+'3.0G", " +1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-+'50.0G", "+1                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0+'.1G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-+'1.1G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%+'50.1G", "                                                +1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-+'.3G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0+'1.3G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-+'3.3G", "+1 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%+'.50G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%-+'1.50G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0+'3.50G", "+01", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0-+'50.50G", "+1                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% '1g", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- '3g", " 1 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 '50g", " 0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- '.0g", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% '3.0g", "  1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- '50.0g", " 1                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 '.1g", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- '1.1g", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% '50.1g", "                                                 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- '.3g", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 '1.3g", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- '3.3g", " 1 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% '.50g", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- '1.50g", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 '3.50g", " 01", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- '50.50g", " 1                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% '1G", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- '3G", " 1 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 '50G", " 0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- '.0G", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% '3.0G", "  1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- '50.0G", " 1                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 '.1G", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- '1.1G", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% '50.1G", "                                                 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- '.3G", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 '1.3G", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- '3.3G", " 1 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% '.50G", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- '1.50G", " 1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 '3.50G", " 01", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- '50.50G", " 1                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% +'1g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- +'3g", "+1 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 +'50g", "+0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- +'.0g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% +'3.0g", " +1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- +'50.0g", "+1                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 +'.1g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- +'1.1g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% +'50.1g", "                                                +1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- +'.3g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 +'1.3g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- +'3.3g", "+1 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% +'.50g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- +'1.50g", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 +'3.50g", "+01", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- +'50.50g", "+1                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% +'1G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- +'3G", "+1 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 +'50G", "+0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- +'.0G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% +'3.0G", " +1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- +'50.0G", "+1                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 +'.1G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- +'1.1G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% +'50.1G", "                                                +1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- +'.3G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 +'1.3G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- +'3.3G", "+1 ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "% +'.50G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%- +'1.50G", "+1", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0 +'3.50G", "+01", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%0- +'50.50G", "+1                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#'1g", "1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-'3g", "1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0'50g", "00000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-'.0g", "1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#'3.0g", " 1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-'50.0g", "1.                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0'.1g", "1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-'1.1g", "1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#'50.1g", "                                                1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-'.3g", "1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0'1.3g", "1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-'3.3g", "1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#'.50g", "1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-'1.50g", "1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0'3.50g", "1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-'50.50g", "1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#'1G", "1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-'3G", "1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0'50G", "00000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-'.0G", "1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#'3.0G", " 1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-'50.0G", "1.                                                ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0'.1G", "1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-'1.1G", "1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#'50.1G", "                                                1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-'.3G", "1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0'1.3G", "1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-'3.3G", "1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#'.50G", "1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-'1.50G", "1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0'3.50G", "1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-'50.50G", "1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#+'1g", "+1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-+'3g", "+1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0+'50g", "+0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-+'.0g", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#+'3.0g", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-+'50.0g", "+1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0+'.1g", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-+'1.1g", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#+'50.1g", "                                               +1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-+'.3g", "+1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0+'1.3g", "+1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-+'3.3g", "+1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#+'.50g", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-+'1.50g", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0+'3.50g", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-+'50.50g", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#+'1G", "+1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-+'3G", "+1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0+'50G", "+0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-+'.0G", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#+'3.0G", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-+'50.0G", "+1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0+'.1G", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-+'1.1G", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#+'50.1G", "                                               +1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-+'.3G", "+1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0+'1.3G", "+1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-+'3.3G", "+1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#+'.50G", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#-+'1.50G", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0+'3.50G", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0-+'50.50G", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# '1g", " 1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- '3g", " 1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 '50g", " 0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- '.0g", " 1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# '3.0g", " 1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- '50.0g", " 1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 '.1g", " 1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- '1.1g", " 1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# '50.1g", "                                                1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- '.3g", " 1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 '1.3g", " 1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- '3.3g", " 1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# '.50g", " 1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- '1.50g", " 1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 '3.50g", " 1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- '50.50g", " 1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# '1G", " 1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- '3G", " 1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 '50G", " 0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- '.0G", " 1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# '3.0G", " 1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- '50.0G", " 1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 '.1G", " 1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- '1.1G", " 1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# '50.1G", "                                                1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- '.3G", " 1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 '1.3G", " 1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- '3.3G", " 1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# '.50G", " 1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- '1.50G", " 1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 '3.50G", " 1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- '50.50G", " 1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# +'1g", "+1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- +'3g", "+1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 +'50g", "+0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- +'.0g", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# +'3.0g", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- +'50.0g", "+1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 +'.1g", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- +'1.1g", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# +'50.1g", "                                               +1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- +'.3g", "+1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 +'1.3g", "+1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- +'3.3g", "+1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# +'.50g", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- +'1.50g", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 +'3.50g", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- +'50.50g", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# +'1G", "+1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- +'3G", "+1.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 +'50G", "+0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- +'.0G", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# +'3.0G", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- +'50.0G", "+1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 +'.1G", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- +'1.1G", "+1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# +'50.1G", "                                               +1.", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- +'.3G", "+1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 +'1.3G", "+1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- +'3.3G", "+1.00", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%# +'.50G", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#- +'1.50G", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0 +'3.50G", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%#0- +'50.50G", "+1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 63 } },
    { "%'1g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-'3g", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0'50g", "-0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-'.0g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%'3.0g", " -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-'50.0g", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0'.1g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-'1.1g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%'50.1g", "                                                -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-'.3g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0'1.3g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-'3.3g", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%'.50g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-'1.50g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0'3.50g", "-01", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-'50.50g", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%'1G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-'3G", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0'50G", "-0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-'.0G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%'3.0G", " -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-'50.0G", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0'.1G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-'1.1G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%'50.1G", "                                                -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-'.3G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0'1.3G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-'3.3G", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%'.50G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-'1.50G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0'3.50G", "-01", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-'50.50G", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%+'1g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-+'3g", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0+'50g", "-0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-+'.0g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%+'3.0g", " -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-+'50.0g", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0+'.1g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-+'1.1g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%+'50.1g", "                                                -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-+'.3g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0+'1.3g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-+'3.3g", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%+'.50g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-+'1.50g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0+'3.50g", "-01", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-+'50.50g", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%+'1G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-+'3G", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0+'50G", "-0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-+'.0G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%+'3.0G", " -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-+'50.0G", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0+'.1G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-+'1.1G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%+'50.1G", "                                                -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-+'.3G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0+'1.3G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-+'3.3G", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%+'.50G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%-+'1.50G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0+'3.50G", "-01", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0-+'50.50G", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% '1g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- '3g", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 '50g", "-0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- '.0g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% '3.0g", " -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- '50.0g", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 '.1g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- '1.1g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% '50.1g", "                                                -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- '.3g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 '1.3g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- '3.3g", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% '.50g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- '1.50g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 '3.50g", "-01", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- '50.50g", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% '1G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- '3G", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 '50G", "-0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- '.0G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% '3.0G", " -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- '50.0G", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 '.1G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- '1.1G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% '50.1G", "                                                -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- '.3G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 '1.3G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- '3.3G", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% '.50G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- '1.50G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 '3.50G", "-01", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- '50.50G", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% +'1g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- +'3g", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 +'50g", "-0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- +'.0g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% +'3.0g", " -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- +'50.0g", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 +'.1g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- +'1.1g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% +'50.1g", "                                                -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- +'.3g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 +'1.3g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- +'3.3g", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% +'.50g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- +'1.50g", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 +'3.50g", "-01", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- +'50.50g", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% +'1G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- +'3G", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 +'50G", "-0000000000000000000000000000000000000000000000001", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- +'.0G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% +'3.0G", " -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- +'50.0G", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 +'.1G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- +'1.1G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% +'50.1G", "                                                -1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- +'.3G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 +'1.3G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- +'3.3G", "-1 ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "% +'.50G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%- +'1.50G", "-1", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0 +'3.50G", "-01", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%0- +'50.50G", "-1                                                ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#'1g", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-'3g", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0'50g", "-0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-'.0g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#'3.0g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-'50.0g", "-1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0'.1g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-'1.1g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#'50.1g", "                                               -1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-'.3g", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0'1.3g", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-'3.3g", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#'.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-'1.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0'3.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-'50.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#'1G", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-'3G", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0'50G", "-0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-'.0G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#'3.0G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-'50.0G", "-1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0'.1G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-'1.1G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#'50.1G", "                                               -1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-'.3G", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0'1.3G", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-'3.3G", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#'.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-'1.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0'3.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-'50.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#+'1g", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-+'3g", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0+'50g", "-0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-+'.0g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#+'3.0g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-+'50.0g", "-1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0+'.1g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-+'1.1g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#+'50.1g", "                                               -1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-+'.3g", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0+'1.3g", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-+'3.3g", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#+'.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-+'1.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0+'3.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-+'50.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#+'1G", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-+'3G", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0+'50G", "-0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-+'.0G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#+'3.0G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-+'50.0G", "-1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0+'.1G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-+'1.1G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#+'50.1G", "                                               -1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-+'.3G", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0+'1.3G", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-+'3.3G", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#+'.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#-+'1.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0+'3.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0-+'50.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# '1g", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- '3g", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 '50g", "-0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- '.0g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# '3.0g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- '50.0g", "-1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 '.1g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- '1.1g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# '50.1g", "                                               -1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- '.3g", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 '1.3g", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- '3.3g", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# '.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- '1.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 '3.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- '50.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# '1G", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- '3G", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 '50G", "-0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- '.0G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# '3.0G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- '50.0G", "-1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 '.1G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- '1.1G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# '50.1G", "                                               -1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- '.3G", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 '1.3G", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- '3.3G", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# '.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- '1.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 '3.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- '50.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# +'1g", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- +'3g", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 +'50g", "-0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- +'.0g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# +'3.0g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- +'50.0g", "-1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 +'.1g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- +'1.1g", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# +'50.1g", "                                               -1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- +'.3g", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 +'1.3g", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- +'3.3g", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# +'.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- +'1.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 +'3.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- +'50.50g", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# +'1G", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- +'3G", "-1.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 +'50G", "-0000000000000000000000000000000000000000001.00000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- +'.0G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# +'3.0G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- +'50.0G", "-1.                                               ", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 +'.1G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- +'1.1G", "-1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# +'50.1G", "                                               -1.", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- +'.3G", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 +'1.3G", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- +'3.3G", "-1.00", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%# +'.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#- +'1.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0 +'3.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%#0- +'50.50G", "-1.0000000000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 0, 240, 191 } },
    { "%'1g", "1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-'3g", "1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0'50g", "00000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-'.0g", "2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%'3.0g", "  2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-'50.0g", "2                                                 ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0'.1g", "2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-'1.1g", "2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%'50.1g", "                                                 2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-'.3g", "1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0'1.3g", "1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-'3.3g", "1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%'.50g", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-'1.50g", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0'3.50g", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-'50.50g", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%'1G", "1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-'3G", "1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0'50G", "00000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-'.0G", "2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%'3.0G", "  2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-'50.0G", "2                                                 ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0'.1G", "2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-'1.1G", "2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%'50.1G", "                                                 2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-'.3G", "1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0'1.3G", "1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-'3.3G", "1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%'.50G", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-'1.50G", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0'3.50G", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-'50.50G", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%+'1g", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-+'3g", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0+'50g", "+0000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-+'.0g", "+2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%+'3.0g", " +2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-+'50.0g", "+2                                                ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0+'.1g", "+2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-+'1.1g", "+2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%+'50.1g", "                                                +2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-+'.3g", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0+'1.3g", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-+'3.3g", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%+'.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-+'1.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0+'3.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-+'50.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%+'1G", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-+'3G", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0+'50G", "+0000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-+'.0G", "+2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%+'3.0G", " +2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-+'50.0G", "+2                                                ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0+'.1G", "+2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-+'1.1G", "+2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%+'50.1G", "                                                +2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-+'.3G", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0+'1.3G", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-+'3.3G", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%+'.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%-+'1.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0+'3.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0-+'50.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% '1g", " 1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- '3g", " 1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 '50g", " 0000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- '.0g", " 2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% '3.0g", "  2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- '50.0g", " 2                                                ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 '.1g", " 2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- '1.1g", " 2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% '50.1g", "                                                 2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- '.3g", " 1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 '1.3g", " 1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- '3.3g", " 1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% '.50g", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- '1.50g", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 '3.50g", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- '50.50g", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% '1G", " 1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- '3G", " 1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 '50G", " 0000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- '.0G", " 2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% '3.0G", "  2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- '50.0G", " 2                                                ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 '.1G", " 2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- '1.1G", " 2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% '50.1G", "                                                 2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- '.3G", " 1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 '1.3G", " 1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- '3.3G", " 1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% '.50G", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- '1.50G", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 '3.50G", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- '50.50G", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% +'1g", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- +'3g", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 +'50g", "+0000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- +'.0g", "+2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% +'3.0g", " +2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- +'50.0g", "+2                                                ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 +'.1g", "+2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- +'1.1g", "+2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% +'50.1g", "                                                +2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- +'.3g", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 +'1.3g", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- +'3.3g", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% +'.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- +'1.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 +'3.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- +'50.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% +'1G", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- +'3G", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 +'50G", "+0000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- +'.0G", "+2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% +'3.0G", " +2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- +'50.0G", "+2                                                ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 +'.1G", "+2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- +'1.1G", "+2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% +'50.1G", "                                                +2", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- +'.3G", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 +'1.3G", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- +'3.3G", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "% +'.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%- +'1.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0 +'3.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%0- +'50.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#'1g", "1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-'3g", "1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0'50g", "00000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-'.0g", "2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#'3.0g", " 2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-'50.0g", "2.                                                ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0'.1g", "2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-'1.1g", "2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#'50.1g", "                                                2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-'.3g", "1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0'1.3g", "1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-'3.3g", "1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#'.50g", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-'1.50g", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0'3.50g", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-'50.50g", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#'1G", "1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-'3G", "1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0'50G", "00000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-'.0G", "2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#'3.0G", " 2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-'50.0G", "2.                                                ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0'.1G", "2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-'1.1G", "2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#'50.1G", "                                                2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-'.3G", "1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0'1.3G", "1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-'3.3G", "1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#'.50G", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-'1.50G", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0'3.50G", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-'50.50G", "1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#+'1g", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-+'3g", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0+'50g", "+0000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-+'.0g", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#+'3.0g", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-+'50.0g", "+2.                                               ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0+'.1g", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-+'1.1g", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#+'50.1g", "                                               +2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-+'.3g", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0+'1.3g", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-+'3.3g", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#+'.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-+'1.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0+'3.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-+'50.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#+'1G", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-+'3G", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0+'50G", "+0000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-+'.0G", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#+'3.0G", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-+'50.0G", "+2.                                               ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0+'.1G", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-+'1.1G", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#+'50.1G", "                                               +2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-+'.3G", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0+'1.3G", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-+'3.3G", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#+'.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#-+'1.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0+'3.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0-+'50.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# '1g", " 1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- '3g", " 1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 '50g", " 0000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- '.0g", " 2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# '3.0g", " 2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- '50.0g", " 2.                                               ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 '.1g", " 2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- '1.1g", " 2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# '50.1g", "                                                2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- '.3g", " 1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 '1.3g", " 1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- '3.3g", " 1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# '.50g", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- '1.50g", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 '3.50g", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- '50.50g", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# '1G", " 1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- '3G", " 1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 '50G", " 0000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- '.0G", " 2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# '3.0G", " 2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- '50.0G", " 2.                                               ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 '.1G", " 2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- '1.1G", " 2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# '50.1G", "                                                2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- '.3G", " 1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 '1.3G", " 1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- '3.3G", " 1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# '.50G", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- '1.50G", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 '3.50G", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- '50.50G", " 1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# +'1g", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- +'3g", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 +'50g", "+0000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- +'.0g", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# +'3.0g", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- +'50.0g", "+2.                                               ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 +'.1g", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- +'1.1g", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# +'50.1g", "                                               +2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- +'.3g", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 +'1.3g", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- +'3.3g", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# +'.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- +'1.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 +'3.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- +'50.50g", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# +'1G", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- +'3G", "+1.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 +'50G", "+0000000000000000000000000000000000000000001.57143", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- +'.0G", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# +'3.0G", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- +'50.0G", "+2.                                               ", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 +'.1G", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- +'1.1G", "+2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# +'50.1G", "                                               +2.", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- +'.3G", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 +'1.3G", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- +'3.3G", "+1.57", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%# +'.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#- +'1.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0 +'3.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%#0- +'50.50G", "+1.5714285714285713968507707249955274164676666259766", { 73, 146, 36, 73, 146, 36, 249, 63 } },
    { "%'1g", "0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-'3g", "0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0'50g", "0000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-'.0g", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%'3.0g", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-'50.0g", "0.6                                               ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0'.1g", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-'1.1g", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%'50.1g", "                                               0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-'.3g", "0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0'1.3g", "0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-'3.3g", "0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%'.50g", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-'1.50g", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0'3.50g", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-'50.50g", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%'1G", "0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-'3G", "0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0'50G", "0000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-'.0G", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%'3.0G", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-'50.0G", "0.6                                               ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0'.1G", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-'1.1G", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%'50.1G", "                                               0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-'.3G", "0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0'1.3G", "0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-'3.3G", "0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%'.50G", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-'1.50G", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0'3.50G", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-'50.50G", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%+'1g", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-+'3g", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0+'50g", "+000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-+'.0g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%+'3.0g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-+'50.0g", "+0.6                                              ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0+'.1g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-+'1.1g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%+'50.1g", "                                              +0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-+'.3g", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0+'1.3g", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-+'3.3g", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%+'.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-+'1.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0+'3.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-+'50.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%+'1G", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-+'3G", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0+'50G", "+000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-+'.0G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%+'3.0G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-+'50.0G", "+0.6                                              ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0+'.1G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-+'1.1G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%+'50.1G", "                                              +0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-+'.3G", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0+'1.3G", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-+'3.3G", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%+'.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%-+'1.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0+'3.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0-+'50.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% '1g", " 0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- '3g", " 0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 '50g", " 000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- '.0g", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% '3.0g", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- '50.0g", " 0.6                                              ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 '.1g", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- '1.1g", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% '50.1g", "                                               0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- '.3g", " 0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 '1.3g", " 0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- '3.3g", " 0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% '.50g", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- '1.50g", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 '3.50g", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- '50.50g", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% '1G", " 0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- '3G", " 0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 '50G", " 000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- '.0G", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% '3.0G", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- '50.0G", " 0.6                                              ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 '.1G", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- '1.1G", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% '50.1G", "                                               0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- '.3G", " 0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 '1.3G", " 0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- '3.3G", " 0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% '.50G", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- '1.50G", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 '3.50G", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- '50.50G", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% +'1g", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- +'3g", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 +'50g", "+000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- +'.0g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% +'3.0g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- +'50.0g", "+0.6                                              ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 +'.1g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- +'1.1g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% +'50.1g", "                                              +0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- +'.3g", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 +'1.3g", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- +'3.3g", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% +'.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- +'1.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 +'3.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- +'50.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% +'1G", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- +'3G", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 +'50G", "+000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- +'.0G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% +'3.0G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- +'50.0G", "+0.6                                              ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 +'.1G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- +'1.1G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% +'50.1G", "                                              +0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- +'.3G", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 +'1.3G", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- +'3.3G", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "% +'.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%- +'1.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0 +'3.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%0- +'50.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#'1g", "0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-'3g", "0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0'50g", "0000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-'.0g", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#'3.0g", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-'50.0g", "0.6                                               ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0'.1g", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-'1.1g", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#'50.1g", "                                               0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-'.3g", "0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0'1.3g", "0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-'3.3g", "0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#'.50g", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-'1.50g", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0'3.50g", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-'50.50g", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#'1G", "0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-'3G", "0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0'50G", "0000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-'.0G", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#'3.0G", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-'50.0G", "0.6                                               ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0'.1G", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-'1.1G", "0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#'50.1G", "                                               0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-'.3G", "0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0'1.3G", "0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-'3.3G", "0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#'.50G", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-'1.50G", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0'3.50G", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-'50.50G", "0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#+'1g", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-+'3g", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0+'50g", "+000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-+'.0g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#+'3.0g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-+'50.0g", "+0.6                                              ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0+'.1g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-+'1.1g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#+'50.1g", "                                              +0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-+'.3g", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0+'1.3g", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-+'3.3g", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#+'.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-+'1.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0+'3.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-+'50.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#+'1G", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-+'3G", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0+'50G", "+000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-+'.0G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#+'3.0G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-+'50.0G", "+0.6                                              ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0+'.1G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-+'1.1G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#+'50.1G", "                                              +0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-+'.3G", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0+'1.3G", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-+'3.3G", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#+'.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#-+'1.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0+'3.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0-+'50.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# '1g", " 0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- '3g", " 0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 '50g", " 000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- '.0g", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# '3.0g", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- '50.0g", " 0.6                                              ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 '.1g", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- '1.1g", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# '50.1g", "                                               0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- '.3g", " 0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 '1.3g", " 0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- '3.3g", " 0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# '.50g", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- '1.50g", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 '3.50g", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- '50.50g", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# '1G", " 0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- '3G", " 0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 '50G", " 000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- '.0G", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# '3.0G", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- '50.0G", " 0.6                                              ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 '.1G", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- '1.1G", " 0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# '50.1G", "                                               0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- '.3G", " 0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 '1.3G", " 0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- '3.3G", " 0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# '.50G", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- '1.50G", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 '3.50G", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- '50.50G", " 0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# +'1g", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- +'3g", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- +'.0g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# +'3.0g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- +'50.0g", "+0.6                                              ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 +'.1g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- +'1.1g", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# +'50.1g", "                                              +0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- +'.3g", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 +'1.3g", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- +'3.3g", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# +'.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- +'1.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 +'3.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- +'50.50g", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# +'1G", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- +'3G", "+0.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000000000.636364", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- +'.0G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# +'3.0G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- +'50.0G", "+0.6                                              ", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 +'.1G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- +'1.1G", "+0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# +'50.1G", "                                              +0.6", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- +'.3G", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 +'1.3G", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- +'3.3G", "+0.636", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%# +'.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#- +'1.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0 +'3.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%#0- +'50.50G", "+0.63636363636363635354342704886221326887607574462891", { 93, 116, 209, 69, 23, 93, 228, 63 } },
    { "%'1g", "1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-'3g", "1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0'50g", "0000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-'.0g", "2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%'3.0g", "2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-'50.0g", "2e+03                                             ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0'.1g", "2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-'1.1g", "2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%'50.1g", "                                             2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-'.3g", "1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0'1.3g", "1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-'3.3g", "1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%'.50g", "1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-'1.50g", "1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0'3.50g", "1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-'50.50g", "1,571.428571428571331125567667186260223388671875  ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%'1G", "1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-'3G", "1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0'50G", "0000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-'.0G", "2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%'3.0G", "2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-'50.0G", "2E+03                                             ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0'.1G", "2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-'1.1G", "2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%'50.1G", "                                             2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-'.3G", "1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0'1.3G", "1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-'3.3G", "1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%'.50G", "1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-'1.50G", "1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0'3.50G", "1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-'50.50G", "1,571.428571428571331125567667186260223388671875  ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%+'1g", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-+'3g", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0+'50g", "+000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-+'.0g", "+2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%+'3.0g", "+2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-+'50.0g", "+2e+03                                            ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0+'.1g", "+2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-+'1.1g", "+2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%+'50.1g", "                                            +2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-+'.3g", "+1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0+'1.3g", "+1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-+'3.3g", "+1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%+'.50g", "+1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-+'1.50g", "+1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0+'3.50g", "+1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-+'50.50g", "+1,571.428571428571331125567667186260223388671875 ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%+'1G", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-+'3G", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0+'50G", "+000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-+'.0G", "+2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%+'3.0G", "+2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-+'50.0G", "+2E+03                                            ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0+'.1G", "+2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-+'1.1G", "+2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%+'50.1G", "                                            +2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-+'.3G", "+1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0+'1.3G", "+1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-+'3.3G", "+1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%+'.50G", "+1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%-+'1.50G", "+1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0+'3.50G", "+1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0-+'50.50G", "+1,571.428571428571331125567667186260223388671875 ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% '1g", " 1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- '3g", " 1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 '50g", " 000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- '.0g", " 2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% '3.0g", " 2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- '50.0g", " 2e+03                                            ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 '.1g", " 2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- '1.1g", " 2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% '50.1g", "                                             2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- '.3g", " 1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 '1.3g", " 1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- '3.3g", " 1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% '.50g", " 1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- '1.50g", " 1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 '3.50g", " 1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- '50.50g", " 1,571.428571428571331125567667186260223388671875 ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% '1G", " 1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- '3G", " 1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 '50G", " 000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- '.0G", " 2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% '3.0G", " 2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- '50.0G", " 2E+03                                            ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 '.1G", " 2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- '1.1G", " 2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% '50.1G", "                                             2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- '.3G", " 1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 '1.3G", " 1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- '3.3G", " 1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% '.50G", " 1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- '1.50G", " 1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 '3.50G", " 1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- '50.50G", " 1,571.428571428571331125567667186260223388671875 ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% +'1g", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- +'3g", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 +'50g", "+000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- +'.0g", "+2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% +'3.0g", "+2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- +'50.0g", "+2e+03                                            ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 +'.1g", "+2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- +'1.1g", "+2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% +'50.1g", "                                            +2e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- +'.3g", "+1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 +'1.3g", "+1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- +'3.3g", "+1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% +'.50g", "+1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- +'1.50g", "+1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 +'3.50g", "+1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- +'50.50g", "+1,571.428571428571331125567667186260223388671875 ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% +'1G", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- +'3G", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 +'50G", "+000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- +'.0G", "+2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% +'3.0G", "+2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- +'50.0G", "+2E+03                                            ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 +'.1G", "+2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- +'1.1G", "+2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% +'50.1G", "                                            +2E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- +'.3G", "+1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 +'1.3G", "+1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- +'3.3G", "+1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "% +'.50G", "+1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%- +'1.50G", "+1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0 +'3.50G", "+1,571.428571428571331125567667186260223388671875", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%0- +'50.50G", "+1,571.428571428571331125567667186260223388671875 ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#'1g", "1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-'3g", "1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0'50g", "0000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-'.0g", "2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#'3.0g", "2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-'50.0g", "2.e+03                                            ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0'.1g", "2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-'1.1g", "2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#'50.1g", "                                            2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-'.3g", "1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0'1.3g", "1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-'3.3g", "1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#'.50g", "1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-'1.50g", "1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0'3.50g", "1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-'50.50g", "1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#'1G", "1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-'3G", "1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0'50G", "0000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-'.0G", "2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#'3.0G", "2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-'50.0G", "2.E+03                                            ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0'.1G", "2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-'1.1G", "2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#'50.1G", "                                            2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-'.3G", "1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0'1.3G", "1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-'3.3G", "1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#'.50G", "1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-'1.50G", "1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0'3.50G", "1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-'50.50G", "1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#+'1g", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-+'3g", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0+'50g", "+000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-+'.0g", "+2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#+'3.0g", "+2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-+'50.0g", "+2.e+03                                           ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0+'.1g", "+2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-+'1.1g", "+2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#+'50.1g", "                                           +2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-+'.3g", "+1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0+'1.3g", "+1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-+'3.3g", "+1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#+'.50g", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-+'1.50g", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0+'3.50g", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-+'50.50g", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#+'1G", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-+'3G", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0+'50G", "+000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-+'.0G", "+2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#+'3.0G", "+2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-+'50.0G", "+2.E+03                                           ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0+'.1G", "+2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-+'1.1G", "+2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#+'50.1G", "                                           +2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-+'.3G", "+1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0+'1.3G", "+1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-+'3.3G", "+1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#+'.50G", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#-+'1.50G", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0+'3.50G", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0-+'50.50G", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# '1g", " 1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- '3g", " 1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 '50g", " 000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- '.0g", " 2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# '3.0g", " 2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- '50.0g", " 2.e+03                                           ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 '.1g", " 2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- '1.1g", " 2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# '50.1g", "                                            2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- '.3g", " 1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 '1.3g", " 1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- '3.3g", " 1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# '.50g", " 1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- '1.50g", " 1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 '3.50g", " 1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- '50.50g", " 1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# '1G", " 1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- '3G", " 1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 '50G", " 000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- '.0G", " 2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# '3.0G", " 2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- '50.0G", " 2.E+03                                           ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 '.1G", " 2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- '1.1G", " 2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# '50.1G", "                                            2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- '.3G", " 1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 '1.3G", " 1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- '3.3G", " 1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# '.50G", " 1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- '1.50G", " 1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 '3.50G", " 1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- '50.50G", " 1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# +'1g", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- +'3g", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- +'.0g", "+2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# +'3.0g", "+2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- +'50.0g", "+2.e+03                                           ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 +'.1g", "+2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- +'1.1g", "+2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# +'50.1g", "                                           +2.e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- +'.3g", "+1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 +'1.3g", "+1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- +'3.3g", "+1.57e+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# +'.50g", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- +'1.50g", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 +'3.50g", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- +'50.50g", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# +'1G", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- +'3G", "+1,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000000001,571.43", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- +'.0G", "+2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# +'3.0G", "+2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- +'50.0G", "+2.E+03                                           ", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 +'.1G", "+2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- +'1.1G", "+2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# +'50.1G", "                                           +2.E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- +'.3G", "+1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 +'1.3G", "+1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- +'3.3G", "+1.57E+03", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%# +'.50G", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#- +'1.50G", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0 +'3.50G", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%#0- +'50.50G", "+1,571.4285714285713311255676671862602233886718750000", { 219, 182, 109, 219, 182, 141, 152, 64 } },
    { "%'1g", "1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-'3g", "1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0'50g", "0000000000000000000000000000000000000001.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-'.0g", "2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%'3.0g", "2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-'50.0g", "2e+06                                             ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0'.1g", "2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-'1.1g", "2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%'50.1g", "                                             2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-'.3g", "1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0'1.3g", "1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-'3.3g", "1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%'.50g", "1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-'1.50g", "1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0'3.50g", "1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-'50.50g", "1,571,428.5714285713620483875274658203125         ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%'1G", "1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-'3G", "1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0'50G", "0000000000000000000000000000000000000001.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-'.0G", "2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%'3.0G", "2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-'50.0G", "2E+06                                             ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0'.1G", "2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-'1.1G", "2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%'50.1G", "                                             2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-'.3G", "1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0'1.3G", "1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-'3.3G", "1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%'.50G", "1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-'1.50G", "1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0'3.50G", "1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-'50.50G", "1,571,428.5714285713620483875274658203125         ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%+'1g", "+1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-+'3g", "+1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0+'50g", "+000000000000000000000000000000000000001.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-+'.0g", "+2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%+'3.0g", "+2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-+'50.0g", "+2e+06                                            ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0+'.1g", "+2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-+'1.1g", "+2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%+'50.1g", "                                            +2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-+'.3g", "+1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0+'1.3g", "+1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-+'3.3g", "+1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%+'.50g", "+1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-+'1.50g", "+1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0+'3.50g", "+1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-+'50.50g", "+1,571,428.5714285713620483875274658203125        ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%+'1G", "+1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-+'3G", "+1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0+'50G", "+000000000000000000000000000000000000001.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-+'.0G", "+2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%+'3.0G", "+2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-+'50.0G", "+2E+06                                            ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0+'.1G", "+2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-+'1.1G", "+2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%+'50.1G", "                                            +2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-+'.3G", "+1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0+'1.3G", "+1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-+'3.3G", "+1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%+'.50G", "+1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%-+'1.50G", "+1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0+'3.50G", "+1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0-+'50.50G", "+1,571,428.5714285713620483875274658203125        ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% '1g", " 1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- '3g", " 1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 '50g", " 000000000000000000000000000000000000001.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- '.0g", " 2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% '3.0g", " 2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- '50.0g", " 2e+06                                            ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 '.1g", " 2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- '1.1g", " 2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% '50.1g", "                                             2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- '.3g", " 1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 '1.3g", " 1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- '3.3g", " 1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% '.50g", " 1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- '1.50g", " 1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 '3.50g", " 1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- '50.50g", " 1,571,428.5714285713620483875274658203125        ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% '1G", " 1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- '3G", " 1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 '50G", " 000000000000000000000000000000000000001.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- '.0G", " 2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% '3.0G", " 2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- '50.0G", " 2E+06                                            ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 '.1G", " 2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- '1.1G", " 2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% '50.1G", "                                             2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- '.3G", " 1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 '1.3G", " 1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- '3.3G", " 1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% '.50G", " 1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- '1.50G", " 1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 '3.50G", " 1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- '50.50G", " 1,571,428.5714285713620483875274658203125        ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% +'1g", "+1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- +'3g", "+1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 +'50g", "+000000000000000000000000000000000000001.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- +'.0g", "+2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% +'3.0g", "+2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- +'50.0g", "+2e+06                                            ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 +'.1g", "+2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- +'1.1g", "+2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% +'50.1g", "                                            +2e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- +'.3g", "+1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 +'1.3g", "+1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- +'3.3g", "+1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% +'.50g", "+1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- +'1.50g", "+1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 +'3.50g", "+1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- +'50.50g", "+1,571,428.5714285713620483875274658203125        ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% +'1G", "+1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- +'3G", "+1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 +'50G", "+000000000000000000000000000000000000001.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- +'.0G", "+2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% +'3.0G", "+2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- +'50.0G", "+2E+06                                            ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 +'.1G", "+2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- +'1.1G", "+2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% +'50.1G", "                                            +2E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- +'.3G", "+1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 +'1.3G", "+1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- +'3.3G", "+1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "% +'.50G", "+1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%- +'1.50G", "+1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0 +'3.50G", "+1,571,428.5714285713620483875274658203125", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%0- +'50.50G", "+1,571,428.5714285713620483875274658203125        ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#'1g", "1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-'3g", "1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0'50g", "0000000000000000000000000000000000000001.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-'.0g", "2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#'3.0g", "2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-'50.0g", "2.e+06                                            ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0'.1g", "2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-'1.1g", "2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#'50.1g", "                                            2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-'.3g", "1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0'1.3g", "1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-'3.3g", "1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#'.50g", "1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-'1.50g", "1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0'3.50g", "1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-'50.50g", "1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#'1G", "1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-'3G", "1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0'50G", "0000000000000000000000000000000000000001.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-'.0G", "2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#'3.0G", "2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-'50.0G", "2.E+06                                            ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0'.1G", "2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-'1.1G", "2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#'50.1G", "                                            2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-'.3G", "1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0'1.3G", "1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-'3.3G", "1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#'.50G", "1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-'1.50G", "1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0'3.50G", "1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-'50.50G", "1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#+'1g", "+1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-+'3g", "+1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0+'50g", "+000000000000000000000000000000000000001.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-+'.0g", "+2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#+'3.0g", "+2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-+'50.0g", "+2.e+06                                           ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0+'.1g", "+2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-+'1.1g", "+2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#+'50.1g", "                                           +2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-+'.3g", "+1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0+'1.3g", "+1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-+'3.3g", "+1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#+'.50g", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-+'1.50g", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0+'3.50g", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-+'50.50g", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#+'1G", "+1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-+'3G", "+1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0+'50G", "+000000000000000000000000000000000000001.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-+'.0G", "+2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#+'3.0G", "+2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-+'50.0G", "+2.E+06                                           ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0+'.1G", "+2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-+'1.1G", "+2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#+'50.1G", "                                           +2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-+'.3G", "+1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0+'1.3G", "+1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-+'3.3G", "+1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#+'.50G", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#-+'1.50G", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0+'3.50G", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0-+'50.50G", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# '1g", " 1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- '3g", " 1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 '50g", " 000000000000000000000000000000000000001.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- '.0g", " 2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# '3.0g", " 2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- '50.0g", " 2.e+06                                           ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 '.1g", " 2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- '1.1g", " 2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# '50.1g", "                                            2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- '.3g", " 1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 '1.3g", " 1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- '3.3g", " 1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# '.50g", " 1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- '1.50g", " 1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 '3.50g", " 1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- '50.50g", " 1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# '1G", " 1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- '3G", " 1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 '50G", " 000000000000000000000000000000000000001.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- '.0G", " 2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# '3.0G", " 2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- '50.0G", " 2.E+06                                           ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 '.1G", " 2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- '1.1G", " 2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# '50.1G", "                                            2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- '.3G", " 1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 '1.3G", " 1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- '3.3G", " 1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# '.50G", " 1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- '1.50G", " 1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 '3.50G", " 1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- '50.50G", " 1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# +'1g", "+1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- +'3g", "+1.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000001.57143e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- +'.0g", "+2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# +'3.0g", "+2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- +'50.0g", "+2.e+06                                           ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 +'.1g", "+2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- +'1.1g", "+2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# +'50.1g", "                                           +2.e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- +'.3g", "+1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 +'1.3g", "+1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- +'3.3g", "+1.57e+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# +'.50g", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- +'1.50g", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 +'3.50g", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- +'50.50g", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# +'1G", "+1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- +'3G", "+1.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000001.57143E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- +'.0G", "+2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# +'3.0G", "+2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- +'50.0G", "+2.E+06                                           ", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 +'.1G", "+2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- +'1.1G", "+2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# +'50.1G", "                                           +2.E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- +'.3G", "+1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 +'1.3G", "+1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- +'3.3G", "+1.57E+06", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%# +'.50G", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#- +'1.50G", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0 +'3.50G", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%#0- +'50.50G", "+1,571,428.5714285713620483875274658203125000000000000", { 146, 36, 73, 146, 100, 250, 55, 65 } },
    { "%'1g", "0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-'3g", "0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0'50g", "00000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-'.0g", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%'3.0g", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-'50.0g", "0.002                                             ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0'.1g", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-'1.1g", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%'50.1g", "                                             0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-'.3g", "0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0'1.3g", "0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-'3.3g", "0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%'.50g", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-'1.50g", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0'3.50g", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-'50.50g", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%'1G", "0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-'3G", "0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0'50G", "00000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-'.0G", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%'3.0G", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-'50.0G", "0.002                                             ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0'.1G", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-'1.1G", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%'50.1G", "                                             0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-'.3G", "0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0'1.3G", "0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-'3.3G", "0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%'.50G", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-'1.50G", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0'3.50G", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-'50.50G", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%+'1g", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-+'3g", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0+'50g", "+0000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-+'.0g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%+'3.0g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-+'50.0g", "+0.002                                            ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0+'.1g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-+'1.1g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%+'50.1g", "                                            +0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-+'.3g", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0+'1.3g", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-+'3.3g", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%+'.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-+'1.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0+'3.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-+'50.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%+'1G", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-+'3G", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0+'50G", "+0000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-+'.0G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%+'3.0G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-+'50.0G", "+0.002                                            ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0+'.1G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-+'1.1G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%+'50.1G", "                                            +0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-+'.3G", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0+'1.3G", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-+'3.3G", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%+'.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%-+'1.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0+'3.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0-+'50.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% '1g", " 0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- '3g", " 0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 '50g", " 0000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- '.0g", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% '3.0g", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- '50.0g", " 0.002                                            ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 '.1g", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- '1.1g", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% '50.1g", "                                             0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- '.3g", " 0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 '1.3g", " 0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- '3.3g", " 0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% '.50g", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- '1.50g", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 '3.50g", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- '50.50g", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% '1G", " 0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- '3G", " 0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 '50G", " 0000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- '.0G", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% '3.0G", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- '50.0G", " 0.002                                            ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 '.1G", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- '1.1G", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% '50.1G", "                                             0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- '.3G", " 0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 '1.3G", " 0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- '3.3G", " 0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% '.50G", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- '1.50G", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 '3.50G", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- '50.50G", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% +'1g", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- +'3g", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 +'50g", "+0000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- +'.0g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% +'3.0g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- +'50.0g", "+0.002                                            ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 +'.1g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- +'1.1g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% +'50.1g", "                                            +0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- +'.3g", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 +'1.3g", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- +'3.3g", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% +'.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- +'1.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 +'3.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- +'50.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% +'1G", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- +'3G", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 +'50G", "+0000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- +'.0G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% +'3.0G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- +'50.0G", "+0.002                                            ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 +'.1G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- +'1.1G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% +'50.1G", "                                            +0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- +'.3G", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 +'1.3G", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- +'3.3G", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "% +'.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%- +'1.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0 +'3.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%0- +'50.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#'1g", "0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-'3g", "0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0'50g", "00000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-'.0g", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#'3.0g", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-'50.0g", "0.002                                             ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0'.1g", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-'1.1g", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#'50.1g", "                                             0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-'.3g", "0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0'1.3g", "0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-'3.3g", "0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#'.50g", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-'1.50g", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0'3.50g", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-'50.50g", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#'1G", "0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-'3G", "0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0'50G", "00000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-'.0G", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#'3.0G", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-'50.0G", "0.002                                             ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0'.1G", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-'1.1G", "0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#'50.1G", "                                             0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-'.3G", "0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0'1.3G", "0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-'3.3G", "0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#'.50G", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-'1.50G", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0'3.50G", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-'50.50G", "0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#+'1g", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-+'3g", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0+'50g", "+0000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-+'.0g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#+'3.0g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-+'50.0g", "+0.002                                            ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0+'.1g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-+'1.1g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#+'50.1g", "                                            +0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-+'.3g", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0+'1.3g", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-+'3.3g", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#+'.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-+'1.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0+'3.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-+'50.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#+'1G", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-+'3G", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0+'50G", "+0000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-+'.0G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#+'3.0G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-+'50.0G", "+0.002                                            ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0+'.1G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-+'1.1G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#+'50.1G", "                                            +0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-+'.3G", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0+'1.3G", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-+'3.3G", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#+'.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#-+'1.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0+'3.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0-+'50.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# '1g", " 0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- '3g", " 0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 '50g", " 0000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- '.0g", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# '3.0g", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- '50.0g", " 0.002                                            ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 '.1g", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- '1.1g", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# '50.1g", "                                             0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- '.3g", " 0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 '1.3g", " 0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- '3.3g", " 0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# '.50g", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- '1.50g", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 '3.50g", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- '50.50g", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# '1G", " 0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- '3G", " 0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 '50G", " 0000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- '.0G", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# '3.0G", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- '50.0G", " 0.002                                            ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 '.1G", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- '1.1G", " 0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# '50.1G", "                                             0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- '.3G", " 0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 '1.3G", " 0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- '3.3G", " 0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# '.50G", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- '1.50G", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 '3.50G", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- '50.50G", " 0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# +'1g", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- +'3g", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 +'50g", "+0000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- +'.0g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# +'3.0g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- +'50.0g", "+0.002                                            ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 +'.1g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- +'1.1g", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# +'50.1g", "                                            +0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- +'.3g", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 +'1.3g", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- +'3.3g", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# +'.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- +'1.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 +'3.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- +'50.50g", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# +'1G", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- +'3G", "+0.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 +'50G", "+0000000000000000000000000000000000000000.00157143", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- +'.0G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# +'3.0G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- +'50.0G", "+0.002                                            ", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 +'.1G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- +'1.1G", "+0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# +'50.1G", "                                            +0.002", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- +'.3G", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 +'1.3G", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- +'3.3G", "+0.00157", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%# +'.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#- +'1.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0 +'3.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%#0- +'50.50G", "+0.0015714285714285714922605619037199176091235131025314", { 67, 84, 160, 148, 12, 191, 89, 63 } },
    { "%'1g", "1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-'3g", "1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0'50g", "0000000000000000000000000000000000000001.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-'.0g", "2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%'3.0g", "2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-'50.0g", "2e-06                                             ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0'.1g", "2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-'1.1g", "2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%'50.1g", "                                             2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-'.3g", "1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0'1.3g", "1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-'3.3g", "1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%'.50g", "1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-'1.50g", "1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0'3.50g", "1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-'50.50g", "1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%'1G", "1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-'3G", "1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0'50G", "0000000000000000000000000000000000000001.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-'.0G", "2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%'3.0G", "2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-'50.0G", "2E-06                                             ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0'.1G", "2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-'1.1G", "2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%'50.1G", "                                             2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-'.3G", "1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0'1.3G", "1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-'3.3G", "1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%'.50G", "1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-'1.50G", "1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0'3.50G", "1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-'50.50G", "1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%+'1g", "+1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-+'3g", "+1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0+'50g", "+000000000000000000000000000000000000001.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-+'.0g", "+2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%+'3.0g", "+2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-+'50.0g", "+2e-06                                            ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0+'.1g", "+2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-+'1.1g", "+2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%+'50.1g", "                                            +2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-+'.3g", "+1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0+'1.3g", "+1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-+'3.3g", "+1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%+'.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-+'1.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0+'3.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-+'50.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%+'1G", "+1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-+'3G", "+1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0+'50G", "+000000000000000000000000000000000000001.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-+'.0G", "+2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%+'3.0G", "+2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-+'50.0G", "+2E-06                                            ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0+'.1G", "+2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-+'1.1G", "+2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%+'50.1G", "                                            +2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-+'.3G", "+1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0+'1.3G", "+1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-+'3.3G", "+1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%+'.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%-+'1.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0+'3.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0-+'50.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% '1g", " 1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- '3g", " 1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 '50g", " 000000000000000000000000000000000000001.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- '.0g", " 2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% '3.0g", " 2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- '50.0g", " 2e-06                                            ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 '.1g", " 2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- '1.1g", " 2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% '50.1g", "                                             2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- '.3g", " 1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 '1.3g", " 1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- '3.3g", " 1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% '.50g", " 1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- '1.50g", " 1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 '3.50g", " 1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- '50.50g", " 1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% '1G", " 1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- '3G", " 1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 '50G", " 000000000000000000000000000000000000001.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- '.0G", " 2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% '3.0G", " 2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- '50.0G", " 2E-06                                            ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 '.1G", " 2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- '1.1G", " 2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% '50.1G", "                                             2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- '.3G", " 1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 '1.3G", " 1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- '3.3G", " 1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% '.50G", " 1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- '1.50G", " 1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 '3.50G", " 1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- '50.50G", " 1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% +'1g", "+1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- +'3g", "+1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 +'50g", "+000000000000000000000000000000000000001.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- +'.0g", "+2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% +'3.0g", "+2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- +'50.0g", "+2e-06                                            ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 +'.1g", "+2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- +'1.1g", "+2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% +'50.1g", "                                            +2e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- +'.3g", "+1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 +'1.3g", "+1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- +'3.3g", "+1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% +'.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- +'1.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 +'3.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- +'50.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% +'1G", "+1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- +'3G", "+1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 +'50G", "+000000000000000000000000000000000000001.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- +'.0G", "+2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% +'3.0G", "+2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- +'50.0G", "+2E-06                                            ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 +'.1G", "+2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- +'1.1G", "+2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% +'50.1G", "                                            +2E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- +'.3G", "+1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 +'1.3G", "+1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- +'3.3G", "+1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "% +'.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%- +'1.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0 +'3.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%0- +'50.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#'1g", "1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-'3g", "1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0'50g", "0000000000000000000000000000000000000001.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-'.0g", "2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#'3.0g", "2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-'50.0g", "2.e-06                                            ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0'.1g", "2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-'1.1g", "2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#'50.1g", "                                            2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-'.3g", "1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0'1.3g", "1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-'3.3g", "1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#'.50g", "1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-'1.50g", "1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0'3.50g", "1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-'50.50g", "1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#'1G", "1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-'3G", "1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0'50G", "0000000000000000000000000000000000000001.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-'.0G", "2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#'3.0G", "2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-'50.0G", "2.E-06                                            ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0'.1G", "2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-'1.1G", "2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#'50.1G", "                                            2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-'.3G", "1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0'1.3G", "1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-'3.3G", "1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#'.50G", "1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-'1.50G", "1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0'3.50G", "1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-'50.50G", "1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#+'1g", "+1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-+'3g", "+1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0+'50g", "+000000000000000000000000000000000000001.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-+'.0g", "+2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#+'3.0g", "+2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-+'50.0g", "+2.e-06                                           ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0+'.1g", "+2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-+'1.1g", "+2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#+'50.1g", "                                           +2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-+'.3g", "+1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0+'1.3g", "+1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-+'3.3g", "+1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#+'.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-+'1.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0+'3.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-+'50.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#+'1G", "+1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-+'3G", "+1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0+'50G", "+000000000000000000000000000000000000001.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-+'.0G", "+2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#+'3.0G", "+2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-+'50.0G", "+2.E-06                                           ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0+'.1G", "+2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-+'1.1G", "+2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#+'50.1G", "                                           +2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-+'.3G", "+1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0+'1.3G", "+1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-+'3.3G", "+1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#+'.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#-+'1.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0+'3.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0-+'50.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# '1g", " 1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- '3g", " 1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 '50g", " 000000000000000000000000000000000000001.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- '.0g", " 2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# '3.0g", " 2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- '50.0g", " 2.e-06                                           ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 '.1g", " 2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- '1.1g", " 2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# '50.1g", "                                            2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- '.3g", " 1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 '1.3g", " 1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- '3.3g", " 1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# '.50g", " 1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- '1.50g", " 1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 '3.50g", " 1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- '50.50g", " 1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# '1G", " 1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- '3G", " 1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 '50G", " 000000000000000000000000000000000000001.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- '.0G", " 2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# '3.0G", " 2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- '50.0G", " 2.E-06                                           ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 '.1G", " 2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- '1.1G", " 2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# '50.1G", "                                            2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- '.3G", " 1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 '1.3G", " 1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- '3.3G", " 1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# '.50G", " 1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- '1.50G", " 1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 '3.50G", " 1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- '50.50G", " 1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# +'1g", "+1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- +'3g", "+1.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000001.57143e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- +'.0g", "+2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# +'3.0g", "+2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- +'50.0g", "+2.e-06                                           ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 +'.1g", "+2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- +'1.1g", "+2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# +'50.1g", "                                           +2.e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- +'.3g", "+1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 +'1.3g", "+1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- +'3.3g", "+1.57e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# +'.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- +'1.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 +'3.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- +'50.50g", "+1.5714285714285714482148486464962999775707430671901e-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# +'1G", "+1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- +'3G", "+1.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000001.57143E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- +'.0G", "+2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# +'3.0G", "+2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- +'50.0G", "+2.E-06                                           ", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 +'.1G", "+2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- +'1.1G", "+2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# +'50.1G", "                                           +2.E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- +'.3G", "+1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 +'1.3G", "+1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- +'3.3G", "+1.57E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%# +'.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#- +'1.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0 +'3.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%#0- +'50.50G", "+1.5714285714285714482148486464962999775707430671901E-06", { 222, 153, 139, 252, 59, 93, 186, 62 } },
    { "%'1g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-'3g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0'50g", "000000000000000000000000000000000000000000000000.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-'.0g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%'3.0g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-'50.0g", "0.1                                               ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0'.1g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-'1.1g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%'50.1g", "                                               0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-'.3g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0'1.3g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-'3.3g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%'.50g", "0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-'1.50g", "0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0'3.50g", "0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-'50.50g", "0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%'1G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-'3G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0'50G", "000000000000000000000000000000000000000000000000.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-'.0G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%'3.0G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-'50.0G", "0.1                                               ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0'.1G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-'1.1G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%'50.1G", "                                               0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-'.3G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0'1.3G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-'3.3G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%'.50G", "0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-'1.50G", "0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0'3.50G", "0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-'50.50G", "0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%+'1g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-+'3g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0+'50g", "+00000000000000000000000000000000000000000000000.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-+'.0g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%+'3.0g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-+'50.0g", "+0.1                                              ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0+'.1g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-+'1.1g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%+'50.1g", "                                              +0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-+'.3g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0+'1.3g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-+'3.3g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%+'.50g", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-+'1.50g", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0+'3.50g", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-+'50.50g", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%+'1G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-+'3G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0+'50G", "+00000000000000000000000000000000000000000000000.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-+'.0G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%+'3.0G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-+'50.0G", "+0.1                                              ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0+'.1G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-+'1.1G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%+'50.1G", "                                              +0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-+'.3G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0+'1.3G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-+'3.3G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%+'.50G", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%-+'1.50G", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0+'3.50G", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0-+'50.50G", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% '1g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- '3g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 '50g", " 00000000000000000000000000000000000000000000000.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- '.0g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% '3.0g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- '50.0g", " 0.1                                              ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 '.1g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- '1.1g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% '50.1g", "                                               0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- '.3g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 '1.3g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- '3.3g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% '.50g", " 0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- '1.50g", " 0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 '3.50g", " 0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- '50.50g", " 0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% '1G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- '3G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 '50G", " 00000000000000000000000000000000000000000000000.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- '.0G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% '3.0G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- '50.0G", " 0.1                                              ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 '.1G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- '1.1G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% '50.1G", "                                               0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- '.3G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 '1.3G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- '3.3G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% '.50G", " 0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- '1.50G", " 0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 '3.50G", " 0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- '50.50G", " 0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% +'1g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- +'3g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 +'50g", "+00000000000000000000000000000000000000000000000.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- +'.0g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% +'3.0g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- +'50.0g", "+0.1                                              ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 +'.1g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- +'1.1g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% +'50.1g", "                                              +0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- +'.3g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 +'1.3g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- +'3.3g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% +'.50g", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- +'1.50g", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 +'3.50g", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- +'50.50g", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% +'1G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- +'3G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 +'50G", "+00000000000000000000000000000000000000000000000.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- +'.0G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% +'3.0G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- +'50.0G", "+0.1                                              ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 +'.1G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- +'1.1G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% +'50.1G", "                                              +0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- +'.3G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 +'1.3G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- +'3.3G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "% +'.50G", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%- +'1.50G", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0 +'3.50G", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%0- +'50.50G", "+0.1000000000000000055511151231257827021181583404541", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#'1g", "0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-'3g", "0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0'50g", "0000000000000000000000000000000000000000000.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-'.0g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#'3.0g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-'50.0g", "0.1                                               ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0'.1g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-'1.1g", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#'50.1g", "                                               0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-'.3g", "0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0'1.3g", "0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-'3.3g", "0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#'.50g", "0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-'1.50g", "0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0'3.50g", "0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-'50.50g", "0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#'1G", "0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-'3G", "0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0'50G", "0000000000000000000000000000000000000000000.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-'.0G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#'3.0G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-'50.0G", "0.1                                               ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0'.1G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-'1.1G", "0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#'50.1G", "                                               0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-'.3G", "0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0'1.3G", "0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-'3.3G", "0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#'.50G", "0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-'1.50G", "0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0'3.50G", "0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-'50.50G", "0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#+'1g", "+0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-+'3g", "+0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0+'50g", "+000000000000000000000000000000000000000000.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-+'.0g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#+'3.0g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-+'50.0g", "+0.1                                              ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0+'.1g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-+'1.1g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#+'50.1g", "                                              +0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-+'.3g", "+0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0+'1.3g", "+0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-+'3.3g", "+0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#+'.50g", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-+'1.50g", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0+'3.50g", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-+'50.50g", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#+'1G", "+0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-+'3G", "+0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0+'50G", "+000000000000000000000000000000000000000000.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-+'.0G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#+'3.0G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-+'50.0G", "+0.1                                              ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0+'.1G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-+'1.1G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#+'50.1G", "                                              +0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-+'.3G", "+0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0+'1.3G", "+0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-+'3.3G", "+0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#+'.50G", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#-+'1.50G", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0+'3.50G", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0-+'50.50G", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# '1g", " 0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- '3g", " 0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 '50g", " 000000000000000000000000000000000000000000.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- '.0g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# '3.0g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- '50.0g", " 0.1                                              ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 '.1g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- '1.1g", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# '50.1g", "                                               0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- '.3g", " 0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 '1.3g", " 0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- '3.3g", " 0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# '.50g", " 0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- '1.50g", " 0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 '3.50g", " 0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- '50.50g", " 0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# '1G", " 0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- '3G", " 0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 '50G", " 000000000000000000000000000000000000000000.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- '.0G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# '3.0G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- '50.0G", " 0.1                                              ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 '.1G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- '1.1G", " 0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# '50.1G", "                                               0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- '.3G", " 0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 '1.3G", " 0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- '3.3G", " 0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# '.50G", " 0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- '1.50G", " 0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 '3.50G", " 0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- '50.50G", " 0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# +'1g", "+0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- +'3g", "+0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000000000.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- +'.0g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# +'3.0g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- +'50.0g", "+0.1                                              ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 +'.1g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- +'1.1g", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# +'50.1g", "                                              +0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- +'.3g", "+0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 +'1.3g", "+0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- +'3.3g", "+0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# +'.50g", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- +'1.50g", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 +'3.50g", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- +'50.50g", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# +'1G", "+0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- +'3G", "+0.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000000000.100000", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- +'.0G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# +'3.0G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- +'50.0G", "+0.1                                              ", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 +'.1G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- +'1.1G", "+0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# +'50.1G", "                                              +0.1", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- +'.3G", "+0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 +'1.3G", "+0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- +'3.3G", "+0.100", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%# +'.50G", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#- +'1.50G", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0 +'3.50G", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%#0- +'50.50G", "+0.10000000000000000555111512312578270211815834045410", { 154, 153, 153, 153, 153, 153, 185, 63 } },
    { "%'1g", "1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-'3g", "1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0'50g", "0000000000000000000000000000000000000000000001e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-'.0g", "1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%'3.0g", "1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-'50.0g", "1e-06                                             ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0'.1g", "1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-'1.1g", "1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%'50.1g", "                                             1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-'.3g", "1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0'1.3g", "1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-'3.3g", "1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%'.50g", "9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-'1.50g", "9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0'3.50g", "9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-'50.50g", "9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%'1G", "1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-'3G", "1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0'50G", "0000000000000000000000000000000000000000000001E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-'.0G", "1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%'3.0G", "1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-'50.0G", "1E-06                                             ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0'.1G", "1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-'1.1G", "1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%'50.1G", "                                             1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-'.3G", "1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0'1.3G", "1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-'3.3G", "1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%'.50G", "9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-'1.50G", "9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0'3.50G", "9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-'50.50G", "9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%+'1g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-+'3g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0+'50g", "+000000000000000000000000000000000000000000001e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-+'.0g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%+'3.0g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-+'50.0g", "+1e-06                                            ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0+'.1g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-+'1.1g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%+'50.1g", "                                            +1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-+'.3g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0+'1.3g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-+'3.3g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%+'.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-+'1.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0+'3.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-+'50.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%+'1G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-+'3G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0+'50G", "+000000000000000000000000000000000000000000001E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-+'.0G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%+'3.0G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-+'50.0G", "+1E-06                                            ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0+'.1G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-+'1.1G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%+'50.1G", "                                            +1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-+'.3G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0+'1.3G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-+'3.3G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%+'.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%-+'1.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0+'3.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0-+'50.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% '1g", " 1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- '3g", " 1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 '50g", " 000000000000000000000000000000000000000000001e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- '.0g", " 1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% '3.0g", " 1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- '50.0g", " 1e-06                                            ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 '.1g", " 1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- '1.1g", " 1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% '50.1g", "                                             1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- '.3g", " 1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 '1.3g", " 1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- '3.3g", " 1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% '.50g", " 9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- '1.50g", " 9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 '3.50g", " 9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- '50.50g", " 9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% '1G", " 1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- '3G", " 1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 '50G", " 000000000000000000000000000000000000000000001E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- '.0G", " 1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% '3.0G", " 1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- '50.0G", " 1E-06                                            ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 '.1G", " 1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- '1.1G", " 1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% '50.1G", "                                             1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- '.3G", " 1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 '1.3G", " 1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- '3.3G", " 1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% '.50G", " 9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- '1.50G", " 9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 '3.50G", " 9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- '50.50G", " 9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% +'1g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- +'3g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 +'50g", "+000000000000000000000000000000000000000000001e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- +'.0g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% +'3.0g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- +'50.0g", "+1e-06                                            ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 +'.1g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- +'1.1g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% +'50.1g", "                                            +1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- +'.3g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 +'1.3g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- +'3.3g", "+1e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% +'.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- +'1.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 +'3.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- +'50.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% +'1G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- +'3G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 +'50G", "+000000000000000000000000000000000000000000001E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- +'.0G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% +'3.0G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- +'50.0G", "+1E-06                                            ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 +'.1G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- +'1.1G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% +'50.1G", "                                            +1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- +'.3G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 +'1.3G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- +'3.3G", "+1E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "% +'.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%- +'1.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0 +'3.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%0- +'50.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#'1g", "1.00000e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-'3g", "1.00000e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0'50g", "0000000000000000000000000000000000000001.00000e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-'.0g", "1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#'3.0g", "1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-'50.0g", "1.e-06                                            ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0'.1g", "1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-'1.1g", "1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#'50.1g", "                                            1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-'.3g", "1.00e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0'1.3g", "1.00e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-'3.3g", "1.00e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#'.50g", "9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-'1.50g", "9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0'3.50g", "9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-'50.50g", "9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#'1G", "1.00000E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-'3G", "1.00000E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0'50G", "0000000000000000000000000000000000000001.00000E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-'.0G", "1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#'3.0G", "1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-'50.0G", "1.E-06                                            ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0'.1G", "1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-'1.1G", "1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#'50.1G", "                                            1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-'.3G", "1.00E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0'1.3G", "1.00E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-'3.3G", "1.00E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#'.50G", "9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-'1.50G", "9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0'3.50G", "9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-'50.50G", "9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#+'1g", "+1.00000e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-+'3g", "+1.00000e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0+'50g", "+000000000000000000000000000000000000001.00000e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-+'.0g", "+1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#+'3.0g", "+1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-+'50.0g", "+1.e-06                                           ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0+'.1g", "+1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-+'1.1g", "+1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#+'50.1g", "                                           +1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-+'.3g", "+1.00e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0+'1.3g", "+1.00e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-+'3.3g", "+1.00e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#+'.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-+'1.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0+'3.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-+'50.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#+'1G", "+1.00000E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-+'3G", "+1.00000E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0+'50G", "+000000000000000000000000000000000000001.00000E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-+'.0G", "+1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#+'3.0G", "+1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-+'50.0G", "+1.E-06                                           ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0+'.1G", "+1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-+'1.1G", "+1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#+'50.1G", "                                           +1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-+'.3G", "+1.00E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0+'1.3G", "+1.00E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-+'3.3G", "+1.00E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#+'.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#-+'1.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0+'3.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0-+'50.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# '1g", " 1.00000e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- '3g", " 1.00000e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 '50g", " 000000000000000000000000000000000000001.00000e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- '.0g", " 1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# '3.0g", " 1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- '50.0g", " 1.e-06                                           ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 '.1g", " 1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- '1.1g", " 1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# '50.1g", "                                            1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- '.3g", " 1.00e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 '1.3g", " 1.00e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- '3.3g", " 1.00e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# '.50g", " 9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- '1.50g", " 9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 '3.50g", " 9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- '50.50g", " 9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# '1G", " 1.00000E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- '3G", " 1.00000E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 '50G", " 000000000000000000000000000000000000001.00000E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- '.0G", " 1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# '3.0G", " 1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- '50.0G", " 1.E-06                                           ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 '.1G", " 1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- '1.1G", " 1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# '50.1G", "                                            1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- '.3G", " 1.00E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 '1.3G", " 1.00E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- '3.3G", " 1.00E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# '.50G", " 9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- '1.50G", " 9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 '3.50G", " 9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- '50.50G", " 9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# +'1g", "+1.00000e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- +'3g", "+1.00000e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000001.00000e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- +'.0g", "+1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# +'3.0g", "+1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- +'50.0g", "+1.e-06                                           ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 +'.1g", "+1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- +'1.1g", "+1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# +'50.1g", "                                           +1.e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- +'.3g", "+1.00e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 +'1.3g", "+1.00e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- +'3.3g", "+1.00e-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# +'.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- +'1.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 +'3.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- +'50.50g", "+9.9999999999999995474811182588625868561393872369081e-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# +'1G", "+1.00000E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- +'3G", "+1.00000E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000001.00000E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- +'.0G", "+1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# +'3.0G", "+1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- +'50.0G", "+1.E-06                                           ", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 +'.1G", "+1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- +'1.1G", "+1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# +'50.1G", "                                           +1.E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- +'.3G", "+1.00E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 +'1.3G", "+1.00E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- +'3.3G", "+1.00E-06", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%# +'.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#- +'1.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0 +'3.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%#0- +'50.50G", "+9.9999999999999995474811182588625868561393872369081E-07", { 141, 237, 181, 160, 247, 198, 176, 62 } },
    { "%'1g", "100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-'3g", "100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0'50g", "0000000000000000000000000000000000000000000100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-'.0g", "1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%'3.0g", "1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-'50.0g", "1e+05                                             ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0'.1g", "1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-'1.1g", "1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%'50.1g", "                                             1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-'.3g", "1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0'1.3g", "1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-'3.3g", "1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%'.50g", "100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-'1.50g", "100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0'3.50g", "100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-'50.50g", "100,000                                           ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%'1G", "100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-'3G", "100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0'50G", "0000000000000000000000000000000000000000000100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-'.0G", "1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%'3.0G", "1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-'50.0G", "1E+05                                             ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0'.1G", "1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-'1.1G", "1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%'50.1G", "                                             1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-'.3G", "1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0'1.3G", "1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-'3.3G", "1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%'.50G", "100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-'1.50G", "100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0'3.50G", "100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-'50.50G", "100,000                                           ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%+'1g", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-+'3g", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0+'50g", "+000000000000000000000000000000000000000000100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-+'.0g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%+'3.0g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-+'50.0g", "+1e+05                                            ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0+'.1g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-+'1.1g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%+'50.1g", "                                            +1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-+'.3g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0+'1.3g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-+'3.3g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%+'.50g", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-+'1.50g", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0+'3.50g", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-+'50.50g", "+100,000                                          ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%+'1G", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-+'3G", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0+'50G", "+000000000000000000000000000000000000000000100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-+'.0G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%+'3.0G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-+'50.0G", "+1E+05                                            ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0+'.1G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-+'1.1G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%+'50.1G", "                                            +1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-+'.3G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0+'1.3G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-+'3.3G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%+'.50G", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%-+'1.50G", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0+'3.50G", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0-+'50.50G", "+100,000                                          ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% '1g", " 100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- '3g", " 100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 '50g", " 000000000000000000000000000000000000000000100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- '.0g", " 1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% '3.0g", " 1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- '50.0g", " 1e+05                                            ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 '.1g", " 1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- '1.1g", " 1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% '50.1g", "                                             1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- '.3g", " 1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 '1.3g", " 1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- '3.3g", " 1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% '.50g", " 100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- '1.50g", " 100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 '3.50g", " 100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- '50.50g", " 100,000                                          ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% '1G", " 100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- '3G", " 100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 '50G", " 000000000000000000000000000000000000000000100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- '.0G", " 1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% '3.0G", " 1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- '50.0G", " 1E+05                                            ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 '.1G", " 1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- '1.1G", " 1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% '50.1G", "                                             1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- '.3G", " 1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 '1.3G", " 1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- '3.3G", " 1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% '.50G", " 100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- '1.50G", " 100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 '3.50G", " 100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- '50.50G", " 100,000                                          ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% +'1g", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- +'3g", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 +'50g", "+000000000000000000000000000000000000000000100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- +'.0g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% +'3.0g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- +'50.0g", "+1e+05                                            ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 +'.1g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- +'1.1g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% +'50.1g", "                                            +1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- +'.3g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 +'1.3g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- +'3.3g", "+1e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% +'.50g", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- +'1.50g", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 +'3.50g", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- +'50.50g", "+100,000                                          ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% +'1G", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- +'3G", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 +'50G", "+000000000000000000000000000000000000000000100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- +'.0G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% +'3.0G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- +'50.0G", "+1E+05                                            ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 +'.1G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- +'1.1G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% +'50.1G", "                                            +1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- +'.3G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 +'1.3G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- +'3.3G", "+1E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "% +'.50G", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%- +'1.50G", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0 +'3.50G", "+100,000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%0- +'50.50G", "+100,000                                          ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#'1g", "100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-'3g", "100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0'50g", "000000000000000000000000000000000000000000100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-'.0g", "1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#'3.0g", "1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-'50.0g", "1.e+05                                            ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0'.1g", "1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-'1.1g", "1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#'50.1g", "                                            1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-'.3g", "1.00e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0'1.3g", "1.00e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-'3.3g", "1.00e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#'.50g", "100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-'1.50g", "100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0'3.50g", "100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-'50.50g", "100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#'1G", "100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-'3G", "100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0'50G", "000000000000000000000000000000000000000000100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-'.0G", "1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#'3.0G", "1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-'50.0G", "1.E+05                                            ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0'.1G", "1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-'1.1G", "1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#'50.1G", "                                            1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-'.3G", "1.00E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0'1.3G", "1.00E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-'3.3G", "1.00E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#'.50G", "100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-'1.50G", "100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0'3.50G", "100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-'50.50G", "100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#+'1g", "+100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-+'3g", "+100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0+'50g", "+00000000000000000000000000000000000000000100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-+'.0g", "+1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#+'3.0g", "+1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-+'50.0g", "+1.e+05                                           ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0+'.1g", "+1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-+'1.1g", "+1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#+'50.1g", "                                           +1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-+'.3g", "+1.00e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0+'1.3g", "+1.00e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-+'3.3g", "+1.00e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#+'.50g", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-+'1.50g", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0+'3.50g", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-+'50.50g", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#+'1G", "+100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-+'3G", "+100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0+'50G", "+00000000000000000000000000000000000000000100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-+'.0G", "+1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#+'3.0G", "+1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-+'50.0G", "+1.E+05                                           ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0+'.1G", "+1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-+'1.1G", "+1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#+'50.1G", "                                           +1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-+'.3G", "+1.00E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0+'1.3G", "+1.00E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-+'3.3G", "+1.00E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#+'.50G", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#-+'1.50G", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0+'3.50G", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0-+'50.50G", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# '1g", " 100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- '3g", " 100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 '50g", " 00000000000000000000000000000000000000000100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- '.0g", " 1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# '3.0g", " 1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- '50.0g", " 1.e+05                                           ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 '.1g", " 1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- '1.1g", " 1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# '50.1g", "                                            1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- '.3g", " 1.00e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 '1.3g", " 1.00e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- '3.3g", " 1.00e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# '.50g", " 100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- '1.50g", " 100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 '3.50g", " 100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- '50.50g", " 100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# '1G", " 100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- '3G", " 100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 '50G", " 00000000000000000000000000000000000000000100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- '.0G", " 1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# '3.0G", " 1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- '50.0G", " 1.E+05                                           ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 '.1G", " 1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- '1.1G", " 1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# '50.1G", "                                            1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- '.3G", " 1.00E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 '1.3G", " 1.00E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- '3.3G", " 1.00E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# '.50G", " 100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- '1.50G", " 100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 '3.50G", " 100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- '50.50G", " 100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# +'1g", "+100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- +'3g", "+100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 +'50g", "+00000000000000000000000000000000000000000100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- +'.0g", "+1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# +'3.0g", "+1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- +'50.0g", "+1.e+05                                           ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 +'.1g", "+1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- +'1.1g", "+1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# +'50.1g", "                                           +1.e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- +'.3g", "+1.00e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 +'1.3g", "+1.00e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- +'3.3g", "+1.00e+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# +'.50g", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- +'1.50g", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 +'3.50g", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- +'50.50g", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# +'1G", "+100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- +'3G", "+100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 +'50G", "+00000000000000000000000000000000000000000100,000.", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- +'.0G", "+1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# +'3.0G", "+1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- +'50.0G", "+1.E+05                                           ", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 +'.1G", "+1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- +'1.1G", "+1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# +'50.1G", "                                           +1.E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- +'.3G", "+1.00E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 +'1.3G", "+1.00E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- +'3.3G", "+1.00E+05", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%# +'.50G", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#- +'1.50G", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0 +'3.50G", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%#0- +'50.50G", "+100,000.00000000000000000000000000000000000000000000", { 0, 0, 0, 0, 0, 106, 248, 64 } },
    { "%'1g", "3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-'3g", "3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0'50g", "00000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-'.0g", "3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%'3.0g", "  3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-'50.0g", "3                                                 ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0'.1g", "3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-'1.1g", "3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%'50.1g", "                                                 3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-'.3g", "3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0'1.3g", "3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-'3.3g", "3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%'.50g", "3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-'1.50g", "3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0'3.50g", "3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-'50.50g", "3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%'1G", "3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-'3G", "3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0'50G", "00000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-'.0G", "3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%'3.0G", "  3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-'50.0G", "3                                                 ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0'.1G", "3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-'1.1G", "3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%'50.1G", "                                                 3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-'.3G", "3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0'1.3G", "3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-'3.3G", "3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%'.50G", "3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-'1.50G", "3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0'3.50G", "3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-'50.50G", "3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%+'1g", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-+'3g", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0+'50g", "+0000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-+'.0g", "+3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%+'3.0g", " +3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-+'50.0g", "+3                                                ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0+'.1g", "+3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-+'1.1g", "+3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%+'50.1g", "                                                +3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-+'.3g", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0+'1.3g", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-+'3.3g", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%+'.50g", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-+'1.50g", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0+'3.50g", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-+'50.50g", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%+'1G", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-+'3G", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0+'50G", "+0000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-+'.0G", "+3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%+'3.0G", " +3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-+'50.0G", "+3                                                ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0+'.1G", "+3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-+'1.1G", "+3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%+'50.1G", "                                                +3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-+'.3G", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0+'1.3G", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-+'3.3G", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%+'.50G", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%-+'1.50G", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0+'3.50G", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0-+'50.50G", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% '1g", " 3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- '3g", " 3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 '50g", " 0000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- '.0g", " 3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% '3.0g", "  3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- '50.0g", " 3                                                ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 '.1g", " 3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- '1.1g", " 3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% '50.1g", "                                                 3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- '.3g", " 3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 '1.3g", " 3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- '3.3g", " 3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% '.50g", " 3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- '1.50g", " 3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 '3.50g", " 3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- '50.50g", " 3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% '1G", " 3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- '3G", " 3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 '50G", " 0000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- '.0G", " 3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% '3.0G", "  3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- '50.0G", " 3                                                ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 '.1G", " 3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- '1.1G", " 3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% '50.1G", "                                                 3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- '.3G", " 3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 '1.3G", " 3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- '3.3G", " 3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% '.50G", " 3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- '1.50G", " 3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 '3.50G", " 3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- '50.50G", " 3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% +'1g", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- +'3g", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 +'50g", "+0000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- +'.0g", "+3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% +'3.0g", " +3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- +'50.0g", "+3                                                ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 +'.1g", "+3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- +'1.1g", "+3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% +'50.1g", "                                                +3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- +'.3g", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 +'1.3g", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- +'3.3g", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% +'.50g", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- +'1.50g", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 +'3.50g", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- +'50.50g", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% +'1G", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- +'3G", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 +'50G", "+0000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- +'.0G", "+3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% +'3.0G", " +3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- +'50.0G", "+3                                                ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 +'.1G", "+3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- +'1.1G", "+3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% +'50.1G", "                                                +3", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- +'.3G", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 +'1.3G", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- +'3.3G", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "% +'.50G", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%- +'1.50G", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0 +'3.50G", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%0- +'50.50G", "+3.141592653589793115997963468544185161590576171875", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#'1g", "3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-'3g", "3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0'50g", "00000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-'.0g", "3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#'3.0g", " 3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-'50.0g", "3.                                                ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0'.1g", "3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-'1.1g", "3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#'50.1g", "                                                3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-'.3g", "3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0'1.3g", "3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-'3.3g", "3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#'.50g", "3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-'1.50g", "3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0'3.50g", "3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-'50.50g", "3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#'1G", "3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-'3G", "3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0'50G", "00000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-'.0G", "3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#'3.0G", " 3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-'50.0G", "3.                                                ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0'.1G", "3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-'1.1G", "3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#'50.1G", "                                                3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-'.3G", "3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0'1.3G", "3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-'3.3G", "3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#'.50G", "3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-'1.50G", "3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0'3.50G", "3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-'50.50G", "3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#+'1g", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-+'3g", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0+'50g", "+0000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-+'.0g", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#+'3.0g", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-+'50.0g", "+3.                                               ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0+'.1g", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-+'1.1g", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#+'50.1g", "                                               +3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-+'.3g", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0+'1.3g", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-+'3.3g", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#+'.50g", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-+'1.50g", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0+'3.50g", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-+'50.50g", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#+'1G", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-+'3G", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0+'50G", "+0000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-+'.0G", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#+'3.0G", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-+'50.0G", "+3.                                               ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0+'.1G", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-+'1.1G", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#+'50.1G", "                                               +3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-+'.3G", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0+'1.3G", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-+'3.3G", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#+'.50G", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#-+'1.50G", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0+'3.50G", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0-+'50.50G", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# '1g", " 3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- '3g", " 3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 '50g", " 0000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- '.0g", " 3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# '3.0g", " 3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- '50.0g", " 3.                                               ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 '.1g", " 3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- '1.1g", " 3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# '50.1g", "                                                3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- '.3g", " 3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 '1.3g", " 3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- '3.3g", " 3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# '.50g", " 3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- '1.50g", " 3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 '3.50g", " 3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- '50.50g", " 3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# '1G", " 3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- '3G", " 3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 '50G", " 0000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- '.0G", " 3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# '3.0G", " 3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- '50.0G", " 3.                                               ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 '.1G", " 3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- '1.1G", " 3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# '50.1G", "                                                3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- '.3G", " 3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 '1.3G", " 3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- '3.3G", " 3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# '.50G", " 3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- '1.50G", " 3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 '3.50G", " 3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- '50.50G", " 3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# +'1g", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- +'3g", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 +'50g", "+0000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- +'.0g", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# +'3.0g", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- +'50.0g", "+3.                                               ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 +'.1g", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- +'1.1g", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# +'50.1g", "                                               +3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- +'.3g", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 +'1.3g", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- +'3.3g", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# +'.50g", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- +'1.50g", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 +'3.50g", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- +'50.50g", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# +'1G", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- +'3G", "+3.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 +'50G", "+0000000000000000000000000000000000000000003.14159", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- +'.0G", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# +'3.0G", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- +'50.0G", "+3.                                               ", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 +'.1G", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- +'1.1G", "+3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# +'50.1G", "                                               +3.", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- +'.3G", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 +'1.3G", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- +'3.3G", "+3.14", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%# +'.50G", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#- +'1.50G", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0 +'3.50G", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%#0- +'50.50G", "+3.1415926535897931159979634685441851615905761718750", { 24, 45, 68, 84, 251, 33, 9, 64 } },
    { "%'1g", "3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-'3g", "3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0'50g", "0000000000000000000000000000000000000003.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-'.0g", "3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%'3.0g", "3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-'50.0g", "3e-50                                             ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0'.1g", "3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-'1.1g", "3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%'50.1g", "                                             3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-'.3g", "3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0'1.3g", "3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-'3.3g", "3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%'.50g", "3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-'1.50g", "3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0'3.50g", "3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-'50.50g", "3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%'1G", "3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-'3G", "3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0'50G", "0000000000000000000000000000000000000003.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-'.0G", "3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%'3.0G", "3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-'50.0G", "3E-50                                             ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0'.1G", "3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-'1.1G", "3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%'50.1G", "                                             3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-'.3G", "3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0'1.3G", "3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-'3.3G", "3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%'.50G", "3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-'1.50G", "3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0'3.50G", "3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-'50.50G", "3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%+'1g", "+3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-+'3g", "+3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0+'50g", "+000000000000000000000000000000000000003.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-+'.0g", "+3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%+'3.0g", "+3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-+'50.0g", "+3e-50                                            ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0+'.1g", "+3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-+'1.1g", "+3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%+'50.1g", "                                            +3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-+'.3g", "+3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0+'1.3g", "+3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-+'3.3g", "+3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%+'.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-+'1.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0+'3.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-+'50.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%+'1G", "+3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-+'3G", "+3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0+'50G", "+000000000000000000000000000000000000003.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-+'.0G", "+3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%+'3.0G", "+3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-+'50.0G", "+3E-50                                            ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0+'.1G", "+3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-+'1.1G", "+3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%+'50.1G", "                                            +3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-+'.3G", "+3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0+'1.3G", "+3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-+'3.3G", "+3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%+'.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%-+'1.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0+'3.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0-+'50.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% '1g", " 3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- '3g", " 3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 '50g", " 000000000000000000000000000000000000003.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- '.0g", " 3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% '3.0g", " 3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- '50.0g", " 3e-50                                            ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 '.1g", " 3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- '1.1g", " 3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% '50.1g", "                                             3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- '.3g", " 3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 '1.3g", " 3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- '3.3g", " 3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% '.50g", " 3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- '1.50g", " 3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 '3.50g", " 3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- '50.50g", " 3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% '1G", " 3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- '3G", " 3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 '50G", " 000000000000000000000000000000000000003.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- '.0G", " 3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% '3.0G", " 3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- '50.0G", " 3E-50                                            ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 '.1G", " 3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- '1.1G", " 3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% '50.1G", "                                             3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- '.3G", " 3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 '1.3G", " 3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- '3.3G", " 3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% '.50G", " 3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- '1.50G", " 3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 '3.50G", " 3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- '50.50G", " 3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% +'1g", "+3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- +'3g", "+3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 +'50g", "+000000000000000000000000000000000000003.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- +'.0g", "+3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% +'3.0g", "+3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- +'50.0g", "+3e-50                                            ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 +'.1g", "+3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- +'1.1g", "+3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% +'50.1g", "                                            +3e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- +'.3g", "+3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 +'1.3g", "+3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- +'3.3g", "+3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% +'.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- +'1.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 +'3.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- +'50.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% +'1G", "+3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- +'3G", "+3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 +'50G", "+000000000000000000000000000000000000003.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- +'.0G", "+3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% +'3.0G", "+3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- +'50.0G", "+3E-50                                            ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 +'.1G", "+3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- +'1.1G", "+3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% +'50.1G", "                                            +3E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- +'.3G", "+3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 +'1.3G", "+3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- +'3.3G", "+3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "% +'.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%- +'1.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0 +'3.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%0- +'50.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#'1g", "3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-'3g", "3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0'50g", "0000000000000000000000000000000000000003.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-'.0g", "3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#'3.0g", "3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-'50.0g", "3.e-50                                            ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0'.1g", "3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-'1.1g", "3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#'50.1g", "                                            3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-'.3g", "3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0'1.3g", "3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-'3.3g", "3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#'.50g", "3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-'1.50g", "3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0'3.50g", "3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-'50.50g", "3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#'1G", "3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-'3G", "3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0'50G", "0000000000000000000000000000000000000003.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-'.0G", "3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#'3.0G", "3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-'50.0G", "3.E-50                                            ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0'.1G", "3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-'1.1G", "3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#'50.1G", "                                            3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-'.3G", "3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0'1.3G", "3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-'3.3G", "3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#'.50G", "3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-'1.50G", "3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0'3.50G", "3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-'50.50G", "3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#+'1g", "+3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-+'3g", "+3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0+'50g", "+000000000000000000000000000000000000003.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-+'.0g", "+3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#+'3.0g", "+3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-+'50.0g", "+3.e-50                                           ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0+'.1g", "+3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-+'1.1g", "+3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#+'50.1g", "                                           +3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-+'.3g", "+3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0+'1.3g", "+3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-+'3.3g", "+3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#+'.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-+'1.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0+'3.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-+'50.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#+'1G", "+3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-+'3G", "+3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0+'50G", "+000000000000000000000000000000000000003.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-+'.0G", "+3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#+'3.0G", "+3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-+'50.0G", "+3.E-50                                           ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0+'.1G", "+3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-+'1.1G", "+3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#+'50.1G", "                                           +3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-+'.3G", "+3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0+'1.3G", "+3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-+'3.3G", "+3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#+'.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#-+'1.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0+'3.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0-+'50.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# '1g", " 3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- '3g", " 3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 '50g", " 000000000000000000000000000000000000003.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- '.0g", " 3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# '3.0g", " 3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- '50.0g", " 3.e-50                                           ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 '.1g", " 3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- '1.1g", " 3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# '50.1g", "                                            3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- '.3g", " 3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 '1.3g", " 3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- '3.3g", " 3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# '.50g", " 3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- '1.50g", " 3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 '3.50g", " 3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- '50.50g", " 3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# '1G", " 3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- '3G", " 3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 '50G", " 000000000000000000000000000000000000003.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- '.0G", " 3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# '3.0G", " 3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- '50.0G", " 3.E-50                                           ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 '.1G", " 3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- '1.1G", " 3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# '50.1G", "                                            3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- '.3G", " 3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 '1.3G", " 3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- '3.3G", " 3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# '.50G", " 3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- '1.50G", " 3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 '3.50G", " 3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- '50.50G", " 3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# +'1g", "+3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- +'3g", "+3.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000003.14159e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- +'.0g", "+3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# +'3.0g", "+3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- +'50.0g", "+3.e-50                                           ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 +'.1g", "+3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- +'1.1g", "+3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# +'50.1g", "                                           +3.e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- +'.3g", "+3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 +'1.3g", "+3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- +'3.3g", "+3.14e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# +'.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- +'1.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 +'3.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- +'50.50g", "+3.1415926535897932727069897539156880721183917323596e-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# +'1G", "+3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- +'3G", "+3.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000003.14159E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- +'.0G", "+3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# +'3.0G", "+3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- +'50.0G", "+3.E-50                                           ", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 +'.1G", "+3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- +'1.1G", "+3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# +'50.1G", "                                           +3.E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- +'.3G", "+3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 +'1.3G", "+3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- +'3.3G", "+3.14E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%# +'.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#- +'1.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0 +'3.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%#0- +'50.50G", "+3.1415926535897932727069897539156880721183917323596E-50", { 33, 92, 244, 141, 24, 130, 167, 53 } },
    { "%'1g", "3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-'3g", "3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0'50g", "0000000000000000000000000000000000000003.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-'.0g", "3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%'3.0g", "3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-'50.0g", "3e+50                                             ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0'.1g", "3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-'1.1g", "3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%'50.1g", "                                             3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-'.3g", "3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0'1.3g", "3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-'3.3g", "3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%'.50g", "3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-'1.50g", "3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0'3.50g", "3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-'50.50g", "3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%'1G", "3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-'3G", "3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0'50G", "0000000000000000000000000000000000000003.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-'.0G", "3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%'3.0G", "3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-'50.0G", "3E+50                                             ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0'.1G", "3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-'1.1G", "3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%'50.1G", "                                             3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-'.3G", "3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0'1.3G", "3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-'3.3G", "3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%'.50G", "3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-'1.50G", "3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0'3.50G", "3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-'50.50G", "3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%+'1g", "+3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-+'3g", "+3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0+'50g", "+000000000000000000000000000000000000003.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-+'.0g", "+3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%+'3.0g", "+3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-+'50.0g", "+3e+50                                            ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0+'.1g", "+3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-+'1.1g", "+3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%+'50.1g", "                                            +3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-+'.3g", "+3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0+'1.3g", "+3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-+'3.3g", "+3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%+'.50g", "+3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-+'1.50g", "+3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0+'3.50g", "+3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-+'50.50g", "+3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%+'1G", "+3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-+'3G", "+3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0+'50G", "+000000000000000000000000000000000000003.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-+'.0G", "+3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%+'3.0G", "+3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-+'50.0G", "+3E+50                                            ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0+'.1G", "+3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-+'1.1G", "+3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%+'50.1G", "                                            +3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-+'.3G", "+3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0+'1.3G", "+3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-+'3.3G", "+3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%+'.50G", "+3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%-+'1.50G", "+3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0+'3.50G", "+3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0-+'50.50G", "+3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% '1g", " 3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- '3g", " 3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 '50g", " 000000000000000000000000000000000000003.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- '.0g", " 3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% '3.0g", " 3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- '50.0g", " 3e+50                                            ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 '.1g", " 3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- '1.1g", " 3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% '50.1g", "                                             3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- '.3g", " 3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 '1.3g", " 3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- '3.3g", " 3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% '.50g", " 3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- '1.50g", " 3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 '3.50g", " 3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- '50.50g", " 3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% '1G", " 3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- '3G", " 3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 '50G", " 000000000000000000000000000000000000003.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- '.0G", " 3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% '3.0G", " 3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- '50.0G", " 3E+50                                            ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 '.1G", " 3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- '1.1G", " 3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% '50.1G", "                                             3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- '.3G", " 3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 '1.3G", " 3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- '3.3G", " 3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% '.50G", " 3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- '1.50G", " 3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 '3.50G", " 3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- '50.50G", " 3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% +'1g", "+3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- +'3g", "+3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 +'50g", "+000000000000000000000000000000000000003.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- +'.0g", "+3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% +'3.0g", "+3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- +'50.0g", "+3e+50                                            ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 +'.1g", "+3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- +'1.1g", "+3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% +'50.1g", "                                            +3e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- +'.3g", "+3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 +'1.3g", "+3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- +'3.3g", "+3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% +'.50g", "+3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- +'1.50g", "+3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 +'3.50g", "+3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- +'50.50g", "+3.141592653589793652864438172706023653335508189184e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% +'1G", "+3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- +'3G", "+3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 +'50G", "+000000000000000000000000000000000000003.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- +'.0G", "+3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% +'3.0G", "+3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- +'50.0G", "+3E+50                                            ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 +'.1G", "+3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- +'1.1G", "+3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% +'50.1G", "                                            +3E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- +'.3G", "+3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 +'1.3G", "+3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- +'3.3G", "+3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "% +'.50G", "+3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%- +'1.50G", "+3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0 +'3.50G", "+3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%0- +'50.50G", "+3.141592653589793652864438172706023653335508189184E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#'1g", "3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-'3g", "3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0'50g", "0000000000000000000000000000000000000003.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-'.0g", "3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#'3.0g", "3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-'50.0g", "3.e+50                                            ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0'.1g", "3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-'1.1g", "3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#'50.1g", "                                            3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-'.3g", "3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0'1.3g", "3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-'3.3g", "3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#'.50g", "3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-'1.50g", "3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0'3.50g", "3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-'50.50g", "3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#'1G", "3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-'3G", "3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0'50G", "0000000000000000000000000000000000000003.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-'.0G", "3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#'3.0G", "3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-'50.0G", "3.E+50                                            ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0'.1G", "3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-'1.1G", "3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#'50.1G", "                                            3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-'.3G", "3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0'1.3G", "3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-'3.3G", "3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#'.50G", "3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-'1.50G", "3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0'3.50G", "3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-'50.50G", "3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#+'1g", "+3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-+'3g", "+3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0+'50g", "+000000000000000000000000000000000000003.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-+'.0g", "+3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#+'3.0g", "+3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-+'50.0g", "+3.e+50                                           ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0+'.1g", "+3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-+'1.1g", "+3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#+'50.1g", "                                           +3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-+'.3g", "+3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0+'1.3g", "+3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-+'3.3g", "+3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#+'.50g", "+3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-+'1.50g", "+3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0+'3.50g", "+3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-+'50.50g", "+3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#+'1G", "+3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-+'3G", "+3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0+'50G", "+000000000000000000000000000000000000003.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-+'.0G", "+3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#+'3.0G", "+3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-+'50.0G", "+3.E+50                                           ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0+'.1G", "+3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-+'1.1G", "+3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#+'50.1G", "                                           +3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-+'.3G", "+3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0+'1.3G", "+3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-+'3.3G", "+3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#+'.50G", "+3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#-+'1.50G", "+3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0+'3.50G", "+3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0-+'50.50G", "+3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# '1g", " 3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- '3g", " 3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 '50g", " 000000000000000000000000000000000000003.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- '.0g", " 3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# '3.0g", " 3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- '50.0g", " 3.e+50                                           ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 '.1g", " 3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- '1.1g", " 3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# '50.1g", "                                            3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- '.3g", " 3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 '1.3g", " 3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- '3.3g", " 3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# '.50g", " 3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- '1.50g", " 3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 '3.50g", " 3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- '50.50g", " 3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# '1G", " 3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- '3G", " 3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 '50G", " 000000000000000000000000000000000000003.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- '.0G", " 3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# '3.0G", " 3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- '50.0G", " 3.E+50                                           ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 '.1G", " 3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- '1.1G", " 3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# '50.1G", "                                            3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- '.3G", " 3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 '1.3G", " 3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- '3.3G", " 3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# '.50G", " 3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- '1.50G", " 3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 '3.50G", " 3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- '50.50G", " 3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# +'1g", "+3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- +'3g", "+3.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000003.14159e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- +'.0g", "+3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# +'3.0g", "+3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- +'50.0g", "+3.e+50                                           ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 +'.1g", "+3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- +'1.1g", "+3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# +'50.1g", "                                           +3.e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- +'.3g", "+3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 +'1.3g", "+3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- +'3.3g", "+3.14e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# +'.50g", "+3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- +'1.50g", "+3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 +'3.50g", "+3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- +'50.50g", "+3.1415926535897936528644381727060236533355081891840e+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# +'1G", "+3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- +'3G", "+3.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000003.14159E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- +'.0G", "+3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# +'3.0G", "+3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- +'50.0G", "+3.E+50                                           ", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 +'.1G", "+3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- +'1.1G", "+3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# +'50.1G", "                                           +3.E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- +'.3G", "+3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 +'1.3G", "+3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- +'3.3G", "+3.14E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%# +'.50G", "+3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#- +'1.50G", "+3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0 +'3.50G", "+3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%#0- +'50.50G", "+3.1415926535897936528644381727060236533355081891840E+50", { 209, 124, 155, 149, 155, 222, 106, 74 } },
    { "%'1g", "2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-'3g", "2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0'50g", "00000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-'.0g", "3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%'3.0g", "  3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-'50.0g", "3                                                 ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0'.1g", "3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-'1.1g", "3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%'50.1g", "                                                 3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-'.3g", "2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0'1.3g", "2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-'3.3g", "2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%'.50g", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-'1.50g", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0'3.50g", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-'50.50g", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%'1G", "2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-'3G", "2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0'50G", "00000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-'.0G", "3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%'3.0G", "  3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-'50.0G", "3                                                 ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0'.1G", "3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-'1.1G", "3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%'50.1G", "                                                 3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-'.3G", "2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0'1.3G", "2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-'3.3G", "2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%'.50G", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-'1.50G", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0'3.50G", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-'50.50G", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%+'1g", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-+'3g", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0+'50g", "+0000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-+'.0g", "+3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%+'3.0g", " +3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-+'50.0g", "+3                                                ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0+'.1g", "+3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-+'1.1g", "+3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%+'50.1g", "                                                +3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-+'.3g", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0+'1.3g", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-+'3.3g", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%+'.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-+'1.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0+'3.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-+'50.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%+'1G", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-+'3G", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0+'50G", "+0000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-+'.0G", "+3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%+'3.0G", " +3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-+'50.0G", "+3                                                ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0+'.1G", "+3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-+'1.1G", "+3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%+'50.1G", "                                                +3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-+'.3G", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0+'1.3G", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-+'3.3G", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%+'.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%-+'1.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0+'3.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0-+'50.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% '1g", " 2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- '3g", " 2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 '50g", " 0000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- '.0g", " 3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% '3.0g", "  3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- '50.0g", " 3                                                ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 '.1g", " 3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- '1.1g", " 3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% '50.1g", "                                                 3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- '.3g", " 2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 '1.3g", " 2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- '3.3g", " 2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% '.50g", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- '1.50g", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 '3.50g", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- '50.50g", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% '1G", " 2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- '3G", " 2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 '50G", " 0000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- '.0G", " 3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% '3.0G", "  3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- '50.0G", " 3                                                ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 '.1G", " 3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- '1.1G", " 3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% '50.1G", "                                                 3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- '.3G", " 2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 '1.3G", " 2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- '3.3G", " 2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% '.50G", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- '1.50G", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 '3.50G", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- '50.50G", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% +'1g", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- +'3g", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 +'50g", "+0000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- +'.0g", "+3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% +'3.0g", " +3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- +'50.0g", "+3                                                ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 +'.1g", "+3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- +'1.1g", "+3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% +'50.1g", "                                                +3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- +'.3g", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 +'1.3g", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- +'3.3g", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% +'.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- +'1.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 +'3.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- +'50.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% +'1G", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- +'3G", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 +'50G", "+0000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- +'.0G", "+3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% +'3.0G", " +3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- +'50.0G", "+3                                                ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 +'.1G", "+3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- +'1.1G", "+3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% +'50.1G", "                                                +3", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- +'.3G", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 +'1.3G", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- +'3.3G", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "% +'.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%- +'1.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0 +'3.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%0- +'50.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#'1g", "2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-'3g", "2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0'50g", "00000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-'.0g", "3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#'3.0g", " 3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-'50.0g", "3.                                                ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0'.1g", "3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-'1.1g", "3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#'50.1g", "                                                3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-'.3g", "2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0'1.3g", "2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-'3.3g", "2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#'.50g", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-'1.50g", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0'3.50g", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-'50.50g", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#'1G", "2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-'3G", "2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0'50G", "00000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-'.0G", "3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#'3.0G", " 3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-'50.0G", "3.                                                ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0'.1G", "3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-'1.1G", "3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#'50.1G", "                                                3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-'.3G", "2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0'1.3G", "2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-'3.3G", "2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#'.50G", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-'1.50G", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0'3.50G", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-'50.50G", "2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#+'1g", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-+'3g", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0+'50g", "+0000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-+'.0g", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#+'3.0g", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-+'50.0g", "+3.                                               ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0+'.1g", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-+'1.1g", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#+'50.1g", "                                               +3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-+'.3g", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0+'1.3g", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-+'3.3g", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#+'.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-+'1.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0+'3.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-+'50.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#+'1G", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-+'3G", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0+'50G", "+0000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-+'.0G", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#+'3.0G", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-+'50.0G", "+3.                                               ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0+'.1G", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-+'1.1G", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#+'50.1G", "                                               +3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-+'.3G", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0+'1.3G", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-+'3.3G", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#+'.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#-+'1.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0+'3.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0-+'50.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# '1g", " 2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- '3g", " 2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 '50g", " 0000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- '.0g", " 3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# '3.0g", " 3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- '50.0g", " 3.                                               ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 '.1g", " 3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- '1.1g", " 3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# '50.1g", "                                                3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- '.3g", " 2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 '1.3g", " 2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- '3.3g", " 2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# '.50g", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- '1.50g", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 '3.50g", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- '50.50g", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# '1G", " 2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- '3G", " 2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 '50G", " 0000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- '.0G", " 3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# '3.0G", " 3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- '50.0G", " 3.                                               ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 '.1G", " 3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- '1.1G", " 3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# '50.1G", "                                                3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- '.3G", " 2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 '1.3G", " 2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- '3.3G", " 2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# '.50G", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- '1.50G", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 '3.50G", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- '50.50G", " 2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# +'1g", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- +'3g", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 +'50g", "+0000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- +'.0g", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# +'3.0g", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- +'50.0g", "+3.                                               ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 +'.1g", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- +'1.1g", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# +'50.1g", "                                               +3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- +'.3g", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 +'1.3g", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- +'3.3g", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# +'.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- +'1.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 +'3.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- +'50.50g", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# +'1G", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- +'3G", "+2.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 +'50G", "+0000000000000000000000000000000000000000002.71828", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- +'.0G", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# +'3.0G", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- +'50.0G", "+3.                                               ", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 +'.1G", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- +'1.1G", "+3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# +'50.1G", "                                               +3.", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- +'.3G", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 +'1.3G", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- +'3.3G", "+2.72", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%# +'.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#- +'1.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0 +'3.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%#0- +'50.50G", "+2.7182818284590450907955982984276488423347473144531", { 105, 87, 20, 139, 10, 191, 5, 64 } },
    { "%'1g", "1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-'3g", "1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0'50g", "000000000000000000000000000000000000000000001.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-'.0g", "1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%'3.0g", "  1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-'50.0g", "1                                                 ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0'.1g", "1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-'1.1g", "1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%'50.1g", "                                                 1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-'.3g", "1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0'1.3g", "1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-'3.3g", "1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%'.50g", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-'1.50g", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0'3.50g", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-'50.50g", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%'1G", "1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-'3G", "1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0'50G", "000000000000000000000000000000000000000000001.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-'.0G", "1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%'3.0G", "  1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-'50.0G", "1                                                 ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0'.1G", "1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-'1.1G", "1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%'50.1G", "                                                 1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-'.3G", "1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0'1.3G", "1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-'3.3G", "1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%'.50G", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-'1.50G", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0'3.50G", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-'50.50G", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%+'1g", "+1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-+'3g", "+1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0+'50g", "+00000000000000000000000000000000000000000001.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-+'.0g", "+1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%+'3.0g", " +1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-+'50.0g", "+1                                                ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0+'.1g", "+1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-+'1.1g", "+1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%+'50.1g", "                                                +1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-+'.3g", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0+'1.3g", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-+'3.3g", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%+'.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-+'1.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0+'3.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-+'50.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%+'1G", "+1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-+'3G", "+1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0+'50G", "+00000000000000000000000000000000000000000001.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-+'.0G", "+1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%+'3.0G", " +1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-+'50.0G", "+1                                                ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0+'.1G", "+1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-+'1.1G", "+1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%+'50.1G", "                                                +1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-+'.3G", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0+'1.3G", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-+'3.3G", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%+'.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%-+'1.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0+'3.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0-+'50.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% '1g", " 1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- '3g", " 1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 '50g", " 00000000000000000000000000000000000000000001.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- '.0g", " 1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% '3.0g", "  1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- '50.0g", " 1                                                ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 '.1g", " 1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- '1.1g", " 1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% '50.1g", "                                                 1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- '.3g", " 1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 '1.3g", " 1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- '3.3g", " 1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% '.50g", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- '1.50g", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 '3.50g", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- '50.50g", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% '1G", " 1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- '3G", " 1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 '50G", " 00000000000000000000000000000000000000000001.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- '.0G", " 1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% '3.0G", "  1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- '50.0G", " 1                                                ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 '.1G", " 1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- '1.1G", " 1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% '50.1G", "                                                 1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- '.3G", " 1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 '1.3G", " 1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- '3.3G", " 1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% '.50G", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- '1.50G", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 '3.50G", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- '50.50G", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% +'1g", "+1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- +'3g", "+1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 +'50g", "+00000000000000000000000000000000000000000001.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- +'.0g", "+1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% +'3.0g", " +1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- +'50.0g", "+1                                                ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 +'.1g", "+1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- +'1.1g", "+1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% +'50.1g", "                                                +1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- +'.3g", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 +'1.3g", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- +'3.3g", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% +'.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- +'1.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 +'3.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- +'50.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% +'1G", "+1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- +'3G", "+1.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 +'50G", "+00000000000000000000000000000000000000000001.4427", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- +'.0G", "+1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% +'3.0G", " +1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- +'50.0G", "+1                                                ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 +'.1G", "+1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- +'1.1G", "+1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% +'50.1G", "                                                +1", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- +'.3G", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 +'1.3G", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- +'3.3G", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "% +'.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%- +'1.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0 +'3.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%0- +'50.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#'1g", "1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-'3g", "1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0'50g", "00000000000000000000000000000000000000000001.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-'.0g", "1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#'3.0g", " 1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-'50.0g", "1.                                                ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0'.1g", "1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-'1.1g", "1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#'50.1g", "                                                1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-'.3g", "1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0'1.3g", "1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-'3.3g", "1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#'.50g", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-'1.50g", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0'3.50g", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-'50.50g", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#'1G", "1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-'3G", "1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0'50G", "00000000000000000000000000000000000000000001.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-'.0G", "1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#'3.0G", " 1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-'50.0G", "1.                                                ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0'.1G", "1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-'1.1G", "1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#'50.1G", "                                                1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-'.3G", "1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0'1.3G", "1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-'3.3G", "1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#'.50G", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-'1.50G", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0'3.50G", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-'50.50G", "1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#+'1g", "+1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-+'3g", "+1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0+'50g", "+0000000000000000000000000000000000000000001.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-+'.0g", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#+'3.0g", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-+'50.0g", "+1.                                               ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0+'.1g", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-+'1.1g", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#+'50.1g", "                                               +1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-+'.3g", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0+'1.3g", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-+'3.3g", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#+'.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-+'1.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0+'3.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-+'50.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#+'1G", "+1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-+'3G", "+1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0+'50G", "+0000000000000000000000000000000000000000001.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-+'.0G", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#+'3.0G", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-+'50.0G", "+1.                                               ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0+'.1G", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-+'1.1G", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#+'50.1G", "                                               +1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-+'.3G", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0+'1.3G", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-+'3.3G", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#+'.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#-+'1.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0+'3.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0-+'50.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# '1g", " 1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- '3g", " 1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 '50g", " 0000000000000000000000000000000000000000001.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- '.0g", " 1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# '3.0g", " 1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- '50.0g", " 1.                                               ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 '.1g", " 1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- '1.1g", " 1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# '50.1g", "                                                1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- '.3g", " 1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 '1.3g", " 1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- '3.3g", " 1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# '.50g", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- '1.50g", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 '3.50g", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- '50.50g", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# '1G", " 1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- '3G", " 1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 '50G", " 0000000000000000000000000000000000000000001.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- '.0G", " 1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# '3.0G", " 1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- '50.0G", " 1.                                               ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 '.1G", " 1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- '1.1G", " 1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# '50.1G", "                                                1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- '.3G", " 1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 '1.3G", " 1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- '3.3G", " 1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# '.50G", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- '1.50G", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 '3.50G", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- '50.50G", " 1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# +'1g", "+1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- +'3g", "+1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 +'50g", "+0000000000000000000000000000000000000000001.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- +'.0g", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# +'3.0g", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- +'50.0g", "+1.                                               ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 +'.1g", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- +'1.1g", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# +'50.1g", "                                               +1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- +'.3g", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 +'1.3g", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- +'3.3g", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# +'.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- +'1.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 +'3.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- +'50.50g", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# +'1G", "+1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- +'3G", "+1.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 +'50G", "+0000000000000000000000000000000000000000001.44270", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- +'.0G", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# +'3.0G", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- +'50.0G", "+1.                                               ", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 +'.1G", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- +'1.1G", "+1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# +'50.1G", "                                               +1.", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- +'.3G", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 +'1.3G", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- +'3.3G", "+1.44", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%# +'.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#- +'1.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0 +'3.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%#0- +'50.50G", "+1.4426950408889633870046509400708600878715515136719", { 254, 130, 43, 101, 71, 21, 247, 63 } },
    { "%'1g", "0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-'3g", "0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0'50g", "0000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-'.0g", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%'3.0g", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-'50.0g", "0.4                                               ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0'.1g", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-'1.1g", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%'50.1g", "                                               0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-'.3g", "0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0'1.3g", "0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-'3.3g", "0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%'.50g", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-'1.50g", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0'3.50g", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-'50.50g", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%'1G", "0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-'3G", "0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0'50G", "0000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-'.0G", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%'3.0G", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-'50.0G", "0.4                                               ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0'.1G", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-'1.1G", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%'50.1G", "                                               0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-'.3G", "0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0'1.3G", "0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-'3.3G", "0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%'.50G", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-'1.50G", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0'3.50G", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-'50.50G", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%+'1g", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-+'3g", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0+'50g", "+000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-+'.0g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%+'3.0g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-+'50.0g", "+0.4                                              ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0+'.1g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-+'1.1g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%+'50.1g", "                                              +0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-+'.3g", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0+'1.3g", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-+'3.3g", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%+'.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-+'1.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0+'3.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-+'50.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%+'1G", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-+'3G", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0+'50G", "+000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-+'.0G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%+'3.0G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-+'50.0G", "+0.4                                              ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0+'.1G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-+'1.1G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%+'50.1G", "                                              +0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-+'.3G", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0+'1.3G", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-+'3.3G", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%+'.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%-+'1.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0+'3.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0-+'50.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% '1g", " 0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- '3g", " 0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 '50g", " 000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- '.0g", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% '3.0g", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- '50.0g", " 0.4                                              ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 '.1g", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- '1.1g", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% '50.1g", "                                               0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- '.3g", " 0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 '1.3g", " 0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- '3.3g", " 0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% '.50g", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- '1.50g", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 '3.50g", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- '50.50g", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% '1G", " 0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- '3G", " 0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 '50G", " 000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- '.0G", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% '3.0G", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- '50.0G", " 0.4                                              ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 '.1G", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- '1.1G", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% '50.1G", "                                               0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- '.3G", " 0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 '1.3G", " 0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- '3.3G", " 0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% '.50G", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- '1.50G", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 '3.50G", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- '50.50G", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% +'1g", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- +'3g", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 +'50g", "+000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- +'.0g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% +'3.0g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- +'50.0g", "+0.4                                              ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 +'.1g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- +'1.1g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% +'50.1g", "                                              +0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- +'.3g", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 +'1.3g", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- +'3.3g", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% +'.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- +'1.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 +'3.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- +'50.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% +'1G", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- +'3G", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 +'50G", "+000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- +'.0G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% +'3.0G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- +'50.0G", "+0.4                                              ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 +'.1G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- +'1.1G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% +'50.1G", "                                              +0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- +'.3G", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 +'1.3G", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- +'3.3G", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "% +'.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%- +'1.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0 +'3.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%0- +'50.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#'1g", "0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-'3g", "0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0'50g", "0000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-'.0g", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#'3.0g", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-'50.0g", "0.4                                               ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0'.1g", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-'1.1g", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#'50.1g", "                                               0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-'.3g", "0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0'1.3g", "0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-'3.3g", "0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#'.50g", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-'1.50g", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0'3.50g", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-'50.50g", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#'1G", "0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-'3G", "0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0'50G", "0000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-'.0G", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#'3.0G", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-'50.0G", "0.4                                               ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0'.1G", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-'1.1G", "0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#'50.1G", "                                               0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-'.3G", "0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0'1.3G", "0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-'3.3G", "0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#'.50G", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-'1.50G", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0'3.50G", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-'50.50G", "0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#+'1g", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-+'3g", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0+'50g", "+000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-+'.0g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#+'3.0g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-+'50.0g", "+0.4                                              ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0+'.1g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-+'1.1g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#+'50.1g", "                                              +0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-+'.3g", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0+'1.3g", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-+'3.3g", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#+'.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-+'1.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0+'3.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-+'50.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#+'1G", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-+'3G", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0+'50G", "+000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-+'.0G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#+'3.0G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-+'50.0G", "+0.4                                              ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0+'.1G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-+'1.1G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#+'50.1G", "                                              +0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-+'.3G", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0+'1.3G", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-+'3.3G", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#+'.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#-+'1.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0+'3.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0-+'50.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# '1g", " 0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- '3g", " 0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 '50g", " 000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- '.0g", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# '3.0g", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- '50.0g", " 0.4                                              ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 '.1g", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- '1.1g", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# '50.1g", "                                               0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- '.3g", " 0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 '1.3g", " 0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- '3.3g", " 0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# '.50g", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- '1.50g", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 '3.50g", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- '50.50g", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# '1G", " 0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- '3G", " 0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 '50G", " 000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- '.0G", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# '3.0G", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- '50.0G", " 0.4                                              ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 '.1G", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- '1.1G", " 0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# '50.1G", "                                               0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- '.3G", " 0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 '1.3G", " 0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- '3.3G", " 0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# '.50G", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- '1.50G", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 '3.50G", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- '50.50G", " 0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# +'1g", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- +'3g", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- +'.0g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# +'3.0g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- +'50.0g", "+0.4                                              ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 +'.1g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- +'1.1g", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# +'50.1g", "                                              +0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- +'.3g", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 +'1.3g", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- +'3.3g", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# +'.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- +'1.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 +'3.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- +'50.50g", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# +'1G", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- +'3G", "+0.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000000000.434294", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- +'.0G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# +'3.0G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- +'50.0G", "+0.4                                              ", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 +'.1G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- +'1.1G", "+0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# +'50.1G", "                                              +0.4", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- +'.3G", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 +'1.3G", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- +'3.3G", "+0.434", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%# +'.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#- +'1.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0 +'3.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%#0- +'50.50G", "+0.43429448190325181666793241674895398318767547607422", { 14, 229, 38, 21, 123, 203, 219, 63 } },
    { "%'1g", "0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-'3g", "0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0'50g", "0000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-'.0g", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%'3.0g", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-'50.0g", "0.7                                               ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0'.1g", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-'1.1g", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%'50.1g", "                                               0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-'.3g", "0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0'1.3g", "0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-'3.3g", "0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%'.50g", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-'1.50g", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0'3.50g", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-'50.50g", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%'1G", "0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-'3G", "0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0'50G", "0000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-'.0G", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%'3.0G", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-'50.0G", "0.7                                               ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0'.1G", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-'1.1G", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%'50.1G", "                                               0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-'.3G", "0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0'1.3G", "0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-'3.3G", "0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%'.50G", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-'1.50G", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0'3.50G", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-'50.50G", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%+'1g", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-+'3g", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0+'50g", "+000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-+'.0g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%+'3.0g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-+'50.0g", "+0.7                                              ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0+'.1g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-+'1.1g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%+'50.1g", "                                              +0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-+'.3g", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0+'1.3g", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-+'3.3g", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%+'.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-+'1.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0+'3.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-+'50.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%+'1G", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-+'3G", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0+'50G", "+000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-+'.0G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%+'3.0G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-+'50.0G", "+0.7                                              ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0+'.1G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-+'1.1G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%+'50.1G", "                                              +0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-+'.3G", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0+'1.3G", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-+'3.3G", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%+'.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%-+'1.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0+'3.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0-+'50.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% '1g", " 0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- '3g", " 0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 '50g", " 000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- '.0g", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% '3.0g", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- '50.0g", " 0.7                                              ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 '.1g", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- '1.1g", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% '50.1g", "                                               0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- '.3g", " 0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 '1.3g", " 0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- '3.3g", " 0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% '.50g", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- '1.50g", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 '3.50g", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- '50.50g", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% '1G", " 0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- '3G", " 0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 '50G", " 000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- '.0G", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% '3.0G", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- '50.0G", " 0.7                                              ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 '.1G", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- '1.1G", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% '50.1G", "                                               0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- '.3G", " 0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 '1.3G", " 0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- '3.3G", " 0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% '.50G", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- '1.50G", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 '3.50G", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- '50.50G", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% +'1g", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- +'3g", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 +'50g", "+000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- +'.0g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% +'3.0g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- +'50.0g", "+0.7                                              ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 +'.1g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- +'1.1g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% +'50.1g", "                                              +0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- +'.3g", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 +'1.3g", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- +'3.3g", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% +'.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- +'1.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 +'3.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- +'50.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% +'1G", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- +'3G", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 +'50G", "+000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- +'.0G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% +'3.0G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- +'50.0G", "+0.7                                              ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 +'.1G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- +'1.1G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% +'50.1G", "                                              +0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- +'.3G", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 +'1.3G", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- +'3.3G", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "% +'.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%- +'1.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0 +'3.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%0- +'50.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#'1g", "0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-'3g", "0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0'50g", "0000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-'.0g", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#'3.0g", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-'50.0g", "0.7                                               ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0'.1g", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-'1.1g", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#'50.1g", "                                               0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-'.3g", "0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0'1.3g", "0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-'3.3g", "0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#'.50g", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-'1.50g", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0'3.50g", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-'50.50g", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#'1G", "0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-'3G", "0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0'50G", "0000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-'.0G", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#'3.0G", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-'50.0G", "0.7                                               ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0'.1G", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-'1.1G", "0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#'50.1G", "                                               0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-'.3G", "0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0'1.3G", "0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-'3.3G", "0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#'.50G", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-'1.50G", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0'3.50G", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-'50.50G", "0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#+'1g", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-+'3g", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0+'50g", "+000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-+'.0g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#+'3.0g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-+'50.0g", "+0.7                                              ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0+'.1g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-+'1.1g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#+'50.1g", "                                              +0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-+'.3g", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0+'1.3g", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-+'3.3g", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#+'.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-+'1.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0+'3.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-+'50.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#+'1G", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-+'3G", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0+'50G", "+000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-+'.0G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#+'3.0G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-+'50.0G", "+0.7                                              ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0+'.1G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-+'1.1G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#+'50.1G", "                                              +0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-+'.3G", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0+'1.3G", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-+'3.3G", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#+'.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#-+'1.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0+'3.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0-+'50.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# '1g", " 0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- '3g", " 0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 '50g", " 000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- '.0g", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# '3.0g", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- '50.0g", " 0.7                                              ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 '.1g", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- '1.1g", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# '50.1g", "                                               0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- '.3g", " 0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 '1.3g", " 0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- '3.3g", " 0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# '.50g", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- '1.50g", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 '3.50g", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- '50.50g", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# '1G", " 0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- '3G", " 0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 '50G", " 000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- '.0G", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# '3.0G", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- '50.0G", " 0.7                                              ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 '.1G", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- '1.1G", " 0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# '50.1G", "                                               0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- '.3G", " 0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 '1.3G", " 0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- '3.3G", " 0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# '.50G", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- '1.50G", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 '3.50G", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- '50.50G", " 0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# +'1g", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- +'3g", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- +'.0g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# +'3.0g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- +'50.0g", "+0.7                                              ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 +'.1g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- +'1.1g", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# +'50.1g", "                                              +0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- +'.3g", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 +'1.3g", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- +'3.3g", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# +'.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- +'1.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 +'3.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- +'50.50g", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# +'1G", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- +'3G", "+0.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000000000.693147", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- +'.0G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# +'3.0G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- +'50.0G", "+0.7                                              ", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 +'.1G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- +'1.1G", "+0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# +'50.1G", "                                              +0.7", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- +'.3G", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 +'1.3G", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- +'3.3G", "+0.693", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%# +'.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#- +'1.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0 +'3.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%#0- +'50.50G", "+0.69314718055994528622676398299518041312694549560547", { 239, 57, 250, 254, 66, 46, 230, 63 } },
    { "%'1g", "2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-'3g", "2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0'50g", "00000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-'.0g", "2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%'3.0g", "  2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-'50.0g", "2                                                 ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0'.1g", "2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-'1.1g", "2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%'50.1g", "                                                 2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-'.3g", "2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0'1.3g", "2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-'3.3g", "2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%'.50g", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-'1.50g", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0'3.50g", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-'50.50g", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%'1G", "2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-'3G", "2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0'50G", "00000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-'.0G", "2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%'3.0G", "  2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-'50.0G", "2                                                 ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0'.1G", "2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-'1.1G", "2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%'50.1G", "                                                 2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-'.3G", "2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0'1.3G", "2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-'3.3G", "2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%'.50G", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-'1.50G", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0'3.50G", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-'50.50G", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%+'1g", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-+'3g", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0+'50g", "+0000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-+'.0g", "+2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%+'3.0g", " +2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-+'50.0g", "+2                                                ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0+'.1g", "+2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-+'1.1g", "+2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%+'50.1g", "                                                +2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-+'.3g", "+2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0+'1.3g", "+2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-+'3.3g", "+2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%+'.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-+'1.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0+'3.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-+'50.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%+'1G", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-+'3G", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0+'50G", "+0000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-+'.0G", "+2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%+'3.0G", " +2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-+'50.0G", "+2                                                ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0+'.1G", "+2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-+'1.1G", "+2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%+'50.1G", "                                                +2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-+'.3G", "+2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0+'1.3G", "+2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-+'3.3G", "+2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%+'.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%-+'1.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0+'3.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0-+'50.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% '1g", " 2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- '3g", " 2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 '50g", " 0000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- '.0g", " 2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% '3.0g", "  2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- '50.0g", " 2                                                ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 '.1g", " 2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- '1.1g", " 2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% '50.1g", "                                                 2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- '.3g", " 2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 '1.3g", " 2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- '3.3g", " 2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% '.50g", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- '1.50g", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 '3.50g", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- '50.50g", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% '1G", " 2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- '3G", " 2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 '50G", " 0000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- '.0G", " 2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% '3.0G", "  2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- '50.0G", " 2                                                ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 '.1G", " 2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- '1.1G", " 2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% '50.1G", "                                                 2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- '.3G", " 2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 '1.3G", " 2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- '3.3G", " 2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% '.50G", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- '1.50G", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 '3.50G", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- '50.50G", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% +'1g", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- +'3g", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 +'50g", "+0000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- +'.0g", "+2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% +'3.0g", " +2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- +'50.0g", "+2                                                ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 +'.1g", "+2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- +'1.1g", "+2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% +'50.1g", "                                                +2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- +'.3g", "+2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 +'1.3g", "+2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- +'3.3g", "+2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% +'.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- +'1.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 +'3.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- +'50.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% +'1G", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- +'3G", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 +'50G", "+0000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- +'.0G", "+2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% +'3.0G", " +2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- +'50.0G", "+2                                                ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 +'.1G", "+2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- +'1.1G", "+2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% +'50.1G", "                                                +2", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- +'.3G", "+2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 +'1.3G", "+2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- +'3.3G", "+2.3", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "% +'.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%- +'1.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0 +'3.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%0- +'50.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#'1g", "2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-'3g", "2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0'50g", "00000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-'.0g", "2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#'3.0g", " 2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-'50.0g", "2.                                                ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0'.1g", "2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-'1.1g", "2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#'50.1g", "                                                2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-'.3g", "2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0'1.3g", "2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-'3.3g", "2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#'.50g", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-'1.50g", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0'3.50g", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-'50.50g", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#'1G", "2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-'3G", "2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0'50G", "00000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-'.0G", "2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#'3.0G", " 2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-'50.0G", "2.                                                ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0'.1G", "2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-'1.1G", "2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#'50.1G", "                                                2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-'.3G", "2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0'1.3G", "2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-'3.3G", "2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#'.50G", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-'1.50G", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0'3.50G", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-'50.50G", "2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#+'1g", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-+'3g", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0+'50g", "+0000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-+'.0g", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#+'3.0g", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-+'50.0g", "+2.                                               ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0+'.1g", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-+'1.1g", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#+'50.1g", "                                               +2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-+'.3g", "+2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0+'1.3g", "+2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-+'3.3g", "+2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#+'.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-+'1.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0+'3.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-+'50.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#+'1G", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-+'3G", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0+'50G", "+0000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-+'.0G", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#+'3.0G", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-+'50.0G", "+2.                                               ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0+'.1G", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-+'1.1G", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#+'50.1G", "                                               +2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-+'.3G", "+2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0+'1.3G", "+2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-+'3.3G", "+2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#+'.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#-+'1.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0+'3.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0-+'50.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# '1g", " 2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- '3g", " 2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 '50g", " 0000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- '.0g", " 2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# '3.0g", " 2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- '50.0g", " 2.                                               ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 '.1g", " 2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- '1.1g", " 2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# '50.1g", "                                                2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- '.3g", " 2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 '1.3g", " 2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- '3.3g", " 2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# '.50g", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- '1.50g", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 '3.50g", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- '50.50g", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# '1G", " 2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- '3G", " 2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 '50G", " 0000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- '.0G", " 2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# '3.0G", " 2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- '50.0G", " 2.                                               ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 '.1G", " 2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- '1.1G", " 2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# '50.1G", "                                                2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- '.3G", " 2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 '1.3G", " 2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- '3.3G", " 2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# '.50G", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- '1.50G", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 '3.50G", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- '50.50G", " 2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# +'1g", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- +'3g", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 +'50g", "+0000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- +'.0g", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# +'3.0g", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- +'50.0g", "+2.                                               ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 +'.1g", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- +'1.1g", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# +'50.1g", "                                               +2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- +'.3g", "+2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 +'1.3g", "+2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- +'3.3g", "+2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# +'.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- +'1.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 +'3.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- +'50.50g", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# +'1G", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- +'3G", "+2.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 +'50G", "+0000000000000000000000000000000000000000002.30259", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- +'.0G", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# +'3.0G", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- +'50.0G", "+2.                                               ", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 +'.1G", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- +'1.1G", "+2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# +'50.1G", "                                               +2.", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- +'.3G", "+2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 +'1.3G", "+2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- +'3.3G", "+2.30", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%# +'.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#- +'1.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0 +'3.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%#0- +'50.50G", "+2.3025850929940459010936137929093092679977416992188", { 22, 85, 181, 187, 177, 107, 2, 64 } },
    { "%'1g", "1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-'3g", "1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0'50g", "00000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-'.0g", "1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%'3.0g", "  1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-'50.0g", "1                                                 ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0'.1g", "1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-'1.1g", "1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%'50.1g", "                                                 1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-'.3g", "1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0'1.3g", "1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-'3.3g", "1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%'.50g", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-'1.50g", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0'3.50g", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-'50.50g", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%'1G", "1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-'3G", "1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0'50G", "00000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-'.0G", "1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%'3.0G", "  1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-'50.0G", "1                                                 ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0'.1G", "1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-'1.1G", "1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%'50.1G", "                                                 1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-'.3G", "1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0'1.3G", "1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-'3.3G", "1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%'.50G", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-'1.50G", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0'3.50G", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-'50.50G", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%+'1g", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-+'3g", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0+'50g", "+0000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-+'.0g", "+1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%+'3.0g", " +1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-+'50.0g", "+1                                                ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0+'.1g", "+1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-+'1.1g", "+1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%+'50.1g", "                                                +1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-+'.3g", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0+'1.3g", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-+'3.3g", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%+'.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-+'1.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0+'3.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-+'50.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%+'1G", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-+'3G", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0+'50G", "+0000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-+'.0G", "+1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%+'3.0G", " +1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-+'50.0G", "+1                                                ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0+'.1G", "+1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-+'1.1G", "+1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%+'50.1G", "                                                +1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-+'.3G", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0+'1.3G", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-+'3.3G", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%+'.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%-+'1.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0+'3.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0-+'50.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% '1g", " 1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- '3g", " 1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 '50g", " 0000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- '.0g", " 1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% '3.0g", "  1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- '50.0g", " 1                                                ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 '.1g", " 1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- '1.1g", " 1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% '50.1g", "                                                 1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- '.3g", " 1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 '1.3g", " 1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- '3.3g", " 1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% '.50g", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- '1.50g", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 '3.50g", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- '50.50g", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% '1G", " 1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- '3G", " 1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 '50G", " 0000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- '.0G", " 1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% '3.0G", "  1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- '50.0G", " 1                                                ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 '.1G", " 1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- '1.1G", " 1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% '50.1G", "                                                 1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- '.3G", " 1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 '1.3G", " 1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- '3.3G", " 1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% '.50G", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- '1.50G", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 '3.50G", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- '50.50G", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% +'1g", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- +'3g", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 +'50g", "+0000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- +'.0g", "+1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% +'3.0g", " +1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- +'50.0g", "+1                                                ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 +'.1g", "+1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- +'1.1g", "+1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% +'50.1g", "                                                +1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- +'.3g", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 +'1.3g", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- +'3.3g", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% +'.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- +'1.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 +'3.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- +'50.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% +'1G", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- +'3G", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 +'50G", "+0000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- +'.0G", "+1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% +'3.0G", " +1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- +'50.0G", "+1                                                ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 +'.1G", "+1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- +'1.1G", "+1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% +'50.1G", "                                                +1", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- +'.3G", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 +'1.3G", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- +'3.3G", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "% +'.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%- +'1.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0 +'3.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%0- +'50.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#'1g", "1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-'3g", "1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0'50g", "00000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-'.0g", "1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#'3.0g", " 1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-'50.0g", "1.                                                ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0'.1g", "1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-'1.1g", "1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#'50.1g", "                                                1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-'.3g", "1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0'1.3g", "1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-'3.3g", "1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#'.50g", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-'1.50g", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0'3.50g", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-'50.50g", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#'1G", "1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-'3G", "1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0'50G", "00000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-'.0G", "1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#'3.0G", " 1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-'50.0G", "1.                                                ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0'.1G", "1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-'1.1G", "1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#'50.1G", "                                                1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-'.3G", "1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0'1.3G", "1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-'3.3G", "1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#'.50G", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-'1.50G", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0'3.50G", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-'50.50G", "1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#+'1g", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-+'3g", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0+'50g", "+0000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-+'.0g", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#+'3.0g", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-+'50.0g", "+1.                                               ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0+'.1g", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-+'1.1g", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#+'50.1g", "                                               +1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-+'.3g", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0+'1.3g", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-+'3.3g", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#+'.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-+'1.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0+'3.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-+'50.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#+'1G", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-+'3G", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0+'50G", "+0000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-+'.0G", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#+'3.0G", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-+'50.0G", "+1.                                               ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0+'.1G", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-+'1.1G", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#+'50.1G", "                                               +1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-+'.3G", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0+'1.3G", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-+'3.3G", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#+'.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#-+'1.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0+'3.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0-+'50.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# '1g", " 1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- '3g", " 1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 '50g", " 0000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- '.0g", " 1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# '3.0g", " 1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- '50.0g", " 1.                                               ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 '.1g", " 1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- '1.1g", " 1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# '50.1g", "                                                1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- '.3g", " 1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 '1.3g", " 1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- '3.3g", " 1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# '.50g", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- '1.50g", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 '3.50g", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- '50.50g", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# '1G", " 1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- '3G", " 1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 '50G", " 0000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- '.0G", " 1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# '3.0G", " 1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- '50.0G", " 1.                                               ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 '.1G", " 1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- '1.1G", " 1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# '50.1G", "                                                1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- '.3G", " 1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 '1.3G", " 1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- '3.3G", " 1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# '.50G", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- '1.50G", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 '3.50G", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- '50.50G", " 1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# +'1g", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- +'3g", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 +'50g", "+0000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- +'.0g", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# +'3.0g", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- +'50.0g", "+1.                                               ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 +'.1g", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- +'1.1g", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# +'50.1g", "                                               +1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- +'.3g", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 +'1.3g", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- +'3.3g", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# +'.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- +'1.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 +'3.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- +'50.50g", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# +'1G", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- +'3G", "+1.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 +'50G", "+0000000000000000000000000000000000000000001.12838", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- +'.0G", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# +'3.0G", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- +'50.0G", "+1.                                               ", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 +'.1G", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- +'1.1G", "+1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# +'50.1G", "                                               +1.", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- +'.3G", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 +'1.3G", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- +'3.3G", "+1.13", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%# +'.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#- +'1.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0 +'3.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%#0- +'50.50G", "+1.1283791670955125585606992899556644260883331298828", { 109, 155, 66, 80, 215, 13, 242, 63 } },
    { "%'1g", "1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-'3g", "1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0'50g", "00000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-'.0g", "1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%'3.0g", "  1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-'50.0g", "1                                                 ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0'.1g", "1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-'1.1g", "1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%'50.1g", "                                                 1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-'.3g", "1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0'1.3g", "1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-'3.3g", "1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%'.50g", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-'1.50g", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0'3.50g", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-'50.50g", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%'1G", "1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-'3G", "1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0'50G", "00000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-'.0G", "1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%'3.0G", "  1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-'50.0G", "1                                                 ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0'.1G", "1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-'1.1G", "1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%'50.1G", "                                                 1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-'.3G", "1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0'1.3G", "1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-'3.3G", "1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%'.50G", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-'1.50G", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0'3.50G", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-'50.50G", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%+'1g", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-+'3g", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0+'50g", "+0000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-+'.0g", "+1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%+'3.0g", " +1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-+'50.0g", "+1                                                ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0+'.1g", "+1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-+'1.1g", "+1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%+'50.1g", "                                                +1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-+'.3g", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0+'1.3g", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-+'3.3g", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%+'.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-+'1.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0+'3.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-+'50.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%+'1G", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-+'3G", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0+'50G", "+0000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-+'.0G", "+1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%+'3.0G", " +1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-+'50.0G", "+1                                                ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0+'.1G", "+1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-+'1.1G", "+1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%+'50.1G", "                                                +1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-+'.3G", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0+'1.3G", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-+'3.3G", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%+'.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%-+'1.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0+'3.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0-+'50.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% '1g", " 1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- '3g", " 1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 '50g", " 0000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- '.0g", " 1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% '3.0g", "  1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- '50.0g", " 1                                                ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 '.1g", " 1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- '1.1g", " 1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% '50.1g", "                                                 1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- '.3g", " 1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 '1.3g", " 1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- '3.3g", " 1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% '.50g", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- '1.50g", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 '3.50g", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- '50.50g", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% '1G", " 1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- '3G", " 1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 '50G", " 0000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- '.0G", " 1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% '3.0G", "  1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- '50.0G", " 1                                                ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 '.1G", " 1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- '1.1G", " 1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% '50.1G", "                                                 1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- '.3G", " 1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 '1.3G", " 1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- '3.3G", " 1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% '.50G", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- '1.50G", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 '3.50G", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- '50.50G", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% +'1g", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- +'3g", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 +'50g", "+0000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- +'.0g", "+1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% +'3.0g", " +1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- +'50.0g", "+1                                                ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 +'.1g", "+1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- +'1.1g", "+1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% +'50.1g", "                                                +1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- +'.3g", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 +'1.3g", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- +'3.3g", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% +'.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- +'1.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 +'3.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- +'50.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% +'1G", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- +'3G", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 +'50G", "+0000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- +'.0G", "+1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% +'3.0G", " +1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- +'50.0G", "+1                                                ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 +'.1G", "+1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- +'1.1G", "+1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% +'50.1G", "                                                +1", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- +'.3G", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 +'1.3G", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- +'3.3G", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "% +'.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%- +'1.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0 +'3.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%0- +'50.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#'1g", "1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-'3g", "1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0'50g", "00000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-'.0g", "1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#'3.0g", " 1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-'50.0g", "1.                                                ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0'.1g", "1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-'1.1g", "1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#'50.1g", "                                                1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-'.3g", "1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0'1.3g", "1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-'3.3g", "1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#'.50g", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-'1.50g", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0'3.50g", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-'50.50g", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#'1G", "1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-'3G", "1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0'50G", "00000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-'.0G", "1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#'3.0G", " 1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-'50.0G", "1.                                                ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0'.1G", "1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-'1.1G", "1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#'50.1G", "                                                1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-'.3G", "1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0'1.3G", "1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-'3.3G", "1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#'.50G", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-'1.50G", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0'3.50G", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-'50.50G", "1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#+'1g", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-+'3g", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0+'50g", "+0000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-+'.0g", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#+'3.0g", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-+'50.0g", "+1.                                               ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0+'.1g", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-+'1.1g", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#+'50.1g", "                                               +1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-+'.3g", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0+'1.3g", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-+'3.3g", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#+'.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-+'1.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0+'3.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-+'50.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#+'1G", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-+'3G", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0+'50G", "+0000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-+'.0G", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#+'3.0G", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-+'50.0G", "+1.                                               ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0+'.1G", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-+'1.1G", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#+'50.1G", "                                               +1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-+'.3G", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0+'1.3G", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-+'3.3G", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#+'.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#-+'1.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0+'3.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0-+'50.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# '1g", " 1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- '3g", " 1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 '50g", " 0000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- '.0g", " 1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# '3.0g", " 1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- '50.0g", " 1.                                               ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 '.1g", " 1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- '1.1g", " 1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# '50.1g", "                                                1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- '.3g", " 1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 '1.3g", " 1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- '3.3g", " 1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# '.50g", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- '1.50g", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 '3.50g", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- '50.50g", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# '1G", " 1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- '3G", " 1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 '50G", " 0000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- '.0G", " 1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# '3.0G", " 1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- '50.0G", " 1.                                               ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 '.1G", " 1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- '1.1G", " 1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# '50.1G", "                                                1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- '.3G", " 1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 '1.3G", " 1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- '3.3G", " 1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# '.50G", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- '1.50G", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 '3.50G", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- '50.50G", " 1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# +'1g", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- +'3g", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 +'50g", "+0000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- +'.0g", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# +'3.0g", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- +'50.0g", "+1.                                               ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 +'.1g", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- +'1.1g", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# +'50.1g", "                                               +1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- +'.3g", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 +'1.3g", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- +'3.3g", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# +'.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- +'1.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 +'3.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- +'50.50g", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# +'1G", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- +'3G", "+1.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 +'50G", "+0000000000000000000000000000000000000000001.41421", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- +'.0G", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# +'3.0G", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- +'50.0G", "+1.                                               ", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 +'.1G", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- +'1.1G", "+1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# +'50.1G", "                                               +1.", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- +'.3G", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 +'1.3G", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- +'3.3G", "+1.41", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%# +'.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#- +'1.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0 +'3.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%#0- +'50.50G", "+1.4142135623730951454746218587388284504413604736328", { 205, 59, 127, 102, 158, 160, 246, 63 } },
    { "%'1g", "0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-'3g", "0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0'50g", "0000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-'.0g", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%'3.0g", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-'50.0g", "0.7                                               ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0'.1g", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-'1.1g", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%'50.1g", "                                               0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-'.3g", "0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0'1.3g", "0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-'3.3g", "0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%'.50g", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-'1.50g", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0'3.50g", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-'50.50g", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%'1G", "0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-'3G", "0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0'50G", "0000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-'.0G", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%'3.0G", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-'50.0G", "0.7                                               ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0'.1G", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-'1.1G", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%'50.1G", "                                               0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-'.3G", "0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0'1.3G", "0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-'3.3G", "0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%'.50G", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-'1.50G", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0'3.50G", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-'50.50G", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%+'1g", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-+'3g", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0+'50g", "+000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-+'.0g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%+'3.0g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-+'50.0g", "+0.7                                              ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0+'.1g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-+'1.1g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%+'50.1g", "                                              +0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-+'.3g", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0+'1.3g", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-+'3.3g", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%+'.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-+'1.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0+'3.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-+'50.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%+'1G", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-+'3G", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0+'50G", "+000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-+'.0G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%+'3.0G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-+'50.0G", "+0.7                                              ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0+'.1G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-+'1.1G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%+'50.1G", "                                              +0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-+'.3G", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0+'1.3G", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-+'3.3G", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%+'.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%-+'1.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0+'3.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0-+'50.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% '1g", " 0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- '3g", " 0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 '50g", " 000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- '.0g", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% '3.0g", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- '50.0g", " 0.7                                              ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 '.1g", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- '1.1g", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% '50.1g", "                                               0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- '.3g", " 0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 '1.3g", " 0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- '3.3g", " 0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% '.50g", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- '1.50g", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 '3.50g", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- '50.50g", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% '1G", " 0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- '3G", " 0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 '50G", " 000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- '.0G", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% '3.0G", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- '50.0G", " 0.7                                              ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 '.1G", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- '1.1G", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% '50.1G", "                                               0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- '.3G", " 0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 '1.3G", " 0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- '3.3G", " 0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% '.50G", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- '1.50G", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 '3.50G", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- '50.50G", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% +'1g", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- +'3g", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 +'50g", "+000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- +'.0g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% +'3.0g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- +'50.0g", "+0.7                                              ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 +'.1g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- +'1.1g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% +'50.1g", "                                              +0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- +'.3g", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 +'1.3g", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- +'3.3g", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% +'.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- +'1.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 +'3.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- +'50.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% +'1G", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- +'3G", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 +'50G", "+000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- +'.0G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% +'3.0G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- +'50.0G", "+0.7                                              ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 +'.1G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- +'1.1G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% +'50.1G", "                                              +0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- +'.3G", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 +'1.3G", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- +'3.3G", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "% +'.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%- +'1.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0 +'3.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%0- +'50.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#'1g", "0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-'3g", "0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0'50g", "0000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-'.0g", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#'3.0g", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-'50.0g", "0.7                                               ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0'.1g", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-'1.1g", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#'50.1g", "                                               0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-'.3g", "0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0'1.3g", "0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-'3.3g", "0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#'.50g", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-'1.50g", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0'3.50g", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-'50.50g", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#'1G", "0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-'3G", "0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0'50G", "0000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-'.0G", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#'3.0G", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-'50.0G", "0.7                                               ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0'.1G", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-'1.1G", "0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#'50.1G", "                                               0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-'.3G", "0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0'1.3G", "0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-'3.3G", "0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#'.50G", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-'1.50G", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0'3.50G", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-'50.50G", "0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#+'1g", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-+'3g", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0+'50g", "+000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-+'.0g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#+'3.0g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-+'50.0g", "+0.7                                              ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0+'.1g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-+'1.1g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#+'50.1g", "                                              +0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-+'.3g", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0+'1.3g", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-+'3.3g", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#+'.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-+'1.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0+'3.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-+'50.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#+'1G", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-+'3G", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0+'50G", "+000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-+'.0G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#+'3.0G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-+'50.0G", "+0.7                                              ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0+'.1G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-+'1.1G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#+'50.1G", "                                              +0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-+'.3G", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0+'1.3G", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-+'3.3G", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#+'.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#-+'1.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0+'3.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0-+'50.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# '1g", " 0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- '3g", " 0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 '50g", " 000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- '.0g", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# '3.0g", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- '50.0g", " 0.7                                              ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 '.1g", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- '1.1g", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# '50.1g", "                                               0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- '.3g", " 0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 '1.3g", " 0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- '3.3g", " 0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# '.50g", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- '1.50g", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 '3.50g", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- '50.50g", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# '1G", " 0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- '3G", " 0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 '50G", " 000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- '.0G", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# '3.0G", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- '50.0G", " 0.7                                              ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 '.1G", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- '1.1G", " 0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# '50.1G", "                                               0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- '.3G", " 0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 '1.3G", " 0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- '3.3G", " 0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# '.50G", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- '1.50G", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 '3.50G", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- '50.50G", " 0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# +'1g", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- +'3g", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- +'.0g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# +'3.0g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- +'50.0g", "+0.7                                              ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 +'.1g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- +'1.1g", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# +'50.1g", "                                              +0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- +'.3g", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 +'1.3g", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- +'3.3g", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# +'.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- +'1.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 +'3.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- +'50.50g", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# +'1G", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- +'3G", "+0.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000000000.707107", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- +'.0G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# +'3.0G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- +'50.0G", "+0.7                                              ", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 +'.1G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- +'1.1G", "+0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# +'50.1G", "                                              +0.7", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- +'.3G", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 +'1.3G", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- +'3.3G", "+0.707", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%# +'.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#- +'1.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0 +'3.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%#0- +'50.50G", "+0.70710678118654757273731092936941422522068023681641", { 205, 59, 127, 102, 158, 160, 230, 63 } },
    { "%'1g", "1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-'3g", "1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0'50g", "0000000000000000000000000000000000000000000001e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-'.0g", "1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%'3.0g", "1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-'50.0g", "1e-14                                             ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0'.1g", "1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-'1.1g", "1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%'50.1g", "                                             1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-'.3g", "1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0'1.3g", "1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-'3.3g", "1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%'.50g", "9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-'1.50g", "9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0'3.50g", "9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-'50.50g", "9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%'1G", "1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-'3G", "1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0'50G", "0000000000000000000000000000000000000000000001E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-'.0G", "1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%'3.0G", "1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-'50.0G", "1E-14                                             ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0'.1G", "1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-'1.1G", "1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%'50.1G", "                                             1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-'.3G", "1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0'1.3G", "1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-'3.3G", "1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%'.50G", "9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-'1.50G", "9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0'3.50G", "9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-'50.50G", "9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%+'1g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-+'3g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0+'50g", "+000000000000000000000000000000000000000000001e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-+'.0g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%+'3.0g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-+'50.0g", "+1e-14                                            ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0+'.1g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-+'1.1g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%+'50.1g", "                                            +1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-+'.3g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0+'1.3g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-+'3.3g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%+'.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-+'1.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0+'3.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-+'50.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%+'1G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-+'3G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0+'50G", "+000000000000000000000000000000000000000000001E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-+'.0G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%+'3.0G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-+'50.0G", "+1E-14                                            ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0+'.1G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-+'1.1G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%+'50.1G", "                                            +1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-+'.3G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0+'1.3G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-+'3.3G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%+'.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%-+'1.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0+'3.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0-+'50.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% '1g", " 1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- '3g", " 1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 '50g", " 000000000000000000000000000000000000000000001e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- '.0g", " 1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% '3.0g", " 1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- '50.0g", " 1e-14                                            ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 '.1g", " 1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- '1.1g", " 1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% '50.1g", "                                             1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- '.3g", " 1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 '1.3g", " 1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- '3.3g", " 1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% '.50g", " 9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- '1.50g", " 9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 '3.50g", " 9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- '50.50g", " 9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% '1G", " 1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- '3G", " 1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 '50G", " 000000000000000000000000000000000000000000001E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- '.0G", " 1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% '3.0G", " 1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- '50.0G", " 1E-14                                            ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 '.1G", " 1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- '1.1G", " 1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% '50.1G", "                                             1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- '.3G", " 1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 '1.3G", " 1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- '3.3G", " 1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% '.50G", " 9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- '1.50G", " 9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 '3.50G", " 9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- '50.50G", " 9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% +'1g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- +'3g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 +'50g", "+000000000000000000000000000000000000000000001e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- +'.0g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% +'3.0g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- +'50.0g", "+1e-14                                            ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 +'.1g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- +'1.1g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% +'50.1g", "                                            +1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- +'.3g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 +'1.3g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- +'3.3g", "+1e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% +'.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- +'1.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 +'3.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- +'50.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% +'1G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- +'3G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 +'50G", "+000000000000000000000000000000000000000000001E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- +'.0G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% +'3.0G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- +'50.0G", "+1E-14                                            ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 +'.1G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- +'1.1G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% +'50.1G", "                                            +1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- +'.3G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 +'1.3G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- +'3.3G", "+1E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "% +'.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%- +'1.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0 +'3.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%0- +'50.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#'1g", "1.00000e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-'3g", "1.00000e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0'50g", "0000000000000000000000000000000000000001.00000e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-'.0g", "1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#'3.0g", "1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-'50.0g", "1.e-14                                            ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0'.1g", "1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-'1.1g", "1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#'50.1g", "                                            1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-'.3g", "1.00e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0'1.3g", "1.00e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-'3.3g", "1.00e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#'.50g", "9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-'1.50g", "9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0'3.50g", "9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-'50.50g", "9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#'1G", "1.00000E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-'3G", "1.00000E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0'50G", "0000000000000000000000000000000000000001.00000E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-'.0G", "1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#'3.0G", "1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-'50.0G", "1.E-14                                            ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0'.1G", "1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-'1.1G", "1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#'50.1G", "                                            1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-'.3G", "1.00E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0'1.3G", "1.00E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-'3.3G", "1.00E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#'.50G", "9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-'1.50G", "9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0'3.50G", "9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-'50.50G", "9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#+'1g", "+1.00000e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-+'3g", "+1.00000e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0+'50g", "+000000000000000000000000000000000000001.00000e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-+'.0g", "+1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#+'3.0g", "+1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-+'50.0g", "+1.e-14                                           ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0+'.1g", "+1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-+'1.1g", "+1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#+'50.1g", "                                           +1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-+'.3g", "+1.00e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0+'1.3g", "+1.00e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-+'3.3g", "+1.00e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#+'.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-+'1.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0+'3.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-+'50.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#+'1G", "+1.00000E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-+'3G", "+1.00000E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0+'50G", "+000000000000000000000000000000000000001.00000E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-+'.0G", "+1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#+'3.0G", "+1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-+'50.0G", "+1.E-14                                           ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0+'.1G", "+1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-+'1.1G", "+1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#+'50.1G", "                                           +1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-+'.3G", "+1.00E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0+'1.3G", "+1.00E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-+'3.3G", "+1.00E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#+'.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#-+'1.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0+'3.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0-+'50.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# '1g", " 1.00000e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- '3g", " 1.00000e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 '50g", " 000000000000000000000000000000000000001.00000e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- '.0g", " 1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# '3.0g", " 1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- '50.0g", " 1.e-14                                           ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 '.1g", " 1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- '1.1g", " 1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# '50.1g", "                                            1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- '.3g", " 1.00e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 '1.3g", " 1.00e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- '3.3g", " 1.00e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# '.50g", " 9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- '1.50g", " 9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 '3.50g", " 9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- '50.50g", " 9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# '1G", " 1.00000E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- '3G", " 1.00000E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 '50G", " 000000000000000000000000000000000000001.00000E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- '.0G", " 1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# '3.0G", " 1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- '50.0G", " 1.E-14                                           ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 '.1G", " 1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- '1.1G", " 1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# '50.1G", "                                            1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- '.3G", " 1.00E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 '1.3G", " 1.00E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- '3.3G", " 1.00E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# '.50G", " 9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- '1.50G", " 9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 '3.50G", " 9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- '50.50G", " 9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# +'1g", "+1.00000e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- +'3g", "+1.00000e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000001.00000e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- +'.0g", "+1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# +'3.0g", "+1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- +'50.0g", "+1.e-14                                           ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 +'.1g", "+1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- +'1.1g", "+1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# +'50.1g", "                                           +1.e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- +'.3g", "+1.00e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 +'1.3g", "+1.00e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- +'3.3g", "+1.00e-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# +'.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- +'1.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 +'3.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- +'50.50g", "+9.9999999999999999881930935455989869713432907291639e-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# +'1G", "+1.00000E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- +'3G", "+1.00000E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000001.00000E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- +'.0G", "+1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# +'3.0G", "+1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- +'50.0G", "+1.E-14                                           ", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 +'.1G", "+1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- +'1.1G", "+1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# +'50.1G", "                                           +1.E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- +'.3G", "+1.00E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 +'1.3G", "+1.00E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- +'3.3G", "+1.00E-14", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%# +'.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#- +'1.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0 +'3.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%#0- +'50.50G", "+9.9999999999999999881930935455989869713432907291639E-15", { 155, 43, 161, 134, 155, 132, 6, 61 } },
    { "%'1g", "1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-'3g", "1  ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0'50g", "00000000000000000000000000000000000000000000000001", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-'.0g", "1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%'3.0g", "  1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-'50.0g", "1                                                 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0'.1g", "1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-'1.1g", "1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%'50.1g", "                                                 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-'.3g", "1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0'1.3g", "1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-'3.3g", "1  ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%'.50g", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-'1.50g", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0'3.50g", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-'50.50g", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%'1G", "1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-'3G", "1  ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0'50G", "00000000000000000000000000000000000000000000000001", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-'.0G", "1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%'3.0G", "  1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-'50.0G", "1                                                 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0'.1G", "1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-'1.1G", "1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%'50.1G", "                                                 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-'.3G", "1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0'1.3G", "1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-'3.3G", "1  ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%'.50G", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-'1.50G", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0'3.50G", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-'50.50G", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%+'1g", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-+'3g", "+1 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0+'50g", "+0000000000000000000000000000000000000000000000001", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-+'.0g", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%+'3.0g", " +1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-+'50.0g", "+1                                                ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0+'.1g", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-+'1.1g", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%+'50.1g", "                                                +1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-+'.3g", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0+'1.3g", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-+'3.3g", "+1 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%+'.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-+'1.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0+'3.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-+'50.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%+'1G", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-+'3G", "+1 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0+'50G", "+0000000000000000000000000000000000000000000000001", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-+'.0G", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%+'3.0G", " +1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-+'50.0G", "+1                                                ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0+'.1G", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-+'1.1G", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%+'50.1G", "                                                +1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-+'.3G", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0+'1.3G", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-+'3.3G", "+1 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%+'.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%-+'1.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0+'3.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0-+'50.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% '1g", " 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- '3g", " 1 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 '50g", " 0000000000000000000000000000000000000000000000001", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- '.0g", " 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% '3.0g", "  1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- '50.0g", " 1                                                ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 '.1g", " 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- '1.1g", " 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% '50.1g", "                                                 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- '.3g", " 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 '1.3g", " 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- '3.3g", " 1 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% '.50g", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- '1.50g", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 '3.50g", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- '50.50g", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% '1G", " 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- '3G", " 1 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 '50G", " 0000000000000000000000000000000000000000000000001", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- '.0G", " 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% '3.0G", "  1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- '50.0G", " 1                                                ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 '.1G", " 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- '1.1G", " 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% '50.1G", "                                                 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- '.3G", " 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 '1.3G", " 1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- '3.3G", " 1 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% '.50G", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- '1.50G", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 '3.50G", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- '50.50G", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% +'1g", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- +'3g", "+1 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 +'50g", "+0000000000000000000000000000000000000000000000001", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- +'.0g", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% +'3.0g", " +1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- +'50.0g", "+1                                                ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 +'.1g", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- +'1.1g", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% +'50.1g", "                                                +1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- +'.3g", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 +'1.3g", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- +'3.3g", "+1 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% +'.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- +'1.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 +'3.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- +'50.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% +'1G", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- +'3G", "+1 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 +'50G", "+0000000000000000000000000000000000000000000000001", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- +'.0G", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% +'3.0G", " +1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- +'50.0G", "+1                                                ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 +'.1G", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- +'1.1G", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% +'50.1G", "                                                +1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- +'.3G", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 +'1.3G", "+1", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- +'3.3G", "+1 ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "% +'.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%- +'1.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0 +'3.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%0- +'50.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#'1g", "1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-'3g", "1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0'50g", "00000000000000000000000000000000000000000001.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-'.0g", "1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#'3.0g", " 1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-'50.0g", "1.                                                ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0'.1g", "1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-'1.1g", "1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#'50.1g", "                                                1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-'.3g", "1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0'1.3g", "1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-'3.3g", "1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#'.50g", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-'1.50g", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0'3.50g", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-'50.50g", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#'1G", "1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-'3G", "1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0'50G", "00000000000000000000000000000000000000000001.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-'.0G", "1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#'3.0G", " 1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-'50.0G", "1.                                                ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0'.1G", "1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-'1.1G", "1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#'50.1G", "                                                1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-'.3G", "1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0'1.3G", "1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-'3.3G", "1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#'.50G", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-'1.50G", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0'3.50G", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-'50.50G", "0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#+'1g", "+1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-+'3g", "+1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0+'50g", "+0000000000000000000000000000000000000000001.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-+'.0g", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#+'3.0g", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-+'50.0g", "+1.                                               ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0+'.1g", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-+'1.1g", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#+'50.1g", "                                               +1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-+'.3g", "+1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0+'1.3g", "+1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-+'3.3g", "+1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#+'.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-+'1.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0+'3.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-+'50.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#+'1G", "+1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-+'3G", "+1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0+'50G", "+0000000000000000000000000000000000000000001.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-+'.0G", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#+'3.0G", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-+'50.0G", "+1.                                               ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0+'.1G", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-+'1.1G", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#+'50.1G", "                                               +1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-+'.3G", "+1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0+'1.3G", "+1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-+'3.3G", "+1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#+'.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#-+'1.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0+'3.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0-+'50.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# '1g", " 1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- '3g", " 1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 '50g", " 0000000000000000000000000000000000000000001.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- '.0g", " 1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# '3.0g", " 1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- '50.0g", " 1.                                               ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 '.1g", " 1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- '1.1g", " 1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# '50.1g", "                                                1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- '.3g", " 1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 '1.3g", " 1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- '3.3g", " 1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# '.50g", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- '1.50g", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 '3.50g", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- '50.50g", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# '1G", " 1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- '3G", " 1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 '50G", " 0000000000000000000000000000000000000000001.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- '.0G", " 1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# '3.0G", " 1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- '50.0G", " 1.                                               ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 '.1G", " 1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- '1.1G", " 1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# '50.1G", "                                                1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- '.3G", " 1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 '1.3G", " 1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- '3.3G", " 1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# '.50G", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- '1.50G", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 '3.50G", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- '50.50G", " 0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# +'1g", "+1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- +'3g", "+1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 +'50g", "+0000000000000000000000000000000000000000001.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- +'.0g", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# +'3.0g", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- +'50.0g", "+1.                                               ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 +'.1g", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- +'1.1g", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# +'50.1g", "                                               +1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- +'.3g", "+1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 +'1.3g", "+1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- +'3.3g", "+1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# +'.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- +'1.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 +'3.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- +'50.50g", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# +'1G", "+1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- +'3G", "+1.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 +'50G", "+0000000000000000000000000000000000000000001.00000", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- +'.0G", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# +'3.0G", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- +'50.0G", "+1.                                               ", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 +'.1G", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- +'1.1G", "+1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# +'50.1G", "                                               +1.", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- +'.3G", "+1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 +'1.3G", "+1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- +'3.3G", "+1.00", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%# +'.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#- +'1.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0 +'3.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%#0- +'50.50G", "+0.99999999999999000799277837359113618731498718261719", { 166, 255, 255, 255, 255, 255, 239, 63 } },
    { "%'1g", "1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-'3g", "1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0'50g", "0000000000000000000000000000000000000000000001e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-'.0g", "1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%'3.0g", "1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-'50.0g", "1e+50                                             ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0'.1g", "1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-'1.1g", "1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%'50.1g", "                                             1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-'.3g", "1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0'1.3g", "1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-'3.3g", "1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%'.50g", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-'1.50g", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0'3.50g", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-'50.50g", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%'1G", "1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-'3G", "1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0'50G", "0000000000000000000000000000000000000000000001E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-'.0G", "1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%'3.0G", "1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-'50.0G", "1E+50                                             ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0'.1G", "1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-'1.1G", "1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%'50.1G", "                                             1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-'.3G", "1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0'1.3G", "1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-'3.3G", "1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%'.50G", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-'1.50G", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0'3.50G", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-'50.50G", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%+'1g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-+'3g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0+'50g", "+000000000000000000000000000000000000000000001e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-+'.0g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%+'3.0g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-+'50.0g", "+1e+50                                            ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0+'.1g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-+'1.1g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%+'50.1g", "                                            +1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-+'.3g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0+'1.3g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-+'3.3g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%+'.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-+'1.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0+'3.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-+'50.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%+'1G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-+'3G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0+'50G", "+000000000000000000000000000000000000000000001E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-+'.0G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%+'3.0G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-+'50.0G", "+1E+50                                            ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0+'.1G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-+'1.1G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%+'50.1G", "                                            +1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-+'.3G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0+'1.3G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-+'3.3G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%+'.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%-+'1.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0+'3.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0-+'50.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% '1g", " 1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- '3g", " 1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 '50g", " 000000000000000000000000000000000000000000001e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- '.0g", " 1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% '3.0g", " 1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- '50.0g", " 1e+50                                            ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 '.1g", " 1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- '1.1g", " 1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% '50.1g", "                                             1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- '.3g", " 1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 '1.3g", " 1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- '3.3g", " 1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% '.50g", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- '1.50g", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 '3.50g", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- '50.50g", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% '1G", " 1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- '3G", " 1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 '50G", " 000000000000000000000000000000000000000000001E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- '.0G", " 1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% '3.0G", " 1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- '50.0G", " 1E+50                                            ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 '.1G", " 1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- '1.1G", " 1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% '50.1G", "                                             1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- '.3G", " 1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 '1.3G", " 1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- '3.3G", " 1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% '.50G", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- '1.50G", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 '3.50G", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- '50.50G", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% +'1g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- +'3g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 +'50g", "+000000000000000000000000000000000000000000001e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- +'.0g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% +'3.0g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- +'50.0g", "+1e+50                                            ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 +'.1g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- +'1.1g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% +'50.1g", "                                            +1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- +'.3g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 +'1.3g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- +'3.3g", "+1e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% +'.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- +'1.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 +'3.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- +'50.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% +'1G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- +'3G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 +'50G", "+000000000000000000000000000000000000000000001E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- +'.0G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% +'3.0G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- +'50.0G", "+1E+50                                            ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 +'.1G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- +'1.1G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% +'50.1G", "                                            +1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- +'.3G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 +'1.3G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- +'3.3G", "+1E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "% +'.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%- +'1.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0 +'3.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%0- +'50.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#'1g", "1.00000e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-'3g", "1.00000e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0'50g", "0000000000000000000000000000000000000001.00000e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-'.0g", "1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#'3.0g", "1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-'50.0g", "1.e+50                                            ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0'.1g", "1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-'1.1g", "1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#'50.1g", "                                            1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-'.3g", "1.00e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0'1.3g", "1.00e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-'3.3g", "1.00e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#'.50g", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-'1.50g", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0'3.50g", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-'50.50g", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#'1G", "1.00000E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-'3G", "1.00000E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0'50G", "0000000000000000000000000000000000000001.00000E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-'.0G", "1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#'3.0G", "1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-'50.0G", "1.E+50                                            ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0'.1G", "1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-'1.1G", "1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#'50.1G", "                                            1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-'.3G", "1.00E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0'1.3G", "1.00E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-'3.3G", "1.00E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#'.50G", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-'1.50G", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0'3.50G", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-'50.50G", "99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#+'1g", "+1.00000e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-+'3g", "+1.00000e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0+'50g", "+000000000000000000000000000000000000001.00000e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-+'.0g", "+1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#+'3.0g", "+1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-+'50.0g", "+1.e+50                                           ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0+'.1g", "+1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-+'1.1g", "+1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#+'50.1g", "                                           +1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-+'.3g", "+1.00e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0+'1.3g", "+1.00e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-+'3.3g", "+1.00e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#+'.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-+'1.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0+'3.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-+'50.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#+'1G", "+1.00000E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-+'3G", "+1.00000E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0+'50G", "+000000000000000000000000000000000000001.00000E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-+'.0G", "+1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#+'3.0G", "+1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-+'50.0G", "+1.E+50                                           ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0+'.1G", "+1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-+'1.1G", "+1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#+'50.1G", "                                           +1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-+'.3G", "+1.00E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0+'1.3G", "+1.00E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-+'3.3G", "+1.00E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#+'.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#-+'1.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0+'3.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0-+'50.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# '1g", " 1.00000e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- '3g", " 1.00000e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 '50g", " 000000000000000000000000000000000000001.00000e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- '.0g", " 1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# '3.0g", " 1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- '50.0g", " 1.e+50                                           ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 '.1g", " 1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- '1.1g", " 1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# '50.1g", "                                            1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- '.3g", " 1.00e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 '1.3g", " 1.00e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- '3.3g", " 1.00e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# '.50g", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- '1.50g", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 '3.50g", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- '50.50g", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# '1G", " 1.00000E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- '3G", " 1.00000E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 '50G", " 000000000000000000000000000000000000001.00000E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- '.0G", " 1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# '3.0G", " 1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- '50.0G", " 1.E+50                                           ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 '.1G", " 1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- '1.1G", " 1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# '50.1G", "                                            1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- '.3G", " 1.00E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 '1.3G", " 1.00E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- '3.3G", " 1.00E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# '.50G", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- '1.50G", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 '3.50G", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- '50.50G", " 99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# +'1g", "+1.00000e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- +'3g", "+1.00000e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000001.00000e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- +'.0g", "+1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# +'3.0g", "+1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- +'50.0g", "+1.e+50                                           ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 +'.1g", "+1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- +'1.1g", "+1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# +'50.1g", "                                           +1.e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- +'.3g", "+1.00e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 +'1.3g", "+1.00e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- +'3.3g", "+1.00e+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# +'.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- +'1.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 +'3.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- +'50.50g", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# +'1G", "+1.00000E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- +'3G", "+1.00000E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000001.00000E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- +'.0G", "+1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# +'3.0G", "+1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- +'50.0G", "+1.E+50                                           ", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 +'.1G", "+1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- +'1.1G", "+1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# +'50.1G", "                                           +1.E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- +'.3G", "+1.00E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 +'1.3G", "+1.00E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- +'3.3G", "+1.00E+50", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%# +'.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#- +'1.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0 +'3.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%#0- +'50.50G", "+99,999,999,999,999,010,708,773,002,404,982,325,439,669,760,688,128.", { 106, 100, 126, 197, 14, 27, 81, 74 } },
    { "%'1g", "1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-'3g", "1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0'50g", "0000000000000000000000000000000000000000000001e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-'.0g", "1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%'3.0g", "1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-'50.0g", "1e-50                                             ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0'.1g", "1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-'1.1g", "1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%'50.1g", "                                             1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-'.3g", "1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0'1.3g", "1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-'3.3g", "1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%'.50g", "9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-'1.50g", "9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0'3.50g", "9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-'50.50g", "9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%'1G", "1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-'3G", "1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0'50G", "0000000000000000000000000000000000000000000001E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-'.0G", "1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%'3.0G", "1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-'50.0G", "1E-50                                             ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0'.1G", "1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-'1.1G", "1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%'50.1G", "                                             1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-'.3G", "1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0'1.3G", "1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-'3.3G", "1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%'.50G", "9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-'1.50G", "9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0'3.50G", "9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-'50.50G", "9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%+'1g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-+'3g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0+'50g", "+000000000000000000000000000000000000000000001e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-+'.0g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%+'3.0g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-+'50.0g", "+1e-50                                            ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0+'.1g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-+'1.1g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%+'50.1g", "                                            +1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-+'.3g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0+'1.3g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-+'3.3g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%+'.50g", "+9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-+'1.50g", "+9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0+'3.50g", "+9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-+'50.50g", "+9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%+'1G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-+'3G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0+'50G", "+000000000000000000000000000000000000000000001E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-+'.0G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%+'3.0G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-+'50.0G", "+1E-50                                            ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0+'.1G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-+'1.1G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%+'50.1G", "                                            +1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-+'.3G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0+'1.3G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-+'3.3G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%+'.50G", "+9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%-+'1.50G", "+9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0+'3.50G", "+9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0-+'50.50G", "+9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% '1g", " 1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- '3g", " 1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 '50g", " 000000000000000000000000000000000000000000001e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- '.0g", " 1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% '3.0g", " 1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- '50.0g", " 1e-50                                            ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 '.1g", " 1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- '1.1g", " 1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% '50.1g", "                                             1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- '.3g", " 1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 '1.3g", " 1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- '3.3g", " 1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% '.50g", " 9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- '1.50g", " 9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 '3.50g", " 9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- '50.50g", " 9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% '1G", " 1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- '3G", " 1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 '50G", " 000000000000000000000000000000000000000000001E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- '.0G", " 1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% '3.0G", " 1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- '50.0G", " 1E-50                                            ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 '.1G", " 1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- '1.1G", " 1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% '50.1G", "                                             1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- '.3G", " 1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 '1.3G", " 1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- '3.3G", " 1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% '.50G", " 9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- '1.50G", " 9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 '3.50G", " 9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- '50.50G", " 9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% +'1g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- +'3g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 +'50g", "+000000000000000000000000000000000000000000001e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- +'.0g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% +'3.0g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- +'50.0g", "+1e-50                                            ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 +'.1g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- +'1.1g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% +'50.1g", "                                            +1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- +'.3g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 +'1.3g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- +'3.3g", "+1e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% +'.50g", "+9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- +'1.50g", "+9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 +'3.50g", "+9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- +'50.50g", "+9.999999999999900372700906579936580106949261241377e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% +'1G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- +'3G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 +'50G", "+000000000000000000000000000000000000000000001E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- +'.0G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% +'3.0G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- +'50.0G", "+1E-50                                            ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 +'.1G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- +'1.1G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% +'50.1G", "                                            +1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- +'.3G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 +'1.3G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- +'3.3G", "+1E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "% +'.50G", "+9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%- +'1.50G", "+9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0 +'3.50G", "+9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%0- +'50.50G", "+9.999999999999900372700906579936580106949261241377E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#'1g", "1.00000e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-'3g", "1.00000e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0'50g", "0000000000000000000000000000000000000001.00000e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-'.0g", "1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#'3.0g", "1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-'50.0g", "1.e-50                                            ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0'.1g", "1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-'1.1g", "1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#'50.1g", "                                            1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-'.3g", "1.00e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0'1.3g", "1.00e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-'3.3g", "1.00e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#'.50g", "9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-'1.50g", "9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0'3.50g", "9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-'50.50g", "9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#'1G", "1.00000E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-'3G", "1.00000E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0'50G", "0000000000000000000000000000000000000001.00000E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-'.0G", "1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#'3.0G", "1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-'50.0G", "1.E-50                                            ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0'.1G", "1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-'1.1G", "1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#'50.1G", "                                            1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-'.3G", "1.00E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0'1.3G", "1.00E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-'3.3G", "1.00E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#'.50G", "9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-'1.50G", "9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0'3.50G", "9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-'50.50G", "9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#+'1g", "+1.00000e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-+'3g", "+1.00000e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0+'50g", "+000000000000000000000000000000000000001.00000e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-+'.0g", "+1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#+'3.0g", "+1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-+'50.0g", "+1.e-50                                           ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0+'.1g", "+1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-+'1.1g", "+1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#+'50.1g", "                                           +1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-+'.3g", "+1.00e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0+'1.3g", "+1.00e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-+'3.3g", "+1.00e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#+'.50g", "+9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-+'1.50g", "+9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0+'3.50g", "+9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-+'50.50g", "+9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#+'1G", "+1.00000E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-+'3G", "+1.00000E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0+'50G", "+000000000000000000000000000000000000001.00000E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-+'.0G", "+1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#+'3.0G", "+1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-+'50.0G", "+1.E-50                                           ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0+'.1G", "+1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-+'1.1G", "+1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#+'50.1G", "                                           +1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-+'.3G", "+1.00E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0+'1.3G", "+1.00E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-+'3.3G", "+1.00E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#+'.50G", "+9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#-+'1.50G", "+9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0+'3.50G", "+9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0-+'50.50G", "+9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# '1g", " 1.00000e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- '3g", " 1.00000e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 '50g", " 000000000000000000000000000000000000001.00000e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- '.0g", " 1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# '3.0g", " 1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- '50.0g", " 1.e-50                                           ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 '.1g", " 1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- '1.1g", " 1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# '50.1g", "                                            1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- '.3g", " 1.00e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 '1.3g", " 1.00e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- '3.3g", " 1.00e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# '.50g", " 9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- '1.50g", " 9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 '3.50g", " 9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- '50.50g", " 9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# '1G", " 1.00000E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- '3G", " 1.00000E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 '50G", " 000000000000000000000000000000000000001.00000E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- '.0G", " 1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# '3.0G", " 1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- '50.0G", " 1.E-50                                           ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 '.1G", " 1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- '1.1G", " 1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# '50.1G", "                                            1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- '.3G", " 1.00E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 '1.3G", " 1.00E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- '3.3G", " 1.00E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# '.50G", " 9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- '1.50G", " 9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 '3.50G", " 9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- '50.50G", " 9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# +'1g", "+1.00000e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- +'3g", "+1.00000e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000001.00000e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- +'.0g", "+1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# +'3.0g", "+1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- +'50.0g", "+1.e-50                                           ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 +'.1g", "+1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- +'1.1g", "+1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# +'50.1g", "                                           +1.e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- +'.3g", "+1.00e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 +'1.3g", "+1.00e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- +'3.3g", "+1.00e-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# +'.50g", "+9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- +'1.50g", "+9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 +'3.50g", "+9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- +'50.50g", "+9.9999999999999003727009065799365801069492612413770e-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# +'1G", "+1.00000E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- +'3G", "+1.00000E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000001.00000E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- +'.0G", "+1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# +'3.0G", "+1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- +'50.0G", "+1.E-50                                           ", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 +'.1G", "+1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- +'1.1G", "+1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# +'50.1G", "                                           +1.E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- +'.3G", "+1.00E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 +'1.3G", "+1.00E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- +'3.3G", "+1.00E-50", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%# +'.50G", "+9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#- +'1.50G", "+9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0 +'3.50G", "+9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%#0- +'50.50G", "+9.9999999999999003727009065799365801069492612413770E-51", { 203, 183, 212, 74, 122, 238, 141, 53 } },
    { "%'1g", "1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-'3g", "1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0'50g", "000000000000000000000000000000000000000000001e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-'.0g", "1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%'3.0g", "1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-'50.0g", "1e+150                                            ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0'.1g", "1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-'1.1g", "1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%'50.1g", "                                            1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-'.3g", "1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0'1.3g", "1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-'3.3g", "1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%'.50g", "9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-'1.50g", "9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0'3.50g", "9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-'50.50g", "9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%'1G", "1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-'3G", "1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0'50G", "000000000000000000000000000000000000000000001E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-'.0G", "1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%'3.0G", "1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-'50.0G", "1E+150                                            ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0'.1G", "1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-'1.1G", "1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%'50.1G", "                                            1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-'.3G", "1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0'1.3G", "1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-'3.3G", "1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%'.50G", "9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-'1.50G", "9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0'3.50G", "9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-'50.50G", "9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%+'1g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-+'3g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0+'50g", "+00000000000000000000000000000000000000000001e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-+'.0g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%+'3.0g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-+'50.0g", "+1e+150                                           ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0+'.1g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-+'1.1g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%+'50.1g", "                                           +1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-+'.3g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0+'1.3g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-+'3.3g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%+'.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-+'1.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0+'3.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-+'50.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%+'1G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-+'3G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0+'50G", "+00000000000000000000000000000000000000000001E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-+'.0G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%+'3.0G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-+'50.0G", "+1E+150                                           ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0+'.1G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-+'1.1G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%+'50.1G", "                                           +1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-+'.3G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0+'1.3G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-+'3.3G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%+'.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%-+'1.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0+'3.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0-+'50.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% '1g", " 1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- '3g", " 1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 '50g", " 00000000000000000000000000000000000000000001e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- '.0g", " 1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% '3.0g", " 1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- '50.0g", " 1e+150                                           ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 '.1g", " 1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- '1.1g", " 1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% '50.1g", "                                            1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- '.3g", " 1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 '1.3g", " 1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- '3.3g", " 1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% '.50g", " 9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- '1.50g", " 9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 '3.50g", " 9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- '50.50g", " 9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% '1G", " 1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- '3G", " 1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 '50G", " 00000000000000000000000000000000000000000001E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- '.0G", " 1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% '3.0G", " 1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- '50.0G", " 1E+150                                           ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 '.1G", " 1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- '1.1G", " 1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% '50.1G", "                                            1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- '.3G", " 1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 '1.3G", " 1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- '3.3G", " 1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% '.50G", " 9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- '1.50G", " 9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 '3.50G", " 9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- '50.50G", " 9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% +'1g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- +'3g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 +'50g", "+00000000000000000000000000000000000000000001e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- +'.0g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% +'3.0g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- +'50.0g", "+1e+150                                           ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 +'.1g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- +'1.1g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% +'50.1g", "                                           +1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- +'.3g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 +'1.3g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- +'3.3g", "+1e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% +'.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- +'1.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 +'3.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- +'50.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% +'1G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- +'3G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 +'50G", "+00000000000000000000000000000000000000000001E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- +'.0G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% +'3.0G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- +'50.0G", "+1E+150                                           ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 +'.1G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- +'1.1G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% +'50.1G", "                                           +1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- +'.3G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 +'1.3G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- +'3.3G", "+1E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "% +'.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%- +'1.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0 +'3.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%0- +'50.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#'1g", "1.00000e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-'3g", "1.00000e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0'50g", "000000000000000000000000000000000000001.00000e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-'.0g", "1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#'3.0g", "1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-'50.0g", "1.e+150                                           ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0'.1g", "1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-'1.1g", "1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#'50.1g", "                                           1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-'.3g", "1.00e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0'1.3g", "1.00e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-'3.3g", "1.00e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#'.50g", "9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-'1.50g", "9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0'3.50g", "9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-'50.50g", "9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#'1G", "1.00000E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-'3G", "1.00000E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0'50G", "000000000000000000000000000000000000001.00000E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-'.0G", "1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#'3.0G", "1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-'50.0G", "1.E+150                                           ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0'.1G", "1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-'1.1G", "1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#'50.1G", "                                           1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-'.3G", "1.00E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0'1.3G", "1.00E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-'3.3G", "1.00E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#'.50G", "9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-'1.50G", "9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0'3.50G", "9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-'50.50G", "9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#+'1g", "+1.00000e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-+'3g", "+1.00000e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0+'50g", "+00000000000000000000000000000000000001.00000e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-+'.0g", "+1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#+'3.0g", "+1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-+'50.0g", "+1.e+150                                          ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0+'.1g", "+1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-+'1.1g", "+1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#+'50.1g", "                                          +1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-+'.3g", "+1.00e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0+'1.3g", "+1.00e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-+'3.3g", "+1.00e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#+'.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-+'1.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0+'3.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-+'50.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#+'1G", "+1.00000E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-+'3G", "+1.00000E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0+'50G", "+00000000000000000000000000000000000001.00000E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-+'.0G", "+1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#+'3.0G", "+1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-+'50.0G", "+1.E+150                                          ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0+'.1G", "+1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-+'1.1G", "+1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#+'50.1G", "                                          +1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-+'.3G", "+1.00E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0+'1.3G", "+1.00E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-+'3.3G", "+1.00E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#+'.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#-+'1.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0+'3.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0-+'50.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# '1g", " 1.00000e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- '3g", " 1.00000e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 '50g", " 00000000000000000000000000000000000001.00000e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- '.0g", " 1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# '3.0g", " 1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- '50.0g", " 1.e+150                                          ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 '.1g", " 1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- '1.1g", " 1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# '50.1g", "                                           1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- '.3g", " 1.00e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 '1.3g", " 1.00e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- '3.3g", " 1.00e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# '.50g", " 9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- '1.50g", " 9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 '3.50g", " 9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- '50.50g", " 9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# '1G", " 1.00000E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- '3G", " 1.00000E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 '50G", " 00000000000000000000000000000000000001.00000E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- '.0G", " 1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# '3.0G", " 1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- '50.0G", " 1.E+150                                          ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 '.1G", " 1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- '1.1G", " 1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# '50.1G", "                                           1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- '.3G", " 1.00E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 '1.3G", " 1.00E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- '3.3G", " 1.00E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# '.50G", " 9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- '1.50G", " 9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 '3.50G", " 9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- '50.50G", " 9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# +'1g", "+1.00000e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- +'3g", "+1.00000e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 +'50g", "+00000000000000000000000000000000000001.00000e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- +'.0g", "+1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# +'3.0g", "+1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- +'50.0g", "+1.e+150                                          ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 +'.1g", "+1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- +'1.1g", "+1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# +'50.1g", "                                          +1.e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- +'.3g", "+1.00e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 +'1.3g", "+1.00e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- +'3.3g", "+1.00e+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# +'.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- +'1.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 +'3.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- +'50.50g", "+9.9999999999998998680313710784262953737076155396797e+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# +'1G", "+1.00000E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- +'3G", "+1.00000E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 +'50G", "+00000000000000000000000000000000000001.00000E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- +'.0G", "+1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# +'3.0G", "+1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- +'50.0G", "+1.E+150                                          ", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 +'.1G", "+1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- +'1.1G", "+1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# +'50.1G", "                                          +1.E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- +'.3G", "+1.00E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 +'1.3G", "+1.00E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- +'3.3G", "+1.00E+150", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%# +'.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#- +'1.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0 +'3.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%#0- +'50.50G", "+9.9999999999998998680313710784262953737076155396797E+149", { 120, 150, 80, 46, 53, 141, 19, 95 } },
    { "%'1g", "1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-'3g", "1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0'50g", "000000000000000000000000000000000000000000001e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-'.0g", "1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%'3.0g", "1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-'50.0g", "1e-150                                            ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0'.1g", "1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-'1.1g", "1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%'50.1g", "                                            1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-'.3g", "1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0'1.3g", "1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-'3.3g", "1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%'.50g", "9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-'1.50g", "9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0'3.50g", "9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-'50.50g", "9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%'1G", "1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-'3G", "1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0'50G", "000000000000000000000000000000000000000000001E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-'.0G", "1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%'3.0G", "1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-'50.0G", "1E-150                                            ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0'.1G", "1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-'1.1G", "1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%'50.1G", "                                            1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-'.3G", "1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0'1.3G", "1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-'3.3G", "1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%'.50G", "9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-'1.50G", "9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0'3.50G", "9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-'50.50G", "9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%+'1g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-+'3g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0+'50g", "+00000000000000000000000000000000000000000001e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-+'.0g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%+'3.0g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-+'50.0g", "+1e-150                                           ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0+'.1g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-+'1.1g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%+'50.1g", "                                           +1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-+'.3g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0+'1.3g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-+'3.3g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%+'.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-+'1.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0+'3.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-+'50.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%+'1G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-+'3G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0+'50G", "+00000000000000000000000000000000000000000001E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-+'.0G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%+'3.0G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-+'50.0G", "+1E-150                                           ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0+'.1G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-+'1.1G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%+'50.1G", "                                           +1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-+'.3G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0+'1.3G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-+'3.3G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%+'.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%-+'1.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0+'3.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0-+'50.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% '1g", " 1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- '3g", " 1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 '50g", " 00000000000000000000000000000000000000000001e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- '.0g", " 1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% '3.0g", " 1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- '50.0g", " 1e-150                                           ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 '.1g", " 1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- '1.1g", " 1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% '50.1g", "                                            1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- '.3g", " 1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 '1.3g", " 1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- '3.3g", " 1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% '.50g", " 9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- '1.50g", " 9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 '3.50g", " 9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- '50.50g", " 9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% '1G", " 1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- '3G", " 1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 '50G", " 00000000000000000000000000000000000000000001E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- '.0G", " 1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% '3.0G", " 1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- '50.0G", " 1E-150                                           ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 '.1G", " 1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- '1.1G", " 1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% '50.1G", "                                            1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- '.3G", " 1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 '1.3G", " 1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- '3.3G", " 1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% '.50G", " 9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- '1.50G", " 9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 '3.50G", " 9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- '50.50G", " 9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% +'1g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- +'3g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 +'50g", "+00000000000000000000000000000000000000000001e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- +'.0g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% +'3.0g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- +'50.0g", "+1e-150                                           ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 +'.1g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- +'1.1g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% +'50.1g", "                                           +1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- +'.3g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 +'1.3g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- +'3.3g", "+1e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% +'.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- +'1.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 +'3.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- +'50.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% +'1G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- +'3G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 +'50G", "+00000000000000000000000000000000000000000001E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- +'.0G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% +'3.0G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- +'50.0G", "+1E-150                                           ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 +'.1G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- +'1.1G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% +'50.1G", "                                           +1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- +'.3G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 +'1.3G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- +'3.3G", "+1E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "% +'.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%- +'1.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0 +'3.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%0- +'50.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#'1g", "1.00000e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-'3g", "1.00000e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0'50g", "000000000000000000000000000000000000001.00000e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-'.0g", "1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#'3.0g", "1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-'50.0g", "1.e-150                                           ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0'.1g", "1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-'1.1g", "1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#'50.1g", "                                           1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-'.3g", "1.00e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0'1.3g", "1.00e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-'3.3g", "1.00e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#'.50g", "9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-'1.50g", "9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0'3.50g", "9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-'50.50g", "9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#'1G", "1.00000E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-'3G", "1.00000E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0'50G", "000000000000000000000000000000000000001.00000E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-'.0G", "1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#'3.0G", "1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-'50.0G", "1.E-150                                           ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0'.1G", "1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-'1.1G", "1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#'50.1G", "                                           1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-'.3G", "1.00E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0'1.3G", "1.00E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-'3.3G", "1.00E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#'.50G", "9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-'1.50G", "9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0'3.50G", "9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-'50.50G", "9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#+'1g", "+1.00000e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-+'3g", "+1.00000e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0+'50g", "+00000000000000000000000000000000000001.00000e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-+'.0g", "+1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#+'3.0g", "+1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-+'50.0g", "+1.e-150                                          ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0+'.1g", "+1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-+'1.1g", "+1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#+'50.1g", "                                          +1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-+'.3g", "+1.00e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0+'1.3g", "+1.00e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-+'3.3g", "+1.00e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#+'.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-+'1.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0+'3.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-+'50.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#+'1G", "+1.00000E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-+'3G", "+1.00000E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0+'50G", "+00000000000000000000000000000000000001.00000E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-+'.0G", "+1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#+'3.0G", "+1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-+'50.0G", "+1.E-150                                          ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0+'.1G", "+1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-+'1.1G", "+1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#+'50.1G", "                                          +1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-+'.3G", "+1.00E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0+'1.3G", "+1.00E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-+'3.3G", "+1.00E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#+'.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#-+'1.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0+'3.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0-+'50.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# '1g", " 1.00000e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- '3g", " 1.00000e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 '50g", " 00000000000000000000000000000000000001.00000e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- '.0g", " 1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# '3.0g", " 1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- '50.0g", " 1.e-150                                          ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 '.1g", " 1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- '1.1g", " 1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# '50.1g", "                                           1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- '.3g", " 1.00e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 '1.3g", " 1.00e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- '3.3g", " 1.00e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# '.50g", " 9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- '1.50g", " 9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 '3.50g", " 9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- '50.50g", " 9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# '1G", " 1.00000E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- '3G", " 1.00000E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 '50G", " 00000000000000000000000000000000000001.00000E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- '.0G", " 1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# '3.0G", " 1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- '50.0G", " 1.E-150                                          ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 '.1G", " 1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- '1.1G", " 1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# '50.1G", "                                           1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- '.3G", " 1.00E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 '1.3G", " 1.00E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- '3.3G", " 1.00E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# '.50G", " 9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- '1.50G", " 9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 '3.50G", " 9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- '50.50G", " 9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# +'1g", "+1.00000e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- +'3g", "+1.00000e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 +'50g", "+00000000000000000000000000000000000001.00000e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- +'.0g", "+1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# +'3.0g", "+1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- +'50.0g", "+1.e-150                                          ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 +'.1g", "+1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- +'1.1g", "+1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# +'50.1g", "                                          +1.e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- +'.3g", "+1.00e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 +'1.3g", "+1.00e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- +'3.3g", "+1.00e-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# +'.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- +'1.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 +'3.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- +'50.50g", "+9.9999999999998996697971724732593184628359320226585e-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# +'1G", "+1.00000E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- +'3G", "+1.00000E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 +'50G", "+00000000000000000000000000000000000001.00000E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- +'.0G", "+1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# +'3.0G", "+1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- +'50.0G", "+1.E-150                                          ", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 +'.1G", "+1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- +'1.1G", "+1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# +'50.1G", "                                          +1.E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- +'.3G", "+1.00E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 +'1.3G", "+1.00E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- +'3.3G", "+1.00E-150", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%# +'.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#- +'1.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0 +'3.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%#0- +'50.50G", "+9.9999999999998996697971724732593184628359320226585E-151", { 43, 148, 63, 106, 231, 47, 202, 32 } },
    { "%'1g", "1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-'3g", "1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0'50g", "000000000000000000000000000000000000000000001e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-'.0g", "1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%'3.0g", "1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-'50.0g", "1e+200                                            ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0'.1g", "1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-'1.1g", "1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%'50.1g", "                                            1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-'.3g", "1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0'1.3g", "1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-'3.3g", "1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%'.50g", "9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-'1.50g", "9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0'3.50g", "9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-'50.50g", "9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%'1G", "1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-'3G", "1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0'50G", "000000000000000000000000000000000000000000001E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-'.0G", "1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%'3.0G", "1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-'50.0G", "1E+200                                            ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0'.1G", "1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-'1.1G", "1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%'50.1G", "                                            1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-'.3G", "1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0'1.3G", "1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-'3.3G", "1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%'.50G", "9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-'1.50G", "9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0'3.50G", "9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-'50.50G", "9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%+'1g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-+'3g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0+'50g", "+00000000000000000000000000000000000000000001e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-+'.0g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%+'3.0g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-+'50.0g", "+1e+200                                           ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0+'.1g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-+'1.1g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%+'50.1g", "                                           +1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-+'.3g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0+'1.3g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-+'3.3g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%+'.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-+'1.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0+'3.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-+'50.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%+'1G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-+'3G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0+'50G", "+00000000000000000000000000000000000000000001E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-+'.0G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%+'3.0G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-+'50.0G", "+1E+200                                           ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0+'.1G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-+'1.1G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%+'50.1G", "                                           +1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-+'.3G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0+'1.3G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-+'3.3G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%+'.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%-+'1.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0+'3.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0-+'50.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% '1g", " 1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- '3g", " 1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 '50g", " 00000000000000000000000000000000000000000001e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- '.0g", " 1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% '3.0g", " 1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- '50.0g", " 1e+200                                           ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 '.1g", " 1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- '1.1g", " 1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% '50.1g", "                                            1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- '.3g", " 1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 '1.3g", " 1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- '3.3g", " 1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% '.50g", " 9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- '1.50g", " 9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 '3.50g", " 9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- '50.50g", " 9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% '1G", " 1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- '3G", " 1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 '50G", " 00000000000000000000000000000000000000000001E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- '.0G", " 1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% '3.0G", " 1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- '50.0G", " 1E+200                                           ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 '.1G", " 1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- '1.1G", " 1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% '50.1G", "                                            1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- '.3G", " 1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 '1.3G", " 1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- '3.3G", " 1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% '.50G", " 9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- '1.50G", " 9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 '3.50G", " 9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- '50.50G", " 9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% +'1g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- +'3g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 +'50g", "+00000000000000000000000000000000000000000001e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- +'.0g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% +'3.0g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- +'50.0g", "+1e+200                                           ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 +'.1g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- +'1.1g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% +'50.1g", "                                           +1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- +'.3g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 +'1.3g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- +'3.3g", "+1e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% +'.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- +'1.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 +'3.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- +'50.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% +'1G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- +'3G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 +'50G", "+00000000000000000000000000000000000000000001E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- +'.0G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% +'3.0G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- +'50.0G", "+1E+200                                           ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 +'.1G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- +'1.1G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% +'50.1G", "                                           +1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- +'.3G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 +'1.3G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- +'3.3G", "+1E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "% +'.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%- +'1.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0 +'3.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%0- +'50.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#'1g", "1.00000e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-'3g", "1.00000e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0'50g", "000000000000000000000000000000000000001.00000e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-'.0g", "1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#'3.0g", "1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-'50.0g", "1.e+200                                           ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0'.1g", "1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-'1.1g", "1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#'50.1g", "                                           1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-'.3g", "1.00e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0'1.3g", "1.00e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-'3.3g", "1.00e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#'.50g", "9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-'1.50g", "9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0'3.50g", "9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-'50.50g", "9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#'1G", "1.00000E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-'3G", "1.00000E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0'50G", "000000000000000000000000000000000000001.00000E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-'.0G", "1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#'3.0G", "1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-'50.0G", "1.E+200                                           ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0'.1G", "1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-'1.1G", "1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#'50.1G", "                                           1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-'.3G", "1.00E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0'1.3G", "1.00E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-'3.3G", "1.00E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#'.50G", "9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-'1.50G", "9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0'3.50G", "9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-'50.50G", "9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#+'1g", "+1.00000e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-+'3g", "+1.00000e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0+'50g", "+00000000000000000000000000000000000001.00000e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-+'.0g", "+1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#+'3.0g", "+1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-+'50.0g", "+1.e+200                                          ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0+'.1g", "+1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-+'1.1g", "+1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#+'50.1g", "                                          +1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-+'.3g", "+1.00e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0+'1.3g", "+1.00e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-+'3.3g", "+1.00e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#+'.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-+'1.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0+'3.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-+'50.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#+'1G", "+1.00000E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-+'3G", "+1.00000E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0+'50G", "+00000000000000000000000000000000000001.00000E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-+'.0G", "+1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#+'3.0G", "+1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-+'50.0G", "+1.E+200                                          ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0+'.1G", "+1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-+'1.1G", "+1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#+'50.1G", "                                          +1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-+'.3G", "+1.00E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0+'1.3G", "+1.00E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-+'3.3G", "+1.00E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#+'.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#-+'1.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0+'3.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0-+'50.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# '1g", " 1.00000e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- '3g", " 1.00000e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 '50g", " 00000000000000000000000000000000000001.00000e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- '.0g", " 1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# '3.0g", " 1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- '50.0g", " 1.e+200                                          ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 '.1g", " 1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- '1.1g", " 1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# '50.1g", "                                           1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- '.3g", " 1.00e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 '1.3g", " 1.00e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- '3.3g", " 1.00e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# '.50g", " 9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- '1.50g", " 9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 '3.50g", " 9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- '50.50g", " 9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# '1G", " 1.00000E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- '3G", " 1.00000E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 '50G", " 00000000000000000000000000000000000001.00000E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- '.0G", " 1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# '3.0G", " 1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- '50.0G", " 1.E+200                                          ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 '.1G", " 1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- '1.1G", " 1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# '50.1G", "                                           1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- '.3G", " 1.00E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 '1.3G", " 1.00E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- '3.3G", " 1.00E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# '.50G", " 9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- '1.50G", " 9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 '3.50G", " 9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- '50.50G", " 9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# +'1g", "+1.00000e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- +'3g", "+1.00000e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 +'50g", "+00000000000000000000000000000000000001.00000e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- +'.0g", "+1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# +'3.0g", "+1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- +'50.0g", "+1.e+200                                          ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 +'.1g", "+1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- +'1.1g", "+1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# +'50.1g", "                                          +1.e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- +'.3g", "+1.00e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 +'1.3g", "+1.00e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- +'3.3g", "+1.00e+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# +'.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- +'1.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 +'3.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- +'50.50g", "+9.9999999999998994184781783194753840004916356484734e+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# +'1G", "+1.00000E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- +'3G", "+1.00000E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 +'50G", "+00000000000000000000000000000000000001.00000E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- +'.0G", "+1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# +'3.0G", "+1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- +'50.0G", "+1.E+200                                          ", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 +'.1G", "+1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- +'1.1G", "+1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# +'50.1G", "                                          +1.E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- +'.3G", "+1.00E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 +'1.3G", "+1.00E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- +'3.3G", "+1.00E+200", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%# +'.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#- +'1.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0 +'3.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%#0- +'50.50G", "+9.9999999999998994184781783194753840004916356484734E+199", { 31, 98, 215, 215, 24, 231, 116, 105 } },
    { "%'1g", "1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-'3g", "1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0'50g", "000000000000000000000000000000000000000000001e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-'.0g", "1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%'3.0g", "1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-'50.0g", "1e-200                                            ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0'.1g", "1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-'1.1g", "1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%'50.1g", "                                            1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-'.3g", "1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0'1.3g", "1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-'3.3g", "1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%'.50g", "9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-'1.50g", "9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0'3.50g", "9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-'50.50g", "9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%'1G", "1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-'3G", "1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0'50G", "000000000000000000000000000000000000000000001E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-'.0G", "1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%'3.0G", "1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-'50.0G", "1E-200                                            ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0'.1G", "1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-'1.1G", "1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%'50.1G", "                                            1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-'.3G", "1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0'1.3G", "1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-'3.3G", "1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%'.50G", "9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-'1.50G", "9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0'3.50G", "9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-'50.50G", "9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%+'1g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-+'3g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0+'50g", "+00000000000000000000000000000000000000000001e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-+'.0g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%+'3.0g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-+'50.0g", "+1e-200                                           ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0+'.1g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-+'1.1g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%+'50.1g", "                                           +1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-+'.3g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0+'1.3g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-+'3.3g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%+'.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-+'1.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0+'3.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-+'50.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%+'1G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-+'3G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0+'50G", "+00000000000000000000000000000000000000000001E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-+'.0G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%+'3.0G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-+'50.0G", "+1E-200                                           ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0+'.1G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-+'1.1G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%+'50.1G", "                                           +1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-+'.3G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0+'1.3G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-+'3.3G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%+'.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%-+'1.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0+'3.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0-+'50.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% '1g", " 1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- '3g", " 1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 '50g", " 00000000000000000000000000000000000000000001e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- '.0g", " 1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% '3.0g", " 1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- '50.0g", " 1e-200                                           ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 '.1g", " 1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- '1.1g", " 1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% '50.1g", "                                            1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- '.3g", " 1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 '1.3g", " 1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- '3.3g", " 1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% '.50g", " 9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- '1.50g", " 9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 '3.50g", " 9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- '50.50g", " 9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% '1G", " 1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- '3G", " 1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 '50G", " 00000000000000000000000000000000000000000001E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- '.0G", " 1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% '3.0G", " 1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- '50.0G", " 1E-200                                           ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 '.1G", " 1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- '1.1G", " 1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% '50.1G", "                                            1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- '.3G", " 1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 '1.3G", " 1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- '3.3G", " 1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% '.50G", " 9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- '1.50G", " 9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 '3.50G", " 9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- '50.50G", " 9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% +'1g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- +'3g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 +'50g", "+00000000000000000000000000000000000000000001e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- +'.0g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% +'3.0g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- +'50.0g", "+1e-200                                           ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 +'.1g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- +'1.1g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% +'50.1g", "                                           +1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- +'.3g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 +'1.3g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- +'3.3g", "+1e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% +'.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- +'1.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 +'3.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- +'50.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% +'1G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- +'3G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 +'50G", "+00000000000000000000000000000000000000000001E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- +'.0G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% +'3.0G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- +'50.0G", "+1E-200                                           ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 +'.1G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- +'1.1G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% +'50.1G", "                                           +1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- +'.3G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 +'1.3G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- +'3.3G", "+1E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "% +'.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%- +'1.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0 +'3.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%0- +'50.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#'1g", "1.00000e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-'3g", "1.00000e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0'50g", "000000000000000000000000000000000000001.00000e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-'.0g", "1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#'3.0g", "1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-'50.0g", "1.e-200                                           ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0'.1g", "1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-'1.1g", "1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#'50.1g", "                                           1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-'.3g", "1.00e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0'1.3g", "1.00e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-'3.3g", "1.00e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#'.50g", "9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-'1.50g", "9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0'3.50g", "9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-'50.50g", "9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#'1G", "1.00000E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-'3G", "1.00000E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0'50G", "000000000000000000000000000000000000001.00000E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-'.0G", "1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#'3.0G", "1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-'50.0G", "1.E-200                                           ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0'.1G", "1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-'1.1G", "1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#'50.1G", "                                           1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-'.3G", "1.00E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0'1.3G", "1.00E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-'3.3G", "1.00E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#'.50G", "9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-'1.50G", "9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0'3.50G", "9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-'50.50G", "9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#+'1g", "+1.00000e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-+'3g", "+1.00000e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0+'50g", "+00000000000000000000000000000000000001.00000e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-+'.0g", "+1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#+'3.0g", "+1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-+'50.0g", "+1.e-200                                          ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0+'.1g", "+1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-+'1.1g", "+1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#+'50.1g", "                                          +1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-+'.3g", "+1.00e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0+'1.3g", "+1.00e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-+'3.3g", "+1.00e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#+'.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-+'1.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0+'3.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-+'50.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#+'1G", "+1.00000E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-+'3G", "+1.00000E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0+'50G", "+00000000000000000000000000000000000001.00000E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-+'.0G", "+1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#+'3.0G", "+1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-+'50.0G", "+1.E-200                                          ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0+'.1G", "+1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-+'1.1G", "+1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#+'50.1G", "                                          +1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-+'.3G", "+1.00E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0+'1.3G", "+1.00E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-+'3.3G", "+1.00E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#+'.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#-+'1.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0+'3.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0-+'50.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# '1g", " 1.00000e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- '3g", " 1.00000e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 '50g", " 00000000000000000000000000000000000001.00000e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- '.0g", " 1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# '3.0g", " 1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- '50.0g", " 1.e-200                                          ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 '.1g", " 1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- '1.1g", " 1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# '50.1g", "                                           1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- '.3g", " 1.00e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 '1.3g", " 1.00e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- '3.3g", " 1.00e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# '.50g", " 9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- '1.50g", " 9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 '3.50g", " 9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- '50.50g", " 9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# '1G", " 1.00000E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- '3G", " 1.00000E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 '50G", " 00000000000000000000000000000000000001.00000E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- '.0G", " 1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# '3.0G", " 1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- '50.0G", " 1.E-200                                          ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 '.1G", " 1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- '1.1G", " 1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# '50.1G", "                                           1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- '.3G", " 1.00E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 '1.3G", " 1.00E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- '3.3G", " 1.00E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# '.50G", " 9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- '1.50G", " 9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 '3.50G", " 9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- '50.50G", " 9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# +'1g", "+1.00000e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- +'3g", "+1.00000e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 +'50g", "+00000000000000000000000000000000000001.00000e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- +'.0g", "+1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# +'3.0g", "+1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- +'50.0g", "+1.e-200                                          ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 +'.1g", "+1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- +'1.1g", "+1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# +'50.1g", "                                          +1.e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- +'.3g", "+1.00e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 +'1.3g", "+1.00e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- +'3.3g", "+1.00e-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# +'.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- +'1.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 +'3.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- +'50.50g", "+9.9999999999998997421771888360822479533450192126953e-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# +'1G", "+1.00000E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- +'3G", "+1.00000E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 +'50G", "+00000000000000000000000000000000000001.00000E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- +'.0G", "+1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# +'3.0G", "+1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- +'50.0G", "+1.E-200                                          ", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 +'.1G", "+1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- +'1.1G", "+1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# +'50.1G", "                                          +1.E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- +'.3G", "+1.00E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 +'1.3G", "+1.00E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- +'3.3G", "+1.00E-200", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%# +'.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#- +'1.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0 +'3.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%#0- +'50.50G", "+9.9999999999998997421771888360822479533450192126953E-201", { 103, 247, 78, 21, 146, 126, 104, 22 } },
    { "%'1g", "1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-'3g", "1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0'50g", "000000000000000000000000000000000000001.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-'.0g", "2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%'3.0g", "2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-'50.0g", "2e+308                                            ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0'.1g", "2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-'1.1g", "2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%'50.1g", "                                            2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-'.3g", "1.8e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0'1.3g", "1.8e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-'3.3g", "1.8e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%'.50g", "1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-'1.50g", "1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0'3.50g", "1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-'50.50g", "1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%'1G", "1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-'3G", "1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0'50G", "000000000000000000000000000000000000001.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-'.0G", "2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%'3.0G", "2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-'50.0G", "2E+308                                            ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0'.1G", "2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-'1.1G", "2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%'50.1G", "                                            2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-'.3G", "1.8E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0'1.3G", "1.8E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-'3.3G", "1.8E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%'.50G", "1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-'1.50G", "1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0'3.50G", "1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-'50.50G", "1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%+'1g", "+1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-+'3g", "+1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0+'50g", "+00000000000000000000000000000000000001.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-+'.0g", "+2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%+'3.0g", "+2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-+'50.0g", "+2e+308                                           ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0+'.1g", "+2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-+'1.1g", "+2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%+'50.1g", "                                           +2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-+'.3g", "+1.8e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0+'1.3g", "+1.8e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-+'3.3g", "+1.8e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%+'.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-+'1.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0+'3.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-+'50.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%+'1G", "+1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-+'3G", "+1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0+'50G", "+00000000000000000000000000000000000001.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-+'.0G", "+2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%+'3.0G", "+2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-+'50.0G", "+2E+308                                           ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0+'.1G", "+2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-+'1.1G", "+2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%+'50.1G", "                                           +2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-+'.3G", "+1.8E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0+'1.3G", "+1.8E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-+'3.3G", "+1.8E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%+'.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%-+'1.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0+'3.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0-+'50.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% '1g", " 1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- '3g", " 1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 '50g", " 00000000000000000000000000000000000001.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- '.0g", " 2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% '3.0g", " 2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- '50.0g", " 2e+308                                           ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 '.1g", " 2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- '1.1g", " 2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% '50.1g", "                                            2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- '.3g", " 1.8e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 '1.3g", " 1.8e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- '3.3g", " 1.8e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% '.50g", " 1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- '1.50g", " 1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 '3.50g", " 1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- '50.50g", " 1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% '1G", " 1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- '3G", " 1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 '50G", " 00000000000000000000000000000000000001.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- '.0G", " 2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% '3.0G", " 2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- '50.0G", " 2E+308                                           ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 '.1G", " 2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- '1.1G", " 2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% '50.1G", "                                            2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- '.3G", " 1.8E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 '1.3G", " 1.8E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- '3.3G", " 1.8E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% '.50G", " 1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- '1.50G", " 1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 '3.50G", " 1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- '50.50G", " 1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% +'1g", "+1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- +'3g", "+1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 +'50g", "+00000000000000000000000000000000000001.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- +'.0g", "+2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% +'3.0g", "+2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- +'50.0g", "+2e+308                                           ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 +'.1g", "+2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- +'1.1g", "+2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% +'50.1g", "                                           +2e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- +'.3g", "+1.8e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 +'1.3g", "+1.8e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- +'3.3g", "+1.8e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% +'.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- +'1.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 +'3.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- +'50.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% +'1G", "+1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- +'3G", "+1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 +'50G", "+00000000000000000000000000000000000001.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- +'.0G", "+2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% +'3.0G", "+2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- +'50.0G", "+2E+308                                           ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 +'.1G", "+2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- +'1.1G", "+2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% +'50.1G", "                                           +2E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- +'.3G", "+1.8E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 +'1.3G", "+1.8E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- +'3.3G", "+1.8E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "% +'.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%- +'1.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0 +'3.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%0- +'50.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#'1g", "1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-'3g", "1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0'50g", "000000000000000000000000000000000000001.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-'.0g", "2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#'3.0g", "2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-'50.0g", "2.e+308                                           ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0'.1g", "2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-'1.1g", "2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#'50.1g", "                                           2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-'.3g", "1.80e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0'1.3g", "1.80e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-'3.3g", "1.80e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#'.50g", "1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-'1.50g", "1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0'3.50g", "1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-'50.50g", "1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#'1G", "1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-'3G", "1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0'50G", "000000000000000000000000000000000000001.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-'.0G", "2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#'3.0G", "2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-'50.0G", "2.E+308                                           ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0'.1G", "2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-'1.1G", "2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#'50.1G", "                                           2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-'.3G", "1.80E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0'1.3G", "1.80E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-'3.3G", "1.80E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#'.50G", "1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-'1.50G", "1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0'3.50G", "1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-'50.50G", "1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#+'1g", "+1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-+'3g", "+1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0+'50g", "+00000000000000000000000000000000000001.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-+'.0g", "+2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#+'3.0g", "+2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-+'50.0g", "+2.e+308                                          ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0+'.1g", "+2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-+'1.1g", "+2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#+'50.1g", "                                          +2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-+'.3g", "+1.80e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0+'1.3g", "+1.80e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-+'3.3g", "+1.80e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#+'.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-+'1.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0+'3.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-+'50.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#+'1G", "+1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-+'3G", "+1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0+'50G", "+00000000000000000000000000000000000001.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-+'.0G", "+2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#+'3.0G", "+2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-+'50.0G", "+2.E+308                                          ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0+'.1G", "+2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-+'1.1G", "+2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#+'50.1G", "                                          +2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-+'.3G", "+1.80E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0+'1.3G", "+1.80E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-+'3.3G", "+1.80E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#+'.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#-+'1.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0+'3.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0-+'50.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# '1g", " 1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- '3g", " 1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 '50g", " 00000000000000000000000000000000000001.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- '.0g", " 2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# '3.0g", " 2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- '50.0g", " 2.e+308                                          ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 '.1g", " 2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- '1.1g", " 2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# '50.1g", "                                           2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- '.3g", " 1.80e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 '1.3g", " 1.80e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- '3.3g", " 1.80e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# '.50g", " 1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- '1.50g", " 1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 '3.50g", " 1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- '50.50g", " 1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# '1G", " 1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- '3G", " 1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 '50G", " 00000000000000000000000000000000000001.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- '.0G", " 2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# '3.0G", " 2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- '50.0G", " 2.E+308                                          ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 '.1G", " 2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- '1.1G", " 2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# '50.1G", "                                           2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- '.3G", " 1.80E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 '1.3G", " 1.80E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- '3.3G", " 1.80E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# '.50G", " 1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- '1.50G", " 1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 '3.50G", " 1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- '50.50G", " 1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# +'1g", "+1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- +'3g", "+1.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 +'50g", "+00000000000000000000000000000000000001.79769e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- +'.0g", "+2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# +'3.0g", "+2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- +'50.0g", "+2.e+308                                          ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 +'.1g", "+2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- +'1.1g", "+2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# +'50.1g", "                                          +2.e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- +'.3g", "+1.80e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 +'1.3g", "+1.80e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- +'3.3g", "+1.80e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# +'.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- +'1.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 +'3.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- +'50.50g", "+1.7976931348623157081452742373170435679807056752584e+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# +'1G", "+1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- +'3G", "+1.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 +'50G", "+00000000000000000000000000000000000001.79769E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- +'.0G", "+2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# +'3.0G", "+2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- +'50.0G", "+2.E+308                                          ", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 +'.1G", "+2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- +'1.1G", "+2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# +'50.1G", "                                          +2.E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- +'.3G", "+1.80E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 +'1.3G", "+1.80E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- +'3.3G", "+1.80E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%# +'.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#- +'1.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0 +'3.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%#0- +'50.50G", "+1.7976931348623157081452742373170435679807056752584E+308", { 255, 255, 255, 255, 255, 255, 239, 127 } },
    { "%'1g", "3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-'3g", "3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0'50g", "0000000000000000000000000000000000000003.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-'.0g", "3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%'3.0g", "3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-'50.0g", "3e+38                                             ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0'.1g", "3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-'1.1g", "3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%'50.1g", "                                             3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-'.3g", "3.4e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0'1.3g", "3.4e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-'3.3g", "3.4e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%'.50g", "340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-'1.50g", "340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0'3.50g", "340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-'50.50g", "340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%'1G", "3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-'3G", "3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0'50G", "0000000000000000000000000000000000000003.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-'.0G", "3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%'3.0G", "3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-'50.0G", "3E+38                                             ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0'.1G", "3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-'1.1G", "3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%'50.1G", "                                             3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-'.3G", "3.4E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0'1.3G", "3.4E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-'3.3G", "3.4E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%'.50G", "340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-'1.50G", "340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0'3.50G", "340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-'50.50G", "340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%+'1g", "+3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-+'3g", "+3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0+'50g", "+000000000000000000000000000000000000003.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-+'.0g", "+3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%+'3.0g", "+3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-+'50.0g", "+3e+38                                            ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0+'.1g", "+3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-+'1.1g", "+3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%+'50.1g", "                                            +3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-+'.3g", "+3.4e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0+'1.3g", "+3.4e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-+'3.3g", "+3.4e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%+'.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-+'1.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0+'3.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-+'50.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%+'1G", "+3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-+'3G", "+3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0+'50G", "+000000000000000000000000000000000000003.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-+'.0G", "+3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%+'3.0G", "+3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-+'50.0G", "+3E+38                                            ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0+'.1G", "+3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-+'1.1G", "+3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%+'50.1G", "                                            +3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-+'.3G", "+3.4E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0+'1.3G", "+3.4E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-+'3.3G", "+3.4E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%+'.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%-+'1.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0+'3.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0-+'50.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% '1g", " 3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- '3g", " 3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 '50g", " 000000000000000000000000000000000000003.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- '.0g", " 3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% '3.0g", " 3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- '50.0g", " 3e+38                                            ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 '.1g", " 3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- '1.1g", " 3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% '50.1g", "                                             3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- '.3g", " 3.4e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 '1.3g", " 3.4e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- '3.3g", " 3.4e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% '.50g", " 340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- '1.50g", " 340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 '3.50g", " 340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- '50.50g", " 340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% '1G", " 3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- '3G", " 3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 '50G", " 000000000000000000000000000000000000003.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- '.0G", " 3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% '3.0G", " 3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- '50.0G", " 3E+38                                            ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 '.1G", " 3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- '1.1G", " 3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% '50.1G", "                                             3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- '.3G", " 3.4E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 '1.3G", " 3.4E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- '3.3G", " 3.4E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% '.50G", " 340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- '1.50G", " 340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 '3.50G", " 340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- '50.50G", " 340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% +'1g", "+3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- +'3g", "+3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 +'50g", "+000000000000000000000000000000000000003.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- +'.0g", "+3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% +'3.0g", "+3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- +'50.0g", "+3e+38                                            ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 +'.1g", "+3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- +'1.1g", "+3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% +'50.1g", "                                            +3e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- +'.3g", "+3.4e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 +'1.3g", "+3.4e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- +'3.3g", "+3.4e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% +'.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- +'1.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 +'3.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- +'50.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% +'1G", "+3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- +'3G", "+3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 +'50G", "+000000000000000000000000000000000000003.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- +'.0G", "+3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% +'3.0G", "+3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- +'50.0G", "+3E+38                                            ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 +'.1G", "+3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- +'1.1G", "+3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% +'50.1G", "                                            +3E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- +'.3G", "+3.4E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 +'1.3G", "+3.4E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- +'3.3G", "+3.4E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "% +'.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%- +'1.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0 +'3.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%0- +'50.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#'1g", "3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-'3g", "3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0'50g", "0000000000000000000000000000000000000003.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-'.0g", "3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#'3.0g", "3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-'50.0g", "3.e+38                                            ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0'.1g", "3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-'1.1g", "3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#'50.1g", "                                            3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-'.3g", "3.40e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0'1.3g", "3.40e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-'3.3g", "3.40e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#'.50g", "340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-'1.50g", "340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0'3.50g", "340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-'50.50g", "340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#'1G", "3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-'3G", "3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0'50G", "0000000000000000000000000000000000000003.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-'.0G", "3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#'3.0G", "3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-'50.0G", "3.E+38                                            ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0'.1G", "3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-'1.1G", "3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#'50.1G", "                                            3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-'.3G", "3.40E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0'1.3G", "3.40E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-'3.3G", "3.40E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#'.50G", "340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-'1.50G", "340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0'3.50G", "340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-'50.50G", "340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#+'1g", "+3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-+'3g", "+3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0+'50g", "+000000000000000000000000000000000000003.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-+'.0g", "+3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#+'3.0g", "+3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-+'50.0g", "+3.e+38                                           ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0+'.1g", "+3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-+'1.1g", "+3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#+'50.1g", "                                           +3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-+'.3g", "+3.40e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0+'1.3g", "+3.40e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-+'3.3g", "+3.40e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#+'.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-+'1.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0+'3.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-+'50.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#+'1G", "+3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-+'3G", "+3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0+'50G", "+000000000000000000000000000000000000003.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-+'.0G", "+3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#+'3.0G", "+3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-+'50.0G", "+3.E+38                                           ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0+'.1G", "+3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-+'1.1G", "+3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#+'50.1G", "                                           +3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-+'.3G", "+3.40E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0+'1.3G", "+3.40E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-+'3.3G", "+3.40E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#+'.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#-+'1.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0+'3.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0-+'50.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# '1g", " 3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- '3g", " 3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 '50g", " 000000000000000000000000000000000000003.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- '.0g", " 3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# '3.0g", " 3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- '50.0g", " 3.e+38                                           ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 '.1g", " 3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- '1.1g", " 3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# '50.1g", "                                            3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- '.3g", " 3.40e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 '1.3g", " 3.40e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- '3.3g", " 3.40e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# '.50g", " 340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- '1.50g", " 340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 '3.50g", " 340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- '50.50g", " 340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# '1G", " 3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- '3G", " 3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 '50G", " 000000000000000000000000000000000000003.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- '.0G", " 3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# '3.0G", " 3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- '50.0G", " 3.E+38                                           ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 '.1G", " 3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- '1.1G", " 3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# '50.1G", "                                            3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- '.3G", " 3.40E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 '1.3G", " 3.40E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- '3.3G", " 3.40E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# '.50G", " 340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- '1.50G", " 340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 '3.50G", " 340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- '50.50G", " 340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# +'1g", "+3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- +'3g", "+3.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000003.40282e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- +'.0g", "+3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# +'3.0g", "+3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- +'50.0g", "+3.e+38                                           ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 +'.1g", "+3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- +'1.1g", "+3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# +'50.1g", "                                           +3.e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- +'.3g", "+3.40e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 +'1.3g", "+3.40e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- +'3.3g", "+3.40e+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# +'.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- +'1.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 +'3.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- +'50.50g", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# +'1G", "+3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- +'3G", "+3.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000003.40282E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- +'.0G", "+3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# +'3.0G", "+3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- +'50.0G", "+3.E+38                                           ", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 +'.1G", "+3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- +'1.1G", "+3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# +'50.1G", "                                           +3.E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- +'.3G", "+3.40E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 +'1.3G", "+3.40E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- +'3.3G", "+3.40E+38", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%# +'.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#- +'1.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0 +'3.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%#0- +'50.50G", "+340,282,346,638,528,859,811,704,183,484,516,925,440.00000000000", { 0, 0, 0, 224, 255, 255, 239, 71 } },
    { "%'1g", "2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-'3g", "2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0'50g", "0000000000000000000000000000000000000002.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-'.0g", "2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%'3.0g", "2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-'50.0g", "2e-16                                             ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0'.1g", "2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-'1.1g", "2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%'50.1g", "                                             2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-'.3g", "2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0'1.3g", "2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-'3.3g", "2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%'.50g", "2.220446049250313080847263336181640625e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-'1.50g", "2.220446049250313080847263336181640625e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0'3.50g", "2.220446049250313080847263336181640625e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-'50.50g", "2.220446049250313080847263336181640625e-16        ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%'1G", "2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-'3G", "2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0'50G", "0000000000000000000000000000000000000002.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-'.0G", "2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%'3.0G", "2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-'50.0G", "2E-16                                             ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0'.1G", "2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-'1.1G", "2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%'50.1G", "                                             2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-'.3G", "2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0'1.3G", "2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-'3.3G", "2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%'.50G", "2.220446049250313080847263336181640625E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-'1.50G", "2.220446049250313080847263336181640625E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0'3.50G", "2.220446049250313080847263336181640625E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-'50.50G", "2.220446049250313080847263336181640625E-16        ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%+'1g", "+2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-+'3g", "+2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0+'50g", "+000000000000000000000000000000000000002.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-+'.0g", "+2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%+'3.0g", "+2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-+'50.0g", "+2e-16                                            ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0+'.1g", "+2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-+'1.1g", "+2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%+'50.1g", "                                            +2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-+'.3g", "+2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0+'1.3g", "+2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-+'3.3g", "+2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%+'.50g", "+2.220446049250313080847263336181640625e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-+'1.50g", "+2.220446049250313080847263336181640625e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0+'3.50g", "+2.220446049250313080847263336181640625e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-+'50.50g", "+2.220446049250313080847263336181640625e-16       ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%+'1G", "+2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-+'3G", "+2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0+'50G", "+000000000000000000000000000000000000002.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-+'.0G", "+2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%+'3.0G", "+2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-+'50.0G", "+2E-16                                            ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0+'.1G", "+2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-+'1.1G", "+2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%+'50.1G", "                                            +2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-+'.3G", "+2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0+'1.3G", "+2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-+'3.3G", "+2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%+'.50G", "+2.220446049250313080847263336181640625E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%-+'1.50G", "+2.220446049250313080847263336181640625E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0+'3.50G", "+2.220446049250313080847263336181640625E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0-+'50.50G", "+2.220446049250313080847263336181640625E-16       ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% '1g", " 2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- '3g", " 2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 '50g", " 000000000000000000000000000000000000002.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- '.0g", " 2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% '3.0g", " 2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- '50.0g", " 2e-16                                            ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 '.1g", " 2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- '1.1g", " 2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% '50.1g", "                                             2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- '.3g", " 2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 '1.3g", " 2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- '3.3g", " 2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% '.50g", " 2.220446049250313080847263336181640625e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- '1.50g", " 2.220446049250313080847263336181640625e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 '3.50g", " 2.220446049250313080847263336181640625e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- '50.50g", " 2.220446049250313080847263336181640625e-16       ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% '1G", " 2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- '3G", " 2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 '50G", " 000000000000000000000000000000000000002.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- '.0G", " 2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% '3.0G", " 2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- '50.0G", " 2E-16                                            ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 '.1G", " 2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- '1.1G", " 2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% '50.1G", "                                             2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- '.3G", " 2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 '1.3G", " 2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- '3.3G", " 2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% '.50G", " 2.220446049250313080847263336181640625E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- '1.50G", " 2.220446049250313080847263336181640625E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 '3.50G", " 2.220446049250313080847263336181640625E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- '50.50G", " 2.220446049250313080847263336181640625E-16       ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% +'1g", "+2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- +'3g", "+2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 +'50g", "+000000000000000000000000000000000000002.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- +'.0g", "+2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% +'3.0g", "+2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- +'50.0g", "+2e-16                                            ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 +'.1g", "+2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- +'1.1g", "+2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% +'50.1g", "                                            +2e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- +'.3g", "+2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 +'1.3g", "+2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- +'3.3g", "+2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% +'.50g", "+2.220446049250313080847263336181640625e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- +'1.50g", "+2.220446049250313080847263336181640625e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 +'3.50g", "+2.220446049250313080847263336181640625e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- +'50.50g", "+2.220446049250313080847263336181640625e-16       ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% +'1G", "+2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- +'3G", "+2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 +'50G", "+000000000000000000000000000000000000002.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- +'.0G", "+2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% +'3.0G", "+2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- +'50.0G", "+2E-16                                            ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 +'.1G", "+2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- +'1.1G", "+2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% +'50.1G", "                                            +2E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- +'.3G", "+2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 +'1.3G", "+2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- +'3.3G", "+2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "% +'.50G", "+2.220446049250313080847263336181640625E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%- +'1.50G", "+2.220446049250313080847263336181640625E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0 +'3.50G", "+2.220446049250313080847263336181640625E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%0- +'50.50G", "+2.220446049250313080847263336181640625E-16       ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#'1g", "2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-'3g", "2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0'50g", "0000000000000000000000000000000000000002.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-'.0g", "2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#'3.0g", "2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-'50.0g", "2.e-16                                            ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0'.1g", "2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-'1.1g", "2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#'50.1g", "                                            2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-'.3g", "2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0'1.3g", "2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-'3.3g", "2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#'.50g", "2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-'1.50g", "2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0'3.50g", "2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-'50.50g", "2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#'1G", "2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-'3G", "2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0'50G", "0000000000000000000000000000000000000002.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-'.0G", "2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#'3.0G", "2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-'50.0G", "2.E-16                                            ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0'.1G", "2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-'1.1G", "2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#'50.1G", "                                            2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-'.3G", "2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0'1.3G", "2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-'3.3G", "2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#'.50G", "2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-'1.50G", "2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0'3.50G", "2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-'50.50G", "2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#+'1g", "+2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-+'3g", "+2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0+'50g", "+000000000000000000000000000000000000002.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-+'.0g", "+2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#+'3.0g", "+2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-+'50.0g", "+2.e-16                                           ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0+'.1g", "+2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-+'1.1g", "+2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#+'50.1g", "                                           +2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-+'.3g", "+2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0+'1.3g", "+2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-+'3.3g", "+2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#+'.50g", "+2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-+'1.50g", "+2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0+'3.50g", "+2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-+'50.50g", "+2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#+'1G", "+2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-+'3G", "+2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0+'50G", "+000000000000000000000000000000000000002.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-+'.0G", "+2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#+'3.0G", "+2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-+'50.0G", "+2.E-16                                           ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0+'.1G", "+2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-+'1.1G", "+2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#+'50.1G", "                                           +2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-+'.3G", "+2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0+'1.3G", "+2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-+'3.3G", "+2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#+'.50G", "+2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#-+'1.50G", "+2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0+'3.50G", "+2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0-+'50.50G", "+2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# '1g", " 2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- '3g", " 2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 '50g", " 000000000000000000000000000000000000002.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- '.0g", " 2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# '3.0g", " 2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- '50.0g", " 2.e-16                                           ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 '.1g", " 2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- '1.1g", " 2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# '50.1g", "                                            2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- '.3g", " 2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 '1.3g", " 2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- '3.3g", " 2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# '.50g", " 2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- '1.50g", " 2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 '3.50g", " 2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- '50.50g", " 2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# '1G", " 2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- '3G", " 2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 '50G", " 000000000000000000000000000000000000002.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- '.0G", " 2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# '3.0G", " 2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- '50.0G", " 2.E-16                                           ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 '.1G", " 2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- '1.1G", " 2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# '50.1G", "                                            2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- '.3G", " 2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 '1.3G", " 2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- '3.3G", " 2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# '.50G", " 2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- '1.50G", " 2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 '3.50G", " 2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- '50.50G", " 2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# +'1g", "+2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- +'3g", "+2.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000002.22045e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- +'.0g", "+2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# +'3.0g", "+2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- +'50.0g", "+2.e-16                                           ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 +'.1g", "+2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- +'1.1g", "+2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# +'50.1g", "                                           +2.e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- +'.3g", "+2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 +'1.3g", "+2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- +'3.3g", "+2.22e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# +'.50g", "+2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- +'1.50g", "+2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 +'3.50g", "+2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- +'50.50g", "+2.2204460492503130808472633361816406250000000000000e-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# +'1G", "+2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- +'3G", "+2.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000002.22045E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- +'.0G", "+2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# +'3.0G", "+2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- +'50.0G", "+2.E-16                                           ", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 +'.1G", "+2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- +'1.1G", "+2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# +'50.1G", "                                           +2.E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- +'.3G", "+2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 +'1.3G", "+2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- +'3.3G", "+2.22E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%# +'.50G", "+2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#- +'1.50G", "+2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0 +'3.50G", "+2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%#0- +'50.50G", "+2.2204460492503130808472633361816406250000000000000E-16", { 0, 0, 0, 0, 0, 0, 176, 60 } },
    { "%'1g", "2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-'3g", "2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0'50g", "000000000000000000000000000000000000002.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-'.0g", "2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%'3.0g", "2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-'50.0g", "2e-308                                            ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0'.1g", "2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-'1.1g", "2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%'50.1g", "                                            2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-'.3g", "2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0'1.3g", "2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-'3.3g", "2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%'.50g", "2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-'1.50g", "2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0'3.50g", "2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-'50.50g", "2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%'1G", "2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-'3G", "2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0'50G", "000000000000000000000000000000000000002.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-'.0G", "2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%'3.0G", "2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-'50.0G", "2E-308                                            ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0'.1G", "2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-'1.1G", "2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%'50.1G", "                                            2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-'.3G", "2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0'1.3G", "2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-'3.3G", "2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%'.50G", "2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-'1.50G", "2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0'3.50G", "2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-'50.50G", "2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%+'1g", "+2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-+'3g", "+2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0+'50g", "+00000000000000000000000000000000000002.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-+'.0g", "+2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%+'3.0g", "+2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-+'50.0g", "+2e-308                                           ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0+'.1g", "+2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-+'1.1g", "+2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%+'50.1g", "                                           +2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-+'.3g", "+2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0+'1.3g", "+2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-+'3.3g", "+2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%+'.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-+'1.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0+'3.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-+'50.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%+'1G", "+2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-+'3G", "+2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0+'50G", "+00000000000000000000000000000000000002.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-+'.0G", "+2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%+'3.0G", "+2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-+'50.0G", "+2E-308                                           ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0+'.1G", "+2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-+'1.1G", "+2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%+'50.1G", "                                           +2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-+'.3G", "+2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0+'1.3G", "+2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-+'3.3G", "+2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%+'.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%-+'1.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0+'3.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0-+'50.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% '1g", " 2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- '3g", " 2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 '50g", " 00000000000000000000000000000000000002.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- '.0g", " 2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% '3.0g", " 2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- '50.0g", " 2e-308                                           ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 '.1g", " 2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- '1.1g", " 2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% '50.1g", "                                            2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- '.3g", " 2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 '1.3g", " 2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- '3.3g", " 2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% '.50g", " 2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- '1.50g", " 2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 '3.50g", " 2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- '50.50g", " 2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% '1G", " 2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- '3G", " 2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 '50G", " 00000000000000000000000000000000000002.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- '.0G", " 2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% '3.0G", " 2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- '50.0G", " 2E-308                                           ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 '.1G", " 2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- '1.1G", " 2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% '50.1G", "                                            2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- '.3G", " 2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 '1.3G", " 2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- '3.3G", " 2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% '.50G", " 2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- '1.50G", " 2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 '3.50G", " 2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- '50.50G", " 2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% +'1g", "+2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- +'3g", "+2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 +'50g", "+00000000000000000000000000000000000002.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- +'.0g", "+2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% +'3.0g", "+2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- +'50.0g", "+2e-308                                           ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 +'.1g", "+2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- +'1.1g", "+2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% +'50.1g", "                                           +2e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- +'.3g", "+2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 +'1.3g", "+2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- +'3.3g", "+2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% +'.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- +'1.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 +'3.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- +'50.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% +'1G", "+2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- +'3G", "+2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 +'50G", "+00000000000000000000000000000000000002.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- +'.0G", "+2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% +'3.0G", "+2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- +'50.0G", "+2E-308                                           ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 +'.1G", "+2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- +'1.1G", "+2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% +'50.1G", "                                           +2E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- +'.3G", "+2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 +'1.3G", "+2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- +'3.3G", "+2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "% +'.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%- +'1.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0 +'3.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%0- +'50.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#'1g", "2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-'3g", "2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0'50g", "000000000000000000000000000000000000002.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-'.0g", "2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#'3.0g", "2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-'50.0g", "2.e-308                                           ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0'.1g", "2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-'1.1g", "2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#'50.1g", "                                           2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-'.3g", "2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0'1.3g", "2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-'3.3g", "2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#'.50g", "2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-'1.50g", "2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0'3.50g", "2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-'50.50g", "2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#'1G", "2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-'3G", "2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0'50G", "000000000000000000000000000000000000002.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-'.0G", "2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#'3.0G", "2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-'50.0G", "2.E-308                                           ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0'.1G", "2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-'1.1G", "2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#'50.1G", "                                           2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-'.3G", "2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0'1.3G", "2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-'3.3G", "2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#'.50G", "2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-'1.50G", "2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0'3.50G", "2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-'50.50G", "2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#+'1g", "+2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-+'3g", "+2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0+'50g", "+00000000000000000000000000000000000002.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-+'.0g", "+2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#+'3.0g", "+2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-+'50.0g", "+2.e-308                                          ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0+'.1g", "+2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-+'1.1g", "+2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#+'50.1g", "                                          +2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-+'.3g", "+2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0+'1.3g", "+2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-+'3.3g", "+2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#+'.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-+'1.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0+'3.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-+'50.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#+'1G", "+2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-+'3G", "+2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0+'50G", "+00000000000000000000000000000000000002.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-+'.0G", "+2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#+'3.0G", "+2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-+'50.0G", "+2.E-308                                          ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0+'.1G", "+2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-+'1.1G", "+2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#+'50.1G", "                                          +2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-+'.3G", "+2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0+'1.3G", "+2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-+'3.3G", "+2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#+'.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#-+'1.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0+'3.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0-+'50.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# '1g", " 2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- '3g", " 2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 '50g", " 00000000000000000000000000000000000002.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- '.0g", " 2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# '3.0g", " 2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- '50.0g", " 2.e-308                                          ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 '.1g", " 2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- '1.1g", " 2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# '50.1g", "                                           2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- '.3g", " 2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 '1.3g", " 2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- '3.3g", " 2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# '.50g", " 2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- '1.50g", " 2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 '3.50g", " 2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- '50.50g", " 2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# '1G", " 2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- '3G", " 2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 '50G", " 00000000000000000000000000000000000002.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- '.0G", " 2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# '3.0G", " 2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- '50.0G", " 2.E-308                                          ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 '.1G", " 2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- '1.1G", " 2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# '50.1G", "                                           2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- '.3G", " 2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 '1.3G", " 2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- '3.3G", " 2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# '.50G", " 2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- '1.50G", " 2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 '3.50G", " 2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- '50.50G", " 2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# +'1g", "+2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- +'3g", "+2.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 +'50g", "+00000000000000000000000000000000000002.22507e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- +'.0g", "+2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# +'3.0g", "+2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- +'50.0g", "+2.e-308                                          ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 +'.1g", "+2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- +'1.1g", "+2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# +'50.1g", "                                          +2.e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- +'.3g", "+2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 +'1.3g", "+2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- +'3.3g", "+2.23e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# +'.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- +'1.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 +'3.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- +'50.50g", "+2.2250738585072013830902327173324040642192159804623e-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# +'1G", "+2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- +'3G", "+2.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 +'50G", "+00000000000000000000000000000000000002.22507E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- +'.0G", "+2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# +'3.0G", "+2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- +'50.0G", "+2.E-308                                          ", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 +'.1G", "+2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- +'1.1G", "+2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# +'50.1G", "                                          +2.E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- +'.3G", "+2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 +'1.3G", "+2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- +'3.3G", "+2.23E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%# +'.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#- +'1.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0 +'3.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%#0- +'50.50G", "+2.2250738585072013830902327173324040642192159804623E-308", { 0, 0, 0, 0, 0, 0, 16, 0 } },
    { "%'1g", "1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-'3g", "1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0'50g", "0000000000000000000000000000000000000001.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-'.0g", "1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%'3.0g", "1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-'50.0g", "1e-38                                             ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0'.1g", "1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-'1.1g", "1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%'50.1g", "                                             1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-'.3g", "1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0'1.3g", "1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-'3.3g", "1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%'.50g", "1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-'1.50g", "1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0'3.50g", "1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-'50.50g", "1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%'1G", "1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-'3G", "1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0'50G", "0000000000000000000000000000000000000001.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-'.0G", "1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%'3.0G", "1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-'50.0G", "1E-38                                             ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0'.1G", "1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-'1.1G", "1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%'50.1G", "                                             1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-'.3G", "1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0'1.3G", "1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-'3.3G", "1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%'.50G", "1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-'1.50G", "1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0'3.50G", "1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-'50.50G", "1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%+'1g", "+1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-+'3g", "+1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0+'50g", "+000000000000000000000000000000000000001.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-+'.0g", "+1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%+'3.0g", "+1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-+'50.0g", "+1e-38                                            ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0+'.1g", "+1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-+'1.1g", "+1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%+'50.1g", "                                            +1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-+'.3g", "+1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0+'1.3g", "+1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-+'3.3g", "+1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%+'.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-+'1.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0+'3.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-+'50.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%+'1G", "+1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-+'3G", "+1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0+'50G", "+000000000000000000000000000000000000001.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-+'.0G", "+1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%+'3.0G", "+1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-+'50.0G", "+1E-38                                            ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0+'.1G", "+1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-+'1.1G", "+1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%+'50.1G", "                                            +1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-+'.3G", "+1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0+'1.3G", "+1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-+'3.3G", "+1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%+'.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%-+'1.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0+'3.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0-+'50.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% '1g", " 1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- '3g", " 1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 '50g", " 000000000000000000000000000000000000001.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- '.0g", " 1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% '3.0g", " 1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- '50.0g", " 1e-38                                            ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 '.1g", " 1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- '1.1g", " 1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% '50.1g", "                                             1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- '.3g", " 1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 '1.3g", " 1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- '3.3g", " 1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% '.50g", " 1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- '1.50g", " 1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 '3.50g", " 1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- '50.50g", " 1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% '1G", " 1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- '3G", " 1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 '50G", " 000000000000000000000000000000000000001.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- '.0G", " 1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% '3.0G", " 1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- '50.0G", " 1E-38                                            ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 '.1G", " 1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- '1.1G", " 1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% '50.1G", "                                             1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- '.3G", " 1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 '1.3G", " 1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- '3.3G", " 1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% '.50G", " 1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- '1.50G", " 1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 '3.50G", " 1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- '50.50G", " 1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% +'1g", "+1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- +'3g", "+1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 +'50g", "+000000000000000000000000000000000000001.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- +'.0g", "+1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% +'3.0g", "+1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- +'50.0g", "+1e-38                                            ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 +'.1g", "+1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- +'1.1g", "+1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% +'50.1g", "                                            +1e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- +'.3g", "+1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 +'1.3g", "+1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- +'3.3g", "+1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% +'.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- +'1.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 +'3.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- +'50.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% +'1G", "+1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- +'3G", "+1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 +'50G", "+000000000000000000000000000000000000001.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- +'.0G", "+1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% +'3.0G", "+1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- +'50.0G", "+1E-38                                            ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 +'.1G", "+1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- +'1.1G", "+1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% +'50.1G", "                                            +1E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- +'.3G", "+1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 +'1.3G", "+1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- +'3.3G", "+1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "% +'.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%- +'1.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0 +'3.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%0- +'50.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#'1g", "1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-'3g", "1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0'50g", "0000000000000000000000000000000000000001.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-'.0g", "1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#'3.0g", "1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-'50.0g", "1.e-38                                            ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0'.1g", "1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-'1.1g", "1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#'50.1g", "                                            1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-'.3g", "1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0'1.3g", "1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-'3.3g", "1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#'.50g", "1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-'1.50g", "1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0'3.50g", "1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-'50.50g", "1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#'1G", "1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-'3G", "1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0'50G", "0000000000000000000000000000000000000001.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-'.0G", "1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#'3.0G", "1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-'50.0G", "1.E-38                                            ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0'.1G", "1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-'1.1G", "1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#'50.1G", "                                            1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-'.3G", "1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0'1.3G", "1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-'3.3G", "1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#'.50G", "1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-'1.50G", "1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0'3.50G", "1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-'50.50G", "1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#+'1g", "+1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-+'3g", "+1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0+'50g", "+000000000000000000000000000000000000001.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-+'.0g", "+1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#+'3.0g", "+1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-+'50.0g", "+1.e-38                                           ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0+'.1g", "+1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-+'1.1g", "+1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#+'50.1g", "                                           +1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-+'.3g", "+1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0+'1.3g", "+1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-+'3.3g", "+1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#+'.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-+'1.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0+'3.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-+'50.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#+'1G", "+1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-+'3G", "+1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0+'50G", "+000000000000000000000000000000000000001.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-+'.0G", "+1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#+'3.0G", "+1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-+'50.0G", "+1.E-38                                           ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0+'.1G", "+1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-+'1.1G", "+1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#+'50.1G", "                                           +1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-+'.3G", "+1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0+'1.3G", "+1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-+'3.3G", "+1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#+'.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#-+'1.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0+'3.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0-+'50.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# '1g", " 1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- '3g", " 1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 '50g", " 000000000000000000000000000000000000001.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- '.0g", " 1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# '3.0g", " 1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- '50.0g", " 1.e-38                                           ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 '.1g", " 1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- '1.1g", " 1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# '50.1g", "                                            1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- '.3g", " 1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 '1.3g", " 1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- '3.3g", " 1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# '.50g", " 1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- '1.50g", " 1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 '3.50g", " 1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- '50.50g", " 1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# '1G", " 1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- '3G", " 1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 '50G", " 000000000000000000000000000000000000001.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- '.0G", " 1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# '3.0G", " 1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- '50.0G", " 1.E-38                                           ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 '.1G", " 1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- '1.1G", " 1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# '50.1G", "                                            1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- '.3G", " 1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 '1.3G", " 1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- '3.3G", " 1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# '.50G", " 1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- '1.50G", " 1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 '3.50G", " 1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- '50.50G", " 1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# +'1g", "+1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- +'3g", "+1.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 +'50g", "+000000000000000000000000000000000000001.17549e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- +'.0g", "+1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# +'3.0g", "+1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- +'50.0g", "+1.e-38                                           ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 +'.1g", "+1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- +'1.1g", "+1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# +'50.1g", "                                           +1.e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- +'.3g", "+1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 +'1.3g", "+1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- +'3.3g", "+1.18e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# +'.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- +'1.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 +'3.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- +'50.50g", "+1.1754943508222875079687365372222456778186655567721e-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# +'1G", "+1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- +'3G", "+1.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 +'50G", "+000000000000000000000000000000000000001.17549E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- +'.0G", "+1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# +'3.0G", "+1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- +'50.0G", "+1.E-38                                           ", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 +'.1G", "+1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- +'1.1G", "+1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# +'50.1G", "                                           +1.E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- +'.3G", "+1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 +'1.3G", "+1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- +'3.3G", "+1.18E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%# +'.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#- +'1.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0 +'3.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { "%#0- +'50.50G", "+1.1754943508222875079687365372222456778186655567721E-38", { 0, 0, 0, 0, 0, 0, 16, 56 } },
    { 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};

