# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.

import string

makefileTemplate = """# THIS FILE IS AUTOGENERATED BY ${caller} - DO NOT EDIT

DEPTH = ${depth}

topsrcdir = @top_srcdir@
srcdir = @srcdir@
VPATH = @srcdir@
relativesrcdir = ${relativesrcdir}

DIRS = \\
${dirs}

include $$(DEPTH)/config/autoconf.mk
"""

filesTemplate = """
MOCHITEST_FILES := \\
${files}

include $$(topsrcdir)/config/rules.mk
"""

def makefileString(entries):
  if not len(entries):
    return "  $(NULL)"
  return "\n".join(["  %s \\" % (entry, ) for entry in entries]) + "\n  $(NULL)"

def substMakefile(caller, path, subdirs, files):
  result = string.Template(makefileTemplate).substitute({
    "caller": caller,
    "depth": "..%s" % ("/.." * path.count("/"), ),
    "relativesrcdir": path,
    "dirs": makefileString(subdirs)
  })

  if files:
    result += string.Template(filesTemplate).substitute({
      "files": makefileString(files)
    })

  return result
