#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <vga.h>
#include <dirent.h>
#include <errno.h>

#include "vidplay.h"

#define BUFSIZE 32

struct {
    char name[256];
    int x;
    int y;
} files[2048];

int numfiles;
static char dir[256];
play_info pi[64];
int pids[64];
int scr_width=800;
int scr_height=600;
int scr_mode=G800x600x16M32;    
int scr_bpp;
unsigned int novga;
static int conc;
int ringbuf[BUFSIZE];
int ringb,ringe;

int select_file(const struct dirent *dirent){
    int l;
    VIDEO_FILE vf;
    char fn[256];

    l=strlen(dirent->d_name);    
    if (
        !strcasecmp(dirent->d_name+l-4,".avi") ||
        !strcasecmp(dirent->d_name+l-4,".mpg") ||
        !strcasecmp(dirent->d_name+l-5,".mpeg") ||
        !strcasecmp(dirent->d_name+l-3,".qt") ||
        !strcasecmp(dirent->d_name+l-4,".mov")
    ) {
        strcpy(fn,dir);
        strcat(fn,dirent->d_name);
        if(!strncmp("/mount/x/nocd/avi/sadie",fn,23)) return 0;
        if(!strncmp("/mount/x/nocd/avi/ve/4",fn,22)) return 0;
        if(!strncmp("/mount/x/nocd/avi/ve/tg/4",fn,25)) return 0;
        if(!strncmp("/mount/x/nocd/avi/ve/5",fn,22)) return 0;
        if(!strncmp("/mount/x/nocd/avi/ve/fire07/1",fn,29)) return 0;
        if(!strncmp("/mount/x/nocd/avi/ve/fire07/2",fn,29)) return 0;
        if(!vidinfo(fn,&vf,0)) {
            strcpy(files[numfiles].name,fn);
            files[numfiles].x=vf.width;
            files[numfiles].y=vf.height;
            if((files[numfiles].x>0)&&(files[numfiles].x<8192)&&(files[numfiles].y>0)&&(files[numfiles].y<8192))
                numfiles++;
        }
    }
    return 0;
}

int intersect(x1,y1,w1,h1,x2,y2,w2,h2) {
    return !(
        (x2>=x1+w1) ||
        (x1>=x2+w2) ||
        (y2>=y1+h1) ||
        (y1>=y2+h2)
    );
}

int startplay(int j, int verbose) {
    int sx,sy;
    int r;
    int i,n;
    
    r=random()%numfiles;
    strncpy(pi[j].filename,files[r].name,254);

    if(verbose)printf("starting %i: (%i) %s  (%ix%i)",j,r,pi[j].filename,files[r].x,files[r].y);
    
    i=1;
    n=1000;
    while(i && n ) {
        int k;
        n--;
        sx=random()%(scr_width-files[r].x);
        sy=random()%(scr_height-files[r].y);
        i=0;
        for(k=0;k<conc;k++)if(k!=j)i+=intersect(sx,sy,files[r].x,files[r].y,pi[k].sx,pi[k].sy,
            files[pi[k].scr_mode].x,files[pi[k].scr_mode].y);
    }
    
    if(!n) {
        if(verbose)printf(" - giving up.\n");
        pi[j].sx=-9999;
        pi[j].sy=-9999;
        pi[j].scr_mode=0;
        sleep(1);
        return -1;
    }
    
    if(verbose)printf("     at %ix%i\n",sx,sy);

    pi[j].verbose=0;
    pi[j].noaudio=1;
    pi[j].novideo=0;
    pi[j].playframe=0;
    pi[j].len=99999;
    pi[j].novga=novga+sx*4+sy*scr_width*4;
    pi[j].scr_width=scr_width;
    pi[j].scr_bpp=scr_bpp;
    pi[j].sx=sx;
    pi[j].sy=sy;
    pi[j].scr_mode=r;
    pids[j]=fork();    
    if(!pids[j]) {
        int y;
        playvideo(&pi[j]);
        for(y=0;y<files[pi[j].scr_mode].y;y++)
            memset((unsigned char *)pi[j].novga+4*scr_width*y,0,4*files[pi[j].scr_mode].x);
        
        exit(0);
    }
    return 0;
}

int main (int argc, char **argv)
{
    int c;
    vga_modeinfo *mi;
    int i;
    struct dirent **d;
    FILE *conf;
    char confname[256];
    int num=50;    
    int verbose;

    srandom(getpid());

    strcpy(confname,getenv("HOME"));
    strcat(confname,"/.multiplay");
    verbose=0;
    conc=4;
    numfiles=0;
    
    errno=0;
    if((conf=fopen(confname,"r"))) {
        char tmp[1024], v[1024];
        int i, n;
        fgets(tmp,1023,conf);
        sscanf(tmp,"%s %i\n",v,&i);
        if(strcmp(v,"version") || i) {
            fprintf(stderr,"Bad config file.  %s %i\n",v,i);
            exit(3);
        }
        fgets(tmp,1023,conf);
        sscanf(tmp,"%i",&numfiles);
        for(i=0;i<numfiles;i++) {
            fgets(tmp,1023,conf);
            sscanf(tmp,"%i %i %i %i %s",&n,&n,&files[i].x,&files[i].y,files[i].name);
        }
        fclose(conf);
    } else {
        i=errno;
        strcpy(dir,"/mount/x/goals/");
        scandir(dir,&d,select_file,NULL);
        if(i==ENOENT) {
            conf=fopen(confname,"w");
            fprintf(conf,"version 0\n");
            fprintf(conf,"%i\n",numfiles);
            for(i=0;i<numfiles;i++) {
                fprintf(conf,"%i %i %i %i %s\n",i,0,files[i].x,files[i].y,files[i].name);
            }
            fclose(conf);
        }
    }

    for (;;) {
	if (-1 == (c = getopt(argc, argv, "l:n:s:v")))
	    break;
	switch (c) {
	    case 's':
                scr_mode=atoi(optarg);
                break;
	    case 'l':
                num=atoi(optarg);
                break;
	    case 'n':
                conc=atoi(optarg);
                break;
            case 'v':
                verbose=1;
                break;
	}
    }

    if(conc>num)conc=num;
    
    vga_init();
    vga_setmode(scr_mode);
    mi=vga_getmodeinfo(scr_mode);
    scr_width=mi->width;
    scr_height=mi->height;
    switch(mi->bytesperpixel+mi->colors) {
        case 257:
            scr_bpp=8;
            break;
        case 32770:
            scr_bpp=15;
            break;
        case 65538:
            scr_bpp=16;
            break;
        case (1<<24)+3:
            scr_bpp=24;
            break;
        case (1<<24)+4:
            scr_bpp=32;
            break;
        default:
            scr_bpp=0;
            break;
    }

    sleep(1);
    vga_setlinearaddressing();
    novga=(unsigned int)vga_getgraphmem();

    for(i=0;i<conc;i++) {
        pi[i].sx=-9999;
        pi[i].sy=-9999;
        pi[i].scr_mode=0;
        ringbuf[i]=i;
    }
    ringb=0;
    ringe=conc;
    
    i=0;
    while(i<num+conc) {
        int p, j, s;
        
        if(i<num)while(ringb!=ringe) {
            if(!startplay(ringbuf[ringb],verbose)) {
                i++;
                ringb=(ringb+1)%BUFSIZE;
            } else {
                p=waitpid(-1,&s,WNOHANG);
                if(p>0) {
                    j=0;
                    while((p!=pids[j])&&(j<conc))j++;
                    if(j==conc)goto enn;
                    if(verbose)printf("finished %i   status=%x\n",j,s);
                    ringbuf[ringe]=j;
                    pi[j].sx=-9999;
                    pi[j].sy=-9999;
                    ringe=(ringe+1)%BUFSIZE;
                }
            }
        }
        p=waitpid(-1,&s,0);
        j=0;
        while((p!=pids[j])&&(j<conc))j++;
        if(j==conc)break;
        if(verbose)printf("finished %i   status=%x\n",j,s);
        if(i<num) {
            ringbuf[ringe]=j;
            pi[j].sx=-9999;
            pi[j].sy=-9999;
            ringe=(ringe+1)%BUFSIZE;
        }
    }

enn:

#if 0
    for(i=0;i<conc;i++)
        waitpid(pids[i],NULL,0);

    for(i=0;i<conc;i++)
        kill(pids[i],9);
#endif

    vga_setmode(TEXT);

    return 0;
}
