#include "mod.h"
#include <stdlib.h>
unsigned char *xa_byte_limit;
unsigned char *jpg_samp_limit;

YUVTabs def_yuv_tabs;

xaLONG *YUV_Y_tab  = 0;
xaLONG *YUV_UB_tab = 0;
xaLONG *YUV_VR_tab = 0;
xaLONG *YUV_UG_tab = 0;
xaLONG *YUV_VG_tab = 0;
xaLONG *YUV2_UB_tab = 0;
xaLONG *YUV2_VR_tab = 0;
xaLONG *YUV2_UG_tab = 0;
xaLONG *YUV2_VG_tab = 0;

void XA_Add_Func_To_Free_Chain(void *a, void *b) {
}

void TheEnd1(char *s) {
}

void XA_Gen_YUV_Tabs(anim_hdr)
void *anim_hdr;
{ long i;
  float t_ub,  t_vr,  t_ug,  t_vg;
  float t2_ub, t2_vr, t2_ug, t2_vg;

  if (YUV_Y_tab==0)
  {
    YUV_Y_tab =  (xaLONG *)malloc( 256 * sizeof(long) );
    YUV_UB_tab = (xaLONG *)malloc( 256 * sizeof(long) );
    YUV_VR_tab = (xaLONG *)malloc( 256 * sizeof(long) );
    YUV_UG_tab = (xaLONG *)malloc( 256 * sizeof(long) );
    YUV_VG_tab = (xaLONG *)malloc( 256 * sizeof(long) );

    YUV2_UB_tab = (xaLONG *)malloc( 256 * sizeof(long) );
    YUV2_VR_tab = (xaLONG *)malloc( 256 * sizeof(long) );
    YUV2_UG_tab = (xaLONG *)malloc( 256 * sizeof(long) );
    YUV2_VG_tab = (xaLONG *)malloc( 256 * sizeof(long) );
  }

  t_ub = (1.77200/2.0) * (float)(1<<6) + 0.5;
  t_vr = (1.40200/2.0) * (float)(1<<6) + 0.5;
  t_ug = (0.34414/2.0) * (float)(1<<6) + 0.5;
  t_vg = (0.71414/2.0) * (float)(1<<6) + 0.5;
  t2_ub = (1.4 * 1.77200/2.0) * (float)(1<<6) + 0.5;
  t2_vr = (1.4 * 1.40200/2.0) * (float)(1<<6) + 0.5;
  t2_ug = (1.4 * 0.34414/2.0) * (float)(1<<6) + 0.5;
  t2_vg = (1.4 * 0.71414/2.0) * (float)(1<<6) + 0.5;

  for(i=0;i<256;i++)
  {
    float x = (float)(2 * i - 255);
    
    YUV_UB_tab[i] = (xaLONG)( ( t_ub * x) + (1<<5));
    YUV_VR_tab[i] = (xaLONG)( ( t_vr * x) + (1<<5));
    YUV_UG_tab[i] = (xaLONG)( (-t_ug * x)         );
    YUV_VG_tab[i] = (xaLONG)( (-t_vg * x) + (1<<5));
    YUV_Y_tab[i]  = (xaLONG)( (i << 6) | (i >> 2) );

    YUV2_UB_tab[i] = (xaLONG)( ( t2_ub * x) + (1<<5));
    YUV2_VR_tab[i] = (xaLONG)( ( t2_vr * x) + (1<<5));
    YUV2_UG_tab[i] = (xaLONG)( (-t2_ug * x)         );
    YUV2_VG_tab[i] = (xaLONG)( (-t2_vg * x) + (1<<5));
  }
  
  def_yuv_tabs.Uskip_mask = 0;
  def_yuv_tabs.YUV_Y_tab  = YUV_Y_tab;
  def_yuv_tabs.YUV_UB_tab = YUV_UB_tab;
  def_yuv_tabs.YUV_VR_tab = YUV_VR_tab;
  def_yuv_tabs.YUV_UG_tab = YUV_UG_tab;
  def_yuv_tabs.YUV_VG_tab = YUV_VG_tab;
}

void XA_2x2_OUT_1BLK_rgb(image,x,y,imagex,cmap2x2)
xaUBYTE *image;
xaULONG x,y,imagex;
XA_2x2_Color *cmap2x2;
{ xaULONG row_inc = imagex - 3;
  register xaUBYTE r0,r1,b0,b1,g0,g1;
  xaUBYTE *ip = image;		ip += 3*(y * imagex + x);
  row_inc *= 3; row_inc -= 2;
  *ip++ = r0 = (xaUBYTE)(cmap2x2->r0);  
  *ip++ = g0 = (xaUBYTE)(cmap2x2->g0);  
  *ip++ = b0 = (xaUBYTE)(cmap2x2->b0);  
  *ip++ = r0; *ip++ = g0; *ip++ = b0;
  *ip++ = r1 = (xaUBYTE)(cmap2x2->r1);  
  *ip++ = g1 = (xaUBYTE)(cmap2x2->g1);  
  *ip++ = b1 = (xaUBYTE)(cmap2x2->b1);  
  *ip++ = r1; *ip++ = g1; *ip = b1;
   ip += row_inc;
  *ip++ = r0; *ip++ = g0; *ip++ = b0;
  *ip++ = r0; *ip++ = g0; *ip++ = b0;
  *ip++ = r1; *ip++ = g1; *ip++ = b1;
  *ip++ = r1; *ip++ = g1; *ip   = b1;
   ip += row_inc;
  *ip++ = r0 = (xaUBYTE)(cmap2x2->r2);  
  *ip++ = g0 = (xaUBYTE)(cmap2x2->g2);  
  *ip++ = b0 = (xaUBYTE)(cmap2x2->b2);  
  *ip++ = r0; *ip++ = g0; *ip++ = b0;
  *ip++ = r1 = (xaUBYTE)(cmap2x2->r3);  
  *ip++ = g1 = (xaUBYTE)(cmap2x2->g3);  
  *ip++ = b1 = (xaUBYTE)(cmap2x2->b3);  
  *ip++ = r1; *ip++ = g1; *ip = b1;
   ip += row_inc;
  *ip++ = r0; *ip++ = g0; *ip++ = b0;
  *ip++ = r0; *ip++ = g0; *ip++ = b0;
  *ip++ = r1; *ip++ = g1; *ip++ = b1;
  *ip++ = r1; *ip++ = g1; *ip   = b1;
}

void XA_2x2_OUT_4BLKS_rgb(image,x,y,imagex,cm0,cm1,cm2,cm3)
xaUBYTE *image;
xaULONG x,y,imagex;
XA_2x2_Color *cm0,*cm1,*cm2,*cm3;
{ xaULONG row_inc = imagex - 3;
  xaUBYTE *ip = (xaUBYTE *)(image + 3*(y * imagex + x) );
  row_inc *= 3; row_inc -= 2;
  *ip++ = (xaUBYTE)(cm0->r0);  *ip++ = (xaUBYTE)(cm0->g0);  
  *ip++ = (xaUBYTE)(cm0->b0);
  *ip++ = (xaUBYTE)(cm0->r1);  *ip++ = (xaUBYTE)(cm0->g1);  
  *ip++ = (xaUBYTE)(cm0->b1);
  *ip++ = (xaUBYTE)(cm1->r0);  *ip++ = (xaUBYTE)(cm1->g0);  
  *ip++ = (xaUBYTE)(cm1->b0);
  *ip++ = (xaUBYTE)(cm1->r1);  *ip++ = (xaUBYTE)(cm1->g1);  
  *ip   = (xaUBYTE)(cm1->b1);   ip += row_inc;
  *ip++ = (xaUBYTE)(cm0->r2);  *ip++ = (xaUBYTE)(cm0->g2);  
  *ip++ = (xaUBYTE)(cm0->b2);
  *ip++ = (xaUBYTE)(cm0->r3);  *ip++ = (xaUBYTE)(cm0->g3);  
  *ip++ = (xaUBYTE)(cm0->b3);
  *ip++ = (xaUBYTE)(cm1->r2);  *ip++ = (xaUBYTE)(cm1->g2);  
  *ip++ = (xaUBYTE)(cm1->b2);
  *ip++ = (xaUBYTE)(cm1->r3);  *ip++ = (xaUBYTE)(cm1->g3);  
  *ip   = (xaUBYTE)(cm1->b3);   ip += row_inc;
  *ip++ = (xaUBYTE)(cm2->r0);  *ip++ = (xaUBYTE)(cm2->g0);  
  *ip++ = (xaUBYTE)(cm2->b0);
  *ip++ = (xaUBYTE)(cm2->r1);  *ip++ = (xaUBYTE)(cm2->g1);  
  *ip++ = (xaUBYTE)(cm2->b1);
  *ip++ = (xaUBYTE)(cm3->r0);  *ip++ = (xaUBYTE)(cm3->g0);  
  *ip++ = (xaUBYTE)(cm3->b0);
  *ip++ = (xaUBYTE)(cm3->r1);  *ip++ = (xaUBYTE)(cm3->g1);  
  *ip   = (xaUBYTE)(cm3->b1);   ip += row_inc;
  *ip++ = (xaUBYTE)(cm2->r2);  *ip++ = (xaUBYTE)(cm2->g2);  
  *ip++ = (xaUBYTE)(cm2->b2);
  *ip++ = (xaUBYTE)(cm2->r3);  *ip++ = (xaUBYTE)(cm2->g3);  
  *ip++ = (xaUBYTE)(cm2->b3);
  *ip++ = (xaUBYTE)(cm3->r2);  *ip++ = (xaUBYTE)(cm3->g2);  
  *ip++ = (xaUBYTE)(cm3->b2);
  *ip++ = (xaUBYTE)(cm3->r3);  *ip++ = (xaUBYTE)(cm3->g3);  
  *ip   = (xaUBYTE)(cm3->b3);
}

void *YUV2x2_Blk_Func(image_type,blks,dith_flag)
xaULONG image_type;
xaULONG dith_flag;
{ void (*color_func)();
  if (blks == 1)
  {
      color_func = XA_2x2_OUT_1BLK_rgb;
  }
  else /* blks == 4 */
  {
      color_func = XA_2x2_OUT_4BLKS_rgb;
  }
  return( (void *)color_func);
}

#define YUV_TO_RGB(y,cr,cg,cb,rnglimit,r,g,b)      \
{ xaLONG YY = (xaLONG)(YUV_Y_tab[(y)]);             \
  r = (xaUBYTE)rnglimit[ (YY + cr) >> 6 ];  \
  g = (xaUBYTE)rnglimit[ (YY + cg) >> 6 ];  \
  b = (xaUBYTE)rnglimit[ (YY + cb) >> 6 ];  \
}

void XA_YUV_2x2_rgb(cmap2x2,Y0,Y1,Y2,Y3,U,V)
XA_2x2_Color *cmap2x2;
xaULONG Y0,Y1,Y2,Y3,U,V;
{ xaLONG cr,cg,cb;
  xaUBYTE *rl = xa_byte_limit;

  cr = YUV2_VR_tab[V];
  cb = YUV2_UB_tab[U];
  cg = YUV2_UG_tab[U] + YUV2_VG_tab[V];

  YUV_TO_RGB(Y0, cr, cg, cb, rl, cmap2x2->r0, cmap2x2->g0, cmap2x2->b0);
  YUV_TO_RGB(Y1, cr, cg, cb, rl, cmap2x2->r1, cmap2x2->g1, cmap2x2->b1);
  YUV_TO_RGB(Y2, cr, cg, cb, rl, cmap2x2->r2, cmap2x2->g2, cmap2x2->b2);
  YUV_TO_RGB(Y3, cr, cg, cb, rl, cmap2x2->r3, cmap2x2->g3, cmap2x2->b3);
}

void *YUV2x2_Map_Func(image_type,dith_type)
xaULONG image_type;
xaULONG dith_type;
{ void (*color_func)();

  color_func = XA_YUV_2x2_rgb;

  return( (void *)color_func);
}

#define XA_YUV_DECLR	\
xaUBYTE *image;		xaULONG imagex,imagey,i_x,i_y;	\
YUVBufs *yuv_bufs;	YUVTabs *yuv_tabs;		\
xaULONG map_flag,*map;	XA_CHDR *chdr

#define XA_YUV_VARS	\
 xaULONG mx = xaMIN(i_x,imagex);	xaULONG my = xaMIN(i_y,imagey);	\
 xaUBYTE *rnglimit = xa_byte_limit;	xaUBYTE *ybuf,*ubuf,*vbuf;	\
 xaLONG *YTab,*UBTab,*VRTab,*UGTab,*VGTab

#define XA_YUV_INIT	\
  YTab  = yuv_tabs->YUV_Y_tab;	\
  UBTab = yuv_tabs->YUV_UB_tab; VRTab = yuv_tabs->YUV_VR_tab;	\
  UGTab = yuv_tabs->YUV_UG_tab; VGTab = yuv_tabs->YUV_VG_tab;	\
  ybuf = yuv_bufs->Ybuf; ubuf = yuv_bufs->Ubuf; vbuf = yuv_bufs->Vbuf

#define DEC_YUV_CALC(u,v,V2R,U2B,UV2G) { \
  V2R = VRTab[v];	\
  U2B = UBTab[u];	\
  UV2G = VGTab[v] + UGTab[u];	\
}

#define DEC_YUV_RGB(y,V2R,U2B,V2G,ip)	\
{ register xaLONG _r,_g,_b,YY;		\
  YY = YTab[y];				\
  _r = (xaLONG)rnglimit[(YY + V2R) >> 6];	\
  _g = (xaLONG)rnglimit[(YY + UV2G) >> 6];	\
  _b = (xaLONG)rnglimit[(YY + U2B) >> 6];	\
  *ip++ = (xaUBYTE)_r; *ip++ = (xaUBYTE)_g; *ip++ = (xaUBYTE)_b;	\
}

#define XA_YUV16_Y_VARS(IP_CAST)	\
  IP_CAST *iptr = (IP_CAST *)image;	xaUBYTE *yptr = ybuf;	\
  xaUBYTE *up = ubuf;			xaUBYTE *vp = vbuf

#define UVW16_KLUDGE(uvw,ix) ( (((uvw)?(uvw):((ix)>>2) + 3) >> 2) << 2)


void XA_YUV1611_To_RGB(image,imagex,imagey,i_x,i_y,yuv_bufs,yuv_tabs,map_flag,map,chdr)
XA_YUV_DECLR;
{ XA_YUV_VARS;
  xaULONG x,y;
  xaULONG i_rowinc = 3 * (imagex - 4);
  xaULONG y_rowinc = i_x - 3;
  xaULONG i_rowinc12 = 3 * (imagex << 2);
  xaULONG uv_inc = UVW16_KLUDGE(yuv_bufs->uv_w,i_x);
  register xaULONG USkip_Mask = yuv_tabs->Uskip_mask;
  XA_YUV_INIT;

  for(y=0; y<my; y += 4)
  { XA_YUV16_Y_VARS(xaUBYTE);
    for(x=0; x<mx; x += 4)
    { xaULONG iU,iV;
	xaUBYTE *ip = iptr;		xaUBYTE *yp = yptr;
	xaLONG V2R,U2B,UV2G;

	iptr += 12;	yptr += 4;
	iU = (*up++);		iV = (*vp++);  
	if (iU & USkip_Mask) continue;  /* skip */
	DEC_YUV_CALC(iU,iV,V2R,U2B,UV2G);

	/* Row 0 */
	DEC_YUV_RGB(*yp++,V2R,U2B,UV2G,ip);
	DEC_YUV_RGB(*yp++,V2R,U2B,UV2G,ip);
	DEC_YUV_RGB(*yp++,V2R,U2B,UV2G,ip);
	DEC_YUV_RGB(*yp  ,V2R,U2B,UV2G,ip);
	/* Row 1 */ ip += i_rowinc;  yp += y_rowinc;
	DEC_YUV_RGB(*yp++,V2R,U2B,UV2G,ip);
	DEC_YUV_RGB(*yp++,V2R,U2B,UV2G,ip);
	DEC_YUV_RGB(*yp++,V2R,U2B,UV2G,ip);
	DEC_YUV_RGB(*yp  ,V2R,U2B,UV2G,ip);
	/* Row 2 */ ip += i_rowinc;  yp += y_rowinc;
	DEC_YUV_RGB(*yp++,V2R,U2B,UV2G,ip);
	DEC_YUV_RGB(*yp++,V2R,U2B,UV2G,ip);
	DEC_YUV_RGB(*yp++,V2R,U2B,UV2G,ip);
	DEC_YUV_RGB(*yp  ,V2R,U2B,UV2G,ip);
	/* Row 3 */ ip += i_rowinc;  yp += y_rowinc;
	DEC_YUV_RGB(*yp++,V2R,U2B,UV2G,ip);
	DEC_YUV_RGB(*yp++,V2R,U2B,UV2G,ip);
	DEC_YUV_RGB(*yp++,V2R,U2B,UV2G,ip);
	DEC_YUV_RGB(*yp  ,V2R,U2B,UV2G,ip);
    } /* end x */
    image += i_rowinc12;
    ybuf += (i_x << 2);
    ubuf += uv_inc;
    vbuf += uv_inc;
  } /* end y */
} /* end function */

void *XA_YUV1611_Func(image_type)
xaULONG image_type;
{ void (*color_func)();
  color_func = XA_YUV1611_To_RGB;		
  return( (void *)color_func);
}

/**********************************************************************
 * JPG from here						      *
 **********************************************************************/

void JPG_Setup_Samp_Limit_Table(anim_hdr)
void *anim_hdr;
{
  xaUBYTE *table;
  xaLONG i;

  if (jpg_samp_limit==0)
  {
     jpg_samp_limit = (xaUBYTE *)malloc((5 * (MAXJSAMPLE+1) + CENTERJSAMPLE));
     if (jpg_samp_limit==0) 
     { 
	/* fprintf(stderr,"JJ: samp limit malloc err\n"); */

       return;
     } /*POD note improve this */
     xa_byte_limit = jpg_samp_limit+(MAXJSAMPLE+1);
  }
  else return; /* already done */

  xa_byte_limit = jpg_samp_limit + (MAXJSAMPLE + 1);

  table = jpg_samp_limit;
  table += (MAXJSAMPLE+1);   /* allow negative subscripts of simple table */

  /* First segment of "simple" table: limit[x] = 0 for x < 0 */
  memset(table - (MAXJSAMPLE+1), 0, (MAXJSAMPLE+1));

  /* Main part of "simple" table: limit[x] = x */
  for (i = 0; i <= MAXJSAMPLE; i++) table[i] = (xaUBYTE) i;

  table += CENTERJSAMPLE;       /* Point to where post-IDCT table starts */
  /* End of simple table, rest of first half of post-IDCT table */

  for (i = CENTERJSAMPLE; i < 2*(MAXJSAMPLE+1); i++) table[i] = MAXJSAMPLE;

  /* Second half of post-IDCT table */
  memset(table + (2 * (MAXJSAMPLE+1)), 0, (2 * (MAXJSAMPLE+1) - CENTERJSAMPLE));
  memcpy(table + (4 * (MAXJSAMPLE+1) - CENTERJSAMPLE),
          (char *)(jpg_samp_limit+(MAXJSAMPLE+1)), CENTERJSAMPLE);

}

