typedef int		xaLONG;
typedef unsigned int	xaULONG;
typedef short		xaSHORT;
typedef unsigned short	xaUSHORT;
typedef char		xaBYTE;
typedef unsigned char	xaUBYTE;

#define MAXJSAMPLE 255
#define CENTERJSAMPLE 128

#define xaMIN(x,y) ( ((x)>(y))?(y):(x) )

#define XA_DEC_SPEC_RGB		0x0001
#define XA_DEC_SPEC_CF4		0x0002
#define XA_DEC_SPEC_DITH	0x0004

#define XA_IMTYPE_RGB		0x0001
#define XA_IMTYPE_GRAY		0x0002
#define XA_IMTYPE_CLR8		0x0003
#define XA_IMTYPE_CLR16		0x0004
#define XA_IMTYPE_CLR32		0x0005
#define XA_IMTYPE_332		0x0006
#define XA_IMTYPE_332DITH	0x0007
#define XA_IMTYPE_CF4		0x0008
#define XA_IMTYPE_CF4DITH	0x0009

typedef struct
{
  void *anim_hdr;		/* used to add stuff to Free Chain */
  int compression;		/* input/output compression */
  int x,y;			/* input/output x,y */
  int depth;		/* input depth  and cfunc */
  void  *extra;			/* extra for delta */
  int xapi_rev;		/* XAnim API rev */
  int (*decoder)();		/* decoder routine */
  char *description;		/* text string */
  int avi_ctab_flag;	/* AVI ctable to be read */
  int (*avi_read_ext)();	/* routine to read extended data */
} XA_CODEC_HDR;

typedef struct S_XAVID_FUNC_HDR
{
  int	what;
  int	id;
  int	(*iq_func)();	/* init/query function */
  int	(*dec_func)();  /* opt decode function */
} XAVID_FUNC_HDR;

#define XAVID_WHAT_NO_MORE	0x0000
#define XAVID_AVI_QUERY		0x0001
#define XAVID_QT_QUERY		0x0002
#define XAVID_DEC_FUNC		0x0100

#define XAVID_API_REV		0x0003

typedef struct
{
  int		api_rev;
  char			*desc;
  char			*rev;
  char			*copyright;
  char			*mod_author;
  char			*authors;
  int		num_funcs;
  XAVID_FUNC_HDR	*funcs;
} XAVID_MOD_HDR;

typedef struct
{
  xaUBYTE *Ybuf;
  xaUBYTE *Ubuf;
  xaUBYTE *Vbuf;
  xaUBYTE *the_buf;
  xaULONG  the_buf_size;
  xaUSHORT y_w,y_h;
  xaUSHORT uv_w,uv_h;
} YUVBufs;

typedef struct
{
  unsigned long Uskip_mask;
  xaLONG *YUV_Y_tab;
  xaLONG *YUV_UB_tab;
  xaLONG *YUV_VR_tab;
  xaLONG *YUV_UG_tab;
  xaLONG *YUV_VG_tab;
} YUVTabs;

typedef struct
{
  xaUBYTE r0,g0,b0;
  xaUBYTE r1,g1,b1;
  xaUBYTE r2,g2,b2;
  xaUBYTE r3,g3,b3;
  xaULONG clr0_0,clr0_1,clr0_2,clr0_3;
  xaULONG clr1_0,clr1_1,clr1_2,clr1_3;
  xaULONG clr2_0,clr2_1,clr2_2,clr2_3;
  xaULONG clr3_0,clr3_1,clr3_2,clr3_3;
} XA_2x2_Color;

typedef struct
{
  xaUSHORT red,green,blue,gray;
} ColorReg;

typedef struct XA_ACTION_STRUCT
{
 xaLONG type;		/* type of action */
 xaLONG cmap_rev;          /* rev of cmap */
 xaUBYTE *data;		/* data ptr */
 struct XA_ACTION_STRUCT *next;
 struct XA_CHDR_STRUCT *chdr;
 ColorReg *h_cmap;	/* For IFF HAM images */
 xaULONG *map;
 struct XA_ACTION_STRUCT *next_same_chdr; /*ptr to next action with same cmap*/
} XA_ACTION;

typedef struct XA_CHDR_STRUCT
{
 xaLONG rev;
 ColorReg *cmap;
 xaULONG csize,coff;
 xaULONG *map;
 xaULONG msize,moff;
 struct XA_CHDR_STRUCT *next;
 XA_ACTION *acts;
 struct XA_CHDR_STRUCT *new_chdr;
} XA_CHDR;

typedef struct
{
  xaULONG cmd;			/* decode or query */
  xaULONG skip_flag;		/* skip_flag */
  xaULONG imagex,imagey;	/* Image Buffer Size */
  xaULONG imaged; 		/* Image depth */
  XA_CHDR *chdr;		/* Color Map Header */
  xaULONG map_flag;		/* remap image? */
  xaULONG *map;			/* map to use */
  xaULONG xs,ys;		/* pos of changed area */
  xaULONG xe,ye;		/* size of change area */
  xaULONG special;		/* Special Info */
  void *extra;			/* Decompression specific info */
} XA_DEC_INFO;

typedef struct
{
  xaULONG cmd;			/* decode or query */
  xaULONG skip_flag;		/* skip_flag */
  xaULONG imagex,imagey;	/* Image Buffer Size */
  xaULONG imaged; 		/* Image depth */
  XA_CHDR *chdr;		/* Color Map Header */
  xaULONG map_flag;		/* remap image? */
  xaULONG *map;			/* map to use */
  xaULONG xs,ys;		/* pos of changed area */
  xaULONG xe,ye;		/* size of change area */
  xaULONG special;		/* Special Info */
  xaULONG bytes_pixel;		/* bytes per pixel */
  xaULONG image_type;		/* type of image */
  xaULONG tmp1;			/* future expansion */
  xaULONG tmp2;			/* future expansion */
  xaULONG tmp3;			/* future expansion */
  xaULONG tmp4;			/* future expansion */
  void *extra;			/* Decompression specific info */
} XA_DEC2_INFO;

