static int CalcVClock
(
    int           clockIn,
    int          *clockOut,
    int          *mOut,
    int          *nOut,
    int          *pOut
)
{
    unsigned DeltaNew, DeltaOld;
    unsigned VClk, Freq;
    unsigned M, N, P;



    int PLL_INPUT_FREQ, MAXVCLOCK, P_MAX, M_MAX, M_MIN;    
    PLL_INPUT_FREQ= 14318;
    MAXVCLOCK=256000;
    P_MAX=4; /* XFree say 3, but 4 works on my Riva128 */
    if(PLL_INPUT_FREQ==13500)M_MAX=12; else M_MAX=13;
    M_MIN=M_MAX-5;


    DeltaOld = 0xFFFFFFFF;

    VClk     = (unsigned)clockIn;
    
    for (P = 0; P <= P_MAX; P ++)
    {
        Freq = VClk << P;
        if ((Freq >= 128000) && (Freq <= MAXVCLOCK))
        {
            for (M = M_MIN; M <= M_MAX; M++)
            {
                N    = ((VClk<<P) * M + PLL_INPUT_FREQ/2) / PLL_INPUT_FREQ;
                Freq = (PLL_INPUT_FREQ * N / M) >> P;
                if (Freq > VClk)
                    DeltaNew = Freq - VClk;
                else
                    DeltaNew = VClk - Freq;
                if ((DeltaNew < DeltaOld) && (N<256))
                {
                    *mOut     = M;
                    *nOut     = N;
                    *pOut     = P;
                    *clockOut = Freq;
                    DeltaOld  = DeltaNew;
                }
            }
        }
    }
    return (DeltaOld != 0xFFFFFFFF);
}

int nv3_setclock(int clock) {
    int  n, m, p, co, i;
    
    CalcVClock(clock, &co, &m, &n, &p);

    *(unsigned int *)(MMIO_POINTER + 0x680508) = m + (n<<8) + (p<<16);
    *(unsigned int *)(MMIO_POINTER + 0x68050C) |= (1<<16);

    i=inb(0x3cc);
    outb(i|0x0c, 0x3c2);
    return 0;    
}

