/*-------------------------------------------------------------------------
 * Filename:      clock.c
 * Version:       $Id: clock.c,v 1.2 2000/03/25 13:42:52 erikm Exp $
 * Copyright:     Copyright (C) 2000, Johan Pouwelse
 * Author:        Johan Pouwelse <pouwelse@twi.tudelft.nl>
 * Description:   Clock switching functions
 * Created at:    Sat Mar 25 14:11:22 2000
 * Modified by:   Erik Mouw <J.A.K.Mouw@its.tudelft.nl>
 * Modified at:   Sat Mar 25 14:12:42 2000
 *-----------------------------------------------------------------------*/
/*
 * clock.c: Utility to set clock speed and DRAM parameters 
 *
 * Copyright (C) 2000  Johan Pouwelse (pouwelse@twi.tudelft.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <types.h>
#include <serial.h>
#include <util.h>

int MyIsXDigit(char isdigit) {
  if ((isdigit >= '0' && isdigit <= '9' ) ||
      (isdigit >= 'a' && isdigit <= 'f'))
     return 1;
  else
     return 0;
} /* MyIsXDigit */

int MyXDigitValue(char isdigit) {
  if (isdigit >= '0' && isdigit <= '9' )
    return isdigit - '0';
  if (isdigit >= 'a' && isdigit <= 'f')
    return 10 + isdigit - 'a';
  return -1;
} /* MyXDigitValue */

/* Converts 8 characters 0-9a-f into a 4 byte hexadecimal value */
char *GetHexValue(char *commandline,u32 *value) {
  int i;

  if(commandline[0] == '\0') {
    SerialOutputString(__FUNCTION__ ": zero length string\n");
    return(NULL);
  }

  *value=0x00;
  if (MyStrNCmp(commandline, " 0x", 3) == 0) {
    commandline += 3;
  } else if(commandline[0] == ' ') {
    commandline += 1;
  } else {
    SerialOutputString(__FUNCTION__ ":value not hexdecimal\n");
    return NULL;
  }
  
//  SerialOutputString("char: ");
//  SerialOutputString(commandline);
//  SerialOutputByte(' ');
  
  for (i=0; i<8;i++) {
    if (*commandline == '\0') {
      SerialOutputString(__FUNCTION__ ":hex value not 32 bits\n");
      return NULL;
    } else {
      if (MyIsXDigit(*commandline) == 0) {
        SerialOutputString("hex value contains invalid characters\n");
        return NULL;
      } else {
        *value |= (u32) MyXDigitValue(*commandline) << ((7-i)*4);
      }
    }

    commandline++;
  }

//  SerialOutputString("hex 0x");
//  SerialOutputHex(*value);
//  SerialOutputByte('\r');

  return commandline;
} /* GetHexValue */

void bra (char *commandline) {
    unsigned int ad;
    void (*branch)(void);
    
    GetHexValue(commandline,&ad);
    
    branch=ad;
    branch();
    
}

void dmb(char *commandline) {
    unsigned char *ad;
    u32 value;
    
    GetHexValue(commandline,&ad);
    
    value=*ad;
    SerialOutputHex(value);
    
}
void dmw(char *commandline) {
    unsigned short *ad;
    u32 value;
    
    GetHexValue(commandline,&ad);
    
    value=*ad;
    SerialOutputHex(value);
    
}
void dml(char *commandline) {
    unsigned int *ad;
    u32 value;
    
    GetHexValue(commandline,&ad);
    
    value=*ad;
    SerialOutputHex(value);
    
}

void smb(char *commandline) {
    unsigned char *ad;
    u32 value;
    
    commandline=GetHexValue(commandline,&ad);
    GetHexValue(commandline,&value);    
    *ad=value;
    
}
void smw(char *commandline) {
    unsigned short *ad;
    u32 value;
    
    commandline=GetHexValue(commandline,&ad);
    GetHexValue(commandline,&value);    
    *ad=value;
    
}
void sml(char *commandline) {
    unsigned int *ad;
    u32 value;
    
    commandline=GetHexValue(commandline,&ad);
    GetHexValue(commandline,&value);    
    *ad=value;
    
}

