/*-------------------------------------------------------------------------
 * Filename:      util.c
 * Version:       $Id: util.c,v 1.5 1999/10/03 22:03:52 erikm Exp $
 * Copyright:     Copyright (C) 1999, Jan-Derk Bakker
 * Author:        Jan-Derk Bakker <J.D.Bakker@its.tudelft.nl>
 * Description:   Simple utility functions for blob
 * Created at:    Wed Aug 25 21:00:00 1999
 * Modified by:   Erik Mouw <J.A.K.Mouw@its.tudelft.nl>
 * Modified at:   Sun Oct  3 21:10:43 1999
 *-----------------------------------------------------------------------*/
/*
 * util.c: Simple utility functions for blob
 *
 * Copyright (C) 1999  Jan-Derk Bakker (J.D.Bakker@its.tudelft.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
# include "config.h"

#include "types.h"
#include "util.h"
#include "serial.h"


void MyMemCpy(u32 *dest, const u32 *src, int numWords) 
{

	while(numWords--) {
		if((numWords & 0xffff) == 0x0)
			SerialOutputByte('.');

		*dest++ = *src++;
	}
} /* MyMemCpy */


void MyMemCpyChar(char *dest, const char *src, int numBytes)
{
	char *destLim = dest + numBytes;
	
	while(dest < destLim)
		*dest++ = *src++;
} /* MyMemCpyChar */


int MyStrNCmp(const char *s1, const char *s2, int maxlen) 
{
	int i;

	for(i = 0; i < maxlen; i++) {
		if(s1[i] != s2[i])
			return ((int) s1[i]) - ((int) s2[i]);
		if(s1[i] == 0)
			return 0;
	}

	return 0;
} /* MyStrNCmp */

void udelay (int i){
    volatile int j;
    for(j=i*27;j>0;j--) ;
}

int MyIsXDigit(char isdigit) {
  if ((isdigit >= '0' && isdigit <= '9' ) ||
      (isdigit >= 'a' && isdigit <= 'f'))
     return 1;
  else
     return 0;
} /* MyIsXDigit */

int MyXDigitValue(char isdigit) {
  if (isdigit >= '0' && isdigit <= '9' )
    return isdigit - '0';
  if (isdigit >= 'a' && isdigit <= 'f')
    return 10 + isdigit - 'a';
  return -1;
} /* MyXDigitValue */

/* Converts 8 characters 0-9a-f into a 4 byte hexadecimal value */
char *GetHexValue(char *commandline, unsigned int *value) {
  int i;

  *value=0x00;

  if(commandline[0] == '\0') {
    return(commandline);
  }
 
  while(commandline[0] == ' ') {
    commandline += 1;
  }

  if (MyStrNCmp(commandline, "0x", 2) == 0) {
    commandline += 2;
  }
  
//  SerialOutputString("char: ");
//  SerialOutputString(commandline);
//  SerialOutputByte(' ');
  
  for (i=0; i<8;i++) {
    if (*commandline == '\0') {
      return commandline;
    } else {
      if (MyIsXDigit(*commandline) == 0) {
        return commandline;
      } else {
        *value <<=4;
        *value |= (u32) MyXDigitValue(*commandline);
      }
    }

    commandline++;
  }

//  SerialOutputString("hex 0x");
//  SerialOutputHex(*value);
//  SerialOutputByte('\r');

  return commandline;
} /* GetHexValue */


