###########################################################################
## Filename:      start.S
## Version:       $Id: start.S,v 1.18 2000/07/14 17:25:11 erikm Exp $
## Copyright:     Copyright (C) 1999, Erik Mouw
## Author:        Erik Mouw <J.A.K.Mouw@its.tudelft.nl>
## Description:   blob start code
## Created at:    Sun Jul 18 20:29:08 1999
## Modified by:   Erik Mouw <J.A.K.Mouw@its.tudelft.nl>
## Modified at:   Fri Jul  14 17:55:36 2000
###########################################################################
/*
 * start.S: blob start code
 *
 * Copyright (C) 1999  Erik Mouw (J.A.K.Mouw@its.tudelft.nl) and 
 *                     Jan-Derk Bakker (J.D.Bakker@its.tudelft.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

.text

reset:
	
	/* Set up the SDRAM */
        mov.l	bcr2, r1
        mov.l   bcr2_val, r2
        mov.w	r2, @r1

        mov.l	pcr, r1
        mov.l   pcr_val, r2
        mov.w	r2, @r1

        mov.l 	delay, r7
        shal r7

        mov.l	scscr2, r1
        mov	#0, r2
        mov.w   r2, @r1

    	mov.l scfcr2, r1
        mov #6, r2
        mov.w r2, @r1
    	mov.l scsmr2, r1
        mov #0, r2
        mov.w r2, @r1
        mov.l	scbrr2, r1

        mov.l PCICONF0, r8
        mov.l SH7751,   r9
        mov.l @r8,      r10
        cmp/eq r9, r10
        bf isnot51
        nop
	
        mov.l   scbrr2_val2, r2
        mov.b   r2, @r1
        bra cont
        nop

isnot51:
        mov.l   scbrr2_val, r2
        mov.b   r2, @r1

cont:

        mov.l 	delay, r7
        shal r7
        shal r7
        shal r7
        shal r7

	
lp4:
        nop
        dt r7
        bf lp4
        nop

        mov.l	scsptr2, r1
        mov.w	scsptr2_val, r2
        mov.w   r2, @r1
    	mov.l scfcr2, r1
        mov #0, r2
        mov.w r2, @r1
        mov.l	scscr2, r1
        mov.w	scscr2_val, r2
        mov.w   r2, @r1

        mov.l	ccr, r1
        mov.l   ccr_val1, r2
        mov.l	r2, @r1

        mov.l	bcr1, r1
        mov.l   bcr1_val, r2
        mov.l	r2, @r1
        mov.l	bcr2, r1
        mov.w   bcr2_val, r2
        mov.w	r2, @r1

        mov.l	wcr1, r1
        mov.l   wcr1_val, r2
        mov.l	r2, @r1
        mov.l	wcr2, r1
        mov.l   wcr2_val, r2
        mov.l	r2, @r1
        mov.l	wcr3, r1
        mov.l   wcr3_val, r2
        mov.l	r2, @r1

        mov.l	mcr, r1
        mov.l   mcr_val3, r2
        mov.l	r2, @r1

        mov.l	rtcsr, r1
        mov.l   rtcsr_val, r2
        mov.w	r2, @r1
        mov.l	rtcnt, r1
        mov.l   rtcnt_val, r2
        mov.w	r2, @r1
        mov.l	rtcor, r1
        mov.l   rtcor_val2, r2
        mov.w	r2, @r1
        mov.l	rfcr, r1
        mov.l   rfcr_val, r2
        mov.w	r2, @r1
	
	mov.l   sdmr2, r1
	mov #0, r2
	mov.b r2, @r1
	mov.l   sdmr3, r1
	mov #0, r2
	mov.b r2, @r1

        mov.l	mcr, r1
        mov.l   mcr_val, r2
        mov.l	r2, @r1

        mov.l 	delay, r7
        shal r7
3:
        nop
        dt r7
        bf 3b
        nop

        mov.l	mcr, r1
        mov.l   mcr_val2, r2
        mov.l	r2, @r1
	mov.l   sdmr2, r1
	mov #0, r2
	mov.b r2, @r1
	mov.l   sdmr3, r1
	mov #0, r2
	mov.b r2, @r1

        mov.l	rtcnt, r1
        mov.l   rtcnt_val, r2
        mov.w	r2, @r1
        mov.l	rfcr, r1
        mov.l   rfcr_val, r2
        mov.w	r2, @r1
        mov.l	rtcsr, r1
        mov.l   rtcsr_val, r2
        mov.w	r2, @r1
        mov.l	rtcor, r1
        mov.l   rtcor_val, r2
        mov.w	r2, @r1

        mov.l	ccr, r1
        mov.l   ccr_val2, r2
        mov.l	r2, @r1

	bra afterram
	nop

.align 2
scfcr2:
    	.long 0xffe80018

scsmr2:
    	.long 0xffe80000

scsptr2:
    	.long 0xffe80020

scsptr2_val:
    	.long 0x51

scbrr2:
    	.long 0xffe80004
scbrr2_val:
    	.long 0x0f
scbrr2_val2:
		.long 0x07

PCICONF0:
        .long 0xfe200000
SH7751:
        .long 0x35051054

scscr2:
    	.long 0xffe80008
scscr2_val:
    	.short 0x30
        .short 0

delay:
	.long 40000

ccr:
	.long 0xff00001c
ccr_val1:
	.long 0x0808
ccr_val2:
	.long 0x090d

bcr1:
        .long 0xff800000
bcr1_val:
//    	.long 0x8000000c 
		.long 0x8000000d /* PCMCPIA */

bcr2:
        .long 0xff800004
bcr2_val:
    	.long 0xfdf4

pcr:
		.long 0xff800018
pcr_val:
		.long 0xffff
		
wcr1:
        .long 0xff800008
wcr1_val:
	.long 0x77711111
wcr2:
        .long 0xff80000c
wcr2_val:
	.long 0xfffe67ff
/* 0xfffe45ff for CAS Latency = 2 */
/* 0xfffe67ff for CAS Latency = 3 */
wcr3:
        .long 0xff800010
wcr3_val:
	.long 0x07770077
mcr:
    	.long 0xff800014
mcr_val:
    	.long 0x080923f4
mcr_val2:
    	.long 0x480923f4
mcr_val3:
    	.long 0x480923f0

rtcsr:
        .long 0xff80001c
rtcsr_val:
	.long 0xa508
rtcnt:
        .long 0xff800020
rtcnt_val:
	.long 0xa500
rtcor:
        .long 0xff800024
rtcor_val:
	.long 0xa5f0
rtcor_val2:
	.long 0xa510
rfcr:
        .long 0xff800028
rfcr_val:
	.long 0xa400
sdmr2:
	.long 0xff9000c8
sdmr3:
	.long 0xff9400c8
/* 0xff900088 for CAS Latency = 2 */
/* 0xff9000C8 for CAS Latency = 3 */

afterram:

	mov.l	stack, r15

/* This jumps from P2 (uncached) to P0 (cached) all the nops are there
   because I am not sure what is the value of the saved PC 
   The move is before the long copy of blob from rom to ram */
   
	bsr A0
	nop
	nop

A0:

	nop
	sts pr, r6
	mov.l admask, r5
	and r5, r6
	mov #26, r5
	add r5, r6
	jmp @r6
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop

/* Copy blob from rom to ram */

	mov.l   dest, r5
	mov.l	src,  r4
	mov.l   len,  r3
	mov		#4,	  r6

cpy:
	mov.l	@r4, r2
	mov.l   r2,	@r5
	add		r6, r4
	add		r6, r5
	dt		r3
	bf		cpy
	nop

/* Now move from rom at P0 to ram at P1 */
		
	bsr B0
	nop
	nop

B0:

	nop
	sts pr, r6
	mov.l admask, r5
	and r5, r6
	mov #30, r5
	add r5, r6
	mov.l dest, r5
	add r5, r6
	jmp @r6
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop


	bsr	c_main 
        nop
        
        bra	reset

.align 2
stack:
	.long 0x08001000

admask:
	.long 0x0fffffff

dest:
	.long 0x89000000

src:
	.long 0x00000000

len:
	.long 0x00004000 /* Length in words. 64K should be enough */

c_main:	
