/*
 *
 *  Rev 10-30-91
 *  This file contains Unix specific code for setting terminal modes,
 *  very little is specific to ZMODEM or YMODEM per se (that code is in
 *  sz.c and rz.c).  The CRC-16 routines used by XMODEM, YMODEM, and ZMODEM
 *  are also in this file, a fast table driven macro version
 *
 *	V7/BSD HACKERS:  SEE NOTES UNDER mode(2) !!!
 *
 *   This file is #included so the main file can set parameters such as HOWMANY.
 *   See the main files (rz.c/sz.c) for compile instructions.
 */
/*
 *  Some systems (Venix, Coherent, Regulus) may not support tty raw mode
 *  read(2) the same way as Unix. ONEREAD must be defined to force one
 *  character reads for these systems. Added 7-01-84 CAF
 */

char linbuf[HOWMANY];
int Lleft=0;		/* number of characters in linbuf */
/* Sorry, Regulus and some others don't work right in raw mode! */
int Readnum = 1;	/* Number of bytes to ask for in read() from modem */

#define fxsendline(c) SerialOutputByte(c)
#define fsendline(c) SerialOutputByte(c)
#define sendline(c) SerialOutputByte(c)
#define xsendline(c) SerialOutputByte(c)

/*
 *  The following uses an external rdchk() routine if available,
 *  otherwise defines the function for BSD or fakes it for SYSV.
 */

static unsigned
getspeed(code)
{
	return 38400;
}



/*
 * mode(n)
 *  3: save old tty stat, set raw mode with flow control
 *  2: set XON/XOFF for sb/sz with ZMODEM or YMODEM-g
 *  1: save old tty stat, set raw mode 
 *  0: restore original tty mode
 */
mode(n)
{
}

sendbrk()
{
}

/* Initialize tty device for serial file xfer */
inittty()
{
}

flushmoc()
{
}

flushmo()
{
}

/*
 * This version of readline is reasoably well suited for
 * reading many characters.
 *
 * timeout is in tenths of seconds
 */
readline(timeout)
int timeout;
{
	static char *cdq;	/* pointer for removing chars from linbuf */

	SerialInputBlock(cdq=linbuf, Readnum, 1000000);
	return (*cdq & 0377);
}



/*
 * Purge the modem input queue of all characters
 */
purgeline()
{
	Lleft = 0;
}


/* send cancel string to get the other end to shut up */
canit()
{
	static char canistr[] = {
	 24,24,24,24,24,24,24,24,24,24,8,8,8,8,8,8,8,8,8,8,0
	};

	zmputs(canistr);
	Lleft=0;	/* Do read next time ... */
}

/*
 * Send a string to the modem, processing for \336 (sleep 1 sec)
 *   and \335 (break signal)
 */
zmputs(s)
char *s;
{
	register c;

	while (*s) {
		switch (c = *s++) {
		case '\336':
//			sleep(1); 
			continue;
		case '\335':
			sendbrk(); continue;
		default:
			SerialOutputByte(c);
		}
	}
	flushmo();
}


/* End of rbsb.c */
