#include "util.h"

#define NONE 0
#define CE  (1<<2)
#define CLE (1<<1)
#define ALE (1<<0)

#define NAND (*(volatile unsigned char *)0xA4000000)

void setlines(int lines) {
    /* ALE - bit 0
     * CLE - bit 1
     * CE  - bit 2
     */
    volatile unsigned char *jj;
    volatile unsigned char j;

    jj = (volatile unsigned char *) ( (lines<<9) | 0xb400f0ff);
    j=*jj;
}

int nand_read_id() {
    int i;

	/* Reset */
    setlines(CE);
	udelay(1);
    setlines(CLE);
    NAND=0xFF;
	udelay(500);
    setlines(CE);
	
	/* Read ID */	
    setlines(CE);
	udelay(1);
    setlines(CLE);
    NAND=0x90;
    setlines(ALE);
    NAND=0;
    setlines(NONE);
    i=NAND*256;
    i += NAND;

	setlines(CE);
	
    return i;
}

void nand_read_oob(int page, unsigned char *buf, int nandsize) {
	/* 16 bytes */
	int i;
	
	setlines(CE);
	udelay(1);
	setlines(CLE);
	NAND=0x50;
	setlines(NONE);
	setlines(ALE);
	NAND=0;
	NAND=page&0xff;
	NAND=(page>>8)&0xff;
	if(nandsize>0x10000) NAND=(page>>16)&0xff;
	setlines(NONE);
	udelay(10);

	for(i=0;i<16;i++)buf[i]=NAND;
	
	setlines(CE);
}

void nand_read(int page, unsigned char *buf, int nandsize) {
	/* 512 bytes */
	int i;
	
	setlines(CE);
	udelay(1);
	setlines(CLE);
	NAND=0;
	setlines(NONE);
	setlines(ALE);
	NAND=0;
	NAND=page&0xff;
	NAND=(page>>8)&0xff;
	if(nandsize>0x10000) NAND=(page>>16)&0xff;
	setlines(NONE);
	udelay(10);

	for(i=0;i<512;i++)buf[i]=NAND;
	
	setlines(CE);
}

int nand_erase(int page, int nandsize) {
	int i;
	
	page>>=9;
	
	setlines(CE);
	udelay(1);
	setlines(CLE);
	NAND=0x60;
	setlines(ALE);
	NAND=page&0xff;
	NAND=(page>>8)&0xff;
	if(nandsize>0x10000) NAND=(page>>16)&0xff;
	setlines(CLE);
	NAND=0xd0;
	setlines(NONE);
	udelay(3000);
	setlines(CLE);
	NAND=0x70;
	setlines(NONE);
	i=NAND;
	setlines(CE);
	return i;
}

int nand_write(int page, unsigned char *buf, int nandsize) {
	/* 528 bytes */
	int i;	
	setlines(CE);
	udelay(1);
	setlines(CLE);
	NAND=0x80;
	setlines(ALE);
	NAND=0;
	NAND=page&0xff;
	NAND=(page>>8)&0xff;
	if(nandsize>0x10000) NAND=(page>>16)&0xff;
	setlines(NONE);
	for(i=0;i<528;i++)NAND=buf[i];
	setlines(CLE);
	NAND=0x10;
	udelay(500);
	NAND=0x70;
	setlines(NONE);
	i=NAND;
	setlines(CE);
	return i;
}


