#include "util.h"

static volatile unsigned char *SCSMR = (unsigned char *) 0xffe00000;
#define SYNC 	0x80

static volatile unsigned char *SCBRR = (unsigned char *) 0xffe00004;

static volatile unsigned char *SCSCR = (unsigned char *) 0xffe00008;
#define TE		0x20
#define RE		0x10

static volatile unsigned char *SCTDR = (unsigned char *) 0xffe0000c;
static volatile unsigned char *SCSSR = (unsigned char *) 0xffe00010;
#define TDRE	0x80
#define RDRF	0x40
#define ORER	0x20
#define TEND	0x04

static volatile unsigned char *SCRDR = (unsigned char *) 0xffe00014;

void set_sci() {
    *SCSCR = 0; 
	*SCSMR = SYNC;
	*SCBRR = 1;
}


static int rev(int c) {
    	return  ((c & 0x01) << 7) | ((c & 0x02) << 5) | ((c & 0x04) << 3) | 
		((c & 0x08) << 1) | ((c & 0x80) >> 7) | ((c & 0x40) >> 5) | 
		((c & 0x20) >> 3) | ((c & 0x10) >> 1) ;
}
    
void set_cs(int card) {
    unsigned int i;
    volatile unsigned char *ii, *jj;
    volatile unsigned char j;

    i=0x1e;
    if(card!=-1)
        i &= 0xfffef>>card;
    ii = (volatile unsigned char *) (i | 0xa4000000);
    jj = (volatile unsigned char *) (i | 0xb4000000);
    j=*ii;
	j=*jj;
}

void send_command (int l, unsigned char *c)
{
	int i;
	*SCSSR = 0;
	*SCSCR = TE;
	while (l) {
		while (!(*SCSSR & TDRE)) ;
		i = rev (*c);
		*SCTDR = i;
		*SCSSR = 0;
		l--;
		c++;
	}
	while (!(*SCSSR & TEND)) ;
	*SCSCR = 0;
}

static int
read_reply (int timeout, int l, unsigned char *c)
{
	int i = 0;

	*SCSSR = 0;
	*SCSCR = RE;

	while (timeout > 0) {
		while (!(*SCSSR & RDRF)) ;
		i = *SCRDR;
		*SCSSR = 0;
		if (i != 0xff)
			timeout = -timeout;
		timeout--;
	}

	if (!timeout)
		return -1;

	c[0] = rev (i);
	for (i = 1; i < l; i++) {
		int j;
		while (!(*SCSSR & RDRF)) ;
		j = *SCRDR;
		*SCSSR = 0;
		c[i] = rev (j);
	}
	*SCSCR = 0;
	return timeout;
}

int reset_card(int card) {
	int timeout, i;
	unsigned char buf[20];

	set_cs(-1);
	udelay (5);
	timeout = 16;		/* try to reset the card 16 times */

	while (timeout > 0) {
		timeout--;
		set_cs(card);
		buf[0] = 0xff;
		buf[1] = 0x40;
		buf[2] = 0;
		buf[3] = 0;
		buf[4] = 0;
		buf[5] = 0;
		buf[6] = 0x95;
		send_command (7, buf);
		i = read_reply (128, 2, buf);
		set_cs(-1);
		if (buf[0] == 1) timeout=-8;
                
	}
	if (timeout != -8) {
		return -2;
	}

	timeout = 10240;
	while (timeout > 0) {
		timeout--;
		set_cs(card);
		buf[0] = 0xff;
		buf[1] = 0x41;
		buf[2] = 0;
		buf[3] = 0;
		buf[4] = 0;
		buf[5] = 0;
		buf[6] = 0x95;
		send_command (7, buf);
		i = read_reply (128, 2, buf);
		set_cs(-1);
                if (buf[0] == 0)
			timeout = -8;
		udelay (5);
	}

	if (timeout != -8) {
		return -3;
	}
        
	return 0;
}

static int
read_r1_data (int timeout, int l, unsigned char *c, unsigned char *st,
	      unsigned char *r1, unsigned char *crc0, unsigned char *crc1)
{
	int i = 0, t;

	*st = 0xff;
	*SCSSR = 0;
	*SCSCR = RE;

	t = timeout;

	while (t > 0) {
		while (!(*SCSSR & RDRF)) ;
		i = *SCRDR;
		*SCSSR = 0;
		if (i != 0xff)
			t = -t;
		t--;
	}
	if (!t)
		return -1;

	*r1 = rev (i);

	while (timeout > 0) {
		while (!(*SCSSR & RDRF)) ;
		i = *SCRDR;
		*SCSSR = 0;
		if (i != 0xff)
			timeout = -timeout;
		timeout--;
	}
	
	if (!timeout)
		return -1;

	*st = rev (i);
	for (i = 0; i < l; i++) {
		int j;
		while (!(*SCSSR & RDRF)) ;
		j = *SCRDR;
		*SCSSR = 0;
		c[i] = rev (j);
	}
	while (!(*SCSSR & RDRF)) ;
	i = *SCRDR;
	*SCSSR = 0;
	*crc0 = rev (i);

	while (!(*SCSSR & RDRF)) ;
	i = *SCRDR;
	*SCSSR = 0;
	*crc1 = rev (i);

/* dummy reads to run the clock */
	while (!(*SCSSR & RDRF)) ;
	i = *SCRDR;
	*SCSSR = 0;
	while (!(*SCSSR & RDRF)) ;
	i = *SCRDR;
	*SCSSR = 0;

	*SCSCR = 0;

	return timeout;
}

void read_block (int bn, unsigned char *buf, int cs)
{
	unsigned char st, r1, crc0, crc1;

	bn <<= 9;
	set_cs(cs);
	buf[0] = 0xff;
	buf[1] = 0x51;
	buf[2] = (bn >> 24) & 0xff;
	buf[3] = (bn >> 16) & 0xff;
	buf[4] = (bn >> 8) & 0xff;
	buf[5] = bn & 0xff;
	buf[6] = 0x80;

	send_command (7, buf);
	set_cs(-1);
	udelay (1);
	set_cs(cs);
	read_r1_data (4096, 512, buf, &st, &r1, &crc0, &crc1);
	
}

