#include "serial.h"
#include "util.h"

void dmb(char *commandline) {
    unsigned char *ad;
    u32 value;
    
    GetHexValue(commandline,(unsigned int *)&ad);
    
    value=*ad;
    SerialOutputHex(value);
    SerialOutputString("\r\n");
    
}
void dmw(char *commandline) {
    unsigned short *ad;
    u32 value;
    
    GetHexValue(commandline,(unsigned int *)&ad);
    
    value=*ad;
    SerialOutputHex(value);
    SerialOutputString("\r\n");
    
}
void dml(char *commandline) {
    unsigned int *ad;
    u32 value;
    
    GetHexValue(commandline,(unsigned int *)&ad);
    
    value=*ad;
    SerialOutputHex(value);
    SerialOutputString("\r\n");
    
}

void mmb(char *commandline) {
    unsigned char *ad;
    u32 len, value;
	int j;
    
    commandline=GetHexValue(commandline,(unsigned int *)&ad);
    GetHexValue(commandline,(unsigned int *)&len);
	while(1) {
		SerialOutputHex((unsigned int)ad);
		for(j=0;j<8;j++) {
			SerialOutputString(" ");
			value=*ad;
			SerialOutputHexNib(value, 2);
			ad++;
			len--;
			if(!len) {
				SerialOutputString("\r\n");
				return;
			}
		}
		
		SerialOutputString("\r\n");
	}
}

void mmw(char *commandline) {
    unsigned short *ad;
    u32 len, value;
	int j;
    
    commandline=GetHexValue(commandline,(unsigned int *)&ad);
    GetHexValue(commandline,(unsigned int *)&len);
	while(1) {
		SerialOutputHex((unsigned int)ad);
		for(j=0;j<8;j++) {
			SerialOutputString(" ");
			value=*ad;
			SerialOutputHexNib(value, 4);
			ad++;
			len--;
			if(!len) {
				SerialOutputString("\r\n");
				return;
			}
		}
		SerialOutputString("\r\n");
	}
}

void mml(char *commandline) {
    unsigned int *ad;
    u32 len, value;
	int j;
    
    commandline=GetHexValue(commandline,(unsigned int *)&ad);
    GetHexValue(commandline,(unsigned int *)&len);
	while(1) {
		SerialOutputHex((unsigned int)ad);
		for(j=0;j<8;j++) {
			SerialOutputString(" ");
			value=*ad;
			SerialOutputHexNib(value, 8);
			ad++;
			len--;
			if(!len) {
				SerialOutputString("\r\n");
				return;
			}
		}
		SerialOutputString("\r\n");
	}
}

void smb(char *commandline) {
    unsigned char *ad;
    u32 value;
    
    commandline=GetHexValue(commandline,(unsigned int *)&ad);
    GetHexValue(commandline,(unsigned int *)&value);    
    *ad=value;
    
}
void smw(char *commandline) {
    unsigned short *ad;
    u32 value;
    
    commandline=GetHexValue(commandline,(unsigned int *)&ad);
    GetHexValue(commandline,(unsigned int *)&value);    
    *ad=value;
    
}
void sml(char *commandline) {
    unsigned int *ad;
    u32 value;
    
    commandline=GetHexValue(commandline,(unsigned int *)&ad);
    GetHexValue(commandline,(unsigned int *)&value);    
    *ad=value;
    
}


