typedef struct
{
	unsigned chunkId:20;
	unsigned serialNumber:2;
	unsigned byteCount:10;
	unsigned objectId:18;
	unsigned ecc:12;
	unsigned unusedStuff:2;
} yaffs_Tags;

typedef union
{
	yaffs_Tags asTags;
	unsigned char asBytes[8];
} yaffs_TagsUnion;

int load_yaffs(int, int, int);

void yaffs_ECCCalculate(const unsigned char *data,unsigned char *ecc);
int yaffs_ECCCorrect(unsigned char *data, unsigned char *read_ecc, const unsigned char *test_ecc);
int yaffs_CountBits(int x);

