/* Emulation of the Z80 CPU with hooks into the other parts of z81.
 * Copyright (C) 1994 Ian Collier.
 * z81 changes (C) 1995-2001 Russell Marks.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define DEBUG 0
#define SNDBUFSIZE 441

#include "z80.h"

#include "string.h"
#include "const.h"
#include <stdio.h>

#define parity(a) (partable[a])

#define in(h,l) ink(h,l,keyb)
#define out(h,l,a) outo(h,l,a,tstates,&out254,shared,&pos)

unsigned char ink(int h, int l, unsigned char *k);
unsigned char outo(int h, int l, int a, int tstates, unsigned char *o, 
		struct shared_t *shared, int *pos);

void mainloop(struct shared_t *shared)
{
	int cc;
	unsigned char a, f, b, c, d, e, h, l;
	unsigned char r, a1, f1, b1, c1, d1, e1, h1, l1, i, iff1, iff2, im;
	unsigned short pc;
	unsigned short ix, iy, sp;
	unsigned int radjust;
	unsigned char ixoriy, new_ixoriy;
	unsigned char intsample;
	unsigned char op;
	unsigned char *memram, *memrom;
	unsigned int tstates, tsmax;
	unsigned char partable[256];
	unsigned int counter;
	unsigned char out254;
	int n;
	int pos;
	unsigned char keyb[9];

	pos=0;

	for(n = 0; n < 256; n += 16) {
		int j, l;
		l = 0x9669 & (1 << (n >> 4)) ? 0x9669 : 0x6996;
		for(j = 0; j < 16; j++) {
			partable[n + j] = 4 * (l & 1);
			l >>= 1;
		}
	}

	memram = shared->ram;
	memrom = shared->rom;
	tstates = shared->tstates;
	tsmax = shared->event_next_event;
#define S(a) a=shared->a
	S(counter);
	S(a);
	S(f);
	S(b);
	S(c);
	S(d);
	S(e);
	S(h);
	S(l);
	r=shared->r|0x80;
	S(a1);
	S(f1);
	S(b1);
	S(c1);
	S(d1);
	S(e1);
	S(h1);
	S(l1);
	S(i);
	S(iff1);
	S(iff2);
	S(im);
	S(pc);
	S(ix);
	S(iy);
	S(sp);
	for(n = 0; n < 9; n++)
		keyb[n] = shared->k[n];
	S(out254);
	
	shared->sndsample=0;
	
	ixoriy = new_ixoriy = 0;
	tstates = radjust = 0;
	cc = 1;
	while(1) {
//fprintf(stderr, "%04x, %02x,  %i, %i\n", pc, memram[0], tstates, tsmax);
		ixoriy = new_ixoriy;
		new_ixoriy = 0;
		intsample = 1;
		if(!counter || !cc || !iff1) {
			op = fetch(pc);
			pc++;
		} else {
#if 0
			op = 0xff;
			cc = 0;
#else
			if(im!=2) {
				op = 0xff;			/* rst 38 */
				cc = 0;
			} else  {
				int a;
				sp-=2;
				iff1=0;
				store2(sp, pc);
				a=((unsigned int)i<<8)+255;
				pc=fetch2(a);
				tstates+=19;
				op=fetch(pc);
				pc++;
				cc=0;
			}
#endif
		}
		radjust++;

		switch (op) {
#include "z80ops.c"
		}
		if((tstates > tsmax) && !new_ixoriy) {
#undef S
#define S(a) shared->a=a
	S(a);
	S(f);
	S(b);
	S(c);
	S(d);
	S(e);
	S(h);
	S(l);
	S(r);
	S(a1);
	S(f1);
	S(b1);
	S(c1);
	S(d1);
	S(e1);
	S(h1);
	S(l1);
	S(i);
	S(iff1);
	S(iff2);
	S(im);
	S(pc);
	S(ix);
	S(iy);
	S(sp);
	S(tstates);
	S(out254);
//fprintf(stderr,"%08x %i %i %08x\n", shared->sound, shared->sndwrite, pos, shared);
	memset(shared->sound+SNDBUFSIZE*shared->sndwrite+pos,
	                      shared->sndsample, SNDBUFSIZE-pos);
			return;
		}
	}
}

unsigned char ink(int h, int l, unsigned char *k)
{
	int i;
	unsigned char j;
	switch (l) {
	case 31:
		return k[8]^0x1f;
		break;
	case 254:
		j = 255;
		for(i = 0; i < 8; i++)
			if(!(h & (1 << i)))
				j &= k[i];
		return j;
		break;
	default:
		return 255;
	}
}

unsigned char outo(int h, int l, int a, int tstates, unsigned char *o, 
		struct shared_t *shared, int *pos)
{
	if(!(l & 1)) {
		*o = a;
		{
			int p;
			unsigned char c=(a&0x10)<<2;
			p=tstates*1000/158731;
//fprintf(stderr,"%08x %i %i %i %08x\n", shared->sound, shared->sndwrite, *pos, p, shared);
			if(p>*pos) {
				memset(shared->sound+SNDBUFSIZE*shared->sndwrite+*pos, 
						c, p-*pos);
			}
			shared->sndsample=64-c;
			*pos=p;
		}
	}
	return 0;
}
