#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include <errno.h>
#include <SDL.h>

#include "const.h"
#include "font.h"

void loadsnap(struct shared_t *emudata,  char *name, struct prefs_t *prefs);

#define DISPLAY_BORDER_WIDTH 0
#define DISPLAY_BORDER_HEIGHT 0

extern unsigned int pal[];

void uidisplay_putpixel(struct shared_t *emudata, int x, int y, int col) {
	emudata->sc[(S_Y+(y)*2)*SCREEN_WIDTH+x*2]=pal[col];
	emudata->sc[(S_Y+(y)*2)*SCREEN_WIDTH+x*2+1]=pal[col];
	emudata->sc[(S_Y+(y)*2+1)*SCREEN_WIDTH+x*2]=pal[col];
	emudata->sc[(S_Y+(y)*2+1)*SCREEN_WIDTH+x*2+1]=pal[col];
}

void printchar(struct shared_t *emudata, int x, int y, int col, int ch) {
    
    int mx, my;

    if((ch<32)||(ch>127)) ch=33;
    ch-=32;
    
    for(my=0; my<8; my++) {
        int b;
        b=font[ch*8+my];
        for(mx=0; mx<8; mx++) {
            if(b&128) uidisplay_putpixel(emudata, 
					mx+DISPLAY_BORDER_WIDTH+8*x, my+DISPLAY_BORDER_HEIGHT+8*y, col);
            b<<=1;
        }
    }
}

void printstring(struct shared_t *emudata, int x, int y, int col, char *s) {
    int i;
    i=0;
    if(s) {
        while((x<32) && s[i]) {
            printchar(emudata, x,y,col,s[i]);
            i++;
            x++;
        }
    }
}

void rect(struct shared_t *emudata, int x, int y, int w, int h, int col) {
	SDL_Rect r;
	r.x=S_X+x*2;
	r.y=S_Y+y*2;
	r.w=w*2;
	r.h=h*2;
	SDL_FillRect(emudata->screen, &r, pal[col]);
}

/* ------------------------------------------------------------------ */

static int numfiles;
static char filenames[8192][64];

static int select_file(const struct dirent *dirent){
    if(dirent->d_name && strcmp(dirent->d_name,".")) {
        strncpy(filenames[numfiles], dirent->d_name, 63);
        numfiles++;
    }
    return 0;
}

static void scan(char *dir) {
    struct dirent **d;
    numfiles=0;
    scandir(dir,&d,select_file,NULL);
    qsort(filenames[0], numfiles, 64, strcmp);
}

static int i,k;

void selectfile(struct shared_t *emudata) {
    char d[512];
    int j;
    char s[14];
   
    getcwd(d,510);
    scan(d);
    i=0;
    k=0;
    
    rect(emudata, 6,6,244,180,9);
    rect(emudata, 8,8,240,176,8);
    for(j=0;j<36;j++) if(i+j<numfiles){
        strncpy(s,filenames[i+j],13);
        s[13]=0;
        printstring(emudata, 2+(j&1)*15, 3+j/2, 2, s);
    }
    strncpy(s,filenames[k],13);
    s[13]=0;
    printstring(emudata, 2+(k&1)*15, 3+k/2, 1, s);
	SDL_Flip(emudata->screen);
    strncpy(s,filenames[k],13);
    s[13]=0;
    printstring(emudata, 2+(k&1)*15, 3+k/2, 2, s);
}

int handlekeys(struct shared_t *emudata, int key, char *name) {
    int nk;
    char fn[1024];
    nk=k;
    switch(key) {
        case '1':
			name[0]='\0';
			return 1;
        case '8':
            if(k<numfiles-1)nk++;
            break;
        case '6':
            if(k<numfiles-2)nk+=2;
            break;
        case '5':
            if(k>0)nk--;
            break;
        case '7':
            if(k>1)nk-=2;
            break;
		case 64 ... 95:
			nk=key-64;
			break;
        case '0':
            getcwd(fn,500);
            strcat(fn,"/");
            strncat(fn,filenames[k],500);
            if(chdir(fn)==-1) {
                if(errno==ENOTDIR) {
                    strcpy(name, fn);
					return 1;
                }
            } else {
                selectfile(emudata);
                nk=0;
            }
            break;
    }
    if(nk!=k) {
        char s[14];
        int r;
        
        r=0;
        if(nk<i) {
            i=nk&~1;
            r=1;
        }
        if(nk>i+35) {
            i=nk&~1;
            i-=34;
            r=1;
        }
        if(r) {
            int j;
            rect(emudata, 8,8,240,176,8);
            for(j=0;j<36;j++) if(i+j<numfiles){
                strncpy(s,filenames[i+j],13);
                s[13]=0;
                printstring(emudata, 2+(j&1)*15, 3+j/2, 2, s);
            }
        }
        
        strncpy(s,filenames[nk],13);
        s[13]=0;
        printstring(emudata, 2+((nk-i)&1)*15, 3+(nk-i)/2, 1, s);
		SDL_Flip(emudata->screen);
        strncpy(s,filenames[nk],13);
        s[13]=0;
        printstring(emudata, 2+((nk-i)&1)*15, 3+(nk-i)/2, 2, s);
        k=nk;
    }
	return 0;
}
