#include <stdlib.h>
#include <unistd.h>
#include <SDL.h>
#include <string.h>
#include "const.h"

#define N800 1
#if N800
int r0=0;
int r1=0;
#endif

void soundcb (void *userdata,  unsigned char *buffer, int l) {
    struct shared_t *emudata=userdata;
#if N800
    int q, wp;
//fprintf(stderr, "h %i %i   %i %i\n", emudata->counter, emudata->scounter, emudata->sndwrite, r1);
    wp=SNDBUFLEN*emudata->sndwrite;
//    if(wp>=r1 && wp-r1<l) return;
//    if(wp<r1 && NUMSNDBUFS*SNDBUFLEN-r1+wp<l) return;
    q=l+r0;
    r0=q % SNDBUFLEN;
    emudata->scounter+=q/SNDBUFLEN;
//fprintf(stderr, " t\n");
    if(r1+l<=NUMSNDBUFS*SNDBUFLEN) {
	    memcpy(buffer, emudata->sound+r1, l);
	    r1+=l;
    } else {
	    memcpy(buffer, emudata->sound+r1, NUMSNDBUFS*SNDBUFLEN-r1);
	    l-=NUMSNDBUFS*SNDBUFLEN-r1;
	    if(l)memcpy(buffer+NUMSNDBUFS*SNDBUFLEN-r1, emudata->sound, l);
	    r1=l;
    }
    
#else
    emudata->scounter++;

    if(l>SNDBUFLEN)l=SNDBUFLEN;

    memcpy(buffer, emudata->sound+emudata->sndread*SNDBUFLEN, l);
    if(++emudata->sndread == NUMSNDBUFS)emudata->sndread=0;
#endif

}

int initsound(struct status_t *stat, struct shared_t *emudata) {
	SDL_AudioSpec *desired, obtained;
	
	if(stat->sndinited) return 0;
	
	stat->sndinited=1;
	stat->sndwant=0;

	desired=malloc(sizeof(SDL_AudioSpec));
	desired->freq=22050;
	desired->format=AUDIO_U8;
	desired->samples=SNDBUFLEN;
	desired->channels=1;
	desired->callback=soundcb;
	desired->userdata=emudata;

	if(SDL_OpenAudio(desired, &obtained)<0) {
		fprintf(stderr, "Couldn't open audio: %s\n", SDL_GetError());
	}
fprintf(stderr, "Obtained audio: freq=%i format=%i channels=%i samples=%i\n",
		obtained.freq, obtained.format, obtained.channels, obtained.samples);
	
	return 0;
}

void uninit_audio(void) {
	SDL_PauseAudio(1);
	usleep(100000);
	SDL_CloseAudio();
}

void run_audio(struct status_t *stat, struct shared_t *emudata) {
	if(!stat->sndinited) initsound(stat, emudata);

	memset(emudata->sound, NUMSNDBUFS*SNDBUFLEN, 0);
	emudata->sndread=0;
	emudata->sndwrite=0;
#if N800
	r1=0;
#endif
	stat->sndrunning=0;
	stat->sndwant=1;
	emudata->scounter = emudata->counter;
	emudata->sndsample = 0;
}

void pause_audio(struct status_t *stat) {
	SDL_PauseAudio(1);
	stat->sndrunning=0;
	stat->sndwant=0;
}

void unpause_audio(struct status_t *stat) {
	SDL_PauseAudio(0);
	stat->sndrunning=1;
	stat->sndwant=1;
}
