#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include "const.h"
#include <SDL.h>
#include <libgen.h>

#define DATASIZE 60000

struct hkeys_s hkeys[7] =
{ /* name, "esc menu home zoom - +  right left down up middle" */
  /* name, "esc f4   f5   f6  f8 f7 right left down up return" */
{ "default", "\0\0\026\0\0\030\01\02\03\04\05"},
{ "pinball", "\n000qppqqp0"},
{ "aticatac", "02\05z20\01\02\03\04\05"},
{ "hskiing", "0\0\0\0\0\00076890"},
{ "krakout", "0\0 pl0lplp "},
{ "maziacs", "bjd\05bj\01\02\03\04\05"},
{ "", ""},
};


void loadz80(struct shared_t *emudata, unsigned char *s, struct prefs_t *prefs) {
	unsigned char k[10];
	unsigned char data[DATASIZE];
	int i;
	int z80v;
	unsigned int p, q;

	for(i=0;i<9;i++)k[i]=144+i;

	z80v=0;
	
	emudata->a = s[0];
	emudata->f = s[1];
	emudata->b = s[3];
	emudata->c = s[2];
	emudata->d = s[14];
	emudata->e = s[13];
	emudata->h = s[5];
	emudata->l = s[4];
	emudata->r = 0x80&(s[12]<<7);
	emudata->i = i;
	emudata->im = s[29]&3;
	emudata->iff1 = s[27];
	emudata->iff2 = s[28];
	emudata->sp = s[8]+256*s[9];
	emudata->ix = s[25]+256*s[26];
	emudata->iy = s[23]+256*s[24];
	emudata->a1 = s[21];
	emudata->f1 = s[22];
	emudata->b1 = s[16];
	emudata->c1 = s[15];
	emudata->d1 = s[18];
	emudata->e1 = s[17];
	emudata->h1 = s[20];
	emudata->l1 = s[19];
	emudata->out254 &= 0xf8;
	emudata->out254 |= (s[12]>>1)&7;
	emudata->pc = s[6]+256*s[7];

	if(emudata->pc==0) {
		z80v=1;
		
		q=s[30]+s[31];
		q+=32;
		memcpy(data, s+q, DATASIZE-q);

		emudata->pc = s[32] + 256*s[33];	
	} else {
		z80v=0;
		memcpy(data, s+30, DATASIZE-30);
	}

	q=0;
	if(z80v==1) {
		unsigned int size;
		for(i=0;i<3;i++) {
			size=data[q]+256*data[q+1];
			q+=2;
			switch(data[q]) {
				case 8:
					p=0;
					break;
				case 4:
					p=0x4000;
					break;
				case 5:
					p=0x8000;
					break;
				default:
					p=0;
			}
			q++;
			while(size>0) {
				size--;
				if(q>=DATASIZE || p>=0xc000) {
					return ;
				}
				if(data[q]==0xed && data[q+1]==0xed) {
					if(p+data[q+2]>=0xc000) {
						return ;
					}
					memset(emudata->ram+p, data[q+3], data[q+2]);
					p+=data[q+2];
					q+=4;
					size-=3;
				} else {
					emudata->ram[p]=data[q];
					p++;
					q++;
				}
			}
		}
	} else if(z80v==0) {
		p=0;
		q=0;
		while(p<0xc000) {
			if(data[q]==0xed && data[q+1]==0xed) {
				memset(emudata->ram+p, data[q+3], data[q+2]);
				p+=data[q+2];
				q+=4;
			} else {
				emudata->ram[p]=data[q];
				p++;
				q++;
			}
		}
	}
		
	//getkeys(n, prefs, k);

}

void loadsna(struct shared_t *emudata, unsigned char *s, struct prefs_t *prefs) {
	unsigned char k[10];
	int i;

	for(i=0;i<9;i++)k[i]=144+i;

	memcpy(emudata->ram, s+27, 49152);

	emudata->a = s[22];
	emudata->f = s[21];
	emudata->b = s[14];
	emudata->c = s[13];
	emudata->d = s[12];
	emudata->e = s[11];
	emudata->h = s[10];
	emudata->l = s[9];
	emudata->r = s[20];
	emudata->i = s[0];
	emudata->im = s[25];
	emudata->iff1 = (s[19]&4)>>2;
	emudata->iff2 = (s[19]&4)>>2;
	emudata->sp = s[23]+256*s[24];
	emudata->ix = s[17]+256*s[18];
	emudata->iy = s[15]+256*s[16];
	emudata->a1 = s[8];
	emudata->f1 = s[7];
	emudata->b1 = s[6];
	emudata->c1 = s[5];
	emudata->d1 = s[4];
	emudata->e1 = s[3];
	emudata->h1 = s[2];
	emudata->l1 = s[1];
	emudata->out254 &= 0xf8;
	emudata->out254 |= s[26]&7;
	emudata->pc = emudata->ram[emudata->sp-0x4000]+256*emudata->ram[emudata->sp-0x3fff];
	emudata->sp += 2;
	
//	getkeys(n, prefs, k);
}

void savesna(struct shared_t *emudata, char *name, struct prefs_t *prefs) {
	unsigned char s[28];
	unsigned char s1, s2;
	int f;

	s[22] = emudata->a;
	s[21] = emudata->f;
	s[14] = emudata->b;
	s[13] = emudata->c;
	s[12] = emudata->d;
	s[11] = emudata->e;
	s[10] = emudata->h;
	s[9] = emudata->l;
	s[20] = emudata->r;
	s[0] = emudata->i;
	s[25] = emudata->im;
	s[19] = emudata->iff1<<2;
	s[8] = emudata->a1;
	s[7] = emudata->f1;
	s[6] = emudata->b1;
	s[5] = emudata->c1;
	s[4] = emudata->d1;
	s[3] = emudata->e1;
	s[2] = emudata->h1;
	s[1] = emudata->l1;
	s[26] = emudata->out254 & 7;
	emudata->sp-=2;
	s1=emudata->ram[emudata->sp-0x4000];
	s2=emudata->ram[emudata->sp-0x3fff];
	emudata->ram[emudata->sp-0x4000]=emudata->pc&0xff;
	emudata->ram[emudata->sp-0x3fff]=(emudata->pc>>8)&0xff;
	s[23]=emudata->sp&0xff;
	s[24]=(emudata->sp>>8)&0xff;
	s[15]=emudata->iy&0xff;
	s[16]=(emudata->iy>>8)&0xff;
	s[17]=emudata->ix&0xff;
	s[18]=(emudata->ix>>8)&0xff;

	f=open(name, O_WRONLY|O_CREAT);
	write(f, s, 27);
	write(f, emudata->ram, 49152);
//	write(f, prefs->hardkeys, 9);
	close(f);

	emudata->ram[emudata->sp-0x4000]=s1;
	emudata->ram[emudata->sp-0x3fff]=s2;
	emudata->sp+=2;
}

void loadsnap(struct shared_t *emudata,  char *name, struct prefs_t *prefs) {
	unsigned char d[60000];
	char *bname;
	int f, l;
	struct hkeys_s *h;
	
	f=open(name, O_RDONLY);
	if(f>=0) {
		l=read(f, d, 60000);
		close(f);

		if(strstr(name,".z80") || strstr(name,".Z80") )
			loadz80(emudata, d,prefs); else loadsna(emudata, d, prefs);
		h=hkeys;
		bname=basename(name);
		while(h->name[0]) {
			if (!strncmp(h->name, bname, strlen(h->name))) {
				memcpy(prefs->hardkeys, h->keys, 11);
				break;
			}
			h++;
		}
	}
}

void savesnap(struct shared_t *emudata, char *name, struct prefs_t *prefs) {
	savesna( emudata, name, prefs);
}
