#include <const.h>

unsigned int pal[16]=
{
	0,
	0x00180018,
	0xc000c000,
	0xc018c018,
	0x06000600,
	0x06180618,
	0xc600c600,
	0xc618c618,
	0,
	0x001f001f,
	0xf800f800,
	0xf81ff81f,
	0x07e007e0,
	0x07ff07ff,
	0xffe0ffe0,
	0xffffffff
};

unsigned long refresh (struct shared_t *emudata) {

	int ad, bm, at,xy;
	int i, j, k, fl;
	unsigned int counter;
	unsigned char *memram;
	unsigned int *sc;
	unsigned char border, lastborder;

	sc= (unsigned int *)emudata->sc;
	memram= emudata->ram;
	counter = emudata->counter;
	border = emudata->out254&7;
	lastborder = emudata->lastborder&7;
	
	ad=0;
	bm=0;
	at=6144;

	if(counter%50>24)fl=1; else fl=0;
	
	ad=0;
	for(i=0;i<3;i++) {
		xy=((S_Y+i*128)*SCREEN_WIDTH+(S_X)*8)/2;
		for(j=0;j<256;j++) {
			int f, b;
			at=6144+i*256+j;
			f=memram[at]&7;
			b=(memram[at]&0x78)>>3;
			if(b&8)f+=8;
			if(memram[at]&0x80 && fl) {
				int x;
				x=f;
				f=b;
				b=x;
			}

			for(k=0;k<2048;k+=256) {
#if 1
				int q,z;
				unsigned int pf,pb;
#define SCF {sc[z]=pf ; sc[xy]=pf;} 	
#define SCB {sc[z]=pb ; sc[xy]=pb;}
				z=xy+SCREEN_WIDTH/2;
				q=memram[ad+k];
				pf=pal[f];
				pb=pal[b];
				if(q&0x80)SCF else SCB;
				xy++;z++;
				if(q&0x40)SCF else SCB;
				xy++;z++;
				if(q&0x20)SCF else SCB;
				xy++;z++;
				if(q&0x10)SCF else SCB;
				xy++;z++;
				if(q&0x08)SCF else SCB;
				xy++;z++;
				if(q&0x04)SCF else SCB;
				xy++;z++;
				if(q&0x02)SCF else SCB;
				xy++;z++;
				if(q&0x01)SCF else SCB;
				xy+=SCREEN_WIDTH-7;
#else
#define SCF {sc[xy+SCREEN_WIDTH/2]=pal[f] ; sc[xy++]=pal[f];} 	
#define SCB {sc[xy+SCREEN_WIDTH/2]=pal[b] ; sc[xy++]=pal[b];}
				if(memram[ad+k]&0x80)SCF else SCB;
				if(memram[ad+k]&0x40)SCF else SCB;
				if(memram[ad+k]&0x20)SCF else SCB;
				if(memram[ad+k]&0x10)SCF else SCB;
				if(memram[ad+k]&0x08)SCF else SCB;
				if(memram[ad+k]&0x04)SCF else SCB;
				if(memram[ad+k]&0x02)SCF else SCB;
				if(memram[ad+k]&0x01)SCF else SCB;
				xy+=SCREEN_WIDTH-8;
#endif
			}
			ad++;
			if((j&31) == 31)xy-=8*31 ; else xy-=8*SCREEN_WIDTH-8;
		}
		ad+=2048-256;
	}
	
#if 0
	if(border != lastborder) {
		xy=12*320-32;
		for(i=0;i<xy;i++)sc[i]=border;
		for(i=204*320-32;i<216*320;i++)sc[i]=border;
		for(i=12;i<204;i++) {
			int j;
			for(j=0;j<64;j++)sc[xy++]=border;
			xy+=256;
		}
		userData68KP[99]++;
	}
#endif
	return 0;
}
