#include <SDL.h>
#include "const.h"
#include "keyboard.h"

struct hkeys_s hkeys[];

int getkey(int s) {
    int x=-1;
    switch (s) {
        case SDLK_ESCAPE:
            x=0;
            break;
        case SDLK_F4:
            x=1;
            break;
        case SDLK_F5:
            x=2;
            break;
        case SDLK_F6:
            x=3;
            break;
        case SDLK_F8:
            x=4;
            break;
        case SDLK_F7:
            x=5;
            break;
        case SDLK_RIGHT:
            x=6;
            break;
        case SDLK_LEFT:
            x=7;
            break;
        case SDLK_DOWN:
            x=8;
            break;
        case SDLK_UP:
            x=9;
            break;
        case SDLK_RETURN:
            x=10;
            break;
        default:
            break;
    }
    return x;
}

#define ROW(i) (i>>4)
#define PRESS(i) (~(1<<(i&15)))
#define RELEASE(i) (1<<(i&15))

#define NUMKEYS (sizeof(keys)/sizeof(keys[1]))

void setkey(int c, struct shared_t *emudata) {
    if(c<NUMKEYS) {
        if(c==keys[c].c) {
            if(keys[c].k1!=-1)emudata->k[ROW(keys[c].k1)]&=PRESS(keys[c].k1);
            if(keys[c].k2!=-1)emudata->k[ROW(keys[c].k2)]&=PRESS(keys[c].k2);
            return;
        }
    }
}

void resetkey(int c, struct shared_t *emudata) {
    if(c<NUMKEYS) {
        if(c==keys[c].c) {
            if(keys[c].k1!=-1)emudata->k[ROW(keys[c].k1)]|=RELEASE(keys[c].k1);
            if(keys[c].k2!=-1)emudata->k[ROW(keys[c].k2)]|=RELEASE(keys[c].k2);
            return;
        }
    }
}

