#!/bin/sh
# $Id; signpkg.sh $
#

# Due to aegis file addition differences in scratchbox and MADDE environments
# This tool will add _aegis to the archive if
# 1) it is not present already (MADDE-added, that is) and
# 2) $2 points to aegis file.

set -eu

die () { echo "$@" >&2; exit 1; }

aegisfile=${2:-}

case ${1:-} in '') die "Usage: $0 pkgname" ;;
	*.deb) ;;
	debian/changelog) eval `perl -nlx $0 debian/changelog` ;;
	*) die "'$1' does not end with .deb" ;;
esac

test -f "$1" || die "'$1': not a file."

wd='_signw'

test -d $wd && die "Dir '$wd' is on the way" || :
trap "rm -rf $wd" 0 INT TERM HUP
mkdir $wd

case $1 in /*) f="$1" ;; *) f="../$1" ;; esac

( cd $wd; ar vx $f )

case $aegisfile in '') ;; *) test -f $wd/_aegis || {
	test -f "$aegisfile" && cp "$aegisfile" $wd/_aegis || :; } ;;
esac

af=
addf ()
{
    if test -f $wd/$1
    then	af="$af $1"
		cat $wd/$1 >> $wd/_signdata
		echo Adding to signfile: $1
    fi
}
addf debian-binary
addf control.tar.gz
addf data.tar.gz
addf _aegis

tar -C $wd --strip-components=1 -zxf dot-gnupg.tar.gz
chmod 700 $wd

rm -f $wd/_gpgsig # if any
/usr/bin/gpg --homedir=`pwd`/$wd --batch --default-key 23E266DD -abs \
	-o $wd/_gpgsig $wd/_signdata

echo Recreating "'$1'"
#test -f "$1.orig" && rm -f "$1" || mv "$1" "$1.orig"
rm -f "$1"

( cd $wd; ar rv $f $af _gpgsig )

exit 0

#!perl

my @l;
if (/^\s*(\S+)\s+\(\s*(\S+?)\s*\)\s/) {
	warn "Looking match for '../$1_$2*.deb'\n";
	@l = glob "../$1_$2*.deb"; last;
}
END {
	print("set '$l[0]'"), return 0 if @l == 1;
	warn "Too many or too few matches: '@l'\n";
	print 'exit 1';
}
