/*
 * tiomap_io.h
 *
 * DSP-BIOS Bridge driver support functions for TI OMAP processors.
 *
 * Definitions, types and function prototypes for the io (r/w external mem).
 *
 * Copyright (C) 2005-2006 Texas Instruments, Inc.
 *
 * This package is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * THIS PACKAGE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef _TIOMAP_IO_
#define _TIOMAP_IO_

/*
 * Symbol that defines beginning of shared memory.
 * For OMAP (Helen) this is the DSP Virtual base address of SDRAM.
 * This will be used to program DSP MMU to map DSP Virt to GPP phys.
 * (see dspMmuTlbEntry()).
 */
#define SHMBASENAME "SHM_BEG"
#define EXTBASE     "EXT_BEG"
#define EXTEND      "_EXT_END"
#define DYNEXTBASE  "_DYNEXT_BEG"
#define DYNEXTEND   "_DYNEXT_END"
#define IVAEXTMEMBASE   "_IVAEXTMEM_BEG"
#define IVAEXTMEMEND   "_IVAEXTMEM_END"
#define PWRM_RESTORE	"_PWRM_restore"

#define DSP_TRACESEC_BEG  "_BRIDGE_TRACE_BEG"
#define DSP_TRACESEC_END  "_BRIDGE_TRACE_END"

#define SYS_PUTCBEG               "_SYS_PUTCBEG"
#define SYS_PUTCEND               "_SYS_PUTCEND"
#define BRIDGE_SYS_PUTC_CURRENT   "_BRIDGE_SYS_PUTC_current"

#define WORDSWAP_ENABLE 0x3	/* Enable word swap */

/*
 *  ======== read_ext_dsp_data ========
 *  Reads it from DSP External memory. The external memory for the DSP
 * is configured by the combination of DSP MMU and shm Memory manager in the CDB
 */
extern dsp_status read_ext_dsp_data(struct wmd_dev_context *dev_context,
				    OUT u8 *pbHostBuf, u32 dwDSPAddr,
				    u32 ul_num_bytes, u32 ulMemType);

/*
 *  ======== write_dsp_data ========
 */
extern dsp_status write_dsp_data(struct wmd_dev_context *dev_context,
				 OUT u8 *pbHostBuf, u32 dwDSPAddr,
				 u32 ul_num_bytes, u32 ulMemType);

/*
 *  ======== write_ext_dsp_data ========
 *  Writes to the DSP External memory for external program.
 *  The ext mem for progra is configured by the combination of DSP MMU and
 *  shm Memory manager in the CDB
 */
extern dsp_status write_ext_dsp_data(struct wmd_dev_context *dev_context,
				     IN u8 *pbHostBuf, u32 dwDSPAddr,
				     u32 ul_num_bytes, u32 ulMemType,
				     bool bDynamicLoad);

/*
 * ======== write_ext32_bit_dsp_data ========
 * Writes 32 bit data to the external memory
 */
extern inline void write_ext32_bit_dsp_data(IN const
					    struct wmd_dev_context *dev_context,
					    IN u32 dwDSPAddr, IN u32 val)
{
	*(u32 *) dwDSPAddr = ((dev_context->tc_word_swap_on) ? (((val << 16) &
								 0xFFFF0000) |
								((val >> 16) &
								 0x0000FFFF)) :
			      val);
}

/*
 * ======== read_ext32_bit_dsp_data ========
 * Reads 32 bit data from the external memory
 */
extern inline u32 read_ext32_bit_dsp_data(IN const struct wmd_dev_context
					  *dev_context, IN u32 dwDSPAddr)
{
	u32 ret;
	ret = *(u32 *) dwDSPAddr;

	ret = ((dev_context->tc_word_swap_on) ? (((ret << 16)
						  & 0xFFFF0000) | ((ret >> 16) &
								   0x0000FFFF))
	       : ret);
	return ret;
}

#endif /* _TIOMAP_IO_ */
