/*
 * linux/arch/arm/mach-omap2/sec_hal.h
 *
 * Copyright (C) 2008 - 2010 Nokia Corporation
 * Author: Urpo Pietikäinen <urpo.pietikainen@offcode.fi>
 *         Dmitry Kasatkin <dmitry.kasatkin@nokia.com>
 *
 * OMAP3 HS HAL API header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef SEC_HAL_H
#define SEC_HAL_H

#define BB5_COMMON_HEADER_MAGIC		0x809795A3UL
#define BB5_STARTUP_OFFSET		328
#define BB5_COMMON_HEADER_SIZE		976

/* Service identifiers */
#define SEC_HAL_PUB_KEY_CERT_IMPORT	1
#define SEC_HAL_RD_CERT_IMPORT		2
#define SEC_HAL_PPA_LOAD		3
#define SEC_HAL_INITIALSW_START		4
#define SEC_HAL_EXT_CODE_CHECK		10
#define SEC_HAL_PA_LOAD			15
#define SEC_HAL_PA_REFRESH		16
#define SEC_HAL_PA_UNLOAD_ALL		17
#define SEC_HAL_PA_KEY_IMPORT		18
#define SEC_HAL_SDP_RUNTIME_INIT	19
#define SEC_HAL_SEC_STORAGE_INIT	20
#define SEC_HAL_SEC_RPC_INIT		21
#define SEC_HAL_CACHE_NON_SECURE_RAM	22
#define SEC_HAL_CONTEXT_SAVE_RESTORE	25
#define SEC_HAL_SEC_RAM_RESIZE		26
#define SEC_HAL_SEC_STORAGE_RESIZE	27
#define SEC_HAL_CL_DES_CHECKWEAKKEYS 	28
#define SEC_HAL_RNG_GENERATE		29
#define SEC_HAL_KM_PUBLIC_ID		30
#define SEC_HAL_KM_ROOTKEYHASH_READ	31
#define SEC_HAL_KM_MODEL_VALUE_READ	32
#define SEC_HAL_KM_SW_REV_READ		33
#define SEC_HAL_KM_CRC_READ		34
#define SEC_HAL_KM_CERT_SIGN_VERIFY	35
#define SEC_HAL_KM_EFUSE_VERSION_CHECK	36
#define SEC_HAL_DEBUG_CONTROL_GET	37
#define SEC_HAL_RESET_INFO_GET		38

/* Nokia PPA extensions */
#define SEC_HAL_PA_LOAD_WITH_SUBAPPS	0x30
#define SEC_HAL_SEC_STORAGE_INIT_NOKIA	0x31

/* Error codes */
#define SEC_HAL_OK 			0x00
#define SEC_HAL_FAIL			0x01
#define SDP_RUN_TIME_INIT_ERROR 	0x02
#define RPC_FAILED 			0x03
#define BOOT_PK_CERT_AUTH_FAIL 		0x10
#define BOOT_RD_CERT_AUTH_FAIL 		0x13
#define BOOT_INSUFFICIENT_MEMORY 	0x14
#define BOOT_AUTH_FAILURE 		0x15
#define SDP_BK_EXT_STORAGE_IN_SECURE 	0x1E
#define SDP_SDRAM_BACKING_STORE_IN_SECURE 0x1F

/* SDP */
#define SDP_RUNTIME_INIT_ERROR 		 0x20
#define SDP_POOL_TOO_SMALL_WARNING	 0x21
#define SDP_EXTRAVMC_INIT_ERROR		 0x22
#define SDP_BK_EXT_STORAGE_IN_SECURE_ERR 0x23
#define SDP_BACKING_STORE_IN_SECURE 	 0x24
#define SDP_KEY_GEN_FAILED		 0x25


#define SDP_RNG_ERROR 			0x27
#define SEC_STORAGE_ALREADY_DONE 	0x30
#define SEC_STORAGE_ERROR_PARAM 	0x31
#define SEC_STORAGE_RESIZE_ERROR 	0x32
#define LM_UNLOAD_FAIL_RUNNING_PA_ONLY	0x40
#define LM_LOAD_FAIL_ILLEGAL_NS_POINTERS 	0x41
#define LM_LOAD_FAIL_ILLEGAL_MAGIC_NUMBER 	0x42
#define LM_LOAD_FAIL_INSUFFICIENT_MEMORY 	0x43
#define LM_LOAD_FAIL_PA_CERT_VERIFICATION	0x44
#define LM_LOAD_FAIL_PA_CODE_VERIFICATION 	0x45
#define LM_LOAD_FAIL_PA_DATA_VERIFICATION 	0x46
#define LM_UNLOAD_NO_PA 			0x48
#define LM_UNLOAD_FAIL 			0x49
#define LM_FAIL_VMC_ACTIVATION 		0x52
#define LM_FAIL_VMC_CONTEXT_SWITCH 	0x53
#define LM_LOAD_FAIL_INVALID_STACK_SIZE 0x54
#define LM_LOAD_FAIL_PA_ALREADY_RUNNING 0x55
#define LM_LOAD_FAIL_ILLEGAL_PA_SIZE 	0x56

#define HAL_LM_UNLOAD_NO_PA                0x52
#define HAL_LM_UNLOAD_FAIL_RUNNING_PA_ONLY 0x53

#define RAMRESIZE_WRONGCONFIG 		0x60
#define RAMRESIZE_AREAINUSE 		0x61
#define RAMRESIZE_SDPERROR 		0x62
#define RAMRESIZE_SECURE_ZONE_TABLE_ERROR 0x63

#define FLAG_START_HAL_CRITICAL 0x04
#define FLAG_IRQFIQ_MASK	0x03
#define FLAG_IRQ_ENABLE		0x02
#define FLAG_FIQ_ENABLE		0x01

#define OMAP_DEFAULT_SEC_FLAG FLAG_START_HAL_CRITICAL

/* Setup RNG reset configuration and set RNG driver as not initialized. */
#define RNG_RESET 0x1

/* Initialize the HW RNG module. Seed number generated by HW. */
#define RNG_GEN_PRNG_HW_INIT 0x2

/* Initialize the Seed number given in p parameter. */
#define RNG_GEN_PRNG_SW_INIT 0x4

/* Generates a random number of n size returned in p parameter.
   Random generated by RNG HW module. */
#define RNG_GEN_HW 0x8

/* Generates a random number of n size returned in p parameter.
   Random generated by SW based on Seed number value. */
#define RNG_GEN_PRNG 0x10

/*
 * Security HAL operational callbacks.
 *
 * @mark_dirty:	Callback called when secure RAM is considered to be dirty.
 * 	Function is called with interrupts disabled.
 */
struct sec_hal_operations {
	void (*mark_dirty)(void);
};

u32 asm_sec_hal_entry(u32 app_id, u32 proc_id, u32 flags, u32 va_ptr);
u32 sec_hal_dispatch(u32 app_id, u32 proc_id, u32 flags, ...);
u32 sec_hal_dispatch_raw(u32 appl_id, u32 proc_id, u32 flag, dma_addr_t params);
u32 sec_hal_read_pub_id(u8 *public_id);
u32 sec_hal_read_rootkey_hash(u8 *rkh);
u32 sec_hal_rpc_init(void *rpc_fn);
u32 sec_hal_stor_init(dma_addr_t secs, int len);
u32 sec_hal_rng(u32 cmd, dma_addr_t p, u32 p_len);
u32 sec_hal_pa_key_import(dma_addr_t cert);
u32 sec_hal_pa_load(u32 pa_addr, int sub_appl, const dma_addr_t params,
		    dma_addr_t results);
u32 sec_hal_ram_resize(u32 size);

void asm_sec_hal_rpc_handler(void);
u32 sec_hal_rpc_handler(u32 service, u32 a1, u32 a2, u32 a3);
void sec_hal_flush_helper(void);

u32 sec_ext_code_check(dma_addr_t hdr);

int sec_hal_register(struct sec_hal_operations *ops);
int sec_hal_unregister(struct sec_hal_operations *ops);

#endif
