/**
 * \file pcm/ACIhookexec.c
 * \ingroup PCM_Hook
 * \brief PCM Hook function lib to execute cmdline
 * \author Pavel Fertser
 * \author Joerg Reisenweber <joerg@openmoko.org>
 * \date 2009
 */
/*
 *  PCM - Hook functions
 *  Copyright (c) 2009 by J.Reisenweber, P.Fertser
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as
 *   published by the Free Software Foundation; either version 2.1 of
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

#define debug true
#define dlclose_alsa_botch true

#include <alsa/asoundlib.h>
#include <alsa/conf.h>
#include <alsa/pcm.h>
#include <dlfcn.h>
#include <stdio.h>
#include <stdlib.h>

snd_config_t *conf_copy;

static int snd_pcm_hook_testhook_hw_params(snd_pcm_hook_t *hook)
{
	const char *str;
        snd_config_t *h = snd_pcm_hook_get_private(hook);
	snd_config_t *s;
	int ret;

	if ( ! snd_config_search(h, "open", &s) ) {
	
		if ( ret = snd_config_get_string(s, &str) ) {
			fprintf(stderr, "testhook open: no string: ret:%i\n", ret);
			return -2;
		};
//#ifdef debug
		fprintf(stderr, "testhook: hw_params ret:%i str:%s\n", ret, str);
//#endif
		ret = system(str);
		if (ret != 0) {
			fprintf(stderr, "testhook: system ret:%i\n", ret);
			return -1;
		}
	}
	return 0;
}

static int snd_pcm_hook_testhook_hw_free(snd_pcm_hook_t *hook)
{
	const char *str;
        snd_config_t *h = snd_pcm_hook_get_private(hook);
	snd_config_t *s;
	snd_config_search(h, "close", &s);
	snd_config_get_string(s, &str);
#ifdef debug
	fprintf(stderr, "testhook: hw_free, %s\n", str);
#endif
	int ret = system(str);
        return ret;
}

static int snd_pcm_hook_testhook_close(snd_pcm_hook_t *hook)
{
	fprintf(stderr, "testhook: close\n");
        return 0;
}

int _snd_pcm_hook_testhook_install(snd_pcm_t *pcm, snd_config_t *conf)
{
	int err;
        snd_pcm_hook_t *h_hw_params = NULL, *h_hw_free = NULL, *h_close = NULL;

	snd_config_copy(&conf_copy, conf);

#ifdef dlclose_alsa_botch
	dlopen("testhook.so", RTLD_NOW);
	fprintf(stderr, "testhook: install + dlopen\n");
#endif

        err = snd_pcm_hook_add(&h_hw_params, pcm, SND_PCM_HOOK_TYPE_HW_PARAMS,
                               snd_pcm_hook_testhook_hw_params, conf_copy);
        if (err < 0)
                goto _err;
        err = snd_pcm_hook_add(&h_hw_free, pcm, SND_PCM_HOOK_TYPE_HW_FREE,
                               snd_pcm_hook_testhook_hw_free, conf_copy);
        if (err < 0)
                goto _err;
        err = snd_pcm_hook_add(&h_close, pcm, SND_PCM_HOOK_TYPE_CLOSE,
                               snd_pcm_hook_testhook_close, NULL);
	return 0;
 _err:
        if (h_hw_params)
                snd_pcm_hook_remove(h_hw_params);
        if (h_hw_free)
                snd_pcm_hook_remove(h_hw_free);
        if (h_close)
                snd_pcm_hook_remove(h_close);
        return err;
}

SND_DLSYM_BUILD_VERSION(_snd_pcm_hook_testhook_install, SND_PCM_DLSYM_VERSION);

